# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetWorkRequestErrorsResult',
    'AwaitableGetWorkRequestErrorsResult',
    'get_work_request_errors',
    'get_work_request_errors_output',
]

@pulumi.output_type
class GetWorkRequestErrorsResult:
    """
    A collection of values returned by getWorkRequestErrors.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, work_request_errors=None, work_request_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if work_request_errors and not isinstance(work_request_errors, list):
            raise TypeError("Expected argument 'work_request_errors' to be a list")
        pulumi.set(__self__, "work_request_errors", work_request_errors)
        if work_request_id and not isinstance(work_request_id, str):
            raise TypeError("Expected argument 'work_request_id' to be a str")
        pulumi.set(__self__, "work_request_id", work_request_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetWorkRequestErrorsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="workRequestErrors")
    def work_request_errors(self) -> Sequence['outputs.GetWorkRequestErrorsWorkRequestErrorResult']:
        """
        The list of work_request_errors.
        """
        return pulumi.get(self, "work_request_errors")

    @property
    @pulumi.getter(name="workRequestId")
    def work_request_id(self) -> str:
        return pulumi.get(self, "work_request_id")


class AwaitableGetWorkRequestErrorsResult(GetWorkRequestErrorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkRequestErrorsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            work_request_errors=self.work_request_errors,
            work_request_id=self.work_request_id)


def get_work_request_errors(compartment_id: Optional[str] = None,
                            filters: Optional[Sequence[Union['GetWorkRequestErrorsFilterArgs', 'GetWorkRequestErrorsFilterArgsDict']]] = None,
                            work_request_id: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkRequestErrorsResult:
    """
    This data source provides the list of Work Request Errors in Oracle Cloud Infrastructure Container Engine service.

    Get the errors of a work request.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_work_request_errors = oci.ContainerEngine.get_work_request_errors(compartment_id=compartment_id,
        work_request_id=test_work_request["id"])
    ```


    :param str compartment_id: The OCID of the compartment.
    :param str work_request_id: The OCID of the work request.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['workRequestId'] = work_request_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ContainerEngine/getWorkRequestErrors:getWorkRequestErrors', __args__, opts=opts, typ=GetWorkRequestErrorsResult).value

    return AwaitableGetWorkRequestErrorsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        work_request_errors=pulumi.get(__ret__, 'work_request_errors'),
        work_request_id=pulumi.get(__ret__, 'work_request_id'))
def get_work_request_errors_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[Union['GetWorkRequestErrorsFilterArgs', 'GetWorkRequestErrorsFilterArgsDict']]]]] = None,
                                   work_request_id: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWorkRequestErrorsResult]:
    """
    This data source provides the list of Work Request Errors in Oracle Cloud Infrastructure Container Engine service.

    Get the errors of a work request.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_work_request_errors = oci.ContainerEngine.get_work_request_errors(compartment_id=compartment_id,
        work_request_id=test_work_request["id"])
    ```


    :param str compartment_id: The OCID of the compartment.
    :param str work_request_id: The OCID of the work request.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['workRequestId'] = work_request_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ContainerEngine/getWorkRequestErrors:getWorkRequestErrors', __args__, opts=opts, typ=GetWorkRequestErrorsResult)
    return __ret__.apply(lambda __response__: GetWorkRequestErrorsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        work_request_errors=pulumi.get(__response__, 'work_request_errors'),
        work_request_id=pulumi.get(__response__, 'work_request_id')))
