# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSensitiveTypeGroupsResult',
    'AwaitableGetSensitiveTypeGroupsResult',
    'get_sensitive_type_groups',
    'get_sensitive_type_groups_output',
]

@pulumi.output_type
class GetSensitiveTypeGroupsResult:
    """
    A collection of values returned by getSensitiveTypeGroups.
    """
    def __init__(__self__, access_level=None, compartment_id=None, compartment_id_in_subtree=None, display_name=None, filters=None, id=None, sensitive_type_group_collections=None, sensitive_type_group_id=None, state=None, time_created_greater_than_or_equal_to=None, time_created_less_than=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if sensitive_type_group_collections and not isinstance(sensitive_type_group_collections, list):
            raise TypeError("Expected argument 'sensitive_type_group_collections' to be a list")
        pulumi.set(__self__, "sensitive_type_group_collections", sensitive_type_group_collections)
        if sensitive_type_group_id and not isinstance(sensitive_type_group_id, str):
            raise TypeError("Expected argument 'sensitive_type_group_id' to be a str")
        pulumi.set(__self__, "sensitive_type_group_id", sensitive_type_group_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created_greater_than_or_equal_to and not isinstance(time_created_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_created_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_created_greater_than_or_equal_to", time_created_greater_than_or_equal_to)
        if time_created_less_than and not isinstance(time_created_less_than, str):
            raise TypeError("Expected argument 'time_created_less_than' to be a str")
        pulumi.set(__self__, "time_created_less_than", time_created_less_than)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[str]:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the sensitive type group.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name of the sensitive type group.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSensitiveTypeGroupsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="sensitiveTypeGroupCollections")
    def sensitive_type_group_collections(self) -> Sequence['outputs.GetSensitiveTypeGroupsSensitiveTypeGroupCollectionResult']:
        """
        The list of sensitive_type_group_collection.
        """
        return pulumi.get(self, "sensitive_type_group_collections")

    @property
    @pulumi.getter(name="sensitiveTypeGroupId")
    def sensitive_type_group_id(self) -> Optional[str]:
        return pulumi.get(self, "sensitive_type_group_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the sensitive type group.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreatedGreaterThanOrEqualTo")
    def time_created_greater_than_or_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "time_created_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="timeCreatedLessThan")
    def time_created_less_than(self) -> Optional[str]:
        return pulumi.get(self, "time_created_less_than")


class AwaitableGetSensitiveTypeGroupsResult(GetSensitiveTypeGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSensitiveTypeGroupsResult(
            access_level=self.access_level,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            sensitive_type_group_collections=self.sensitive_type_group_collections,
            sensitive_type_group_id=self.sensitive_type_group_id,
            state=self.state,
            time_created_greater_than_or_equal_to=self.time_created_greater_than_or_equal_to,
            time_created_less_than=self.time_created_less_than)


def get_sensitive_type_groups(access_level: Optional[str] = None,
                              compartment_id: Optional[str] = None,
                              compartment_id_in_subtree: Optional[bool] = None,
                              display_name: Optional[str] = None,
                              filters: Optional[Sequence[Union['GetSensitiveTypeGroupsFilterArgs', 'GetSensitiveTypeGroupsFilterArgsDict']]] = None,
                              sensitive_type_group_id: Optional[str] = None,
                              state: Optional[str] = None,
                              time_created_greater_than_or_equal_to: Optional[str] = None,
                              time_created_less_than: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSensitiveTypeGroupsResult:
    """
    This data source provides the list of Sensitive Type Groups in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of sensitive type groups based on the specified query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sensitive_type_groups = oci.DataSafe.get_sensitive_type_groups(compartment_id=compartment_id,
        access_level=sensitive_type_group_access_level,
        compartment_id_in_subtree=sensitive_type_group_compartment_id_in_subtree,
        display_name=sensitive_type_group_display_name,
        sensitive_type_group_id=test_sensitive_type_group["id"],
        state=sensitive_type_group_state,
        time_created_greater_than_or_equal_to=sensitive_type_group_time_created_greater_than_or_equal_to,
        time_created_less_than=sensitive_type_group_time_created_less_than)
    ```


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str display_name: A filter to return only resources that match the specified display name.
    :param str sensitive_type_group_id: An optional filter to return only resources that match the specified OCID of the sensitive type group resource.
    :param str state: A filter to return only the resources that match the specified lifecycle state.
    :param str time_created_greater_than_or_equal_to: A filter to return only the resources that were created after the specified date and time, as defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Using TimeCreatedGreaterThanOrEqualToQueryParam parameter retrieves all resources created after that date.
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param str time_created_less_than: Search for resources that were created before a specific date. Specifying this parameter corresponding `timeCreatedLessThan` parameter will retrieve all resources created before the specified created date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by RFC 3339.
           
           **Example:** 2016-12-19T16:39:57.600Z
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['sensitiveTypeGroupId'] = sensitive_type_group_id
    __args__['state'] = state
    __args__['timeCreatedGreaterThanOrEqualTo'] = time_created_greater_than_or_equal_to
    __args__['timeCreatedLessThan'] = time_created_less_than
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getSensitiveTypeGroups:getSensitiveTypeGroups', __args__, opts=opts, typ=GetSensitiveTypeGroupsResult).value

    return AwaitableGetSensitiveTypeGroupsResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        sensitive_type_group_collections=pulumi.get(__ret__, 'sensitive_type_group_collections'),
        sensitive_type_group_id=pulumi.get(__ret__, 'sensitive_type_group_id'),
        state=pulumi.get(__ret__, 'state'),
        time_created_greater_than_or_equal_to=pulumi.get(__ret__, 'time_created_greater_than_or_equal_to'),
        time_created_less_than=pulumi.get(__ret__, 'time_created_less_than'))
def get_sensitive_type_groups_output(access_level: Optional[pulumi.Input[Optional[str]]] = None,
                                     compartment_id: Optional[pulumi.Input[str]] = None,
                                     compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                                     display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                     filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSensitiveTypeGroupsFilterArgs', 'GetSensitiveTypeGroupsFilterArgsDict']]]]] = None,
                                     sensitive_type_group_id: Optional[pulumi.Input[Optional[str]]] = None,
                                     state: Optional[pulumi.Input[Optional[str]]] = None,
                                     time_created_greater_than_or_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                                     time_created_less_than: Optional[pulumi.Input[Optional[str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSensitiveTypeGroupsResult]:
    """
    This data source provides the list of Sensitive Type Groups in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of sensitive type groups based on the specified query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sensitive_type_groups = oci.DataSafe.get_sensitive_type_groups(compartment_id=compartment_id,
        access_level=sensitive_type_group_access_level,
        compartment_id_in_subtree=sensitive_type_group_compartment_id_in_subtree,
        display_name=sensitive_type_group_display_name,
        sensitive_type_group_id=test_sensitive_type_group["id"],
        state=sensitive_type_group_state,
        time_created_greater_than_or_equal_to=sensitive_type_group_time_created_greater_than_or_equal_to,
        time_created_less_than=sensitive_type_group_time_created_less_than)
    ```


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str display_name: A filter to return only resources that match the specified display name.
    :param str sensitive_type_group_id: An optional filter to return only resources that match the specified OCID of the sensitive type group resource.
    :param str state: A filter to return only the resources that match the specified lifecycle state.
    :param str time_created_greater_than_or_equal_to: A filter to return only the resources that were created after the specified date and time, as defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Using TimeCreatedGreaterThanOrEqualToQueryParam parameter retrieves all resources created after that date.
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param str time_created_less_than: Search for resources that were created before a specific date. Specifying this parameter corresponding `timeCreatedLessThan` parameter will retrieve all resources created before the specified created date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by RFC 3339.
           
           **Example:** 2016-12-19T16:39:57.600Z
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['sensitiveTypeGroupId'] = sensitive_type_group_id
    __args__['state'] = state
    __args__['timeCreatedGreaterThanOrEqualTo'] = time_created_greater_than_or_equal_to
    __args__['timeCreatedLessThan'] = time_created_less_than
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getSensitiveTypeGroups:getSensitiveTypeGroups', __args__, opts=opts, typ=GetSensitiveTypeGroupsResult)
    return __ret__.apply(lambda __response__: GetSensitiveTypeGroupsResult(
        access_level=pulumi.get(__response__, 'access_level'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        sensitive_type_group_collections=pulumi.get(__response__, 'sensitive_type_group_collections'),
        sensitive_type_group_id=pulumi.get(__response__, 'sensitive_type_group_id'),
        state=pulumi.get(__response__, 'state'),
        time_created_greater_than_or_equal_to=pulumi.get(__response__, 'time_created_greater_than_or_equal_to'),
        time_created_less_than=pulumi.get(__response__, 'time_created_less_than')))
