# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVulnerabilityScansResult',
    'AwaitableGetVulnerabilityScansResult',
    'get_vulnerability_scans',
    'get_vulnerability_scans_output',
]

@pulumi.output_type
class GetVulnerabilityScansResult:
    """
    A collection of values returned by getVulnerabilityScans.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, time_created_greater_than=None, time_ended_less_than=None, vulnerability_scan_collections=None, vulnerability_scan_id=None, vulnerability_scan_statuses=None, vulnerability_scan_type=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if time_created_greater_than and not isinstance(time_created_greater_than, str):
            raise TypeError("Expected argument 'time_created_greater_than' to be a str")
        pulumi.set(__self__, "time_created_greater_than", time_created_greater_than)
        if time_ended_less_than and not isinstance(time_ended_less_than, str):
            raise TypeError("Expected argument 'time_ended_less_than' to be a str")
        pulumi.set(__self__, "time_ended_less_than", time_ended_less_than)
        if vulnerability_scan_collections and not isinstance(vulnerability_scan_collections, list):
            raise TypeError("Expected argument 'vulnerability_scan_collections' to be a list")
        pulumi.set(__self__, "vulnerability_scan_collections", vulnerability_scan_collections)
        if vulnerability_scan_id and not isinstance(vulnerability_scan_id, str):
            raise TypeError("Expected argument 'vulnerability_scan_id' to be a str")
        pulumi.set(__self__, "vulnerability_scan_id", vulnerability_scan_id)
        if vulnerability_scan_statuses and not isinstance(vulnerability_scan_statuses, list):
            raise TypeError("Expected argument 'vulnerability_scan_statuses' to be a list")
        pulumi.set(__self__, "vulnerability_scan_statuses", vulnerability_scan_statuses)
        if vulnerability_scan_type and not isinstance(vulnerability_scan_type, str):
            raise TypeError("Expected argument 'vulnerability_scan_type' to be a str")
        pulumi.set(__self__, "vulnerability_scan_type", vulnerability_scan_type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. It does not have to be unique, and it is changeable.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVulnerabilityScansFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="timeCreatedGreaterThan")
    def time_created_greater_than(self) -> Optional[str]:
        return pulumi.get(self, "time_created_greater_than")

    @property
    @pulumi.getter(name="timeEndedLessThan")
    def time_ended_less_than(self) -> Optional[str]:
        return pulumi.get(self, "time_ended_less_than")

    @property
    @pulumi.getter(name="vulnerabilityScanCollections")
    def vulnerability_scan_collections(self) -> Sequence['outputs.GetVulnerabilityScansVulnerabilityScanCollectionResult']:
        """
        The list of vulnerability_scan_collection.
        """
        return pulumi.get(self, "vulnerability_scan_collections")

    @property
    @pulumi.getter(name="vulnerabilityScanId")
    def vulnerability_scan_id(self) -> Optional[str]:
        return pulumi.get(self, "vulnerability_scan_id")

    @property
    @pulumi.getter(name="vulnerabilityScanStatuses")
    def vulnerability_scan_statuses(self) -> Optional[Sequence[str]]:
        """
        The status of the vulnerability scan.
        """
        return pulumi.get(self, "vulnerability_scan_statuses")

    @property
    @pulumi.getter(name="vulnerabilityScanType")
    def vulnerability_scan_type(self) -> Optional[str]:
        """
        Scan type is CVE, PATCH or IMAGE_PATCH
        """
        return pulumi.get(self, "vulnerability_scan_type")


class AwaitableGetVulnerabilityScansResult(GetVulnerabilityScansResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVulnerabilityScansResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            time_created_greater_than=self.time_created_greater_than,
            time_ended_less_than=self.time_ended_less_than,
            vulnerability_scan_collections=self.vulnerability_scan_collections,
            vulnerability_scan_id=self.vulnerability_scan_id,
            vulnerability_scan_statuses=self.vulnerability_scan_statuses,
            vulnerability_scan_type=self.vulnerability_scan_type)


def get_vulnerability_scans(compartment_id: Optional[str] = None,
                            display_name: Optional[str] = None,
                            filters: Optional[Sequence[Union['GetVulnerabilityScansFilterArgs', 'GetVulnerabilityScansFilterArgsDict']]] = None,
                            time_created_greater_than: Optional[str] = None,
                            time_ended_less_than: Optional[str] = None,
                            vulnerability_scan_id: Optional[str] = None,
                            vulnerability_scan_statuses: Optional[Sequence[str]] = None,
                            vulnerability_scan_type: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVulnerabilityScansResult:
    """
    This data source provides the list of Vulnerability Scans in Oracle Cloud Infrastructure Dblm service.

    Gets a list of VulnerabilityScans.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vulnerability_scans = oci.Dblm.get_vulnerability_scans(compartment_id=compartment_id,
        display_name=vulnerability_scan_display_name,
        time_created_greater_than=vulnerability_scan_time_created_greater_than,
        time_ended_less_than=vulnerability_scan_time_ended_less_than,
        vulnerability_scan_id=test_vulnerability_scan["id"],
        vulnerability_scan_statuses=vulnerability_scan_vulnerability_scan_status,
        vulnerability_scan_type=vulnerability_scan_vulnerability_scan_type)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str time_created_greater_than: The created greater than.
    :param str time_ended_less_than: The time ended less than.
    :param str vulnerability_scan_id: The ID of the vulnerability scan.
    :param Sequence[str] vulnerability_scan_statuses: Filter by one or more vulnerability scan status. Possible values are completed, running, completed with error, aborted.
    :param str vulnerability_scan_type: The scan type to use is 'CVE', 'PATCH' or 'IMAGE_PATCH'.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['timeCreatedGreaterThan'] = time_created_greater_than
    __args__['timeEndedLessThan'] = time_ended_less_than
    __args__['vulnerabilityScanId'] = vulnerability_scan_id
    __args__['vulnerabilityScanStatuses'] = vulnerability_scan_statuses
    __args__['vulnerabilityScanType'] = vulnerability_scan_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Dblm/getVulnerabilityScans:getVulnerabilityScans', __args__, opts=opts, typ=GetVulnerabilityScansResult).value

    return AwaitableGetVulnerabilityScansResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        time_created_greater_than=pulumi.get(__ret__, 'time_created_greater_than'),
        time_ended_less_than=pulumi.get(__ret__, 'time_ended_less_than'),
        vulnerability_scan_collections=pulumi.get(__ret__, 'vulnerability_scan_collections'),
        vulnerability_scan_id=pulumi.get(__ret__, 'vulnerability_scan_id'),
        vulnerability_scan_statuses=pulumi.get(__ret__, 'vulnerability_scan_statuses'),
        vulnerability_scan_type=pulumi.get(__ret__, 'vulnerability_scan_type'))
def get_vulnerability_scans_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                   display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVulnerabilityScansFilterArgs', 'GetVulnerabilityScansFilterArgsDict']]]]] = None,
                                   time_created_greater_than: Optional[pulumi.Input[Optional[str]]] = None,
                                   time_ended_less_than: Optional[pulumi.Input[Optional[str]]] = None,
                                   vulnerability_scan_id: Optional[pulumi.Input[Optional[str]]] = None,
                                   vulnerability_scan_statuses: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                   vulnerability_scan_type: Optional[pulumi.Input[Optional[str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVulnerabilityScansResult]:
    """
    This data source provides the list of Vulnerability Scans in Oracle Cloud Infrastructure Dblm service.

    Gets a list of VulnerabilityScans.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vulnerability_scans = oci.Dblm.get_vulnerability_scans(compartment_id=compartment_id,
        display_name=vulnerability_scan_display_name,
        time_created_greater_than=vulnerability_scan_time_created_greater_than,
        time_ended_less_than=vulnerability_scan_time_ended_less_than,
        vulnerability_scan_id=test_vulnerability_scan["id"],
        vulnerability_scan_statuses=vulnerability_scan_vulnerability_scan_status,
        vulnerability_scan_type=vulnerability_scan_vulnerability_scan_type)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str time_created_greater_than: The created greater than.
    :param str time_ended_less_than: The time ended less than.
    :param str vulnerability_scan_id: The ID of the vulnerability scan.
    :param Sequence[str] vulnerability_scan_statuses: Filter by one or more vulnerability scan status. Possible values are completed, running, completed with error, aborted.
    :param str vulnerability_scan_type: The scan type to use is 'CVE', 'PATCH' or 'IMAGE_PATCH'.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['timeCreatedGreaterThan'] = time_created_greater_than
    __args__['timeEndedLessThan'] = time_ended_less_than
    __args__['vulnerabilityScanId'] = vulnerability_scan_id
    __args__['vulnerabilityScanStatuses'] = vulnerability_scan_statuses
    __args__['vulnerabilityScanType'] = vulnerability_scan_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Dblm/getVulnerabilityScans:getVulnerabilityScans', __args__, opts=opts, typ=GetVulnerabilityScansResult)
    return __ret__.apply(lambda __response__: GetVulnerabilityScansResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        time_created_greater_than=pulumi.get(__response__, 'time_created_greater_than'),
        time_ended_less_than=pulumi.get(__response__, 'time_ended_less_than'),
        vulnerability_scan_collections=pulumi.get(__response__, 'vulnerability_scan_collections'),
        vulnerability_scan_id=pulumi.get(__response__, 'vulnerability_scan_id'),
        vulnerability_scan_statuses=pulumi.get(__response__, 'vulnerability_scan_statuses'),
        vulnerability_scan_type=pulumi.get(__response__, 'vulnerability_scan_type')))
