# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPipelineSchemaTablesResult',
    'AwaitableGetPipelineSchemaTablesResult',
    'get_pipeline_schema_tables',
    'get_pipeline_schema_tables_output',
]

@pulumi.output_type
class GetPipelineSchemaTablesResult:
    """
    A collection of values returned by getPipelineSchemaTables.
    """
    def __init__(__self__, display_name=None, filters=None, id=None, pipeline_id=None, pipeline_schema_table_collections=None, source_schema_name=None, target_schema_name=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if pipeline_id and not isinstance(pipeline_id, str):
            raise TypeError("Expected argument 'pipeline_id' to be a str")
        pulumi.set(__self__, "pipeline_id", pipeline_id)
        if pipeline_schema_table_collections and not isinstance(pipeline_schema_table_collections, list):
            raise TypeError("Expected argument 'pipeline_schema_table_collections' to be a list")
        pulumi.set(__self__, "pipeline_schema_table_collections", pipeline_schema_table_collections)
        if source_schema_name and not isinstance(source_schema_name, str):
            raise TypeError("Expected argument 'source_schema_name' to be a str")
        pulumi.set(__self__, "source_schema_name", source_schema_name)
        if target_schema_name and not isinstance(target_schema_name, str):
            raise TypeError("Expected argument 'target_schema_name' to be a str")
        pulumi.set(__self__, "target_schema_name", target_schema_name)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPipelineSchemaTablesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> str:
        return pulumi.get(self, "pipeline_id")

    @property
    @pulumi.getter(name="pipelineSchemaTableCollections")
    def pipeline_schema_table_collections(self) -> Sequence['outputs.GetPipelineSchemaTablesPipelineSchemaTableCollectionResult']:
        """
        The list of pipeline_schema_table_collection.
        """
        return pulumi.get(self, "pipeline_schema_table_collections")

    @property
    @pulumi.getter(name="sourceSchemaName")
    def source_schema_name(self) -> str:
        """
        The schema name from the database connection.
        """
        return pulumi.get(self, "source_schema_name")

    @property
    @pulumi.getter(name="targetSchemaName")
    def target_schema_name(self) -> str:
        """
        The schema name from the database connection.
        """
        return pulumi.get(self, "target_schema_name")


class AwaitableGetPipelineSchemaTablesResult(GetPipelineSchemaTablesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPipelineSchemaTablesResult(
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            pipeline_id=self.pipeline_id,
            pipeline_schema_table_collections=self.pipeline_schema_table_collections,
            source_schema_name=self.source_schema_name,
            target_schema_name=self.target_schema_name)


def get_pipeline_schema_tables(display_name: Optional[str] = None,
                               filters: Optional[Sequence[Union['GetPipelineSchemaTablesFilterArgs', 'GetPipelineSchemaTablesFilterArgsDict']]] = None,
                               pipeline_id: Optional[str] = None,
                               source_schema_name: Optional[str] = None,
                               target_schema_name: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPipelineSchemaTablesResult:
    """
    This data source provides the list of Pipeline Schema Tables in Oracle Cloud Infrastructure Golden Gate service.

    Returns an array of tables under the given schemas of the pipeline for given source and target schemas passed as query params.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_pipeline_schema_tables = oci.GoldenGate.get_pipeline_schema_tables(pipeline_id=test_pipeline["id"],
        source_schema_name=pipeline_schema_table_source_schema_name,
        target_schema_name=pipeline_schema_table_target_schema_name,
        display_name=pipeline_schema_table_display_name)
    ```


    :param str display_name: A filter to return only the resources that match the entire 'displayName' given.
    :param str pipeline_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the pipeline created.
    :param str source_schema_name: Name of the source schema obtained from get schema endpoint of the created pipeline.
    :param str target_schema_name: Name of the target schema obtained from get schema endpoint of the created pipeline.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['pipelineId'] = pipeline_id
    __args__['sourceSchemaName'] = source_schema_name
    __args__['targetSchemaName'] = target_schema_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GoldenGate/getPipelineSchemaTables:getPipelineSchemaTables', __args__, opts=opts, typ=GetPipelineSchemaTablesResult).value

    return AwaitableGetPipelineSchemaTablesResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        pipeline_id=pulumi.get(__ret__, 'pipeline_id'),
        pipeline_schema_table_collections=pulumi.get(__ret__, 'pipeline_schema_table_collections'),
        source_schema_name=pulumi.get(__ret__, 'source_schema_name'),
        target_schema_name=pulumi.get(__ret__, 'target_schema_name'))
def get_pipeline_schema_tables_output(display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                      filters: Optional[pulumi.Input[Optional[Sequence[Union['GetPipelineSchemaTablesFilterArgs', 'GetPipelineSchemaTablesFilterArgsDict']]]]] = None,
                                      pipeline_id: Optional[pulumi.Input[str]] = None,
                                      source_schema_name: Optional[pulumi.Input[str]] = None,
                                      target_schema_name: Optional[pulumi.Input[str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPipelineSchemaTablesResult]:
    """
    This data source provides the list of Pipeline Schema Tables in Oracle Cloud Infrastructure Golden Gate service.

    Returns an array of tables under the given schemas of the pipeline for given source and target schemas passed as query params.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_pipeline_schema_tables = oci.GoldenGate.get_pipeline_schema_tables(pipeline_id=test_pipeline["id"],
        source_schema_name=pipeline_schema_table_source_schema_name,
        target_schema_name=pipeline_schema_table_target_schema_name,
        display_name=pipeline_schema_table_display_name)
    ```


    :param str display_name: A filter to return only the resources that match the entire 'displayName' given.
    :param str pipeline_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the pipeline created.
    :param str source_schema_name: Name of the source schema obtained from get schema endpoint of the created pipeline.
    :param str target_schema_name: Name of the target schema obtained from get schema endpoint of the created pipeline.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['pipelineId'] = pipeline_id
    __args__['sourceSchemaName'] = source_schema_name
    __args__['targetSchemaName'] = target_schema_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:GoldenGate/getPipelineSchemaTables:getPipelineSchemaTables', __args__, opts=opts, typ=GetPipelineSchemaTablesResult)
    return __ret__.apply(lambda __response__: GetPipelineSchemaTablesResult(
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        pipeline_id=pulumi.get(__response__, 'pipeline_id'),
        pipeline_schema_table_collections=pulumi.get(__response__, 'pipeline_schema_table_collections'),
        source_schema_name=pulumi.get(__response__, 'source_schema_name'),
        target_schema_name=pulumi.get(__response__, 'target_schema_name')))
