# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetNetworkFirewallPolicyApplicationGroupResult',
    'AwaitableGetNetworkFirewallPolicyApplicationGroupResult',
    'get_network_firewall_policy_application_group',
    'get_network_firewall_policy_application_group_output',
]

@pulumi.output_type
class GetNetworkFirewallPolicyApplicationGroupResult:
    """
    A collection of values returned by getNetworkFirewallPolicyApplicationGroup.
    """
    def __init__(__self__, apps=None, id=None, name=None, network_firewall_policy_id=None, parent_resource_id=None, total_apps=None):
        if apps and not isinstance(apps, list):
            raise TypeError("Expected argument 'apps' to be a list")
        pulumi.set(__self__, "apps", apps)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_firewall_policy_id and not isinstance(network_firewall_policy_id, str):
            raise TypeError("Expected argument 'network_firewall_policy_id' to be a str")
        pulumi.set(__self__, "network_firewall_policy_id", network_firewall_policy_id)
        if parent_resource_id and not isinstance(parent_resource_id, str):
            raise TypeError("Expected argument 'parent_resource_id' to be a str")
        pulumi.set(__self__, "parent_resource_id", parent_resource_id)
        if total_apps and not isinstance(total_apps, int):
            raise TypeError("Expected argument 'total_apps' to be a int")
        pulumi.set(__self__, "total_apps", total_apps)

    @property
    @pulumi.getter
    def apps(self) -> Sequence[str]:
        """
        List of apps in the group.
        """
        return pulumi.get(self, "apps")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the application Group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> str:
        return pulumi.get(self, "network_firewall_policy_id")

    @property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> str:
        """
        OCID of the Network Firewall Policy this application group belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @property
    @pulumi.getter(name="totalApps")
    def total_apps(self) -> int:
        """
        Count of total applications in the given application group.
        """
        return pulumi.get(self, "total_apps")


class AwaitableGetNetworkFirewallPolicyApplicationGroupResult(GetNetworkFirewallPolicyApplicationGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkFirewallPolicyApplicationGroupResult(
            apps=self.apps,
            id=self.id,
            name=self.name,
            network_firewall_policy_id=self.network_firewall_policy_id,
            parent_resource_id=self.parent_resource_id,
            total_apps=self.total_apps)


def get_network_firewall_policy_application_group(name: Optional[str] = None,
                                                  network_firewall_policy_id: Optional[str] = None,
                                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkFirewallPolicyApplicationGroupResult:
    """
    This data source provides details about a specific Network Firewall Policy Application Group resource in Oracle Cloud Infrastructure Network Firewall service.

    Get ApplicationGroup by the given name in the context of network firewall policy.


    :param str name: Name of the application Group.
    :param str network_firewall_policy_id: Unique Network Firewall Policy identifier
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['networkFirewallPolicyId'] = network_firewall_policy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:NetworkFirewall/getNetworkFirewallPolicyApplicationGroup:getNetworkFirewallPolicyApplicationGroup', __args__, opts=opts, typ=GetNetworkFirewallPolicyApplicationGroupResult).value

    return AwaitableGetNetworkFirewallPolicyApplicationGroupResult(
        apps=pulumi.get(__ret__, 'apps'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        network_firewall_policy_id=pulumi.get(__ret__, 'network_firewall_policy_id'),
        parent_resource_id=pulumi.get(__ret__, 'parent_resource_id'),
        total_apps=pulumi.get(__ret__, 'total_apps'))
def get_network_firewall_policy_application_group_output(name: Optional[pulumi.Input[str]] = None,
                                                         network_firewall_policy_id: Optional[pulumi.Input[str]] = None,
                                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkFirewallPolicyApplicationGroupResult]:
    """
    This data source provides details about a specific Network Firewall Policy Application Group resource in Oracle Cloud Infrastructure Network Firewall service.

    Get ApplicationGroup by the given name in the context of network firewall policy.


    :param str name: Name of the application Group.
    :param str network_firewall_policy_id: Unique Network Firewall Policy identifier
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['networkFirewallPolicyId'] = network_firewall_policy_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:NetworkFirewall/getNetworkFirewallPolicyApplicationGroup:getNetworkFirewallPolicyApplicationGroup', __args__, opts=opts, typ=GetNetworkFirewallPolicyApplicationGroupResult)
    return __ret__.apply(lambda __response__: GetNetworkFirewallPolicyApplicationGroupResult(
        apps=pulumi.get(__response__, 'apps'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        network_firewall_policy_id=pulumi.get(__response__, 'network_firewall_policy_id'),
        parent_resource_id=pulumi.get(__response__, 'parent_resource_id'),
        total_apps=pulumi.get(__response__, 'total_apps')))
