# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ManagementStationSynchronizeMirrorsManagementArgs', 'ManagementStationSynchronizeMirrorsManagement']

@pulumi.input_type
class ManagementStationSynchronizeMirrorsManagementArgs:
    def __init__(__self__, *,
                 management_station_id: pulumi.Input[str],
                 software_source_lists: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        The set of arguments for constructing a ManagementStationSynchronizeMirrorsManagement resource.
        :param pulumi.Input[str] management_station_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] software_source_lists: List of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to synchronize.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "management_station_id", management_station_id)
        pulumi.set(__self__, "software_source_lists", software_source_lists)

    @property
    @pulumi.getter(name="managementStationId")
    def management_station_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station.
        """
        return pulumi.get(self, "management_station_id")

    @management_station_id.setter
    def management_station_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "management_station_id", value)

    @property
    @pulumi.getter(name="softwareSourceLists")
    def software_source_lists(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to synchronize.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "software_source_lists")

    @software_source_lists.setter
    def software_source_lists(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "software_source_lists", value)


@pulumi.input_type
class _ManagementStationSynchronizeMirrorsManagementState:
    def __init__(__self__, *,
                 management_station_id: Optional[pulumi.Input[str]] = None,
                 software_source_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering ManagementStationSynchronizeMirrorsManagement resources.
        :param pulumi.Input[str] management_station_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] software_source_lists: List of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to synchronize.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if management_station_id is not None:
            pulumi.set(__self__, "management_station_id", management_station_id)
        if software_source_lists is not None:
            pulumi.set(__self__, "software_source_lists", software_source_lists)

    @property
    @pulumi.getter(name="managementStationId")
    def management_station_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station.
        """
        return pulumi.get(self, "management_station_id")

    @management_station_id.setter
    def management_station_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_station_id", value)

    @property
    @pulumi.getter(name="softwareSourceLists")
    def software_source_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to synchronize.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "software_source_lists")

    @software_source_lists.setter
    def software_source_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "software_source_lists", value)


class ManagementStationSynchronizeMirrorsManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 management_station_id: Optional[pulumi.Input[str]] = None,
                 software_source_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        This resource provides the Management Station Synchronize Mirrors Management resource in Oracle Cloud Infrastructure Os Management Hub service.

        Synchronize the specified software sources mirrored on the management station.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_management_station_synchronize_mirrors_management = oci.os_management_hub.ManagementStationSynchronizeMirrorsManagement("test_management_station_synchronize_mirrors_management",
            management_station_id=test_management_station["id"],
            software_source_lists=management_station_synchronize_mirrors_management_software_source_list)
        ```

        ## Import

        ManagementStationSynchronizeMirrorsManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/managementStationSynchronizeMirrorsManagement:ManagementStationSynchronizeMirrorsManagement test_management_station_synchronize_mirrors_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] management_station_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] software_source_lists: List of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to synchronize.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagementStationSynchronizeMirrorsManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Management Station Synchronize Mirrors Management resource in Oracle Cloud Infrastructure Os Management Hub service.

        Synchronize the specified software sources mirrored on the management station.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_management_station_synchronize_mirrors_management = oci.os_management_hub.ManagementStationSynchronizeMirrorsManagement("test_management_station_synchronize_mirrors_management",
            management_station_id=test_management_station["id"],
            software_source_lists=management_station_synchronize_mirrors_management_software_source_list)
        ```

        ## Import

        ManagementStationSynchronizeMirrorsManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/managementStationSynchronizeMirrorsManagement:ManagementStationSynchronizeMirrorsManagement test_management_station_synchronize_mirrors_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param ManagementStationSynchronizeMirrorsManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagementStationSynchronizeMirrorsManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 management_station_id: Optional[pulumi.Input[str]] = None,
                 software_source_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagementStationSynchronizeMirrorsManagementArgs.__new__(ManagementStationSynchronizeMirrorsManagementArgs)

            if management_station_id is None and not opts.urn:
                raise TypeError("Missing required property 'management_station_id'")
            __props__.__dict__["management_station_id"] = management_station_id
            if software_source_lists is None and not opts.urn:
                raise TypeError("Missing required property 'software_source_lists'")
            __props__.__dict__["software_source_lists"] = software_source_lists
        super(ManagementStationSynchronizeMirrorsManagement, __self__).__init__(
            'oci:OsManagementHub/managementStationSynchronizeMirrorsManagement:ManagementStationSynchronizeMirrorsManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            management_station_id: Optional[pulumi.Input[str]] = None,
            software_source_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'ManagementStationSynchronizeMirrorsManagement':
        """
        Get an existing ManagementStationSynchronizeMirrorsManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] management_station_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] software_source_lists: List of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to synchronize.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagementStationSynchronizeMirrorsManagementState.__new__(_ManagementStationSynchronizeMirrorsManagementState)

        __props__.__dict__["management_station_id"] = management_station_id
        __props__.__dict__["software_source_lists"] = software_source_lists
        return ManagementStationSynchronizeMirrorsManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="managementStationId")
    def management_station_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station.
        """
        return pulumi.get(self, "management_station_id")

    @property
    @pulumi.getter(name="softwareSourceLists")
    def software_source_lists(self) -> pulumi.Output[Sequence[str]]:
        """
        List of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to synchronize.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "software_source_lists")

