# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SoftwareSourceRemovePackagesManagementArgs', 'SoftwareSourceRemovePackagesManagement']

@pulumi.input_type
class SoftwareSourceRemovePackagesManagementArgs:
    def __init__(__self__, *,
                 packages: pulumi.Input[Sequence[pulumi.Input[str]]],
                 software_source_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a SoftwareSourceRemovePackagesManagement resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] packages: List of packages specified by the name of the package (N) or the full package name (NVRA or NEVRA).
        :param pulumi.Input[str] software_source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "packages", packages)
        pulumi.set(__self__, "software_source_id", software_source_id)

    @property
    @pulumi.getter
    def packages(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of packages specified by the name of the package (N) or the full package name (NVRA or NEVRA).
        """
        return pulumi.get(self, "packages")

    @packages.setter
    def packages(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "packages", value)

    @property
    @pulumi.getter(name="softwareSourceId")
    def software_source_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "software_source_id")

    @software_source_id.setter
    def software_source_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "software_source_id", value)


@pulumi.input_type
class _SoftwareSourceRemovePackagesManagementState:
    def __init__(__self__, *,
                 packages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 software_source_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SoftwareSourceRemovePackagesManagement resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] packages: List of packages specified by the name of the package (N) or the full package name (NVRA or NEVRA).
        :param pulumi.Input[str] software_source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if packages is not None:
            pulumi.set(__self__, "packages", packages)
        if software_source_id is not None:
            pulumi.set(__self__, "software_source_id", software_source_id)

    @property
    @pulumi.getter
    def packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of packages specified by the name of the package (N) or the full package name (NVRA or NEVRA).
        """
        return pulumi.get(self, "packages")

    @packages.setter
    def packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "packages", value)

    @property
    @pulumi.getter(name="softwareSourceId")
    def software_source_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "software_source_id")

    @software_source_id.setter
    def software_source_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "software_source_id", value)


class SoftwareSourceRemovePackagesManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 packages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 software_source_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Software Source Remove Packages Management resource in Oracle Cloud Infrastructure Os Management Hub service.

        Removes packages from a software source. This operation can only be done for custom software sources that are not created using filters.
        Packages can be of the format:
          * name (for example: git). This removes all versions of the package.
          * name-version-release.architecture (for example: git-2.43.5-1.el8_10.x86_64)
          * name-epoch:version-release.architecture (for example: git-0:2.43.5-1.el8_10.x86_64)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_software_source_remove_packages_management = oci.os_management_hub.SoftwareSourceRemovePackagesManagement("test_software_source_remove_packages_management",
            packages=software_source_remove_packages_management_packages,
            software_source_id=test_software_source["id"])
        ```

        ## Import

        SoftwareSourceRemovePackagesManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/softwareSourceRemovePackagesManagement:SoftwareSourceRemovePackagesManagement test_software_source_remove_packages_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] packages: List of packages specified by the name of the package (N) or the full package name (NVRA or NEVRA).
        :param pulumi.Input[str] software_source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SoftwareSourceRemovePackagesManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Software Source Remove Packages Management resource in Oracle Cloud Infrastructure Os Management Hub service.

        Removes packages from a software source. This operation can only be done for custom software sources that are not created using filters.
        Packages can be of the format:
          * name (for example: git). This removes all versions of the package.
          * name-version-release.architecture (for example: git-2.43.5-1.el8_10.x86_64)
          * name-epoch:version-release.architecture (for example: git-0:2.43.5-1.el8_10.x86_64)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_software_source_remove_packages_management = oci.os_management_hub.SoftwareSourceRemovePackagesManagement("test_software_source_remove_packages_management",
            packages=software_source_remove_packages_management_packages,
            software_source_id=test_software_source["id"])
        ```

        ## Import

        SoftwareSourceRemovePackagesManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/softwareSourceRemovePackagesManagement:SoftwareSourceRemovePackagesManagement test_software_source_remove_packages_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param SoftwareSourceRemovePackagesManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SoftwareSourceRemovePackagesManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 packages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 software_source_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SoftwareSourceRemovePackagesManagementArgs.__new__(SoftwareSourceRemovePackagesManagementArgs)

            if packages is None and not opts.urn:
                raise TypeError("Missing required property 'packages'")
            __props__.__dict__["packages"] = packages
            if software_source_id is None and not opts.urn:
                raise TypeError("Missing required property 'software_source_id'")
            __props__.__dict__["software_source_id"] = software_source_id
        super(SoftwareSourceRemovePackagesManagement, __self__).__init__(
            'oci:OsManagementHub/softwareSourceRemovePackagesManagement:SoftwareSourceRemovePackagesManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            packages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            software_source_id: Optional[pulumi.Input[str]] = None) -> 'SoftwareSourceRemovePackagesManagement':
        """
        Get an existing SoftwareSourceRemovePackagesManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] packages: List of packages specified by the name of the package (N) or the full package name (NVRA or NEVRA).
        :param pulumi.Input[str] software_source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SoftwareSourceRemovePackagesManagementState.__new__(_SoftwareSourceRemovePackagesManagementState)

        __props__.__dict__["packages"] = packages
        __props__.__dict__["software_source_id"] = software_source_id
        return SoftwareSourceRemovePackagesManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def packages(self) -> pulumi.Output[Sequence[str]]:
        """
        List of packages specified by the name of the package (N) or the full package name (NVRA or NEVRA).
        """
        return pulumi.get(self, "packages")

    @property
    @pulumi.getter(name="softwareSourceId")
    def software_source_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "software_source_id")

