# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDomainsResult',
    'AwaitableGetDomainsResult',
    'get_domains',
    'get_domains_output',
]

@pulumi.output_type
class GetDomainsResult:
    """
    A collection of values returned by getDomains.
    """
    def __init__(__self__, compartment_id=None, domain_collections=None, domain_id=None, filters=None, id=None, name=None, state=None, status=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if domain_collections and not isinstance(domain_collections, list):
            raise TypeError("Expected argument 'domain_collections' to be a list")
        pulumi.set(__self__, "domain_collections", domain_collections)
        if domain_id and not isinstance(domain_id, str):
            raise TypeError("Expected argument 'domain_id' to be a str")
        pulumi.set(__self__, "domain_id", domain_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="domainCollections")
    def domain_collections(self) -> Sequence['outputs.GetDomainsDomainCollectionResult']:
        """
        The list of domain_collection.
        """
        return pulumi.get(self, "domain_collections")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[str]:
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDomainsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Lifecycle state of the domain.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Status of the domain.
        """
        return pulumi.get(self, "status")


class AwaitableGetDomainsResult(GetDomainsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDomainsResult(
            compartment_id=self.compartment_id,
            domain_collections=self.domain_collections,
            domain_id=self.domain_id,
            filters=self.filters,
            id=self.id,
            name=self.name,
            state=self.state,
            status=self.status)


def get_domains(compartment_id: Optional[str] = None,
                domain_id: Optional[str] = None,
                filters: Optional[Sequence[Union['GetDomainsFilterArgs', 'GetDomainsFilterArgsDict']]] = None,
                name: Optional[str] = None,
                state: Optional[str] = None,
                status: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDomainsResult:
    """
    This data source provides the list of Domains in Oracle Cloud Infrastructure Tenantmanagercontrolplane service.

    Return a (paginated) list of domains.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_domains = oci.Tenantmanagercontrolplane.get_domains(compartment_id=compartment_id,
        domain_id=test_domain["id"],
        name=domain_name,
        state=domain_state,
        status=domain_status)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str domain_id: The domain OCID.
    :param str name: A filter to return only resources that exactly match the name given.
    :param str state: The lifecycle state of the resource.
    :param str status: The status of the domain.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['domainId'] = domain_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['state'] = state
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Tenantmanagercontrolplane/getDomains:getDomains', __args__, opts=opts, typ=GetDomainsResult).value

    return AwaitableGetDomainsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        domain_collections=pulumi.get(__ret__, 'domain_collections'),
        domain_id=pulumi.get(__ret__, 'domain_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'))
def get_domains_output(compartment_id: Optional[pulumi.Input[str]] = None,
                       domain_id: Optional[pulumi.Input[Optional[str]]] = None,
                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDomainsFilterArgs', 'GetDomainsFilterArgsDict']]]]] = None,
                       name: Optional[pulumi.Input[Optional[str]]] = None,
                       state: Optional[pulumi.Input[Optional[str]]] = None,
                       status: Optional[pulumi.Input[Optional[str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDomainsResult]:
    """
    This data source provides the list of Domains in Oracle Cloud Infrastructure Tenantmanagercontrolplane service.

    Return a (paginated) list of domains.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_domains = oci.Tenantmanagercontrolplane.get_domains(compartment_id=compartment_id,
        domain_id=test_domain["id"],
        name=domain_name,
        state=domain_state,
        status=domain_status)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str domain_id: The domain OCID.
    :param str name: A filter to return only resources that exactly match the name given.
    :param str state: The lifecycle state of the resource.
    :param str status: The status of the domain.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['domainId'] = domain_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['state'] = state
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Tenantmanagercontrolplane/getDomains:getDomains', __args__, opts=opts, typ=GetDomainsResult)
    return __ret__.apply(lambda __response__: GetDomainsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        domain_collections=pulumi.get(__response__, 'domain_collections'),
        domain_id=pulumi.get(__response__, 'domain_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status')))
