"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScopedAws = exports.Aws = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cfn_reference_1 = require("./private/cfn-reference");
const token_1 = require("./token");
const AWS_ACCOUNTID = 'AWS::AccountId';
const AWS_URLSUFFIX = 'AWS::URLSuffix';
const AWS_NOTIFICATIONARNS = 'AWS::NotificationARNs';
const AWS_PARTITION = 'AWS::Partition';
const AWS_REGION = 'AWS::Region';
const AWS_STACKID = 'AWS::StackId';
const AWS_STACKNAME = 'AWS::StackName';
const AWS_NOVALUE = 'AWS::NoValue';
/**
 * Accessor for pseudo parameters
 *
 * Since pseudo parameters need to be anchored to a stack somewhere in the
 * construct tree, this class takes an scope parameter; the pseudo parameter
 * values can be obtained as properties from an scoped object.
 */
class Aws {
    constructor() { }
}
exports.Aws = Aws;
_a = JSII_RTTI_SYMBOL_1;
Aws[_a] = { fqn: "@aws-cdk/core.Aws", version: "1.149.0" };
Aws.ACCOUNT_ID = pseudoString(AWS_ACCOUNTID);
Aws.URL_SUFFIX = pseudoString(AWS_URLSUFFIX);
Aws.NOTIFICATION_ARNS = token_1.Token.asList({ Ref: AWS_NOTIFICATIONARNS }, { displayHint: AWS_NOTIFICATIONARNS });
Aws.PARTITION = pseudoString(AWS_PARTITION);
Aws.REGION = pseudoString(AWS_REGION);
Aws.STACK_ID = pseudoString(AWS_STACKID);
Aws.STACK_NAME = pseudoString(AWS_STACKNAME);
Aws.NO_VALUE = pseudoString(AWS_NOVALUE);
/**
 * Accessor for scoped pseudo parameters
 *
 * These pseudo parameters are anchored to a stack somewhere in the construct
 * tree, and their values will be exported automatically.
 */
class ScopedAws {
    constructor(scope) {
        this.scope = scope;
        jsiiDeprecationWarnings._aws_cdk_core_Construct(scope);
    }
    get accountId() {
        return this.asString(AWS_ACCOUNTID);
    }
    get urlSuffix() {
        return this.asString(AWS_URLSUFFIX);
    }
    get notificationArns() {
        return token_1.Token.asList(cfn_reference_1.CfnReference.forPseudo(AWS_NOTIFICATIONARNS, this.scope), {
            displayHint: AWS_NOTIFICATIONARNS,
        });
    }
    get partition() {
        return this.asString(AWS_PARTITION);
    }
    get region() {
        return this.asString(AWS_REGION);
    }
    get stackId() {
        return this.asString(AWS_STACKID);
    }
    get stackName() {
        return this.asString(AWS_STACKNAME);
    }
    asString(name) {
        return token_1.Token.asString(cfn_reference_1.CfnReference.forPseudo(name, this.scope), { displayHint: name });
    }
}
exports.ScopedAws = ScopedAws;
_b = JSII_RTTI_SYMBOL_1;
ScopedAws[_b] = { fqn: "@aws-cdk/core.ScopedAws", version: "1.149.0" };
function pseudoString(name) {
    // we don't want any ':' in the serialized form,
    // as ':' is the ARN separator,
    // and so we don't want ARN components
    // (which these CFN references like AWS::Partition certainly can be)
    // to contain ':'s themselves
    return token_1.Token.asString({ Ref: name }, { displayHint: name.replace('::', '.') });
}
//# sourceMappingURL=data:application/json;base64,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