# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel, UnionMetadata
from ...types.athlete import Athlete
from ...types.no_data_returned_status import NoDataReturnedStatus
from ...types.terra_user import TerraUser


class AthleteFetchResponse_Athlete(UncheckedBaseModel):
    type: typing.Literal["athlete"] = "athlete"
    athlete: typing.Optional[Athlete] = None
    user: typing.Optional[TerraUser] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class AthleteFetchResponse_NoData(UncheckedBaseModel):
    type: typing.Literal["no_data"] = "no_data"
    status: typing.Optional[NoDataReturnedStatus] = None
    message: typing.Optional[str] = None
    user: typing.Optional[TerraUser] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class AthleteFetchResponse_Webhook(UncheckedBaseModel):
    type: typing.Literal["webhook"] = "webhook"
    reference: typing.Optional[str] = None
    message: typing.Optional[str] = None
    user: typing.Optional[TerraUser] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


AthleteFetchResponse = typing_extensions.Annotated[
    typing.Union[AthleteFetchResponse_Athlete, AthleteFetchResponse_NoData, AthleteFetchResponse_Webhook],
    UnionMetadata(discriminant="type"),
]
