# This file was auto-generated by Fern from our API Definition.

import typing

import httpx
from .activity.client import ActivityClient, AsyncActivityClient
from .athlete.client import AsyncAthleteClient, AthleteClient
from .authentication.client import AsyncAuthenticationClient, AuthenticationClient
from .body.client import AsyncBodyClient, BodyClient
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .daily.client import AsyncDailyClient, DailyClient
from .environment import TerraEnvironment
from .integrations.client import AsyncIntegrationsClient, IntegrationsClient
from .menstruation.client import AsyncMenstruationClient, MenstruationClient
from .nutrition.client import AsyncNutritionClient, NutritionClient
from .plannedworkout.client import AsyncPlannedworkoutClient, PlannedworkoutClient
from .sleep.client import AsyncSleepClient, SleepClient
from .user.client import AsyncUserClient, UserClient


class Terra:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : TerraEnvironment
        The environment to use for requests from the client. from .environment import TerraEnvironment



        Defaults to TerraEnvironment.DEFAULT



    dev_id : str
    api_key : str
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from terra import Terra

    client = Terra(
        dev_id="YOUR_DEV_ID",
        api_key="YOUR_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: TerraEnvironment = TerraEnvironment.DEFAULT,
        dev_id: str,
        api_key: str,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            dev_id=dev_id,
            api_key=api_key,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.authentication = AuthenticationClient(client_wrapper=self._client_wrapper)
        self.user = UserClient(client_wrapper=self._client_wrapper)
        self.activity = ActivityClient(client_wrapper=self._client_wrapper)
        self.athlete = AthleteClient(client_wrapper=self._client_wrapper)
        self.body = BodyClient(client_wrapper=self._client_wrapper)
        self.daily = DailyClient(client_wrapper=self._client_wrapper)
        self.menstruation = MenstruationClient(client_wrapper=self._client_wrapper)
        self.nutrition = NutritionClient(client_wrapper=self._client_wrapper)
        self.sleep = SleepClient(client_wrapper=self._client_wrapper)
        self.plannedworkout = PlannedworkoutClient(client_wrapper=self._client_wrapper)
        self.integrations = IntegrationsClient(client_wrapper=self._client_wrapper)


class AsyncTerra:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : TerraEnvironment
        The environment to use for requests from the client. from .environment import TerraEnvironment



        Defaults to TerraEnvironment.DEFAULT



    dev_id : str
    api_key : str
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from terra import AsyncTerra

    client = AsyncTerra(
        dev_id="YOUR_DEV_ID",
        api_key="YOUR_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: TerraEnvironment = TerraEnvironment.DEFAULT,
        dev_id: str,
        api_key: str,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            dev_id=dev_id,
            api_key=api_key,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.authentication = AsyncAuthenticationClient(client_wrapper=self._client_wrapper)
        self.user = AsyncUserClient(client_wrapper=self._client_wrapper)
        self.activity = AsyncActivityClient(client_wrapper=self._client_wrapper)
        self.athlete = AsyncAthleteClient(client_wrapper=self._client_wrapper)
        self.body = AsyncBodyClient(client_wrapper=self._client_wrapper)
        self.daily = AsyncDailyClient(client_wrapper=self._client_wrapper)
        self.menstruation = AsyncMenstruationClient(client_wrapper=self._client_wrapper)
        self.nutrition = AsyncNutritionClient(client_wrapper=self._client_wrapper)
        self.sleep = AsyncSleepClient(client_wrapper=self._client_wrapper)
        self.plannedworkout = AsyncPlannedworkoutClient(client_wrapper=self._client_wrapper)
        self.integrations = AsyncIntegrationsClient(client_wrapper=self._client_wrapper)


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: TerraEnvironment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
