# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .terra_user import TerraUser


class AccessRevokedEvent(UncheckedBaseModel):
    """
    Access revoked event when a user revokes access through the provider
    """

    type: typing.Literal["access_revoked"] = "access_revoked"
    user: TerraUser = pydantic.Field()
    """
    User who revoked access
    """

    status: typing.Literal["warning"] = pydantic.Field(default="warning")
    """
    Status of the event
    """

    message: str = pydantic.Field()
    """
    Information about the access revocation
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
