# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .hurling import Hurling
from .timestamp_localization import TimestampLocalization
from .upload_type import UploadType


class ActivityMetadata(UncheckedBaseModel):
    city: typing.Optional[str] = pydantic.Field(default=None)
    """
    The City in which the workout was performed.
    """

    country: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Country in which the workout was performed.
    """

    end_time: str = pydantic.Field()
    """
    The end time of the associated workout, in ISO8601 format with microsecond precision. TimeZone info will be provided whenever possible. If absent, the time corresponds to the user's local time.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name - either user-entered or given by the fitness data provider - of the associated workout.
    """

    start_time: str = pydantic.Field()
    """
    The start time of the associated workout, in ISO8601 format with microsecond precision. TimeZone info will be provided whenever possible. If absent, the time corresponds to the user's local time.
    """

    state: typing.Optional[str] = pydantic.Field(default=None)
    """
    The State in which the workout was performed.
    """

    summary_id: str = pydantic.Field()
    """
    A unique identifier for the workout - note that this is unique for the given user, and may not be globally unique.
    """

    timestamp_localization: typing.Optional[TimestampLocalization] = None
    type: Hurling = pydantic.Field()
    """
    The type of activity performed for the associated workout.
    """

    upload_type: UploadType = pydantic.Field()
    """
    The upload type for the associated workout, providing information on whether this was an automatic workout or user-entered.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
