# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .cadence_planned_workout_step_target_target_type import CadencePlannedWorkoutStepTargetTargetType


class CadencePlannedWorkoutStepTarget(UncheckedBaseModel):
    cadence: typing.Optional[int] = pydantic.Field(default=None)
    """
    Ideal cadence value to be maintained for the workout step
    """

    target_type: typing.Optional[CadencePlannedWorkoutStepTargetTargetType] = pydantic.Field(default=None)
    """
    Type of target for the workout - i.e. metric type for which a criterion must be met for the workout to be completed
    """

    cadence_low: typing.Optional[int] = pydantic.Field(default=None)
    """
    Minimum cadence threshold for the workout step - i.e. the user is to stay above this value during the workout
    """

    cadence_high: typing.Optional[int] = pydantic.Field(default=None)
    """
    Maximum cadence threshold for the workout step - i.e. the user is to stay under this value during the workout step
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
