# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .active_durations_data import ActiveDurationsData
from .calories_data import CaloriesData
from .daily_data_enrichment import DailyDataEnrichment
from .daily_distance_data import DailyDistanceData
from .daily_metadata import DailyMetadata
from .device_data import DeviceData
from .heart_rate_data import HeartRateData
from .met_data import MetData
from .oxygen_data import OxygenData
from .scores_data import ScoresData
from .strain_data import StrainData
from .stress_data import StressData
from .tag_data import TagData


class Daily(UncheckedBaseModel):
    active_durations_data: typing.Optional[ActiveDurationsData] = pydantic.Field(default=None)
    """
    Object containing information related to the time spent in different activity intensities during over the day.
    """

    calories_data: typing.Optional[CaloriesData] = pydantic.Field(default=None)
    """
    Object containing calorie-related information for the user during the specific day.
    """

    data_enrichment: typing.Optional[DailyDataEnrichment] = pydantic.Field(default=None)
    """
    Object containing additional enrichment data for the day.
    """

    device_data: typing.Optional[DeviceData] = pydantic.Field(default=None)
    """
    Object containing information on the device which recorded data for the day.
    """

    distance_data: typing.Optional[DailyDistanceData] = pydantic.Field(default=None)
    """
    Object containing information related to distance covered during the associated day.
    """

    heart_rate_data: typing.Optional[HeartRateData] = pydantic.Field(default=None)
    """
    Object containing heartrate-related information for the day.
    """

    met_data: typing_extensions.Annotated[typing.Optional[MetData], FieldMetadata(alias="MET_data")] = pydantic.Field(
        default=None
    )
    """
    Object containing information on the Metabolic Equivalent of Task for the day.
    """

    metadata: DailyMetadata = pydantic.Field()
    """
    Object containing daily summary metadata.
    """

    oxygen_data: typing.Optional[OxygenData] = pydantic.Field(default=None)
    """
    Object containing information on oxygen-related metrics for the day.
    """

    scores: typing.Optional[ScoresData] = pydantic.Field(default=None)
    """
    Scores for the user's performance on different metrics for the given day, as calculated by the fitness data provider.
    """

    strain_data: typing.Optional[StrainData] = pydantic.Field(default=None)
    """
    Object containing information on the strain put on the user's body over a day.
    """

    stress_data: typing.Optional[StressData] = pydantic.Field(default=None)
    """
    Object containing information on the stress put on the user over a day.
    """

    tag_data: typing.Optional[TagData] = pydantic.Field(default=None)
    """
    Object containing all user-entered or automatically tagged events in the day.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
