# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .distance_data_detailed import DistanceDataDetailed
from .elevation_data import ElevationData
from .swimming_data import SwimmingData


class DailyDistanceData(UncheckedBaseModel):
    detailed: typing.Optional[DistanceDataDetailed] = pydantic.Field(default=None)
    """
    Object containing detailed distance information - this may include second-by-second samples.
    """

    distance_meters: typing.Optional[int] = pydantic.Field(default=None)
    """
    Total distance covered by the user throughout the day.
    """

    elevation: typing.Optional[ElevationData] = pydantic.Field(default=None)
    """
    Average elevation of the user throughout the day.
    """

    floors_climbed: typing.Optional[int] = pydantic.Field(default=None)
    """
    Total number of elevation gain in floors climbed equivalent throughout the day, as determined by the fitness data provider.
    """

    steps: typing.Optional[int] = pydantic.Field(default=None)
    """
    Total number of steps performed during the day.
    """

    swimming: typing.Optional[SwimmingData] = pydantic.Field(default=None)
    """
    Summary information of the user's swimming statistics for the day, if applicable.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
