# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .integration_provider_types import IntegrationProviderTypes


class IntegrationProvider(UncheckedBaseModel):
    provider: typing.Optional[str] = pydantic.Field(default=None)
    """
    Identifier for the provider
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Display name of the integration
    """

    icon: typing.Optional[str] = pydantic.Field(default=None)
    """
    URL for the provider's icon image
    """

    setup: typing.Optional[str] = pydantic.Field(default=None)
    """
    Indicates how the integration is set up
    """

    enabled: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the integration is enabled
    """

    types: typing.Optional[IntegrationProviderTypes] = pydantic.Field(default=None)
    """
    Indicates the types of data available through the provider
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
