# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .terra_user import TerraUser


class LargeRequestSendingEvent(UncheckedBaseModel):
    """
    Large request sending event
    """

    type: typing.Literal["large_request_sending"] = "large_request_sending"
    user: TerraUser = pydantic.Field()
    """
    User whose data is being sent
    """

    reference: str = pydantic.Field()
    """
    Reference ID for tracking this request
    """

    message: str = pydantic.Field()
    """
    Information about the request
    """

    expected_payloads: int = pydantic.Field()
    """
    Number of expected payload events
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
