# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .met_sample import MetSample


class MetData(UncheckedBaseModel):
    met_samples: typing_extensions.Annotated[
        typing.Optional[typing.List[MetSample]], FieldMetadata(alias="MET_samples")
    ] = pydantic.Field(default=None)
    """
    An array of Metabolic Equivalent Time samples, as calculated by the user's wearable.
    """

    avg_level: typing.Optional[float] = pydantic.Field(default=None)
    """
    The average MET level of the activity.
    """

    num_high_intensity_minutes: typing.Optional[float] = pydantic.Field(default=None)
    """
    Number of minutes spent in High Intensity during the workout - based off MET scale.
    """

    num_inactive_minutes: typing.Optional[float] = pydantic.Field(default=None)
    """
    Number of minutes spent in state of Inactivity during the workout - based off MET scale.
    """

    num_low_intensity_minutes: typing.Optional[float] = pydantic.Field(default=None)
    """
    Number of minutes spent in Low Intensity during the workout - based off MET scale.
    """

    num_moderate_intensity_minutes: typing.Optional[float] = pydantic.Field(default=None)
    """
    Number of minutes spent in Moderate Intensity during the workout - based off MET scale.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
