# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .breaths_data import BreathsData
from .oxygen_saturation_data import OxygenSaturationData
from .snoring_data import SnoringData


class RespirationData(UncheckedBaseModel):
    breaths_data: typing.Optional[BreathsData] = pydantic.Field(default=None)
    """
    Object containing information on breathing rate for the sleep session.
    """

    oxygen_saturation_data: typing.Optional[OxygenSaturationData] = pydantic.Field(default=None)
    """
    Object containing information on saturation metrics for the sleep session.
    """

    snoring_data: typing.Optional[SnoringData] = pydantic.Field(default=None)
    """
    Object containing information on snoring metrics for the sleep session.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
