# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class S3PayloadEvent(UncheckedBaseModel):
    """
    S3 Upload event with data download URL
    """

    type: typing.Literal["s3_payload"] = "s3_payload"
    status: typing.Literal["success"] = pydantic.Field(default="success")
    """
    Status of the upload
    """

    url: str = pydantic.Field()
    """
    URL to download the data
    """

    expires_in: int = pydantic.Field()
    """
    Time in seconds until URL expiration
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
