# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .terra_user import TerraUser


class UserReauthEvent(UncheckedBaseModel):
    """
    User re-authentication event
    """

    type: typing.Literal["user_reauth"] = "user_reauth"
    new_user: TerraUser = pydantic.Field()
    """
    The new user record
    """

    old_user: TerraUser = pydantic.Field()
    """
    The old user record that will be deleted
    """

    status: typing.Literal["warning"] = pydantic.Field(default="warning")
    """
    Status of the re-authentication
    """

    message: str = pydantic.Field()
    """
    Information about the re-authentication
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
