# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.terra_user import TerraUser
from .raw_client import AsyncRawUserClient, RawUserClient
from .types.user_get_all_user_i_ds_response import UserGetAllUserIDsResponse
from .types.user_get_info_for_user_id_response import UserGetInfoForUserIdResponse
from .types.user_modify_user_response import UserModifyUserResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class UserClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawUserClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawUserClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawUserClient
        """
        return self._raw_client

    def modifyuser(
        self,
        user_id: str,
        *,
        reference_id: typing.Optional[str] = OMIT,
        active: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UserModifyUserResponse:
        """
        Update a Terra user's reference_id or active status

        Parameters
        ----------
        user_id : str
            Terra user ID to update

        reference_id : typing.Optional[str]
            Identifier on your system to associate with this user

        active : typing.Optional[bool]
            Whether the user should remain active

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserModifyUserResponse
            Returned upon successful user modification

        Examples
        --------
        from terra import Terra

        client = Terra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )
        client.user.modifyuser(
            user_id="user_id",
        )
        """
        _response = self._raw_client.modifyuser(
            user_id, reference_id=reference_id, active=active, request_options=request_options
        )
        return _response.data

    def getinfoforuserid(
        self,
        *,
        user_id: typing.Optional[str] = None,
        reference_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UserGetInfoForUserIdResponse:
        """
        Used to query for information on one Terra user ID, or to query for all registered Terra User objects under one reference ID

        Parameters
        ----------
        user_id : typing.Optional[str]
            user ID to query for

        reference_id : typing.Optional[str]
            reference ID to query for

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserGetInfoForUserIdResponse
            Returned when the provided resources are found

        Examples
        --------
        from terra import Terra

        client = Terra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )
        client.user.getinfoforuserid()
        """
        _response = self._raw_client.getinfoforuserid(
            user_id=user_id, reference_id=reference_id, request_options=request_options
        )
        return _response.data

    def getalluserids(
        self,
        *,
        page: typing.Optional[int] = None,
        per_page: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UserGetAllUserIDsResponse:
        """
        Used to query for information for all Terra User IDs. Supports optional pagination via `page` and `per_page`. If `page` is not provided, it returns all users in one go (backwards compatibility).

        Parameters
        ----------
        page : typing.Optional[int]
            Zero-based page number. If omitted, results are not paginated.

        per_page : typing.Optional[int]
            Number of results per page (default is 500).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserGetAllUserIDsResponse
            Returned upon a successful request

        Examples
        --------
        from terra import Terra

        client = Terra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )
        client.user.getalluserids()
        """
        _response = self._raw_client.getalluserids(page=page, per_page=per_page, request_options=request_options)
        return _response.data

    def getinfoformultipleuserids(
        self, *, request: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[TerraUser]:
        """
        Used to query for information for multiple Terra User IDs

        Parameters
        ----------
        request : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[TerraUser]
            Returned upon successful request

        Examples
        --------
        from terra import Terra

        client = Terra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )
        client.user.getinfoformultipleuserids(
            request=["string"],
        )
        """
        _response = self._raw_client.getinfoformultipleuserids(request=request, request_options=request_options)
        return _response.data


class AsyncUserClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawUserClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawUserClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawUserClient
        """
        return self._raw_client

    async def modifyuser(
        self,
        user_id: str,
        *,
        reference_id: typing.Optional[str] = OMIT,
        active: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UserModifyUserResponse:
        """
        Update a Terra user's reference_id or active status

        Parameters
        ----------
        user_id : str
            Terra user ID to update

        reference_id : typing.Optional[str]
            Identifier on your system to associate with this user

        active : typing.Optional[bool]
            Whether the user should remain active

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserModifyUserResponse
            Returned upon successful user modification

        Examples
        --------
        import asyncio

        from terra import AsyncTerra

        client = AsyncTerra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.modifyuser(
                user_id="user_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.modifyuser(
            user_id, reference_id=reference_id, active=active, request_options=request_options
        )
        return _response.data

    async def getinfoforuserid(
        self,
        *,
        user_id: typing.Optional[str] = None,
        reference_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UserGetInfoForUserIdResponse:
        """
        Used to query for information on one Terra user ID, or to query for all registered Terra User objects under one reference ID

        Parameters
        ----------
        user_id : typing.Optional[str]
            user ID to query for

        reference_id : typing.Optional[str]
            reference ID to query for

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserGetInfoForUserIdResponse
            Returned when the provided resources are found

        Examples
        --------
        import asyncio

        from terra import AsyncTerra

        client = AsyncTerra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.getinfoforuserid()


        asyncio.run(main())
        """
        _response = await self._raw_client.getinfoforuserid(
            user_id=user_id, reference_id=reference_id, request_options=request_options
        )
        return _response.data

    async def getalluserids(
        self,
        *,
        page: typing.Optional[int] = None,
        per_page: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UserGetAllUserIDsResponse:
        """
        Used to query for information for all Terra User IDs. Supports optional pagination via `page` and `per_page`. If `page` is not provided, it returns all users in one go (backwards compatibility).

        Parameters
        ----------
        page : typing.Optional[int]
            Zero-based page number. If omitted, results are not paginated.

        per_page : typing.Optional[int]
            Number of results per page (default is 500).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserGetAllUserIDsResponse
            Returned upon a successful request

        Examples
        --------
        import asyncio

        from terra import AsyncTerra

        client = AsyncTerra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.getalluserids()


        asyncio.run(main())
        """
        _response = await self._raw_client.getalluserids(page=page, per_page=per_page, request_options=request_options)
        return _response.data

    async def getinfoformultipleuserids(
        self, *, request: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[TerraUser]:
        """
        Used to query for information for multiple Terra User IDs

        Parameters
        ----------
        request : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[TerraUser]
            Returned upon successful request

        Examples
        --------
        import asyncio

        from terra import AsyncTerra

        client = AsyncTerra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.getinfoformultipleuserids(
                request=["string"],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.getinfoformultipleuserids(request=request, request_options=request_options)
        return _response.data
