/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.combinatorics;

import cc.redberry.combinatorics.IntCombinatorialIterator;

public final class IntCombinations
extends IntCombinatorialIterator {
    private static final long serialVersionUID = -2446688661078690111L;
    final int[] combination;
    private final int n;
    private final int k;
    private boolean onFirst = true;

    public IntCombinations(int n, int k) {
        if (n < k) {
            throw new IllegalArgumentException(" n < k ");
        }
        this.n = n;
        this.k = k;
        this.combination = new int[k];
        this.reset();
    }

    @Override
    public boolean hasNext() {
        return this.onFirst || !this.isLast();
    }

    @Override
    public void reset() {
        this.onFirst = true;
        for (int i = 0; i < this.k; ++i) {
            this.combination[i] = i;
        }
    }

    private boolean isLast() {
        for (int i = 0; i < this.k; ++i) {
            if (this.combination[i] == i + this.n - this.k) continue;
            return false;
        }
        return true;
    }

    @Override
    public int[] next() {
        if (this.onFirst) {
            this.onFirst = false;
        } else {
            int i;
            for (i = this.k - 1; i >= 0 && this.combination[i] == i + this.n - this.k; --i) {
            }
            int n = i++;
            int n2 = this.combination[n] + 1;
            this.combination[n] = n2;
            int m = n2;
            while (i < this.k) {
                this.combination[i] = ++m;
                ++i;
            }
        }
        return this.combination;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int[] current() {
        return this.combination;
    }
}

