/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.combinatorics;

import cc.redberry.combinatorics.IntCombinations;
import cc.redberry.combinatorics.IntCombinatorialPort;

public final class IntCompositions
implements IntCombinatorialPort {
    private static final long serialVersionUID = 7938373353634964549L;
    private final int integer;
    private final int nCompositions;
    private final IntCombinations generator;
    private int[] array;

    public IntCompositions(int integer, int nCompositions) {
        this.integer = integer;
        this.nCompositions = nCompositions;
        this.generator = new IntCombinations(integer + nCompositions - 1, nCompositions - 1);
        this.array = new int[nCompositions];
    }

    @Override
    public void reset() {
        this.generator.reset();
    }

    @Override
    public int[] getReference() {
        return this.array;
    }

    @Override
    public int[] take() {
        if (!this.generator.hasNext()) {
            this.array = null;
            return null;
        }
        int[] gen = this.generator.next();
        if (gen.length == 0) {
            this.array[0] = this.integer;
            return this.array;
        }
        this.array[0] = gen[0];
        this.array[this.array.length - 1] = this.integer + this.nCompositions - 1 - gen[gen.length - 1] - 1;
        for (int i = 1; i < this.array.length - 1; ++i) {
            this.array[i] = gen[i] - gen[i - 1] - 1;
        }
        return this.array;
    }
}

