/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly;

import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.io.IStringifier;
import cc.redberry.rings.io.Stringifiable;
import java.io.Serializable;

public interface IPolynomial<Poly extends IPolynomial<Poly>>
extends Comparable<Poly>,
Stringifiable<Poly>,
Serializable {
    public boolean sameCoefficientRingWith(Poly var1);

    default public void assertSameCoefficientRingWith(Poly oth) {
        if (!this.sameCoefficientRingWith(oth)) {
            throw new IllegalArgumentException("Mixing polynomials over different coefficient rings: " + this.coefficientRingToString() + " and " + oth.coefficientRingToString());
        }
    }

    public Poly setCoefficientRingFrom(Poly var1);

    default public Poly setCoefficientRingFromOptional(Poly poly) {
        if (this.sameCoefficientRingWith(poly)) {
            return (Poly)this;
        }
        return this.setCoefficientRingFrom(poly);
    }

    public int degree();

    public int size();

    public boolean isZero();

    public boolean isOne();

    public boolean isMonic();

    public boolean isUnitCC();

    public boolean isZeroCC();

    public boolean isConstant();

    public boolean isMonomial();

    public boolean isOverField();

    public boolean isOverZ();

    public boolean isOverFiniteField();

    public boolean isLinearOrConstant();

    public boolean isLinearExactly();

    public BigInteger coefficientRingCardinality();

    public BigInteger coefficientRingCharacteristic();

    public boolean isOverPerfectPower();

    public BigInteger coefficientRingPerfectPowerBase();

    public BigInteger coefficientRingPerfectPowerExponent();

    public Poly monic();

    default public Poly monicExact() {
        Poly self = this.monic();
        if (self == null) {
            throw new ArithmeticException("Not divisible by lc.");
        }
        return self;
    }

    default public Poly canonical() {
        if (this.isOverField()) {
            return this.monic();
        }
        return this.primitivePart();
    }

    public int signumOfLC();

    default public Poly toPositiveLC() {
        if (this.signumOfLC() < 0) {
            return this.negate();
        }
        return (Poly)this;
    }

    public Poly toZero();

    public Poly set(Poly var1);

    public Poly primitivePart();

    public Poly primitivePartSameSign();

    public Poly increment();

    public Poly decrement();

    public Poly createZero();

    public Poly createOne();

    default public Poly createConstant(long value) {
        return this.createOne().multiply(value);
    }

    public Poly add(Poly var1);

    default public Poly add(Poly ... oth) {
        for (Poly t : oth) {
            this.add(t);
        }
        return (Poly)this;
    }

    public Poly subtract(Poly var1);

    default public Poly subtract(Poly ... oth) {
        for (Poly t : oth) {
            this.subtract(t);
        }
        return (Poly)this;
    }

    public Poly negate();

    public Poly multiply(Poly var1);

    default public Poly multiply(Poly ... oth) {
        for (Poly t : oth) {
            this.multiply(t);
        }
        return (Poly)this;
    }

    default public Poly multiply(Iterable<Poly> oth) {
        for (IPolynomial t : oth) {
            this.multiply((Poly)t);
        }
        return (Poly)this;
    }

    public Poly multiply(long var1);

    public Poly multiplyByBigInteger(BigInteger var1);

    public Poly square();

    public Poly contentAsPoly();

    public Poly lcAsPoly();

    public Poly ccAsPoly();

    public Poly divideByLC(Poly var1);

    public Poly monicWithLC(Poly var1);

    public Poly multiplyByLC(Poly var1);

    public Poly clone();

    default public Poly copy() {
        return this.clone();
    }

    public Poly[] createArray(int var1);

    public Poly[][] createArray2d(int var1);

    public Poly[][] createArray2d(int var1, int var2);

    default public Poly[] createArray(Poly a) {
        IPolynomial[] r = this.createArray(1);
        r[0] = a;
        return r;
    }

    default public Poly[] createArray(Poly a, Poly b) {
        IPolynomial[] r = this.createArray(2);
        r[0] = a;
        r[1] = b;
        return r;
    }

    default public Poly[] createArray(Poly a, Poly b, Poly c) {
        IPolynomial[] r = this.createArray(3);
        r[0] = a;
        r[1] = b;
        r[2] = c;
        return r;
    }

    public String coefficientRingToString(IStringifier<Poly> var1);

    default public String coefficientRingToString() {
        return this.coefficientRingToString(IStringifier.dummy());
    }

    default public String toString(String ... variables) {
        return this.toString(IStringifier.mkPolyStringifier(this, variables));
    }

    @Deprecated
    public Poly parsePoly(String var1);
}

