/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly;

import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.PolynomialFactorDecomposition;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.multivar.MultivariateDivision;
import cc.redberry.rings.poly.multivar.MultivariateFactorization;
import cc.redberry.rings.poly.multivar.MultivariateGCD;
import cc.redberry.rings.poly.multivar.MultivariateSquareFreeFactorization;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.IrreduciblePolynomials;
import cc.redberry.rings.poly.univar.UnivariateDivision;
import cc.redberry.rings.poly.univar.UnivariateFactorization;
import cc.redberry.rings.poly.univar.UnivariateGCD;
import cc.redberry.rings.poly.univar.UnivariateSquareFreeFactorization;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.lang.invoke.LambdaMetafactory;
import java.util.function.IntFunction;
import java.util.stream.StreamSupport;

public final class PolynomialMethods {
    private PolynomialMethods() {
    }

    public static <Poly extends IPolynomial<Poly>> PolynomialFactorDecomposition<Poly> Factor(Poly poly) {
        if (poly instanceof IUnivariatePolynomial) {
            return UnivariateFactorization.Factor((IUnivariatePolynomial)poly);
        }
        if (poly instanceof AMultivariatePolynomial) {
            return MultivariateFactorization.Factor((AMultivariatePolynomial)poly);
        }
        throw new RuntimeException();
    }

    public static <Poly extends IPolynomial<Poly>> PolynomialFactorDecomposition<Poly> FactorSquareFree(Poly poly) {
        if (poly instanceof IUnivariatePolynomial) {
            return UnivariateSquareFreeFactorization.SquareFreeFactorization((IUnivariatePolynomial)poly);
        }
        if (poly instanceof AMultivariatePolynomial) {
            return MultivariateSquareFreeFactorization.SquareFreeFactorization((AMultivariatePolynomial)poly);
        }
        throw new RuntimeException();
    }

    public static <Poly extends IPolynomial<Poly>> Poly PolynomialGCD(Poly a, Poly b) {
        if (a instanceof IUnivariatePolynomial) {
            return (Poly)UnivariateGCD.PolynomialGCD((IUnivariatePolynomial)a, (IUnivariatePolynomial)b);
        }
        if (a instanceof AMultivariatePolynomial) {
            return (Poly)MultivariateGCD.PolynomialGCD((AMultivariatePolynomial)a, (AMultivariatePolynomial)b);
        }
        throw new RuntimeException();
    }

    public static <Poly extends IPolynomial<Poly>> Poly PolynomialGCD(Poly ... array) {
        Poly a = array[0];
        if (a instanceof IUnivariatePolynomial) {
            return (Poly)UnivariateGCD.PolynomialGCD((IUnivariatePolynomial[])((IUnivariatePolynomial[])array));
        }
        if (a instanceof AMultivariatePolynomial) {
            return (Poly)MultivariateGCD.PolynomialGCD((AMultivariatePolynomial[])((AMultivariatePolynomial[])array));
        }
        throw new RuntimeException();
    }

    public static <Poly extends IPolynomial<Poly>> Poly PolynomialGCD(Iterable<Poly> array) {
        IPolynomial a = (IPolynomial)array.iterator().next();
        if (a instanceof IUnivariatePolynomial) {
            return UnivariateGCD.PolynomialGCD(array);
        }
        if (a instanceof AMultivariatePolynomial) {
            return MultivariateGCD.PolynomialGCD(array);
        }
        throw new RuntimeException();
    }

    public static <T extends IUnivariatePolynomial<T>> T[] PolynomialExtendedGCD(T a, T b) {
        if (a.isOverField()) {
            return UnivariateGCD.PolynomialExtendedGCD(a, b);
        }
        throw new IllegalArgumentException("Polynomial over field is expected");
    }

    public static <Poly extends IPolynomial<Poly>> Poly[] divideAndRemainder(Poly a, Poly b) {
        if (a instanceof IUnivariatePolynomial) {
            return UnivariateDivision.divideAndRemainder((IUnivariatePolynomial)((IUnivariatePolynomial)a), (IUnivariatePolynomial)((IUnivariatePolynomial)b), (boolean)true);
        }
        if (a instanceof AMultivariatePolynomial) {
            return MultivariateDivision.divideAndRemainder((AMultivariatePolynomial)((AMultivariatePolynomial)a), (AMultivariatePolynomial)((AMultivariatePolynomial)b));
        }
        throw new RuntimeException();
    }

    public static <Poly extends IPolynomial<Poly>> Poly remainder(Poly a, Poly b) {
        if (a instanceof IUnivariatePolynomial) {
            return (Poly)UnivariateDivision.remainder((IUnivariatePolynomial)a, (IUnivariatePolynomial)b, true);
        }
        if (a instanceof AMultivariatePolynomial) {
            return (Poly)MultivariateDivision.divideAndRemainder((AMultivariatePolynomial)((AMultivariatePolynomial)a), (AMultivariatePolynomial)((AMultivariatePolynomial)b))[1];
        }
        throw new RuntimeException();
    }

    public static <Poly extends IPolynomial<Poly>> Poly divideOrNull(Poly a, Poly b) {
        if (a instanceof IUnivariatePolynomial) {
            return (Poly)UnivariateDivision.divideOrNull((IUnivariatePolynomial)a, (IUnivariatePolynomial)b, true);
        }
        if (a instanceof AMultivariatePolynomial) {
            return (Poly)MultivariateDivision.divideOrNull((AMultivariatePolynomial)a, (AMultivariatePolynomial)b);
        }
        throw new RuntimeException();
    }

    public static <Poly extends IPolynomial<Poly>> Poly divideExact(Poly a, Poly b) {
        if (a instanceof IUnivariatePolynomial) {
            return (Poly)UnivariateDivision.divideExact((IUnivariatePolynomial)a, (IUnivariatePolynomial)b, true);
        }
        if (a instanceof AMultivariatePolynomial) {
            return (Poly)MultivariateDivision.divideExact((AMultivariatePolynomial)a, (AMultivariatePolynomial)b);
        }
        throw new RuntimeException();
    }

    public static <Poly extends IPolynomial<Poly>> boolean coprimeQ(Poly ... polynomials) {
        for (int i = 0; i < polynomials.length - 1; ++i) {
            for (int j = i + 1; j < polynomials.length; ++j) {
                if (PolynomialMethods.PolynomialGCD(polynomials[i], polynomials[j]).isConstant()) continue;
                return false;
            }
        }
        return true;
    }

    public static <Poly extends IPolynomial<Poly>> boolean coprimeQ(Iterable<Poly> polynomials) {
        if (!polynomials.iterator().hasNext()) {
            throw new IllegalArgumentException();
        }
        IPolynomial factory = (IPolynomial)polynomials.iterator().next();
        return PolynomialMethods.coprimeQ((IPolynomial[])((IPolynomial[])StreamSupport.stream(polynomials.spliterator(), false).toArray((IntFunction<IPolynomial[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, createArray(int ), (I)[Lcc/redberry/rings/poly/IPolynomial;)((IPolynomial)factory))));
    }

    public static <Poly extends IPolynomial<Poly>> boolean irreducibleQ(Poly poly) {
        if (poly instanceof IUnivariatePolynomial) {
            return IrreduciblePolynomials.irreducibleQ((IUnivariatePolynomial)poly);
        }
        return MultivariateFactorization.Factor((AMultivariatePolynomial)poly).isTrivial();
    }

    public static <T extends IPolynomial<T>> T polyPow(T base, BigInteger exponent, boolean copy) {
        T k2p;
        if (exponent.signum() < 0) {
            throw new IllegalArgumentException();
        }
        if (exponent.isOne() || base.isOne()) {
            return copy ? base.clone() : base;
        }
        T result = base.createOne();
        T t = k2p = copy ? base.clone() : base;
        while (true) {
            if (exponent.testBit(0)) {
                result = result.multiply(k2p);
            }
            if ((exponent = exponent.shiftRight(1)).isZero()) {
                return result;
            }
            k2p = k2p.multiply(k2p);
        }
    }

    public static <T extends IPolynomial<T>> T polyPow(T base, long exponent) {
        return PolynomialMethods.polyPow(base, exponent, true);
    }

    public static <T extends IPolynomial<T>> T polyPow(T base, BigInteger exponent) {
        return PolynomialMethods.polyPow(base, exponent, true);
    }

    public static <T extends IPolynomial<T>> T polyPow(T base, long exponent, boolean copy) {
        T k2p;
        if (exponent < 0L) {
            throw new IllegalArgumentException();
        }
        if (exponent == 1L || base.isOne()) {
            return copy ? base.clone() : base;
        }
        T result = base.createOne();
        T t = k2p = copy ? base.clone() : base;
        while (true) {
            if ((exponent & 1L) != 0L) {
                result = result.multiply(k2p);
            }
            if ((exponent >>= 1) == 0L) {
                return result;
            }
            k2p = k2p.multiply(k2p);
        }
    }

    public static <T extends IPolynomial<T>> T polyPow(T base, int exponent, boolean copy, TIntObjectHashMap<T> cache) {
        if (exponent < 0) {
            throw new IllegalArgumentException();
        }
        if (exponent == 1) {
            return copy ? base.clone() : base;
        }
        IPolynomial cached = (IPolynomial)cache.get(exponent);
        if (cached != null) {
            return (T)cached.clone();
        }
        T result = base.createOne();
        T k2p = copy ? base.clone() : base;
        int rExp = 0;
        int kExp = 1;
        while (true) {
            if ((exponent & 1) != 0) {
                cache.put(rExp += kExp, result.multiply(k2p).clone());
            }
            if ((exponent >>= 1) == 0) {
                cache.put(rExp, result);
                return result;
            }
            cache.put(kExp *= 2, k2p.square().clone());
        }
    }
}

