/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly;

import cc.redberry.rings.IntegersZp;
import cc.redberry.rings.Rational;
import cc.redberry.rings.Rationals;
import cc.redberry.rings.Ring;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.poly.AlgebraicNumberField;
import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.MultipleFieldExtension;
import cc.redberry.rings.poly.SimpleFieldExtension;
import cc.redberry.rings.poly.multivar.MultivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;

public final class Util {
    private Util() {
    }

    public static void ensureOverFiniteField(IPolynomial ... polys) {
        for (IPolynomial poly : polys) {
            if (poly.isOverFiniteField()) continue;
            throw new IllegalArgumentException("Polynomial over finite field is expected; " + poly.getClass());
        }
    }

    public static void ensureOverField(IPolynomial ... polys) {
        for (IPolynomial poly : polys) {
            if (poly.isOverField()) continue;
            throw new IllegalArgumentException("Polynomial over finite field is expected; " + poly.getClass());
        }
    }

    public static void ensureOverZ(IPolynomial ... polys) {
        for (IPolynomial poly : polys) {
            if (poly.isOverZ()) continue;
            throw new IllegalArgumentException("Polynomial over Z is expected, but got " + poly.getClass());
        }
    }

    public static boolean canConvertToZp64(IPolynomial poly) {
        Ring ring;
        if (poly instanceof UnivariatePolynomial) {
            ring = ((UnivariatePolynomial)poly).ring;
        } else if (poly instanceof MultivariatePolynomial) {
            ring = ((MultivariatePolynomial)poly).ring;
        } else {
            return false;
        }
        return ring instanceof IntegersZp && ((IntegersZp)ring).modulus.bitLength() < 62;
    }

    public static <T extends IPolynomial<T>> boolean isOverRationals(T poly) {
        if (poly instanceof UnivariatePolynomial && ((UnivariatePolynomial)poly).ring instanceof Rationals) {
            return true;
        }
        return poly instanceof MultivariatePolynomial && ((MultivariatePolynomial)poly).ring instanceof Rationals;
    }

    public static <T extends IPolynomial<T>> boolean isOverSimpleFieldExtension(T poly) {
        if (poly instanceof UnivariatePolynomial && ((UnivariatePolynomial)poly).ring instanceof SimpleFieldExtension) {
            return true;
        }
        return poly instanceof MultivariatePolynomial && ((MultivariatePolynomial)poly).ring instanceof SimpleFieldExtension;
    }

    public static <T extends IPolynomial<T>> boolean isOverMultipleFieldExtension(T poly) {
        if (poly instanceof UnivariatePolynomial && ((UnivariatePolynomial)poly).ring instanceof MultipleFieldExtension) {
            return true;
        }
        return poly instanceof MultivariatePolynomial && ((MultivariatePolynomial)poly).ring instanceof MultipleFieldExtension;
    }

    public static <T extends IPolynomial<T>> boolean isOverSimpleNumberField(T poly) {
        if (poly instanceof UnivariatePolynomial && ((UnivariatePolynomial)poly).ring instanceof AlgebraicNumberField && Util.isOverQ(((AlgebraicNumberField)((UnivariatePolynomial)poly).ring).getMinimalPolynomial())) {
            return true;
        }
        return poly instanceof MultivariatePolynomial && ((MultivariatePolynomial)poly).ring instanceof AlgebraicNumberField && Util.isOverQ(((AlgebraicNumberField)((MultivariatePolynomial)poly).ring).getMinimalPolynomial());
    }

    public static <T extends IPolynomial<T>> boolean isOverRingOfIntegersOfSimpleNumberField(T poly) {
        if (poly instanceof UnivariatePolynomial && ((UnivariatePolynomial)poly).ring instanceof AlgebraicNumberField && Util.isOverZ(((AlgebraicNumberField)((UnivariatePolynomial)poly).ring).getMinimalPolynomial())) {
            return true;
        }
        return poly instanceof MultivariatePolynomial && ((MultivariatePolynomial)poly).ring instanceof AlgebraicNumberField && Util.isOverZ(((AlgebraicNumberField)((MultivariatePolynomial)poly).ring).getMinimalPolynomial());
    }

    public static <T extends IPolynomial<T>> boolean isOverQ(T poly) {
        Object rep;
        if (poly instanceof UnivariatePolynomial) {
            rep = ((UnivariatePolynomial)poly).ring.getOne();
        } else if (poly instanceof MultivariatePolynomial) {
            rep = ((MultivariatePolynomial)poly).ring.getOne();
        } else {
            return false;
        }
        if (!(rep instanceof Rational)) {
            return false;
        }
        return ((Rational)rep).numerator() instanceof BigInteger;
    }

    public static <T extends IPolynomial<T>> boolean isOverZ(T poly) {
        return poly.isOverZ();
    }

    public static <E> Tuple2<UnivariatePolynomial<E>, E> toCommonDenominator(UnivariatePolynomial<Rational<E>> poly) {
        Ring field = poly.ring;
        Ring integralRing = ((Rational)field.getOne()).ring;
        Object denominator = integralRing.getOne();
        for (int i = 0; i <= poly.degree(); ++i) {
            if (poly.isZeroAt(i)) continue;
            denominator = integralRing.lcm(denominator, poly.get(i).denominator());
        }
        int[] data = integralRing.createArray(poly.degree() + 1);
        for (int i = 0; i <= poly.degree(); ++i) {
            Rational<E> cf = poly.get(i).multiply(denominator);
            assert (cf.isIntegral());
            data[i] = (int)cf.numerator();
        }
        return new Tuple2(UnivariatePolynomial.createUnsafe(integralRing, data), denominator);
    }

    public static <E> E commonDenominator(UnivariatePolynomial<Rational<E>> poly) {
        Ring field = poly.ring;
        Ring integralRing = ((Rational)field.getOne()).ring;
        Object denominator = integralRing.getOne();
        for (int i = 0; i <= poly.degree(); ++i) {
            if (poly.isZeroAt(i)) continue;
            denominator = integralRing.lcm(denominator, poly.get(i).denominator());
        }
        return denominator;
    }

    public static <E> E commonDenominator(MultivariatePolynomial<Rational<E>> poly) {
        Ring field = poly.ring;
        Ring integralRing = ((Rational)field.getOne()).ring;
        Object denominator = integralRing.getOne();
        for (Rational<E> cf : poly.coefficients()) {
            denominator = integralRing.lcm(denominator, cf.denominator());
        }
        return denominator;
    }

    public static <E> Tuple2<MultivariatePolynomial<E>, E> toCommonDenominator(MultivariatePolynomial<Rational<E>> poly) {
        Ring field = poly.ring;
        Ring integralRing = ((Rational)field.getOne()).ring;
        Object denominator = integralRing.getOne();
        for (Rational<E> cf2 : poly.coefficients()) {
            denominator = integralRing.lcm(denominator, cf2.denominator());
        }
        Object d = denominator;
        MultivariatePolynomial<Object> integral = poly.mapCoefficients(integralRing, cf -> {
            Rational<Object> r = cf.multiply(d);
            assert (integralRing.isOne(r.denominator()));
            return r.numerator();
        });
        return new Tuple2(integral, denominator);
    }

    public static <E> UnivariatePolynomial<Rational<E>> asOverRationals(Ring<Rational<E>> field, UnivariatePolynomial<E> poly) {
        return poly.mapCoefficients(field, cf -> new Rational<Object>(poly.ring, cf));
    }

    public static <E> MultivariatePolynomial<Rational<E>> asOverRationals(Ring<Rational<E>> field, MultivariatePolynomial<E> poly) {
        return poly.mapCoefficients(field, cf -> new Rational<Object>(poly.ring, cf));
    }

    public static <E> UnivariatePolynomial<Rational<E>> divideOverRationals(Ring<Rational<E>> field, UnivariatePolynomial<E> poly, E denominator) {
        return poly.mapCoefficients(field, cf -> new Rational<Object>(poly.ring, cf, denominator));
    }

    public static <E> MultivariatePolynomial<Rational<E>> divideOverRationals(Ring<Rational<E>> field, MultivariatePolynomial<E> poly, E denominator) {
        return poly.mapCoefficients(field, cf -> new Rational<Object>(poly.ring, cf, denominator));
    }

    public static final class Tuple2<A, B> {
        public final A _1;
        public final B _2;

        public Tuple2(A _1, B _2) {
            this._1 = _1;
            this._2 = _2;
        }
    }
}

