/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.multivar;

import cc.redberry.combinatorics.Combinatorics;
import cc.redberry.combinatorics.IntCombinatorialPort;
import cc.redberry.combinatorics.IntCompositions;
import cc.redberry.rings.FactorDecomposition;
import cc.redberry.rings.IntegersZp64;
import cc.redberry.rings.Rational;
import cc.redberry.rings.Ring;
import cc.redberry.rings.Rings;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.linear.LinearSolver;
import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.MultivariateRing;
import cc.redberry.rings.poly.PolynomialMethods;
import cc.redberry.rings.poly.multivar.AMonomial;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.multivar.DegreeVector;
import cc.redberry.rings.poly.multivar.GroebnerBases;
import cc.redberry.rings.poly.multivar.Ideal;
import cc.redberry.rings.poly.multivar.Monomial;
import cc.redberry.rings.poly.multivar.MonomialOrder;
import cc.redberry.rings.poly.multivar.MonomialZp64;
import cc.redberry.rings.poly.multivar.MultivariateGCD;
import cc.redberry.rings.poly.multivar.MultivariatePolynomial;
import cc.redberry.rings.poly.multivar.MultivariatePolynomialZp64;
import cc.redberry.rings.poly.multivar.PrivateRandom;
import cc.redberry.rings.util.ArraysUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.math3.random.RandomGenerator;

public final class GroebnerMethods {
    private static final int N_JACOBIAN_EVALUATIONS_TRIES = 2;
    private static final int NULLSTELLENSATZ_LIN_SYS_THRESHOLD = 65536;

    private GroebnerMethods() {
    }

    public static <Poly extends AMultivariatePolynomial> List<Poly> eliminate(List<Poly> ideal, int variable) {
        return GroebnerMethods.eliminate0(ideal, variable);
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> List<Poly> eliminate0(List<Poly> ideal, int variable) {
        if (ideal.isEmpty()) {
            return Collections.emptyList();
        }
        Comparator<DegreeVector> originalOrder = ((AMultivariatePolynomial)ideal.get((int)0)).ordering;
        Comparator<DegreeVector> optimalOrder = GroebnerBases.optimalOrder(ideal);
        List<Object> eliminationIdeal = ideal;
        if (!(optimalOrder instanceof MonomialOrder.GrevLexWithPermutation)) {
            eliminationIdeal = GroebnerBases.GroebnerBasis(eliminationIdeal, new MonomialOrder.EliminationOrder(optimalOrder, variable)).stream().filter(p -> p.degree(variable) == 0).collect(Collectors.toList());
        } else {
            MonomialOrder.GrevLexWithPermutation order = (MonomialOrder.GrevLexWithPermutation)optimalOrder;
            int[] inversePermutation = MultivariateGCD.inversePermutation(order.permutation);
            eliminationIdeal = GroebnerBases.GroebnerBasis(eliminationIdeal.stream().map(p -> AMultivariatePolynomial.renameVariables(p, order.permutation)).collect(Collectors.toList()), new MonomialOrder.EliminationOrder(MonomialOrder.GREVLEX, inversePermutation[variable])).stream().map(p -> AMultivariatePolynomial.renameVariables(p, inversePermutation)).filter(p -> p.degree(variable) == 0).collect(Collectors.toList());
        }
        return eliminationIdeal.stream().map(p -> p.setOrdering(originalOrder)).collect(Collectors.toList());
    }

    public static <Poly extends AMultivariatePolynomial> List<Poly> eliminate(List<Poly> ideal, int ... variables) {
        for (int variable : variables) {
            ideal = GroebnerMethods.eliminate(ideal, variable);
        }
        return ideal;
    }

    public static <Poly extends AMultivariatePolynomial> boolean probablyAlgebraicallyDependentQ(List<Poly> sys) {
        if (sys.isEmpty()) {
            return false;
        }
        AMultivariatePolynomial representative = (AMultivariatePolynomial)sys.get(0);
        if (sys.size() > representative.nVariables) {
            return true;
        }
        List<DegreeVector> leadTerms = sys.stream().allMatch(p -> p.ordering == MonomialOrder.LEX) ? sys.stream().map(AMultivariatePolynomial::lt).collect(Collectors.toList()) : sys.stream().map(p -> p.lt(MonomialOrder.LEX)).collect(Collectors.toList());
        if (!GroebnerMethods.algebraicallyDependentMonomialsQ(leadTerms)) {
            return false;
        }
        if (GroebnerBases.isMonomialIdeal(sys)) {
            return true;
        }
        return !GroebnerMethods.probablyMaximalJacobianRankQ((AMultivariatePolynomial[][])GroebnerMethods.JacobianMatrix(sys));
    }

    public static <Poly extends AMultivariatePolynomial> boolean algebraicallyDependentQ(List<Poly> sys) {
        return !GroebnerMethods.algebraicRelations(sys).isEmpty();
    }

    static boolean algebraicallyDependentMonomialsQ(List<DegreeVector> sys) {
        Rational[] solution;
        if (sys.isEmpty()) {
            return false;
        }
        int nVariables = sys.get((int)0).exponents.length;
        int nUnknowns = sys.size();
        Rational[][] lhs = new Rational[nVariables][nUnknowns];
        for (int i = 0; i < nVariables; ++i) {
            for (int j = 0; j < nUnknowns; ++j) {
                lhs[i][j] = Rings.Q.valueOf(sys.get((int)j).exponents[i]);
            }
        }
        Rational[] rhs = (Rational[])Rings.Q.createZeroesArray(nVariables);
        LinearSolver.SystemInfo solveResult = LinearSolver.solve(Rings.Q, lhs, rhs, solution = (Rational[])Rings.Q.createZeroesArray(nUnknowns));
        if (solveResult == LinearSolver.SystemInfo.Consistent && Arrays.stream(solution).allMatch(Rational::isZero)) {
            return false;
        }
        return solveResult != LinearSolver.SystemInfo.Inconsistent;
    }

    static <Poly extends AMultivariatePolynomial> boolean probablyMaximalJacobianRankQ(Poly[][] jacobian) {
        if (jacobian[0][0] instanceof MultivariatePolynomialZp64) {
            return GroebnerMethods.probablyMaximalJacobianRankQ((MultivariatePolynomialZp64[][])jacobian);
        }
        return GroebnerMethods.probablyMaximalJacobianRankQ((MultivariatePolynomial[][])jacobian);
    }

    static boolean probablyMaximalJacobianRankQ(MultivariatePolynomialZp64[][] jacobian) {
        int nRows = jacobian.length;
        int nColumns = jacobian[0].length;
        MultivariatePolynomialZp64 factory = jacobian[0][0];
        IntegersZp64 ring = factory.ring;
        long[][] matrix = new long[nRows][nColumns];
        long[] substitution = new long[nRows];
        RandomGenerator random = PrivateRandom.getRandom();
        for (int i = 0; i < 2; ++i) {
            for (int var = 0; var < nRows; ++var) {
                substitution[var] = ring.randomNonZeroElement(random);
            }
            for (int iRow = 0; iRow < nRows; ++iRow) {
                for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
                    matrix[iRow][iColumn] = jacobian[iRow][iColumn].evaluate(substitution);
                }
            }
            int nz = LinearSolver.rowEchelonForm(ring, matrix, null, false, true);
            if (nz != 0) continue;
            return true;
        }
        return false;
    }

    static <E> boolean probablyMaximalJacobianRankQ(MultivariatePolynomial<E>[][] jacobian) {
        int nRows = jacobian.length;
        int nColumns = jacobian[0].length;
        MultivariatePolynomial<E> factory = jacobian[0][0];
        Ring<int> ring = factory.ring;
        E[][] matrix = ring.createArray2d(nRows, nColumns);
        int[] substitution = ring.createArray(nRows);
        RandomGenerator random = PrivateRandom.getRandom();
        for (int i = 0; i < 2; ++i) {
            for (int var = 0; var < nRows; ++var) {
                substitution[var] = (int)ring.randomNonZeroElement(random);
            }
            for (int iRow = 0; iRow < nRows; ++iRow) {
                for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
                    matrix[iRow][iColumn] = jacobian[iRow][iColumn].evaluate(substitution);
                }
            }
            int nz = LinearSolver.rowEchelonForm(ring, matrix, null, false, true);
            if (nz != 0) continue;
            return true;
        }
        return false;
    }

    public static <Poly extends AMultivariatePolynomial> List<Poly> algebraicRelations(List<Poly> polys) {
        return GroebnerMethods.algebraicRelations0(polys);
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> List<Poly> algebraicRelations0(List<Poly> polys) {
        if (!GroebnerMethods.probablyAlgebraicallyDependentQ(polys)) {
            return Collections.emptyList();
        }
        int nInitialVars = ((AMultivariatePolynomial)polys.get((int)0)).nVariables;
        int nAdditionalVars = polys.size();
        ArrayList<Poly> helpPolys = new ArrayList<Poly>();
        for (int i = 0; i < polys.size(); ++i) {
            Object p2 = ((AMultivariatePolynomial)polys.get(i)).setNVariables(nInitialVars + nAdditionalVars);
            helpPolys.add(((AMultivariatePolynomial)((AMultivariatePolynomial)p2).createMonomial(nInitialVars + i, 1)).subtract(p2));
        }
        int[] dropVars = ArraysUtil.sequence(0, nInitialVars);
        return GroebnerMethods.eliminate(helpPolys, dropVars).stream().map(p -> p.dropVariables(dropVars)).collect(Collectors.toList());
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly[][] JacobianMatrix(List<Poly> sys) {
        if (sys.isEmpty()) {
            throw new IllegalArgumentException("Empty list");
        }
        MultivariateRing<AMultivariatePolynomial> ring = Rings.MultivariateRing((AMultivariatePolynomial)sys.get(0));
        AMultivariatePolynomial[][] jacobian = (AMultivariatePolynomial[][])ring.createArray2d(ring.nVariables(), sys.size());
        for (int i = 0; i < ring.nVariables(); ++i) {
            for (int j = 0; j < sys.size(); ++j) {
                jacobian[i][j] = ((AMultivariatePolynomial)sys.get(j)).derivative(i);
            }
        }
        return jacobian;
    }

    public static <Poly extends AMultivariatePolynomial> List<Poly> NullstellensatzCertificate(List<Poly> polynomials) {
        return GroebnerMethods.NullstellensatzCertificate(polynomials, true);
    }

    public static <Poly extends AMultivariatePolynomial> List<Poly> NullstellensatzCertificate(List<Poly> polynomials, boolean boundTotalDeg) {
        return GroebnerMethods.NullstellensatzSolver(polynomials, (AMultivariatePolynomial)((AMultivariatePolynomial)polynomials.get(0)).createOne(), boundTotalDeg);
    }

    public static <Poly extends AMultivariatePolynomial> List<Poly> NullstellensatzSolver(List<Poly> polynomials, Poly rhs, boolean boundTotalDeg) {
        return GroebnerMethods.NullstellensatzSolver0(polynomials, rhs, boundTotalDeg);
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> List<Poly> NullstellensatzSolver0(List<Poly> polynomials, Poly rhs, boolean boundTotalDeg) {
        if (rhs.isOverZ()) {
            return GroebnerMethods.NullstellensatzSolverZ(polynomials, (MultivariatePolynomial)rhs, boundTotalDeg);
        }
        AMultivariatePolynomial factory = (AMultivariatePolynomial)polynomials.get(0);
        int degreeBound = 1;
        while (true) {
            List<Poly> cert;
            BigInteger _maxCfSize = boundTotalDeg ? IntStream.rangeClosed(0, degreeBound).mapToObj(d -> Rings.Z.binomial(d + factory.nVariables - 1, factory.nVariables - 1)).reduce(Rings.Z.getZero(), Rings.Z::add) : Rings.Z.pow(Rings.Z.valueOf(degreeBound), factory.nVariables);
            BigInteger _nUnknowns = _maxCfSize.multiply(Rings.Z.valueOf(polynomials.size()));
            if (!_nUnknowns.isInt()) {
                return null;
            }
            int nUnknowns = _nUnknowns.intValue();
            if (nUnknowns > 65536) {
                return null;
            }
            int maxCfSize = _maxCfSize.intValueExact();
            Object cfFactory = ((AMultivariatePolynomial)factory.createZero()).setNVariables(nUnknowns);
            MultivariateRing cfRing = Rings.MultivariateRing(cfFactory);
            MultivariateRing linSysRing = Rings.MultivariateRing(factory.nVariables, cfRing);
            List convertedPolynomials = polynomials.stream().map(p -> p.asOverPoly(cfFactory)).collect(Collectors.toList());
            ArrayList<MultivariatePolynomial<Poly>> certificate = new ArrayList<MultivariatePolynomial<Poly>>();
            MultivariatePolynomial eq = (MultivariatePolynomial)linSysRing.getZero();
            for (int i = 0; i < polynomials.size(); ++i) {
                MultivariatePolynomial unknownPoly = GroebnerMethods.generate(cfRing, linSysRing, degreeBound, i * maxCfSize, boundTotalDeg);
                certificate.add(unknownPoly);
                eq.add(((MultivariatePolynomial)convertedPolynomials.get(i)).multiply(unknownPoly));
            }
            if (eq.getSkeleton().containsAll(rhs.getSkeleton()) && (cert = GroebnerMethods.findCertificateFromLinearSystem(eq, certificate, rhs, nUnknowns)) != null) {
                return cert;
            }
            ++degreeBound;
        }
    }

    private static List<MultivariatePolynomial<BigInteger>> NullstellensatzSolverZ(List<MultivariatePolynomial<BigInteger>> polynomials, MultivariatePolynomial<BigInteger> rhs, boolean boundTotalDeg) {
        List<MultivariatePolynomial<Rational>> result = GroebnerMethods.NullstellensatzSolver(polynomials.stream().map(p -> p.mapCoefficients(Rings.Q, Rings.Q::mkNumerator)).collect(Collectors.toList()), rhs.mapCoefficients(Rings.Q, Rings.Q::mkNumerator), boundTotalDeg);
        if (result.stream().anyMatch(p -> !p.stream().allMatch(Rational::isIntegral))) {
            return null;
        }
        return result.stream().map(p -> p.mapCoefficients(Rings.Z, Rational::numerator)).collect(Collectors.toList());
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> List<Poly> findCertificateFromLinearSystem(MultivariatePolynomial<Poly> eq, List<MultivariatePolynomial<Poly>> certificate, Poly rhs, int nUnknowns) {
        if (eq.cc() instanceof MultivariatePolynomialZp64) {
            return GroebnerMethods.findCertificateZp64(eq, certificate, (MultivariatePolynomialZp64)rhs, nUnknowns);
        }
        return GroebnerMethods.findCertificateE(eq, certificate, (MultivariatePolynomial)rhs, nUnknowns);
    }

    private static List<MultivariatePolynomialZp64> findCertificateZp64(MultivariatePolynomial<MultivariatePolynomialZp64> eq, List<MultivariatePolynomial<MultivariatePolynomialZp64>> certificate, MultivariatePolynomialZp64 rhsPoly, int nUnknowns) {
        long[][] lhs = new long[eq.size()][nUnknowns];
        long[] rhs = new long[eq.size()];
        int iEq = 0;
        for (Monomial monomial : eq) {
            MonomialZp64 rhsTerm = (MonomialZp64)rhsPoly.terms.get(monomial);
            rhs[iEq] = rhsTerm != null ? rhsTerm.coefficient : 0L;
            for (MonomialZp64 cfTerm : (MultivariatePolynomialZp64)monomial.coefficient) {
                assert (cfTerm.totalDegree == 1);
                lhs[iEq][cfTerm.firstNonZeroVariable()] = cfTerm.coefficient;
            }
            ++iEq;
        }
        IntegersZp64 ring = eq.lc().ring;
        long[] lArray = new long[nUnknowns];
        LinearSolver.SystemInfo solve = LinearSolver.solve(ring, lhs, rhs, lArray, true);
        if (solve == LinearSolver.SystemInfo.Inconsistent) {
            return null;
        }
        return certificate.stream().map(p -> p.mapCoefficientsZp64(ring, m -> m.evaluate(result))).collect(Collectors.toList());
    }

    private static <E> List<MultivariatePolynomial<E>> findCertificateE(MultivariatePolynomial<MultivariatePolynomial<E>> eq, List<MultivariatePolynomial<MultivariatePolynomial<E>>> certificate, MultivariatePolynomial<E> rhsPoly, int nUnknowns) {
        Ring<int> ring = eq.lc().ring;
        E[][] lhs = ring.createZeroesArray2d(eq.size(), nUnknowns);
        E[] rhs = ring.createZeroesArray(eq.size());
        int iEq = 0;
        for (Monomial monomial : eq) {
            Monomial rhsTerm = (Monomial)rhsPoly.terms.get(monomial);
            rhs[iEq] = rhsTerm != null ? rhsTerm.coefficient : ring.getZero();
            for (Monomial cfTerm : (MultivariatePolynomial)monomial.coefficient) {
                assert (cfTerm.totalDegree == 1);
                lhs[iEq][cfTerm.firstNonZeroVariable()] = cfTerm.coefficient;
            }
            ++iEq;
        }
        int[] result = ring.createArray(nUnknowns);
        LinearSolver.SystemInfo systemInfo = LinearSolver.solve(ring, lhs, rhs, result, true);
        if (systemInfo == LinearSolver.SystemInfo.Inconsistent) {
            return null;
        }
        return certificate.stream().map(p -> p.mapCoefficients(ring, m -> m.evaluate(result))).collect(Collectors.toList());
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> MultivariatePolynomial<Poly> generate(MultivariateRing<Poly> cfRing, MultivariateRing<MultivariatePolynomial<Poly>> ring, int degree, int startingVar, boolean boundTotalDeg) {
        MultivariatePolynomial result = (MultivariatePolynomial)ring.getZero();
        if (boundTotalDeg) {
            for (int d = 0; d <= degree; ++d) {
                for (int[] tuple : new IntCombinatorialPort.Iterator(new IntCompositions(d, ring.nVariables()))) {
                    result.add(new Monomial<IPolynomial>(tuple, cfRing.variable(startingVar++)));
                }
            }
        } else {
            for (int[] tuple : Combinatorics.tuples(ArraysUtil.arrayOf(degree, ring.nVariables()))) {
                result.add(new Monomial<IPolynomial>(tuple, cfRing.variable(startingVar++)));
            }
        }
        return result;
    }

    public static <Poly extends AMultivariatePolynomial> List<Rational<Poly>> LeinartasDecomposition(Rational<Poly> fraction) {
        return GroebnerMethods.LeinartasDecomposition0(fraction);
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> List<Rational<Poly>> LeinartasDecomposition0(Rational<Poly> fraction) {
        FactorDecomposition denDecomposition = fraction.factorDenominator();
        List denominator = IntStream.range(0, denDecomposition.size()).mapToObj(i -> new Factor((AMultivariatePolynomial)denDecomposition.get(i), denDecomposition.getExponent(i))).collect(Collectors.toList());
        return GroebnerMethods.NullstellensatzDecomposition(new Fraction((AMultivariatePolynomial)fraction.numerator(), denominator, (AMultivariatePolynomial)denDecomposition.unit)).stream().flatMap(p -> GroebnerMethods.AlgebraicDecomposition(p).stream()).map(f -> f.toRational(fraction.ring)).collect(Collectors.toList());
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> List<Fraction<Term, Poly>> NullstellensatzDecomposition(Fraction<Term, Poly> fraction) {
        if (!Ideal.create(fraction.bareDenominatorNoUnits()).isEmpty()) {
            return Collections.singletonList(fraction);
        }
        List certificate = GroebnerMethods.NullstellensatzCertificate(fraction.raisedDenominator());
        return IntStream.range(0, certificate.size()).mapToObj(i -> new Fraction((AMultivariatePolynomial)((AMultivariatePolynomial)certificate.get(i)).multiply(fraction.numerator), GroebnerMethods.remove(fraction.denominator, i), (AMultivariatePolynomial)fraction.denominatorConstantFactor)).flatMap(f -> GroebnerMethods.NullstellensatzDecomposition(f).stream()).collect(Collectors.toList());
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> List<Fraction<Term, Poly>> AlgebraicDecomposition(Fraction<Term, Poly> fraction) {
        if (!GroebnerMethods.probablyAlgebraicallyDependentQ(fraction.bareDenominatorNoUnits())) {
            return Collections.singletonList(fraction);
        }
        List<Poly> raisedDenominator = fraction.raisedDenominator();
        assert (raisedDenominator.stream().noneMatch(IPolynomial::isConstant));
        List<Poly> annihilators = GroebnerMethods.algebraicRelations(raisedDenominator);
        if (annihilators.isEmpty()) {
            return Collections.singletonList(fraction);
        }
        Object annihilator = annihilators.stream().min(Comparator.comparingInt(p -> ((AMonomial)p.mt()).totalDegree)).get().setOrderingUnsafe(MonomialOrder.GREVLEX);
        Term minNormTerm = ((AMultivariatePolynomial)annihilator).mt();
        ((AMultivariatePolynomial)((AMultivariatePolynomial)annihilator).subtract(minNormTerm)).negate();
        Object numerator = fraction.numerator;
        List denominator = fraction.denominator;
        int[] denominatorExponents = denominator.stream().mapToInt(f -> f.exponent).toArray();
        ArrayList<Fraction<Term, Poly>> result = new ArrayList<Fraction<Term, Poly>>();
        for (AMonomial numFactor : annihilator) {
            int[] numExponents = ArraysUtil.multiply(denominatorExponents, numFactor.exponents);
            int[] denExponents = ArraysUtil.sum(denominatorExponents, ArraysUtil.multiply(denominatorExponents, ((AMonomial)minNormTerm).exponents));
            for (int i2 = 0; i2 < numExponents.length; ++i2) {
                if (numExponents[i2] >= denExponents[i2]) {
                    int n = i2;
                    numExponents[n] = numExponents[n] - denExponents[i2];
                    denExponents[i2] = 0;
                    continue;
                }
                int n = i2;
                denExponents[n] = denExponents[n] - numExponents[i2];
                numExponents[i2] = 0;
            }
            AMultivariatePolynomial num = (AMultivariatePolynomial)IntStream.range(0, numExponents.length).mapToObj(i -> ((Factor)denominator.get((int)i)).setExponent((int)numExponents[i]).raised).reduce((AMultivariatePolynomial)((AMultivariatePolynomial)numerator).clone(), (a, b) -> (AMultivariatePolynomial)a.multiply(b)).multiply(((AMultivariatePolynomial)numerator).createConstantFromTerm((AMonomial)numFactor));
            List den = IntStream.range(0, numExponents.length).mapToObj(i -> ((Factor)denominator.get(i)).setExponent(denExponents[i])).collect(Collectors.toList());
            AMultivariatePolynomial denConstant = (AMultivariatePolynomial)((AMultivariatePolynomial)((AMultivariatePolynomial)fraction.denominatorConstantFactor).clone()).multiply(((AMultivariatePolynomial)numerator).createConstantFromTerm(minNormTerm));
            result.addAll(GroebnerMethods.AlgebraicDecomposition(new Fraction(num, den, denConstant)));
        }
        return result;
    }

    private static <E> List<E> remove(List<E> list, int i) {
        list.remove(i);
        return list;
    }

    private static final class Fraction<Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> {
        final Poly numerator;
        final List<Factor<Term, Poly>> denominator;
        final Poly denominatorConstantFactor;

        Fraction(Poly numerator, List<Factor<Term, Poly>> denominator) {
            this((AMultivariatePolynomial)numerator, (List<Factor<Term, AMultivariatePolynomial>>)denominator, (AMultivariatePolynomial)numerator.createOne());
        }

        Fraction(Poly numerator, List<Factor<Term, Poly>> denominator, Poly denominatorConstantFactor) {
            denominator = new ArrayList<Factor<Term, Poly>>(denominator);
            denominatorConstantFactor = ((AMultivariatePolynomial)denominatorConstantFactor).clone();
            for (int i = denominator.size() - 1; i >= 0; --i) {
                if (!denominator.get(i).isConstant()) continue;
                denominatorConstantFactor = (AMultivariatePolynomial)((AMultivariatePolynomial)denominatorConstantFactor).multiply(denominator.get((int)i).raised);
                denominator.remove(i);
            }
            AMultivariatePolynomial cGcd = (AMultivariatePolynomial)PolynomialMethods.PolynomialGCD(numerator, denominatorConstantFactor);
            this.numerator = numerator.divideByLC((AMultivariatePolynomial)cGcd);
            this.denominator = denominator;
            this.denominatorConstantFactor = denominatorConstantFactor.divideByLC(cGcd);
            for (int i = 0; i < this.raisedDenominator().size(); ++i) {
                assert (!((AMultivariatePolynomial)this.raisedDenominator().get(i)).isConstant());
            }
        }

        final List<Poly> raisedDenominator() {
            return this.denominator.stream().map(p -> p.raised).collect(Collectors.toList());
        }

        final List<Poly> bareDenominator() {
            return this.denominator.stream().map(p -> p.factor).collect(Collectors.toList());
        }

        final List<Poly> bareDenominatorNoUnits() {
            return this.bareDenominator().stream().filter(p -> !p.isConstant()).collect(Collectors.toList());
        }

        final Rational<Poly> toRational(Ring<Poly> polyRing) {
            Rational<Poly> r = new Rational<Poly>(polyRing, this.numerator);
            r = r.divide(this.denominatorConstantFactor);
            for (Factor<Term, Poly> den : this.denominator) {
                r = r.divide(den.raised);
            }
            return r;
        }
    }

    private static final class Factor<Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> {
        final Poly factor;
        final int exponent;
        final Poly raised;

        Factor(Poly factor, int exponent, Poly raised) {
            this.factor = exponent == 0 ? (AMultivariatePolynomial)factor.createOne() : factor;
            this.exponent = exponent;
            this.raised = raised;
        }

        Factor(Poly factor, int exponent) {
            this.factor = factor;
            this.exponent = exponent;
            this.raised = (AMultivariatePolynomial)PolynomialMethods.polyPow(factor, exponent, true);
        }

        Factor<Term, Poly> setExponent(int newExponent) {
            if (this.exponent == newExponent) {
                return this;
            }
            if (this.exponent == 0) {
                return new Factor<Term, AMultivariatePolynomial>((AMultivariatePolynomial)this.factor.createOne(), 0, (AMultivariatePolynomial)this.factor.createOne());
            }
            if (newExponent % this.exponent == 0) {
                return new Factor<Term, AMultivariatePolynomial>((AMultivariatePolynomial)this.factor, newExponent, (AMultivariatePolynomial)PolynomialMethods.polyPow(this.raised, newExponent / this.exponent));
            }
            return new Factor<Term, Poly>(this.factor, newExponent);
        }

        boolean isConstant() {
            return this.factor.isConstant();
        }
    }
}

