/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.multivar;

import cc.redberry.rings.IntegersZp64;
import cc.redberry.rings.Ring;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.poly.multivar.AMonomial;
import cc.redberry.rings.poly.multivar.DegreeVector;
import cc.redberry.rings.poly.multivar.Monomial;
import cc.redberry.rings.poly.multivar.MonomialZp64;
import java.io.Serializable;

public interface IMonomialAlgebra<Term extends AMonomial<Term>>
extends Serializable {
    public Term multiply(Term var1, Term var2);

    public Term multiply(Term var1, BigInteger var2);

    public Term divideOrNull(Term var1, Term var2);

    default public Term divideExact(Term dividend, Term divider) {
        Term r = this.divideOrNull(dividend, divider);
        if (r == null) {
            throw new ArithmeticException("not divisible");
        }
        return r;
    }

    default public Term divideExact(DegreeVector dividend, Term divider) {
        return this.divideExact(this.create(dividend), divider);
    }

    public Term pow(Term var1, int var2);

    public Term negate(Term var1);

    public boolean isZero(Term var1);

    public boolean isOne(Term var1);

    public boolean isUnit(Term var1);

    default public boolean isConstant(Term term) {
        return ((DegreeVector)term).isZeroVector();
    }

    public boolean isPureDegreeVector(Term var1);

    public Term create(int[] var1);

    public Term create(DegreeVector var1);

    public Term[] createArray(int var1);

    public Term getUnitTerm(int var1);

    public Term getZeroTerm(int var1);

    public boolean haveSameCoefficients(Term var1, Term var2);

    public static class MonomialAlgebra<E>
    implements IMonomialAlgebra<Monomial<E>> {
        public final Ring<E> ring;

        public MonomialAlgebra(Ring<E> ring) {
            this.ring = ring;
        }

        @Override
        public Monomial<E> multiply(Monomial<E> a, Monomial<E> b) {
            DegreeVector dv = a.dvMultiply(b);
            return new Monomial<E>(dv, this.ring.multiply(a.coefficient, b.coefficient));
        }

        @Override
        public Monomial<E> multiply(Monomial<E> a, BigInteger b) {
            return new Monomial<E>(a.exponents, this.ring.multiply(a.coefficient, this.ring.valueOfBigInteger(b)));
        }

        @Override
        public Monomial<E> divideOrNull(Monomial<E> dividend, Monomial<E> divider) {
            DegreeVector dv = dividend.dvDivideOrNull(divider);
            if (dv == null) {
                return null;
            }
            E div = this.ring.divideOrNull(dividend.coefficient, divider.coefficient);
            if (div == null) {
                return null;
            }
            return new Monomial<E>(dv, div);
        }

        @Override
        public Monomial<E> pow(Monomial<E> term, int exponent) {
            if (exponent == 1) {
                return term;
            }
            if (exponent == 0) {
                return this.getUnitTerm(term.nVariables());
            }
            if (term.totalDegree > Integer.MAX_VALUE / exponent) {
                throw new ArithmeticException("overflow");
            }
            int[] exps = new int[term.exponents.length];
            for (int i = 0; i < exps.length; ++i) {
                exps[i] = term.exponents[i] * exponent;
            }
            return new Monomial<E>(exps, term.totalDegree * exponent, this.ring.pow(term.coefficient, exponent));
        }

        @Override
        public Monomial<E> negate(Monomial<E> term) {
            return term.setCoefficient(this.ring.negate(term.coefficient));
        }

        @Override
        public boolean isZero(Monomial<E> term) {
            return this.ring.isZero(term.coefficient);
        }

        @Override
        public boolean isOne(Monomial<E> term) {
            return this.isConstant(term) && this.ring.isOne(term.coefficient);
        }

        @Override
        public boolean isUnit(Monomial<E> term) {
            return this.isConstant(term) && this.ring.isUnit(term.coefficient);
        }

        @Override
        public boolean isPureDegreeVector(Monomial<E> term) {
            return this.ring.isOne(term.coefficient);
        }

        @Override
        public Monomial<E> create(int[] exponents) {
            return new Monomial<E>(exponents, this.ring.getOne());
        }

        @Override
        public Monomial<E> create(DegreeVector degreeVector) {
            return new Monomial<E>(degreeVector, this.ring.getOne());
        }

        public Monomial<E>[] createArray(int length) {
            return new Monomial[length];
        }

        @Override
        public Monomial<E> getUnitTerm(int nVariables) {
            return new Monomial<E>(nVariables, this.ring.getOne());
        }

        @Override
        public Monomial<E> getZeroTerm(int nVariables) {
            return new Monomial<E>(nVariables, this.ring.getZero());
        }

        @Override
        public boolean haveSameCoefficients(Monomial<E> a, Monomial<E> b) {
            return a.equals(b);
        }
    }

    public static class MonomialAlgebraZp64
    implements IMonomialAlgebra<MonomialZp64> {
        public final IntegersZp64 ring;

        public MonomialAlgebraZp64(IntegersZp64 ring) {
            this.ring = ring;
        }

        @Override
        public MonomialZp64 multiply(MonomialZp64 a, BigInteger b) {
            return new MonomialZp64(a.exponents, this.ring.multiply(a.coefficient, this.ring.modulus(b)));
        }

        @Override
        public MonomialZp64 multiply(MonomialZp64 a, MonomialZp64 b) {
            DegreeVector dv = a.dvMultiply(b);
            return new MonomialZp64(dv, this.ring.multiply(a.coefficient, b.coefficient));
        }

        @Override
        public MonomialZp64 divideOrNull(MonomialZp64 dividend, MonomialZp64 divider) {
            DegreeVector dv = dividend.dvDivideOrNull(divider);
            if (dv == null) {
                return null;
            }
            return new MonomialZp64(dv, this.ring.divide(dividend.coefficient, divider.coefficient));
        }

        @Override
        public MonomialZp64 pow(MonomialZp64 term, int exponent) {
            if (exponent == 1) {
                return term;
            }
            if (exponent == 0) {
                return this.getUnitTerm(term.nVariables());
            }
            if (term.totalDegree > Integer.MAX_VALUE / exponent) {
                throw new ArithmeticException("overflow");
            }
            int[] exps = new int[term.exponents.length];
            for (int i = 0; i < exps.length; ++i) {
                exps[i] = term.exponents[i] * exponent;
            }
            return new MonomialZp64(exps, term.totalDegree * exponent, this.ring.powMod(term.coefficient, exponent));
        }

        @Override
        public MonomialZp64 negate(MonomialZp64 term) {
            return term.setCoefficient(this.ring.negate(term.coefficient));
        }

        @Override
        public boolean isZero(MonomialZp64 term) {
            return term.coefficient == 0L;
        }

        @Override
        public boolean isOne(MonomialZp64 term) {
            return this.isConstant(term) && term.coefficient == 1L;
        }

        @Override
        public boolean isUnit(MonomialZp64 term) {
            return this.isConstant(term);
        }

        @Override
        public boolean isPureDegreeVector(MonomialZp64 term) {
            return term.coefficient == 1L;
        }

        @Override
        public MonomialZp64 create(int[] exponents) {
            return new MonomialZp64(exponents, 1L);
        }

        @Override
        public MonomialZp64 create(DegreeVector degreeVector) {
            return new MonomialZp64(degreeVector, 1L);
        }

        public MonomialZp64[] createArray(int length) {
            return new MonomialZp64[length];
        }

        @Override
        public MonomialZp64 getUnitTerm(int nVariables) {
            return new MonomialZp64(nVariables, 1L);
        }

        @Override
        public MonomialZp64 getZeroTerm(int nVariables) {
            return new MonomialZp64(nVariables, 0L);
        }

        @Override
        public boolean haveSameCoefficients(MonomialZp64 a, MonomialZp64 b) {
            return a.coefficient == b.coefficient;
        }
    }
}

