/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.multivar;

import cc.redberry.rings.IntegersZp64;
import cc.redberry.rings.Ring;
import cc.redberry.rings.poly.IPolynomialRing;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.multivar.MultivariatePolynomial;
import cc.redberry.rings.poly.multivar.MultivariatePolynomialZp64;
import gnu.trove.list.array.TLongArrayList;
import java.util.ArrayList;
import java.util.List;

public final class MultivariateInterpolation {
    private MultivariateInterpolation() {
    }

    private static void checkInput(Object[] points, Object[] values) {
        if (points.length != values.length) {
            throw new IllegalArgumentException();
        }
    }

    public static <E> MultivariatePolynomial<E> interpolateNewton(int variable, E[] points, MultivariatePolynomial<E>[] values) {
        MultivariateInterpolation.checkInput(points, values);
        return new Interpolation<E>(variable, values[0]).update(points, values).getInterpolatingPolynomial();
    }

    public static final class Interpolation<E> {
        private final int variable;
        private final List<E> points = new ArrayList();
        private final List<MultivariatePolynomial<E>> values = new ArrayList<MultivariatePolynomial<E>>();
        private final List<MultivariatePolynomial<E>> mixedRadix = new ArrayList<MultivariatePolynomial<E>>();
        private final MultivariatePolynomial<E> lins;
        private final MultivariatePolynomial<E> poly;
        private final Ring<E> ring;

        public Interpolation(int variable, E point, MultivariatePolynomial<E> value) {
            this.variable = variable;
            this.lins = value.createOne();
            this.poly = value.clone();
            this.ring = this.poly.ring;
            this.points.add(point);
            this.values.add(value);
            this.mixedRadix.add((MultivariatePolynomial<AMultivariatePolynomial>)value.clone());
        }

        public Interpolation(int variable, MultivariatePolynomial<E> factory) {
            this.variable = variable;
            this.lins = factory.createOne();
            this.poly = factory.createOne();
            this.ring = this.poly.ring;
        }

        public Interpolation(int variable, IPolynomialRing<MultivariatePolynomial<E>> factory) {
            this(variable, factory.factory());
        }

        public Interpolation<E> update(E point, MultivariatePolynomial<E> value) {
            if (this.points.isEmpty()) {
                this.poly.multiply(value);
                this.points.add(point);
                this.values.add(value);
                this.mixedRadix.add((MultivariatePolynomial<AMultivariatePolynomial>)value.clone());
                return this;
            }
            E reciprocal = this.ring.subtract(point, this.points.get(0));
            AMultivariatePolynomial accumulator = this.mixedRadix.get(0).clone();
            for (int i = 1; i < this.points.size(); ++i) {
                accumulator = (MultivariatePolynomial)accumulator.add(((MultivariatePolynomial)this.mixedRadix.get(i).clone()).multiply(reciprocal));
                if (!this.ring.isZero(reciprocal = this.ring.multiply(reciprocal, this.ring.subtract(point, this.points.get(i))))) continue;
                throw new IllegalArgumentException("Point " + point + " was already used in interpolation.");
            }
            this.mixedRadix.add(((MultivariatePolynomial)value.clone().subtract(accumulator)).multiply(this.ring.reciprocal(reciprocal)));
            this.lins.multiply(this.lins.createLinear(this.variable, this.ring.negate(this.points.get(this.points.size() - 1)), this.ring.getOne()));
            this.poly.add(((MultivariatePolynomial)this.lins.clone()).multiply(this.mixedRadix.get(this.mixedRadix.size() - 1)));
            this.points.add(point);
            this.values.add(value);
            return this;
        }

        public Interpolation<E> update(E[] points, MultivariatePolynomial<E>[] values) {
            for (int i = 0; i < points.length; ++i) {
                this.update(points[i], values[i]);
            }
            return this;
        }

        public int getVariable() {
            return this.variable;
        }

        public MultivariatePolynomial<E> getInterpolatingPolynomial() {
            return this.poly;
        }

        public List<E> getPoints() {
            return this.points;
        }

        public List<MultivariatePolynomial<E>> getValues() {
            return this.values;
        }

        public int numberOfPoints() {
            return this.points.size();
        }
    }

    public static final class InterpolationZp64 {
        private final int variable;
        private final TLongArrayList points = new TLongArrayList();
        private final List<MultivariatePolynomialZp64> values = new ArrayList<MultivariatePolynomialZp64>();
        private final List<MultivariatePolynomialZp64> mixedRadix = new ArrayList<MultivariatePolynomialZp64>();
        private final MultivariatePolynomialZp64 lins;
        private final MultivariatePolynomialZp64 poly;
        private final IntegersZp64 ring;

        public InterpolationZp64(int variable, long point, MultivariatePolynomialZp64 value) {
            this.variable = variable;
            this.lins = value.createOne();
            this.poly = value.clone();
            this.ring = this.poly.ring;
            this.points.add(point);
            this.values.add(value);
            this.mixedRadix.add(value.clone());
        }

        public InterpolationZp64(int variable, MultivariatePolynomialZp64 factory) {
            this.variable = variable;
            this.lins = factory.createOne();
            this.poly = factory.createOne();
            this.ring = this.poly.ring;
        }

        public InterpolationZp64(int variable, IPolynomialRing<MultivariatePolynomialZp64> factory) {
            this(variable, factory.factory());
        }

        public InterpolationZp64 update(long point, MultivariatePolynomialZp64 value) {
            if (this.points.isEmpty()) {
                this.poly.multiply(value);
                this.points.add(point);
                this.values.add(value);
                this.mixedRadix.add(value.clone());
                return this;
            }
            long reciprocal = this.ring.subtract(point, this.points.get(0));
            MultivariatePolynomialZp64 accumulator = this.mixedRadix.get(0).clone();
            for (int i = 1; i < this.points.size(); ++i) {
                accumulator = (MultivariatePolynomialZp64)accumulator.add(this.mixedRadix.get(i).clone().multiply(reciprocal));
                reciprocal = this.ring.multiply(reciprocal, this.ring.subtract(point, this.points.get(i)));
            }
            if (reciprocal == 0L) {
                throw new IllegalArgumentException("Point " + point + " was already used in interpolation.");
            }
            this.mixedRadix.add(((MultivariatePolynomialZp64)value.clone().subtract(accumulator)).multiply(this.ring.reciprocal(reciprocal)));
            this.lins.multiply(this.lins.createLinear(this.variable, this.ring.negate(this.points.get(this.points.size() - 1)), 1L));
            this.poly.add(this.lins.clone().multiply(this.mixedRadix.get(this.mixedRadix.size() - 1)));
            this.points.add(point);
            this.values.add(value);
            return this;
        }

        public InterpolationZp64 update(long[] points, MultivariatePolynomialZp64[] values) {
            for (int i = 0; i < points.length; ++i) {
                this.update(points[i], values[i]);
            }
            return this;
        }

        public int getVariable() {
            return this.variable;
        }

        public MultivariatePolynomialZp64 getInterpolatingPolynomial() {
            return this.poly;
        }

        public TLongArrayList getPoints() {
            return this.points;
        }

        public List<MultivariatePolynomialZp64> getValues() {
            return this.values;
        }

        public int numberOfPoints() {
            return this.points.size();
        }
    }
}

