/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.univar;

import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.PolynomialFactorDecomposition;
import cc.redberry.rings.poly.Util;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.ModularComposition;
import cc.redberry.rings.poly.univar.UnivariateDivision;
import cc.redberry.rings.poly.univar.UnivariateGCD;
import cc.redberry.rings.poly.univar.UnivariatePolynomialArithmetic;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZp64;
import cc.redberry.rings.poly.univar.UnivariateSquareFreeFactorization;
import java.util.ArrayList;

public final class DistinctDegreeFactorization {
    private static final double SHOUP_BETA = 0.5;
    private static final int DEGREE_SWITCH_TO_SHOUP = 256;

    private DistinctDegreeFactorization() {
    }

    public static PolynomialFactorDecomposition<UnivariatePolynomialZp64> DistinctDegreeFactorizationPlain(UnivariatePolynomialZp64 poly) {
        if (poly.isConstant()) {
            return PolynomialFactorDecomposition.unit(poly);
        }
        long factor = poly.lc();
        UnivariatePolynomialZp64 base = poly.clone().monic();
        UnivariatePolynomialZp64 polyModulus = base.clone();
        if (base.degree <= 1) {
            return PolynomialFactorDecomposition.of((UnivariatePolynomialZp64)base.createConstant(factor), base);
        }
        if (base.isMonomial()) {
            return PolynomialFactorDecomposition.of((UnivariatePolynomialZp64)base.createConstant(factor), base);
        }
        UnivariateDivision.InverseModMonomial<UnivariatePolynomialZp64> invMod = UnivariateDivision.fastDivisionPreConditioning(polyModulus);
        UnivariatePolynomialZp64 exponent = (UnivariatePolynomialZp64)poly.createMonomial(1);
        PolynomialFactorDecomposition<UnivariatePolynomialZp64> result = PolynomialFactorDecomposition.unit((UnivariatePolynomialZp64)poly.createOne());
        int i = 0;
        while (!base.isConstant()) {
            ++i;
            exponent = UnivariatePolynomialArithmetic.polyPowMod(exponent, poly.ring.modulus, polyModulus, invMod, false);
            UnivariatePolynomialZp64 tmpExponent = exponent.clone();
            tmpExponent.ensureCapacity(1);
            tmpExponent.data[1] = base.subtract(tmpExponent.data[1], 1L);
            tmpExponent.fixDegree();
            UnivariatePolynomialZp64 gcd = UnivariateGCD.PolynomialGCD(tmpExponent, base);
            if (!gcd.isConstant()) {
                result.addFactor(gcd.monic(), i);
            }
            base = UnivariateDivision.quotient(base, gcd, false);
            if (base.degree >= 2 * (i + 1)) continue;
            if (base.isConstant()) break;
            result.addFactor(base.monic(), base.degree);
            break;
        }
        return result.setUnit((UnivariatePolynomialZp64)poly.createConstant(factor));
    }

    public static PolynomialFactorDecomposition<UnivariatePolynomialZp64> DistinctDegreeFactorizationPrecomputedExponents(UnivariatePolynomialZp64 poly) {
        if (poly.isConstant()) {
            return PolynomialFactorDecomposition.unit(poly);
        }
        long factor = poly.lc();
        UnivariatePolynomialZp64 base = poly.clone().monic();
        UnivariatePolynomialZp64 polyModulus = base.clone();
        if (base.degree <= 1) {
            return PolynomialFactorDecomposition.of((UnivariatePolynomialZp64)base.createConstant(factor), base);
        }
        if (base.isMonomial()) {
            return PolynomialFactorDecomposition.of((UnivariatePolynomialZp64)base.createConstant(factor), base);
        }
        UnivariateDivision.InverseModMonomial<UnivariatePolynomialZp64> invMod = UnivariateDivision.fastDivisionPreConditioning(polyModulus);
        UnivariatePolynomialZp64 exponent = (UnivariatePolynomialZp64)poly.createMonomial(1);
        PolynomialFactorDecomposition<UnivariatePolynomialZp64> result = PolynomialFactorDecomposition.unit((UnivariatePolynomialZp64)poly.createOne());
        ArrayList<UnivariatePolynomialZp64> xPowers = ModularComposition.xPowers(polyModulus, invMod);
        int i = 0;
        while (!base.isConstant()) {
            ++i;
            exponent = ModularComposition.powModulusMod(exponent, polyModulus, invMod, xPowers);
            UnivariatePolynomialZp64 tmpExponent = exponent.clone();
            tmpExponent.ensureCapacity(1);
            tmpExponent.data[1] = poly.subtract(tmpExponent.data[1], 1L);
            tmpExponent.fixDegree();
            UnivariatePolynomialZp64 gcd = UnivariateGCD.PolynomialGCD(tmpExponent, base);
            if (!gcd.isConstant()) {
                result.addFactor(gcd.monic(), i);
            }
            base = UnivariateDivision.quotient(base, gcd, false);
            if (base.degree >= 2 * (i + 1)) continue;
            if (base.isConstant()) break;
            result.addFactor(base.monic(), base.degree);
            break;
        }
        return result.setUnit((UnivariatePolynomialZp64)poly.createConstant(factor));
    }

    private static <T extends IUnivariatePolynomial<T>> void DistinctDegreeFactorizationShoup(T poly, BabyGiantSteps<T> steps, PolynomialFactorDecomposition<T> result) {
        IPolynomial current = poly.clone();
        for (int j = 1; j <= steps.m; ++j) {
            IUnivariatePolynomial iBase = (IUnivariatePolynomial)poly.createOne();
            for (int i = 0; i <= steps.l - 1; ++i) {
                IUnivariatePolynomial tmp = steps.giantStep(j).clone().subtract((IUnivariatePolynomial)steps.babySteps.get(i));
                iBase = UnivariatePolynomialArithmetic.polyMultiplyMod(iBase, tmp, poly, steps.invMod, false);
            }
            IUnivariatePolynomial gcd = UnivariateGCD.PolynomialGCD(current, iBase);
            if (gcd.isConstant()) continue;
            current = UnivariateDivision.quotient(current, gcd, false);
            for (int i = steps.l - 1; i >= 0; --i) {
                IUnivariatePolynomial tmp = UnivariateGCD.PolynomialGCD(gcd, steps.giantStep(j).clone().subtract((IUnivariatePolynomial)steps.babySteps.get(i)));
                if (!tmp.isConstant()) {
                    result.addFactor((T)((IUnivariatePolynomial)tmp.clone().monic()), steps.l * j - i);
                }
                gcd = UnivariateDivision.quotient(gcd, tmp, false);
            }
            if (current.isOne()) break;
        }
        if (!current.isOne()) {
            result.addFactor((T)((IUnivariatePolynomial)current.monic()), current.degree());
        }
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> PolynomialFactorDecomposition<Poly> DistinctDegreeFactorizationShoup(Poly poly) {
        Util.ensureOverFiniteField(new IPolynomial[]{poly});
        IUnivariatePolynomial factor = (IUnivariatePolynomial)poly.lcAsPoly();
        poly = (IUnivariatePolynomial)poly.clone().monic();
        PolynomialFactorDecomposition<IUnivariatePolynomial> result = PolynomialFactorDecomposition.unit(factor);
        DistinctDegreeFactorization.DistinctDegreeFactorizationShoup(poly, new BabyGiantSteps<Poly>(poly), result);
        return result;
    }

    public static PolynomialFactorDecomposition<UnivariatePolynomialZp64> DistinctDegreeFactorization(UnivariatePolynomialZp64 poly) {
        if (poly.degree < 256) {
            return DistinctDegreeFactorization.DistinctDegreeFactorizationPrecomputedExponents(poly);
        }
        return DistinctDegreeFactorization.DistinctDegreeFactorizationShoup(poly);
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> PolynomialFactorDecomposition<Poly> DistinctDegreeFactorization(Poly poly) {
        Util.ensureOverFiniteField(poly);
        if (poly instanceof UnivariatePolynomialZp64) {
            return DistinctDegreeFactorization.DistinctDegreeFactorization((UnivariatePolynomialZp64)poly);
        }
        return DistinctDegreeFactorization.DistinctDegreeFactorizationShoup(poly);
    }

    static PolynomialFactorDecomposition<UnivariatePolynomialZp64> DistinctDegreeFactorizationComplete(UnivariatePolynomialZp64 poly) {
        PolynomialFactorDecomposition<UnivariatePolynomialZp64> squareFree = UnivariateSquareFreeFactorization.SquareFreeFactorization(poly);
        long overallFactor = ((UnivariatePolynomialZp64)squareFree.unit).lc();
        PolynomialFactorDecomposition<UnivariatePolynomialZp64> result = PolynomialFactorDecomposition.unit((UnivariatePolynomialZp64)poly.createOne());
        for (int i = squareFree.size() - 1; i >= 0; --i) {
            PolynomialFactorDecomposition<UnivariatePolynomialZp64> dd = DistinctDegreeFactorization.DistinctDegreeFactorization((UnivariatePolynomialZp64)squareFree.get(i));
            int nFactors = dd.size();
            for (int j = nFactors - 1; j >= 0; --j) {
                result.addFactor((UnivariatePolynomialZp64)dd.get(j), squareFree.getExponent(i));
            }
            overallFactor = poly.multiply(overallFactor, ((UnivariatePolynomialZp64)dd.unit).lc());
        }
        return result.setUnit((UnivariatePolynomialZp64)poly.createConstant(overallFactor));
    }

    private static final class BabyGiantSteps<Poly extends IUnivariatePolynomial<Poly>> {
        final int l;
        final int m;
        final ArrayList<Poly> babySteps;
        final ArrayList<Poly> giantSteps;
        final UnivariateDivision.InverseModMonomial<Poly> invMod;
        final Poly poly;
        final ArrayList<Poly> hPowers;
        final int tBrentKung;
        Poly xPowerBig;

        public BabyGiantSteps(Poly poly) {
            int n = poly.degree();
            this.l = (int)Math.ceil(Math.pow(1.0 * (double)n, 0.5));
            this.m = (int)Math.ceil(1.0 * (double)n / 2.0 / (double)this.l);
            this.invMod = UnivariateDivision.fastDivisionPreConditioning(poly);
            ArrayList<Poly> xPowers = ModularComposition.xPowers(poly, this.invMod);
            this.babySteps = new ArrayList();
            this.babySteps.add(poly.createMonomial(1));
            IUnivariatePolynomial xPower = (IUnivariatePolynomial)xPowers.get(1);
            this.babySteps.add(xPower);
            for (int i = 0; i <= this.l - 2; ++i) {
                xPower = ModularComposition.powModulusMod(xPower, poly, this.invMod, xPowers);
                this.babySteps.add(xPower);
            }
            this.giantSteps = new ArrayList();
            this.giantSteps.add(poly.createMonomial(1));
            this.giantSteps.add(xPower);
            this.xPowerBig = xPower;
            this.tBrentKung = (int)Math.sqrt(poly.degree());
            this.hPowers = ModularComposition.polyPowers(this.xPowerBig, poly, this.invMod, this.tBrentKung);
            this.poly = poly;
        }

        Poly giantStep(int j) {
            if (this.giantSteps.size() > j) {
                return (Poly)((IUnivariatePolynomial)this.giantSteps.get(j));
            }
            while (j >= this.giantSteps.size()) {
                this.xPowerBig = ModularComposition.compositionBrentKung(this.xPowerBig, this.hPowers, this.poly, this.invMod, this.tBrentKung);
                this.giantSteps.add(this.xPowerBig);
            }
            return (Poly)((IUnivariatePolynomial)this.giantSteps.get(j));
        }
    }
}

