/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.univar;

import cc.redberry.rings.Ring;
import cc.redberry.rings.Rings;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.bigint.BigIntegerUtil;
import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.Util;
import cc.redberry.rings.poly.univar.Conversions64bit;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.ModularComposition;
import cc.redberry.rings.poly.univar.RandomUnivariatePolynomials;
import cc.redberry.rings.poly.univar.UnivariateDivision;
import cc.redberry.rings.poly.univar.UnivariateFactorization;
import cc.redberry.rings.poly.univar.UnivariateGCD;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomialArithmetic;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZp64;
import cc.redberry.rings.primes.SmallPrimes;
import cc.redberry.rings.util.ArraysUtil;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import org.apache.commons.math3.random.RandomGenerator;

public final class IrreduciblePolynomials {
    private IrreduciblePolynomials() {
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> boolean irreducibleQ(Poly poly) {
        if (poly.isOverFiniteField()) {
            return IrreduciblePolynomials.finiteFieldIrreducibleQ(poly);
        }
        return !poly.isMonomial() && UnivariateFactorization.Factor(poly).isTrivial();
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> boolean finiteFieldIrreducibleQ(Poly poly) {
        return IrreduciblePolynomials.finiteFieldIrreducibleBenOr(poly);
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> boolean finiteFieldIrreducibleViaModularComposition(Poly poly) {
        int[] primes;
        Util.ensureOverFiniteField(new IPolynomial[]{poly});
        if (poly.isMonomial()) {
            return false;
        }
        if (Conversions64bit.canConvertToZp64(poly)) {
            return IrreduciblePolynomials.finiteFieldIrreducibleViaModularComposition(Conversions64bit.asOverZp64(poly));
        }
        if (poly.degree() <= 1) {
            return true;
        }
        poly = (IUnivariatePolynomial)poly.clone().monic();
        UnivariateDivision.InverseModMonomial<Poly> invMod = UnivariateDivision.fastDivisionPreConditioning(poly);
        Object xq = UnivariatePolynomialArithmetic.createMonomialMod(poly.coefficientRingCardinality(), poly, invMod);
        TIntObjectHashMap cache = new TIntObjectHashMap();
        int degree = poly.degree();
        Object xqn = IrreduciblePolynomials.composition(xq, degree, poly, invMod, cache);
        assert (xqn.equals(UnivariatePolynomialArithmetic.createMonomialMod(BigIntegerUtil.pow(poly.coefficientRingCardinality(), degree), poly, invMod))) : "\n" + xqn + "\n" + UnivariatePolynomialArithmetic.createMonomialMod(BigIntegerUtil.pow(poly.coefficientRingCardinality(), degree), poly, invMod);
        Object xMonomial = poly.createMonomial(1);
        if (!xqn.equals(xMonomial)) {
            return false;
        }
        for (int prime : primes = ArraysUtil.getSortedDistinct(SmallPrimes.primeFactors(degree))) {
            Object xqp = IrreduciblePolynomials.composition(xq, degree / prime, poly, invMod, cache);
            if (UnivariateGCD.PolynomialGCD((IUnivariatePolynomial)xqp.subtract(xMonomial), poly).isOne()) continue;
            return false;
        }
        return true;
    }

    static <Poly extends IUnivariatePolynomial<Poly>> Poly composition(Poly xq, int exponent, Poly poly, UnivariateDivision.InverseModMonomial<Poly> invMod, TIntObjectMap<Poly> cache) {
        assert (exponent > 0);
        IUnivariatePolynomial cached = (IUnivariatePolynomial)cache.get(exponent);
        if (cached != null) {
            return (Poly)cached;
        }
        Poly result = xq.createMonomial(1);
        Poly k2p = xq;
        int rExp = 0;
        int kExp = 1;
        while (true) {
            if ((exponent & 1) != 0) {
                result = ModularComposition.composition(k2p, result, poly, invMod);
                cache.put(rExp += kExp, result);
            }
            if ((exponent >>= 1) == 0) {
                cache.put(rExp, result);
                return result;
            }
            k2p = ModularComposition.composition(k2p, k2p, poly, invMod);
            cache.put(kExp *= 2, k2p);
        }
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> boolean finiteFieldIrreducibleBenOr(Poly poly) {
        Util.ensureOverFiniteField(new IPolynomial[]{poly});
        if (poly.isMonomial()) {
            return false;
        }
        if (Conversions64bit.canConvertToZp64(poly)) {
            return IrreduciblePolynomials.finiteFieldIrreducibleBenOr(Conversions64bit.asOverZp64(poly));
        }
        if (!poly.isMonic()) {
            poly = (IUnivariatePolynomial)poly.clone().monic();
        }
        UnivariateDivision.InverseModMonomial<Poly> invMod = UnivariateDivision.fastDivisionPreConditioning(poly);
        Poly xMonomial = poly.createMonomial(1);
        Object xq = xMonomial.clone();
        for (int i = 1; i <= poly.degree() / 2; ++i) {
            if (UnivariateGCD.PolynomialGCD((IUnivariatePolynomial)(xq = UnivariatePolynomialArithmetic.polyPowMod(xq, poly.coefficientRingCardinality(), poly, invMod, false)).clone().subtract(xMonomial), poly).isOne()) continue;
            return false;
        }
        return true;
    }

    public static UnivariatePolynomialZp64 randomIrreduciblePolynomial(long modulus, int degree, RandomGenerator rnd) {
        return IrreduciblePolynomials.randomIrreduciblePolynomial(UnivariatePolynomialZp64.zero(modulus), degree, rnd);
    }

    public static <E> UnivariatePolynomial<E> randomIrreduciblePolynomial(Ring<E> ring, int degree, RandomGenerator rnd) {
        UnivariatePolynomial<E> poly;
        do {
            poly = RandomUnivariatePolynomials.randomPoly(degree, ring, rnd);
            if (!ring.isField()) continue;
            poly.monic();
        } while (!IrreduciblePolynomials.irreducibleQ(poly));
        assert (poly.degree == degree);
        return poly;
    }

    public static UnivariatePolynomial<BigInteger> randomIrreduciblePolynomialOverZ(int degree, RandomGenerator rnd) {
        long modulus = SmallPrimes.nextPrime(0x2000000);
        return IrreduciblePolynomials.randomIrreduciblePolynomial(modulus, degree, rnd).toBigPoly().setRing(Rings.Z);
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> Poly randomIrreduciblePolynomial(Poly factory, int degree, RandomGenerator rnd) {
        Poly poly;
        while (!IrreduciblePolynomials.irreducibleQ(poly = RandomUnivariatePolynomials.randomPoly(factory, degree, rnd))) {
        }
        assert (poly.degree() == degree);
        return poly;
    }
}

