/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.univar;

import cc.redberry.libdivide4j.FastDivision;
import cc.redberry.rings.IntegersZp64;
import cc.redberry.rings.Ring;
import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.MachineArithmetic;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZ64;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZp64;
import java.io.Serializable;
import java.util.ArrayList;

public final class UnivariateDivision {
    private UnivariateDivision() {
    }

    public static <T extends IUnivariatePolynomial<T>> T remainderMonomial(T dividend, int xDegree, boolean copy) {
        return (T)(copy ? dividend.clone() : dividend).truncate(xDegree - 1);
    }

    private static void checkZeroDivider(IUnivariatePolynomial p) {
        if (p.isZero()) {
            throw new ArithmeticException("divide by zero");
        }
    }

    public static UnivariatePolynomialZ64[] divideAndRemainder(UnivariatePolynomialZ64 dividend, UnivariatePolynomialZ64 divider, boolean copy) {
        UnivariateDivision.checkZeroDivider(divider);
        if (dividend.isZero()) {
            return new UnivariatePolynomialZ64[]{UnivariatePolynomialZ64.zero(), UnivariatePolynomialZ64.zero()};
        }
        if (dividend.degree < divider.degree) {
            return new UnivariatePolynomialZ64[]{UnivariatePolynomialZ64.zero(), copy ? dividend.clone() : dividend};
        }
        if (divider.degree == 0) {
            UnivariatePolynomialZ64 div = copy ? dividend.clone() : dividend;
            if ((div = div.divideOrNull(divider.lc())) == null) {
                return null;
            }
            return new UnivariatePolynomialZ64[]{div, UnivariatePolynomialZ64.zero()};
        }
        if (divider.degree == 1) {
            return UnivariateDivision.divideAndRemainderLinearDivider(dividend, divider, copy);
        }
        return UnivariateDivision.divideAndRemainderClassic0(dividend, divider, 1L, copy);
    }

    public static UnivariatePolynomialZ64[] pseudoDivideAndRemainder(UnivariatePolynomialZ64 dividend, UnivariatePolynomialZ64 divider, boolean copy) {
        UnivariateDivision.checkZeroDivider(divider);
        if (dividend.isZero()) {
            return new UnivariatePolynomialZ64[]{UnivariatePolynomialZ64.zero(), UnivariatePolynomialZ64.zero()};
        }
        if (dividend.degree < divider.degree) {
            return new UnivariatePolynomialZ64[]{UnivariatePolynomialZ64.zero(), copy ? dividend.clone() : dividend};
        }
        long factor = MachineArithmetic.safePow(divider.lc(), dividend.degree - divider.degree + 1);
        if (divider.degree == 0) {
            return new UnivariatePolynomialZ64[]{(UnivariatePolynomialZ64)(copy ? dividend.clone() : dividend).multiply(factor / divider.lc()), UnivariatePolynomialZ64.zero()};
        }
        if (divider.degree == 1) {
            return UnivariateDivision.divideAndRemainderLinearDivider0(dividend, divider, factor, copy);
        }
        return UnivariateDivision.divideAndRemainderClassic0(dividend, divider, factor, copy);
    }

    static UnivariatePolynomialZ64[] divideAndRemainderClassic0(UnivariatePolynomialZ64 dividend, UnivariatePolynomialZ64 divider, long dividendRaiseFactor, boolean copy) {
        assert (dividend.degree >= divider.degree);
        if (divider.lc() == 1L && dividendRaiseFactor == 1L) {
            return UnivariateDivision.divideAndRemainderClassicMonic(dividend, divider, copy);
        }
        UnivariatePolynomialZ64 remainder = (UnivariatePolynomialZ64)(copy ? dividend.clone() : dividend).multiply(dividendRaiseFactor);
        long[] quotient = new long[dividend.degree - divider.degree + 1];
        FastDivision.Magic magic = FastDivision.magicSigned(divider.lc());
        for (int i = dividend.degree - divider.degree; i >= 0; --i) {
            if (remainder.degree == divider.degree + i) {
                long quot = FastDivision.divideSignedFast(remainder.lc(), magic);
                if (quot * divider.lc() != remainder.lc()) {
                    return null;
                }
                quotient[i] = quot;
                remainder.subtract(divider, quotient[i], i);
                continue;
            }
            quotient[i] = 0L;
        }
        return new UnivariatePolynomialZ64[]{UnivariatePolynomialZ64.create(quotient), remainder};
    }

    private static UnivariatePolynomialZ64[] divideAndRemainderClassicMonic(UnivariatePolynomialZ64 dividend, UnivariatePolynomialZ64 divider, boolean copy) {
        assert (divider.lc() == 1L);
        UnivariatePolynomialZ64 remainder = copy ? dividend.clone() : dividend;
        long[] quotient = new long[dividend.degree - divider.degree + 1];
        for (int i = dividend.degree - divider.degree; i >= 0; --i) {
            if (remainder.degree == divider.degree + i) {
                quotient[i] = remainder.lc();
                remainder.subtract(divider, quotient[i], i);
                continue;
            }
            quotient[i] = 0L;
        }
        return new UnivariatePolynomialZ64[]{UnivariatePolynomialZ64.create(quotient), remainder};
    }

    static UnivariatePolynomialZ64[] pseudoDivideAndRemainderAdaptive(UnivariatePolynomialZ64 dividend, UnivariatePolynomialZ64 divider, boolean copy) {
        UnivariateDivision.checkZeroDivider(divider);
        if (dividend.isZero()) {
            return new UnivariatePolynomialZ64[]{UnivariatePolynomialZ64.zero(), UnivariatePolynomialZ64.zero()};
        }
        if (dividend.degree < divider.degree) {
            return new UnivariatePolynomialZ64[]{UnivariatePolynomialZ64.zero(), copy ? dividend.clone() : dividend};
        }
        if (divider.degree == 0) {
            return new UnivariatePolynomialZ64[]{copy ? dividend.clone() : dividend, UnivariatePolynomialZ64.zero()};
        }
        if (divider.degree == 1) {
            return UnivariateDivision.pseudoDivideAndRemainderLinearDividerAdaptive(dividend, divider, copy);
        }
        return UnivariateDivision.pseudoDivideAndRemainderAdaptive0(dividend, divider, copy);
    }

    static UnivariatePolynomialZ64[] pseudoDivideAndRemainderAdaptive0(UnivariatePolynomialZ64 dividend, UnivariatePolynomialZ64 divider, boolean copy) {
        assert (dividend.degree >= divider.degree);
        UnivariatePolynomialZ64 remainder = copy ? dividend.clone() : dividend;
        long[] quotient = new long[dividend.degree - divider.degree + 1];
        FastDivision.Magic magic = FastDivision.magicSigned(divider.lc());
        for (int i = dividend.degree - divider.degree; i >= 0; --i) {
            if (remainder.degree == divider.degree + i) {
                long quot = FastDivision.divideSignedFast(remainder.lc(), magic);
                if (quot * divider.lc() != remainder.lc()) {
                    long gcd = MachineArithmetic.gcd(remainder.lc(), divider.lc());
                    long factor = divider.lc() / gcd;
                    remainder.multiply(factor);
                    for (int j = i + 1; j < quotient.length; ++j) {
                        quotient[j] = MachineArithmetic.safeMultiply(quotient[j], factor);
                    }
                    quot = FastDivision.divideSignedFast(remainder.lc(), magic);
                }
                quotient[i] = quot;
                remainder.subtract(divider, quotient[i], i);
                continue;
            }
            quotient[i] = 0L;
        }
        return new UnivariatePolynomialZ64[]{UnivariatePolynomialZ64.create(quotient), remainder};
    }

    static UnivariatePolynomialZ64[] pseudoDivideAndRemainderLinearDividerAdaptive(UnivariatePolynomialZ64 dividend, UnivariatePolynomialZ64 divider, boolean copy) {
        assert (divider.degree == 1);
        long cc = -divider.cc();
        long lc = divider.lc();
        long factor = 1L;
        long[] quotient = copy ? new long[dividend.degree] : dividend.data;
        long res = 0L;
        FastDivision.Magic magic = FastDivision.magicSigned(lc);
        int i = dividend.degree;
        while (true) {
            long tmp = dividend.data[i];
            if (i != dividend.degree) {
                quotient[i] = res;
            }
            res = MachineArithmetic.safeAdd(MachineArithmetic.safeMultiply(res, cc), MachineArithmetic.safeMultiply(factor, tmp));
            if (i == 0) break;
            long quot = FastDivision.divideSignedFast(res, magic);
            if (quot * lc != res) {
                long gcd = MachineArithmetic.gcd(res, lc);
                long f = lc / gcd;
                factor = MachineArithmetic.safeMultiply(factor, f);
                res = MachineArithmetic.safeMultiply(res, f);
                if (i != dividend.degree) {
                    for (int j = quotient.length - 1; j >= i; --j) {
                        quotient[j] = MachineArithmetic.safeMultiply(quotient[j], f);
                    }
                }
                quot = FastDivision.divideSignedFast(res, magic);
            }
            res = quot;
            --i;
        }
        if (!copy) {
            quotient[dividend.degree] = 0L;
        }
        return new UnivariatePolynomialZ64[]{UnivariatePolynomialZ64.create(quotient), UnivariatePolynomialZ64.create(res)};
    }

    static UnivariatePolynomialZ64[] divideAndRemainderLinearDivider(UnivariatePolynomialZ64 dividend, UnivariatePolynomialZ64 divider, boolean copy) {
        return UnivariateDivision.divideAndRemainderLinearDivider0(dividend, divider, 1L, copy);
    }

    static UnivariatePolynomialZ64[] pseudoDivideAndRemainderLinearDivider(UnivariatePolynomialZ64 dividend, UnivariatePolynomialZ64 divider, boolean copy) {
        return UnivariateDivision.divideAndRemainderLinearDivider0(dividend, divider, MachineArithmetic.safePow(divider.lc(), dividend.degree), copy);
    }

    static UnivariatePolynomialZ64[] divideAndRemainderLinearDivider0(UnivariatePolynomialZ64 dividend, UnivariatePolynomialZ64 divider, long raiseFactor, boolean copy) {
        assert (divider.degree == 1);
        long cc = -divider.cc();
        long lc = divider.lc();
        long[] quotient = copy ? new long[dividend.degree] : dividend.data;
        long res = 0L;
        FastDivision.Magic magic = FastDivision.magicSigned(lc);
        int i = dividend.degree;
        while (true) {
            long tmp = dividend.data[i];
            if (i != dividend.degree) {
                quotient[i] = res;
            }
            res = MachineArithmetic.safeAdd(MachineArithmetic.safeMultiply(res, cc), MachineArithmetic.safeMultiply(raiseFactor, tmp));
            if (i == 0) break;
            long quot = FastDivision.divideSignedFast(res, magic);
            if (quot * lc != res) {
                return null;
            }
            res = quot;
            --i;
        }
        if (!copy) {
            quotient[dividend.degree] = 0L;
        }
        return new UnivariatePolynomialZ64[]{UnivariatePolynomialZ64.create(quotient), UnivariatePolynomialZ64.create(res)};
    }

    public static UnivariatePolynomialZ64 remainder(UnivariatePolynomialZ64 dividend, UnivariatePolynomialZ64 divider, boolean copy) {
        UnivariateDivision.checkZeroDivider(divider);
        if (dividend.degree < divider.degree) {
            return dividend;
        }
        if (divider.degree == 0) {
            return UnivariatePolynomialZ64.zero();
        }
        if (divider.degree == 1 && divider.cc() % divider.lc() == 0L) {
            return UnivariatePolynomialZ64.create(dividend.evaluate(-divider.cc() / divider.lc()));
        }
        return UnivariateDivision.remainder0(dividend, divider, copy);
    }

    static UnivariatePolynomialZ64 remainder0(UnivariatePolynomialZ64 dividend, UnivariatePolynomialZ64 divider, boolean copy) {
        assert (dividend.degree >= divider.degree);
        UnivariatePolynomialZ64 remainder = copy ? dividend.clone() : dividend;
        FastDivision.Magic magic = FastDivision.magicSigned(divider.lc());
        for (int i = dividend.degree - divider.degree; i >= 0; --i) {
            if (remainder.degree != divider.degree + i) continue;
            long quot = FastDivision.divideSignedFast(remainder.lc(), magic);
            if (quot * divider.lc() != remainder.lc()) {
                return null;
            }
            remainder.subtract(divider, quot, i);
        }
        return remainder;
    }

    public static UnivariatePolynomialZ64 quotient(UnivariatePolynomialZ64 dividend, UnivariatePolynomialZ64 divider, boolean copy) {
        UnivariatePolynomialZ64[] qd = UnivariateDivision.divideAndRemainder(dividend, divider, copy);
        if (qd == null) {
            return null;
        }
        return qd[0];
    }

    private static boolean useClassicalDivision(IUnivariatePolynomial dividend, IUnivariatePolynomial divider) {
        return true;
    }

    private static UnivariatePolynomialZp64[] earlyDivideAndRemainderChecks(UnivariatePolynomialZp64 dividend, UnivariatePolynomialZp64 divider, boolean copy) {
        UnivariateDivision.checkZeroDivider(divider);
        if (dividend.isZero()) {
            return new UnivariatePolynomialZp64[]{(UnivariatePolynomialZp64)dividend.createZero(), (UnivariatePolynomialZp64)dividend.createZero()};
        }
        if (dividend.degree < divider.degree) {
            return new UnivariatePolynomialZp64[]{(UnivariatePolynomialZp64)dividend.createZero(), copy ? dividend.clone() : dividend};
        }
        if (divider.degree == 0) {
            return new UnivariatePolynomialZp64[]{(copy ? dividend.clone() : dividend).divide(divider.lc()), (UnivariatePolynomialZp64)dividend.createZero()};
        }
        if (divider.degree == 1) {
            return UnivariateDivision.divideAndRemainderLinearDividerModulus(dividend, divider, copy);
        }
        return null;
    }

    public static UnivariatePolynomialZp64[] divideAndRemainder(UnivariatePolynomialZp64 dividend, UnivariatePolynomialZp64 divider, boolean copy) {
        UnivariatePolynomialZp64[] r = UnivariateDivision.earlyDivideAndRemainderChecks(dividend, divider, copy);
        if (r != null) {
            return r;
        }
        if (UnivariateDivision.useClassicalDivision(dividend, divider)) {
            return UnivariateDivision.divideAndRemainderClassic0(dividend, divider, copy);
        }
        return UnivariateDivision.divideAndRemainderFast0(dividend, divider, copy);
    }

    public static UnivariatePolynomialZp64[] divideAndRemainderClassic(UnivariatePolynomialZp64 dividend, UnivariatePolynomialZp64 divider, boolean copy) {
        UnivariatePolynomialZp64[] r = UnivariateDivision.earlyDivideAndRemainderChecks(dividend, divider, copy);
        if (r != null) {
            return r;
        }
        return UnivariateDivision.divideAndRemainderClassic0(dividend, divider, copy);
    }

    static UnivariatePolynomialZp64[] divideAndRemainderClassic0(UnivariatePolynomialZp64 dividend, UnivariatePolynomialZp64 divider, boolean copy) {
        assert (dividend.degree >= divider.degree);
        dividend.assertSameCoefficientRingWith(divider);
        UnivariatePolynomialZp64 remainder = copy ? dividend.clone() : dividend;
        long[] quotient = new long[dividend.degree - divider.degree + 1];
        long lcInverse = dividend.ring.reciprocal(divider.lc());
        for (int i = dividend.degree - divider.degree; i >= 0; --i) {
            if (remainder.degree == divider.degree + i) {
                quotient[i] = remainder.ring.multiply(remainder.lc(), lcInverse);
                remainder.subtract(divider, quotient[i], i);
                continue;
            }
            quotient[i] = 0L;
        }
        return new UnivariatePolynomialZp64[]{dividend.createFromArray(quotient), remainder};
    }

    static UnivariatePolynomialZp64[] divideAndRemainderLinearDividerModulus(UnivariatePolynomialZp64 dividend, UnivariatePolynomialZp64 divider, boolean copy) {
        assert (divider.degree == 1);
        assert (dividend.degree > 0);
        dividend.assertSameCoefficientRingWith(divider);
        long cc = dividend.ring.negate(divider.cc());
        long lcInverse = dividend.ring.reciprocal(divider.lc());
        if (divider.lc() != 1L) {
            cc = dividend.ring.multiply(cc, lcInverse);
        }
        long[] quotient = copy ? new long[dividend.degree] : dividend.data;
        long res = 0L;
        for (int i = dividend.degree; i >= 0; --i) {
            long tmp = dividend.data[i];
            if (i != dividend.degree) {
                quotient[i] = dividend.ring.multiply(res, lcInverse);
            }
            res = dividend.ring.add(dividend.ring.multiply(res, cc), tmp);
        }
        if (!copy) {
            quotient[dividend.degree] = 0L;
        }
        return new UnivariatePolynomialZp64[]{dividend.createFromArray(quotient), dividend.createFromArray(new long[]{res})};
    }

    private static <E> UnivariatePolynomial<E>[] earlyDivideAndRemainderChecks(UnivariatePolynomial<E> dividend, UnivariatePolynomial<E> divider, boolean copy) {
        UnivariateDivision.checkZeroDivider(divider);
        if (dividend.isZero()) {
            return dividend.createArray((UnivariatePolynomial<E>)dividend.createZero(), (UnivariatePolynomial<E>)dividend.createZero());
        }
        if (dividend.degree < divider.degree) {
            return dividend.createArray((UnivariatePolynomial<E>)dividend.createZero(), (UnivariatePolynomial<E>)(copy ? dividend.clone() : dividend));
        }
        if (divider.degree == 0) {
            UnivariatePolynomial<E> div = copy ? dividend.clone() : dividend;
            if ((div = div.divideOrNull(divider.lc())) == null) {
                return null;
            }
            return dividend.createArray(div, (UnivariatePolynomial<E>)dividend.createZero());
        }
        if (divider.degree == 1) {
            return UnivariateDivision.divideAndRemainderLinearDivider(dividend, divider, copy);
        }
        return null;
    }

    public static <E> UnivariatePolynomial<E>[] divideAndRemainder(UnivariatePolynomial<E> dividend, UnivariatePolynomial<E> divider, boolean copy) {
        UnivariatePolynomial<E>[] r = UnivariateDivision.earlyDivideAndRemainderChecks(dividend, divider, copy);
        if (r != null) {
            return r;
        }
        if (UnivariateDivision.useClassicalDivision(dividend, divider)) {
            return UnivariateDivision.divideAndRemainderClassic0(dividend, divider, dividend.ring.getOne(), copy);
        }
        return UnivariateDivision.divideAndRemainderFast0(dividend, divider, copy);
    }

    public static <E> UnivariatePolynomial<E>[] pseudoDivideAndRemainder(UnivariatePolynomial<E> dividend, UnivariatePolynomial<E> divider, boolean copy) {
        UnivariateDivision.checkZeroDivider(divider);
        if (dividend.isZero()) {
            return dividend.createArray(dividend.createZero(), dividend.createZero());
        }
        if (dividend.degree < divider.degree) {
            return dividend.createArray(dividend.createZero(), copy ? dividend.clone() : dividend);
        }
        Object factor = dividend.ring.pow(divider.lc(), dividend.degree - divider.degree + 1);
        if (divider.degree == 0) {
            return dividend.createArray(((UnivariatePolynomial)(copy ? dividend.clone() : dividend)).multiply(dividend.ring.divideExact(factor, divider.lc())), dividend.createZero());
        }
        if (divider.degree == 1) {
            return UnivariateDivision.divideAndRemainderLinearDivider0(dividend, divider, factor, copy);
        }
        return UnivariateDivision.divideAndRemainderClassic0(dividend, divider, factor, copy);
    }

    public static <E> UnivariatePolynomial<E>[] divideAndRemainderClassic(UnivariatePolynomial<E> dividend, UnivariatePolynomial<E> divider, boolean copy) {
        UnivariatePolynomial<E>[] r = UnivariateDivision.earlyDivideAndRemainderChecks(dividend, divider, copy);
        if (r != null) {
            return r;
        }
        return UnivariateDivision.divideAndRemainderClassic0(dividend, divider, dividend.ring.getOne(), copy);
    }

    static <E> UnivariatePolynomial<E>[] divideAndRemainderClassic0(UnivariatePolynomial<E> dividend, UnivariatePolynomial<E> divider, E dividendRaiseFactor, boolean copy) {
        E lcDivider;
        Object lcMultiplier;
        assert (dividend.degree >= divider.degree);
        Ring ring = dividend.ring;
        UnivariatePolynomial<int> remainder = ((UnivariatePolynomial)(copy ? dividend.clone() : dividend)).multiply(dividendRaiseFactor);
        int[] quotient = ring.createArray(dividend.degree - divider.degree + 1);
        if (ring.isField()) {
            lcMultiplier = ring.reciprocal(divider.lc());
            lcDivider = ring.getOne();
        } else {
            lcMultiplier = ring.getOne();
            lcDivider = divider.lc();
        }
        for (int i = dividend.degree - divider.degree; i >= 0; --i) {
            if (remainder.degree == divider.degree + i) {
                Object quot = ring.divideOrNull(ring.multiply(remainder.lc(), lcMultiplier), lcDivider);
                if (quot == null) {
                    return null;
                }
                quotient[i] = (int)quot;
                remainder.subtract(divider, quotient[i], i);
                continue;
            }
            quotient[i] = (int)ring.getZero();
        }
        return dividend.createArray(dividend.createFromArray(quotient), remainder);
    }

    static <E> UnivariatePolynomial<E>[] divideAndRemainderLinearDivider(UnivariatePolynomial<E> dividend, UnivariatePolynomial<E> divider, boolean copy) {
        return UnivariateDivision.divideAndRemainderLinearDivider0(dividend, divider, dividend.ring.getOne(), copy);
    }

    static <E> UnivariatePolynomial<E>[] pseudoDivideAndRemainderLinearDivider(UnivariatePolynomial<E> dividend, UnivariatePolynomial<E> divider, boolean copy) {
        return UnivariateDivision.divideAndRemainderLinearDivider0(dividend, divider, dividend.ring.pow(divider.lc(), dividend.degree), copy);
    }

    static <E> UnivariatePolynomial<E>[] divideAndRemainderLinearDivider0(UnivariatePolynomial<E> dividend, UnivariatePolynomial<E> divider, E raiseFactor, boolean copy) {
        E lcDivider;
        Object lcMultiplier;
        assert (divider.degree == 1);
        assert (dividend.degree > 0);
        dividend.assertSameCoefficientRingWith(divider);
        Ring ring = dividend.ring;
        Object cc = ring.negate(divider.cc());
        if (ring.isField()) {
            lcMultiplier = ring.reciprocal(divider.lc());
            lcDivider = ring.getOne();
        } else {
            lcMultiplier = ring.getOne();
            lcDivider = divider.lc();
        }
        E[] quotient = copy ? (Object[])ring.createArray(dividend.degree) : dividend.data;
        Object res = ring.getZero();
        int i = dividend.degree;
        while (true) {
            Object tmp = dividend.data[i];
            if (i != dividend.degree) {
                quotient[i] = ring.copy(res);
            }
            res = ring.addMutable(ring.multiplyMutable(res, cc), ring.multiply(raiseFactor, tmp));
            if (i == 0) break;
            Object quot = ring.divideOrNull(ring.multiply(res, lcMultiplier), lcDivider);
            if (quot == null) {
                return null;
            }
            res = quot;
            --i;
        }
        if (!copy) {
            quotient[dividend.degree] = ring.getZero();
        }
        return dividend.createArray(dividend.createFromArray(quotient), dividend.createConstant(res));
    }

    static <E> UnivariatePolynomial<E>[] pseudoDivideAndRemainderAdaptive(UnivariatePolynomial<E> dividend, UnivariatePolynomial<E> divider, boolean copy) {
        UnivariateDivision.checkZeroDivider(divider);
        if (dividend.isZero()) {
            return new UnivariatePolynomial[]{UnivariatePolynomial.zero(dividend.ring), UnivariatePolynomial.zero(dividend.ring)};
        }
        if (dividend.degree < divider.degree) {
            return new UnivariatePolynomial[]{UnivariatePolynomial.zero(dividend.ring), copy ? dividend.clone() : dividend};
        }
        if (divider.degree == 0) {
            return new UnivariatePolynomial[]{copy ? dividend.clone() : dividend, UnivariatePolynomial.zero(dividend.ring)};
        }
        if (divider.degree == 1) {
            return UnivariateDivision.pseudoDivideAndRemainderLinearDividerAdaptive(dividend, divider, copy);
        }
        return UnivariateDivision.pseudoDivideAndRemainderAdaptive0(dividend, divider, copy);
    }

    static <E> UnivariatePolynomial<E>[] pseudoDivideAndRemainderAdaptive0(UnivariatePolynomial<E> dividend, UnivariatePolynomial<E> divider, boolean copy) {
        assert (dividend.degree >= divider.degree);
        Ring ring = dividend.ring;
        Object remainder = copy ? dividend.clone() : dividend;
        int[] quotient = ring.createArray(dividend.degree - divider.degree + 1);
        E dlc = divider.lc();
        for (int i = dividend.degree - divider.degree; i >= 0; --i) {
            if (((UnivariatePolynomial)remainder).degree == divider.degree + i) {
                Object quot = ring.divideOrNull(((UnivariatePolynomial)remainder).lc(), dlc);
                if (quot == null) {
                    Object gcd = ring.gcd(((UnivariatePolynomial)remainder).lc(), divider.lc());
                    Object factor = ring.divideExact(divider.lc(), gcd);
                    ((UnivariatePolynomial)remainder).multiply(factor);
                    for (int j = i + 1; j < quotient.length; ++j) {
                        quotient[j] = ring.multiply(quotient[j], factor);
                    }
                    quot = ring.divideExact(((UnivariatePolynomial)remainder).lc(), dlc);
                }
                quotient[i] = (int)quot;
                ((UnivariatePolynomial)remainder).subtract(divider, quotient[i], i);
                continue;
            }
            quotient[i] = (int)ring.getZero();
        }
        return new UnivariatePolynomial[]{UnivariatePolynomial.create(ring, quotient), remainder};
    }

    static <E> UnivariatePolynomial<E>[] pseudoDivideAndRemainderLinearDividerAdaptive(UnivariatePolynomial<E> dividend, UnivariatePolynomial<E> divider, boolean copy) {
        assert (divider.degree == 1);
        Ring ring = dividend.ring;
        Object cc = ring.negate(divider.cc());
        E lc = divider.lc();
        Object factor = ring.getOne();
        E[] quotient = copy ? (Object[])ring.createArray(dividend.degree) : dividend.data;
        Object res = ring.getZero();
        int i = dividend.degree;
        while (true) {
            Object tmp = dividend.data[i];
            if (i != dividend.degree) {
                quotient[i] = res;
            }
            res = ring.add(ring.multiply(res, cc), ring.multiply(factor, tmp));
            if (i == 0) break;
            Object quot = ring.divideOrNull(res, lc);
            if (quot == null) {
                Object gcd = ring.gcd(res, lc);
                Object f = ring.divideExact(lc, gcd);
                factor = ring.multiply(factor, f);
                res = ring.multiply(res, f);
                if (i != dividend.degree) {
                    for (int j = quotient.length - 1; j >= i; --j) {
                        quotient[j] = ring.multiply(quotient[j], f);
                    }
                }
                quot = ring.divideExact(res, lc);
            }
            res = quot;
            --i;
        }
        if (!copy) {
            quotient[dividend.degree] = ring.getZero();
        }
        return new UnivariatePolynomial[]{UnivariatePolynomial.create(ring, quotient), UnivariatePolynomial.create(ring, res)};
    }

    static <E> UnivariatePolynomial<E> pseudoRemainderAdaptive(UnivariatePolynomial<E> dividend, UnivariatePolynomial<E> divider, boolean copy) {
        UnivariateDivision.checkZeroDivider(divider);
        if (dividend.isZero()) {
            return UnivariatePolynomial.zero(dividend.ring);
        }
        if (dividend.degree < divider.degree) {
            return copy ? dividend.clone() : dividend;
        }
        if (divider.degree == 0) {
            return UnivariatePolynomial.zero(dividend.ring);
        }
        if (divider.degree == 1) {
            return UnivariateDivision.pseudoRemainderLinearDividerAdaptive(dividend, divider, copy);
        }
        return UnivariateDivision.pseudoRemainderAdaptive0(dividend, divider, copy);
    }

    static <E> UnivariatePolynomial<E> pseudoRemainderAdaptive0(UnivariatePolynomial<E> dividend, UnivariatePolynomial<E> divider, boolean copy) {
        assert (dividend.degree >= divider.degree);
        Ring ring = dividend.ring;
        Object remainder = copy ? dividend.clone() : dividend;
        E dlc = divider.lc();
        for (int i = dividend.degree - divider.degree; i >= 0; --i) {
            if (((UnivariatePolynomial)remainder).degree != divider.degree + i) continue;
            Object quot = ring.divideOrNull(((UnivariatePolynomial)remainder).lc(), dlc);
            if (quot == null) {
                Object gcd = ring.gcd(((UnivariatePolynomial)remainder).lc(), divider.lc());
                Object factor = ring.divideExact(divider.lc(), gcd);
                ((UnivariatePolynomial)remainder).multiply(factor);
                quot = ring.divideExact(((UnivariatePolynomial)remainder).lc(), dlc);
            }
            ((UnivariatePolynomial)remainder).subtract(divider, quot, i);
        }
        return remainder;
    }

    static <E> UnivariatePolynomial<E> pseudoRemainderLinearDividerAdaptive(UnivariatePolynomial<E> dividend, UnivariatePolynomial<E> divider, boolean copy) {
        assert (divider.degree == 1);
        Ring ring = dividend.ring;
        Object cc = ring.negate(divider.cc());
        E lc = divider.lc();
        Object factor = ring.getOne();
        Object res = ring.getZero();
        int i = dividend.degree;
        while (true) {
            Object tmp = dividend.data[i];
            res = ring.add(ring.multiply(res, cc), ring.multiply(factor, tmp));
            if (i == 0) break;
            Object quot = ring.divideOrNull(res, lc);
            if (quot == null) {
                Object gcd = ring.gcd(res, lc);
                Object f = ring.divideExact(lc, gcd);
                factor = ring.multiply(factor, f);
                res = ring.multiply(res, f);
                quot = ring.divideExact(res, lc);
            }
            res = quot;
            --i;
        }
        return UnivariatePolynomial.create(ring, res);
    }

    static int log2(int l) {
        if (l <= 0) {
            throw new IllegalArgumentException();
        }
        return 33 - Integer.numberOfLeadingZeros(l - 1);
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> InverseModMonomial<Poly> fastDivisionPreConditioning(Poly divider) {
        if (!divider.isMonic()) {
            throw new IllegalArgumentException("Only monic polynomials allowed. Input: " + divider);
        }
        return new InverseModMonomial((IUnivariatePolynomial)divider.clone().reverse(), null);
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> InverseModMonomial<Poly> fastDivisionPreConditioningWithLCCorrection(Poly divider) {
        return new InverseModMonomial((IUnivariatePolynomial)((IUnivariatePolynomial)divider.clone().monic()).reverse(), null);
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> Poly[] divideAndRemainderFast0(Poly dividend, Poly divider, InverseModMonomial<Poly> invRevMod, boolean copy) {
        int m = dividend.degree() - divider.degree();
        Object q = UnivariateDivision.remainderMonomial((IUnivariatePolynomial)dividend.clone().reverse().multiply(invRevMod.getInverse(m + 1)), m + 1, false).reverse();
        if (q.degree() < m) {
            q.shiftRight(m - q.degree());
        }
        IUnivariatePolynomial r = (copy ? dividend.clone() : dividend).subtract((IUnivariatePolynomial)((IUnivariatePolynomial)divider.clone().multiply(q)));
        return (IUnivariatePolynomial[])dividend.createArray((IPolynomial)q, r);
    }

    public static UnivariatePolynomialZp64[] divideAndRemainderFast(UnivariatePolynomialZp64 dividend, UnivariatePolynomialZp64 divider, boolean copy) {
        UnivariatePolynomialZp64[] r = UnivariateDivision.earlyDivideAndRemainderChecks(dividend, divider, copy);
        if (r != null) {
            return r;
        }
        return UnivariateDivision.divideAndRemainderFast0(dividend, divider, copy);
    }

    public static UnivariatePolynomialZp64[] divideAndRemainderFast(UnivariatePolynomialZp64 dividend, UnivariatePolynomialZp64 divider, InverseModMonomial<UnivariatePolynomialZp64> invMod, boolean copy) {
        UnivariatePolynomialZp64[] r = UnivariateDivision.earlyDivideAndRemainderChecks(dividend, divider, copy);
        if (r != null) {
            return r;
        }
        return UnivariateDivision.divideAndRemainderFastCorrectLC(dividend, divider, invMod, copy);
    }

    static UnivariatePolynomialZp64[] divideAndRemainderFastCorrectLC(UnivariatePolynomialZp64 dividend, UnivariatePolynomialZp64 divider, InverseModMonomial<UnivariatePolynomialZp64> invMod, boolean copy) {
        if (divider.isMonic()) {
            return (UnivariatePolynomialZp64[])UnivariateDivision.divideAndRemainderFast0((IUnivariatePolynomial)dividend, (IUnivariatePolynomial)divider, invMod, (boolean)copy);
        }
        long lc = divider.lc();
        long lcInv = divider.ring.reciprocal(lc);
        divider.multiply(lcInv);
        UnivariatePolynomialZp64[] result = (UnivariatePolynomialZp64[])UnivariateDivision.divideAndRemainderFast0((IUnivariatePolynomial)dividend, (IUnivariatePolynomial)divider, invMod, (boolean)copy);
        divider.multiply(lc);
        result[0].multiply(lcInv);
        return result;
    }

    static UnivariatePolynomialZp64[] divideAndRemainderFast0(UnivariatePolynomialZp64 dividend, UnivariatePolynomialZp64 divider, boolean copy) {
        if (divider.isMonic()) {
            return (UnivariatePolynomialZp64[])UnivariateDivision.divideAndRemainderFast0((IUnivariatePolynomial)dividend, (IUnivariatePolynomial)divider, UnivariateDivision.fastDivisionPreConditioning(divider), (boolean)copy);
        }
        long lc = divider.lc();
        long lcInv = divider.ring.reciprocal(lc);
        divider.multiply(lcInv);
        UnivariatePolynomialZp64[] result = (UnivariatePolynomialZp64[])UnivariateDivision.divideAndRemainderFast0((IUnivariatePolynomial)dividend, (IUnivariatePolynomial)divider, UnivariateDivision.fastDivisionPreConditioning(divider), (boolean)copy);
        divider.multiply(lc);
        result[0].multiply(lcInv);
        return result;
    }

    public static <E> UnivariatePolynomial<E>[] divideAndRemainderFast(UnivariatePolynomial<E> dividend, UnivariatePolynomial<E> divider, boolean copy) {
        UnivariatePolynomial<E>[] r = UnivariateDivision.earlyDivideAndRemainderChecks(dividend, divider, copy);
        if (r != null) {
            return r;
        }
        return UnivariateDivision.divideAndRemainderFast0(dividend, divider, copy);
    }

    public static <E> UnivariatePolynomial<E>[] divideAndRemainderFast(UnivariatePolynomial<E> dividend, UnivariatePolynomial<E> divider, InverseModMonomial<UnivariatePolynomial<E>> invMod, boolean copy) {
        UnivariatePolynomial<E>[] r = UnivariateDivision.earlyDivideAndRemainderChecks(dividend, divider, copy);
        if (r != null) {
            return r;
        }
        return UnivariateDivision.divideAndRemainderFastCorrectLC(dividend, divider, invMod, copy);
    }

    static <E> UnivariatePolynomial<E>[] divideAndRemainderFastCorrectLC(UnivariatePolynomial<E> dividend, UnivariatePolynomial<E> divider, InverseModMonomial<UnivariatePolynomial<E>> invMod, boolean copy) {
        if (divider.isMonic()) {
            return (UnivariatePolynomial[])UnivariateDivision.divideAndRemainderFast0(dividend, divider, invMod, (boolean)copy);
        }
        E lc = divider.lc();
        Object lcInv = dividend.ring.reciprocal(lc);
        divider.multiply((E)lcInv);
        UnivariatePolynomial[] result = (UnivariatePolynomial[])UnivariateDivision.divideAndRemainderFast0(dividend, divider, invMod, (boolean)copy);
        divider.multiply(lc);
        result[0].multiply(lcInv);
        return result;
    }

    static <E> UnivariatePolynomial<E>[] divideAndRemainderFast0(UnivariatePolynomial<E> dividend, UnivariatePolynomial<E> divider, boolean copy) {
        if (divider.isMonic()) {
            return (UnivariatePolynomial[])UnivariateDivision.divideAndRemainderFast0(dividend, divider, UnivariateDivision.fastDivisionPreConditioning(divider), (boolean)copy);
        }
        E lc = divider.lc();
        Object lcInv = dividend.ring.reciprocal(lc);
        divider.multiply((E)lcInv);
        UnivariatePolynomial[] result = (UnivariatePolynomial[])UnivariateDivision.divideAndRemainderFast0(dividend, divider, UnivariateDivision.fastDivisionPreConditioning(divider), (boolean)copy);
        divider.multiply(lc);
        result[0].multiply(lcInv);
        return result;
    }

    private static UnivariatePolynomialZp64 earlyRemainderChecks(UnivariatePolynomialZp64 dividend, UnivariatePolynomialZp64 divider, boolean copy) {
        if (dividend.degree < divider.degree) {
            return copy ? dividend.clone() : dividend;
        }
        if (divider.degree == 0) {
            return (UnivariatePolynomialZp64)dividend.createZero();
        }
        if (divider.degree == 1) {
            IntegersZp64 ring = dividend.ring;
            return dividend.createFromArray(new long[]{dividend.evaluate(ring.multiply(ring.negate(divider.cc()), ring.reciprocal(divider.lc())))});
        }
        return null;
    }

    public static UnivariatePolynomialZp64 remainder(UnivariatePolynomialZp64 dividend, UnivariatePolynomialZp64 divider, boolean copy) {
        UnivariatePolynomialZp64 rem = UnivariateDivision.earlyRemainderChecks(dividend, divider, copy);
        if (rem != null) {
            return rem;
        }
        if (UnivariateDivision.useClassicalDivision(dividend, divider)) {
            return UnivariateDivision.remainderClassical0(dividend, divider, copy);
        }
        return UnivariateDivision.divideAndRemainderFast0(dividend, divider, copy)[1];
    }

    static UnivariatePolynomialZp64 remainderClassical0(UnivariatePolynomialZp64 dividend, UnivariatePolynomialZp64 divider, boolean copy) {
        assert (dividend.degree >= divider.degree);
        dividend.assertSameCoefficientRingWith(divider);
        UnivariatePolynomialZp64 remainder = copy ? dividend.clone() : dividend;
        long lcInverse = dividend.ring.reciprocal(divider.lc());
        for (int i = dividend.degree - divider.degree; i >= 0; --i) {
            if (remainder.degree != divider.degree + i) continue;
            remainder.subtract(divider, remainder.ring.multiply(remainder.lc(), lcInverse), i);
        }
        return remainder;
    }

    public static UnivariatePolynomialZp64 remainderFast(UnivariatePolynomialZp64 dividend, UnivariatePolynomialZp64 divider, InverseModMonomial<UnivariatePolynomialZp64> invMod, boolean copy) {
        UnivariatePolynomialZp64 rem = UnivariateDivision.earlyRemainderChecks(dividend, divider, copy);
        if (rem != null) {
            return rem;
        }
        return UnivariateDivision.divideAndRemainderFastCorrectLC(dividend, divider, invMod, copy)[1];
    }

    public static UnivariatePolynomialZp64 quotient(UnivariatePolynomialZp64 dividend, UnivariatePolynomialZp64 divider, boolean copy) {
        UnivariatePolynomialZp64[] qd = UnivariateDivision.earlyDivideAndRemainderChecks(dividend, divider, copy);
        if (qd != null) {
            return qd[0];
        }
        if (UnivariateDivision.useClassicalDivision(dividend, divider)) {
            return UnivariateDivision.divideAndRemainderClassic(dividend, divider, copy)[0];
        }
        return UnivariateDivision.divideAndRemainderFast0(dividend, divider, copy)[0];
    }

    public static UnivariatePolynomialZp64 quotientFast(UnivariatePolynomialZp64 dividend, UnivariatePolynomialZp64 divider, InverseModMonomial<UnivariatePolynomialZp64> invMod, boolean copy) {
        UnivariatePolynomialZp64[] qd = UnivariateDivision.earlyDivideAndRemainderChecks(dividend, divider, copy);
        if (qd != null) {
            return qd[0];
        }
        return UnivariateDivision.divideAndRemainderFastCorrectLC(dividend, divider, invMod, copy)[0];
    }

    private static <E> UnivariatePolynomial<E> earlyRemainderChecks(UnivariatePolynomial<E> dividend, UnivariatePolynomial<E> divider, boolean copy) {
        if (dividend.degree < divider.degree) {
            return copy ? dividend.clone() : dividend;
        }
        if (divider.degree == 0) {
            return dividend.createZero();
        }
        if (divider.degree == 1) {
            Object p = dividend.ring.divideOrNull(dividend.ring.negate(divider.cc()), divider.lc());
            if (p == null) {
                return null;
            }
            return dividend.createConstant(dividend.evaluate(p));
        }
        return null;
    }

    public static <E> UnivariatePolynomial<E> remainder(UnivariatePolynomial<E> dividend, UnivariatePolynomial<E> divider, boolean copy) {
        UnivariatePolynomial<E> rem = UnivariateDivision.earlyRemainderChecks(dividend, divider, copy);
        if (rem != null) {
            return rem;
        }
        if (UnivariateDivision.useClassicalDivision(dividend, divider)) {
            return UnivariateDivision.remainderClassical0(dividend, divider, copy);
        }
        return UnivariateDivision.divideAndRemainderFast0(dividend, divider, copy)[1];
    }

    static <E> UnivariatePolynomial<E> remainderClassical0(UnivariatePolynomial<E> dividend, UnivariatePolynomial<E> divider, boolean copy) {
        assert (dividend.degree >= divider.degree);
        dividend.assertSameCoefficientRingWith(divider);
        Object remainder = copy ? dividend.clone() : dividend;
        Ring ring = dividend.ring;
        if (ring.isField()) {
            Object lcInverse = ring.reciprocal(divider.lc());
            for (int i = dividend.degree - divider.degree; i >= 0; --i) {
                if (((UnivariatePolynomial)remainder).degree != divider.degree + i) continue;
                ((UnivariatePolynomial)remainder).subtract(divider, ring.multiply(((UnivariatePolynomial)remainder).lc(), lcInverse), i);
            }
        } else {
            for (int i = dividend.degree - divider.degree; i >= 0; --i) {
                if (((UnivariatePolynomial)remainder).degree != divider.degree + i) continue;
                Object quot = ring.divideOrNull(((UnivariatePolynomial)remainder).lc(), divider.lc());
                if (quot == null) {
                    return null;
                }
                ((UnivariatePolynomial)remainder).subtract(divider, quot, i);
            }
        }
        return remainder;
    }

    public static <E> UnivariatePolynomial<E> remainderFast(UnivariatePolynomial<E> dividend, UnivariatePolynomial<E> divider, InverseModMonomial<UnivariatePolynomial<E>> invMod, boolean copy) {
        UnivariatePolynomial<E> rem = UnivariateDivision.earlyRemainderChecks(dividend, divider, copy);
        if (rem != null) {
            return rem;
        }
        return UnivariateDivision.divideAndRemainderFastCorrectLC(dividend, divider, invMod, copy)[1];
    }

    public static <E> UnivariatePolynomial<E> quotient(UnivariatePolynomial<E> dividend, UnivariatePolynomial<E> divider, boolean copy) {
        UnivariatePolynomial<E>[] qd = UnivariateDivision.earlyDivideAndRemainderChecks(dividend, divider, copy);
        if (qd != null) {
            return qd[0];
        }
        if (UnivariateDivision.useClassicalDivision(dividend, divider)) {
            return UnivariateDivision.divideAndRemainderClassic(dividend, divider, copy)[0];
        }
        return UnivariateDivision.divideAndRemainderFast0(dividend, divider, copy)[0];
    }

    public static <E> UnivariatePolynomial<E> quotientFast(UnivariatePolynomial<E> dividend, UnivariatePolynomial<E> divider, InverseModMonomial<UnivariatePolynomial<E>> invMod, boolean copy) {
        UnivariatePolynomial<E>[] qd = UnivariateDivision.earlyDivideAndRemainderChecks(dividend, divider, copy);
        if (qd != null) {
            return qd[0];
        }
        return UnivariateDivision.divideAndRemainderFastCorrectLC(dividend, divider, invMod, copy)[0];
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> Poly[] pseudoDivideAndRemainder(Poly dividend, Poly divider, boolean copy) {
        if (dividend instanceof UnivariatePolynomialZ64) {
            return UnivariateDivision.pseudoDivideAndRemainder((UnivariatePolynomialZ64)dividend, (UnivariatePolynomialZ64)divider, copy);
        }
        if (dividend instanceof UnivariatePolynomialZp64) {
            return UnivariateDivision.divideAndRemainder((UnivariatePolynomialZp64)dividend, (UnivariatePolynomialZp64)divider, copy);
        }
        if (dividend instanceof UnivariatePolynomial) {
            if (dividend.isOverField()) {
                return UnivariateDivision.divideAndRemainder((UnivariatePolynomial)dividend, (UnivariatePolynomial)divider, copy);
            }
            return UnivariateDivision.pseudoDivideAndRemainder((UnivariatePolynomial)dividend, (UnivariatePolynomial)divider, copy);
        }
        throw new RuntimeException(dividend.getClass().toString());
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> Poly[] divideAndRemainder(Poly dividend, Poly divider, boolean copy) {
        if (dividend instanceof UnivariatePolynomialZ64) {
            return UnivariateDivision.divideAndRemainder((UnivariatePolynomialZ64)dividend, (UnivariatePolynomialZ64)divider, copy);
        }
        if (dividend instanceof UnivariatePolynomialZp64) {
            return UnivariateDivision.divideAndRemainder((UnivariatePolynomialZp64)dividend, (UnivariatePolynomialZp64)divider, copy);
        }
        if (dividend instanceof UnivariatePolynomial) {
            return UnivariateDivision.divideAndRemainder((UnivariatePolynomial)dividend, (UnivariatePolynomial)divider, copy);
        }
        throw new RuntimeException(dividend.getClass().toString());
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> Poly[] divideAndRemainderFast(Poly dividend, Poly divider, InverseModMonomial<Poly> invMod, boolean copy) {
        if (dividend instanceof UnivariatePolynomialZp64) {
            return UnivariateDivision.divideAndRemainderFast((UnivariatePolynomialZp64)dividend, (UnivariatePolynomialZp64)divider, invMod, copy);
        }
        if (dividend instanceof UnivariatePolynomial) {
            return UnivariateDivision.divideAndRemainderFast((UnivariatePolynomial)dividend, (UnivariatePolynomial)divider, invMod, copy);
        }
        throw new RuntimeException(dividend.getClass().toString());
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> Poly divideExact(Poly dividend, Poly divider, boolean copy) {
        IUnivariatePolynomial[] qr = UnivariateDivision.divideAndRemainder(dividend, divider, (boolean)copy);
        if (qr == null || !qr[1].isZero()) {
            throw new ArithmeticException("Not divisible: (" + dividend + ") / (" + divider + ")");
        }
        return (Poly)qr[0];
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> Poly divideOrNull(Poly dividend, Poly divider, boolean copy) {
        IUnivariatePolynomial[] qr = UnivariateDivision.divideAndRemainder(dividend, divider, (boolean)copy);
        if (qr == null || !qr[1].isZero()) {
            return null;
        }
        return (Poly)qr[0];
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> Poly remainder(Poly dividend, Poly divider, boolean copy) {
        if (dividend instanceof UnivariatePolynomialZ64) {
            return (Poly)UnivariateDivision.remainder((UnivariatePolynomialZ64)dividend, (UnivariatePolynomialZ64)divider, copy);
        }
        if (dividend instanceof UnivariatePolynomialZp64) {
            return (Poly)UnivariateDivision.remainder((UnivariatePolynomialZp64)dividend, (UnivariatePolynomialZp64)divider, copy);
        }
        if (dividend instanceof UnivariatePolynomial) {
            return (Poly)UnivariateDivision.remainder((UnivariatePolynomial)dividend, (UnivariatePolynomial)divider, copy);
        }
        throw new RuntimeException(dividend.getClass().toString());
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> Poly quotient(Poly dividend, Poly divider, boolean copy) {
        if (dividend instanceof UnivariatePolynomialZ64) {
            return (Poly)UnivariateDivision.quotient((UnivariatePolynomialZ64)dividend, (UnivariatePolynomialZ64)divider, copy);
        }
        if (dividend instanceof UnivariatePolynomialZp64) {
            return (Poly)UnivariateDivision.quotient((UnivariatePolynomialZp64)dividend, (UnivariatePolynomialZp64)divider, copy);
        }
        if (dividend instanceof UnivariatePolynomial) {
            return (Poly)UnivariateDivision.quotient((UnivariatePolynomial)dividend, (UnivariatePolynomial)divider, copy);
        }
        throw new RuntimeException(dividend.getClass().toString());
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> Poly remainderFast(Poly dividend, Poly divider, InverseModMonomial<Poly> invMod, boolean copy) {
        if (dividend instanceof UnivariatePolynomialZp64) {
            return (Poly)UnivariateDivision.remainderFast((UnivariatePolynomialZp64)dividend, (UnivariatePolynomialZp64)divider, invMod, copy);
        }
        if (dividend instanceof UnivariatePolynomial) {
            return (Poly)UnivariateDivision.remainderFast((UnivariatePolynomial)dividend, (UnivariatePolynomial)divider, invMod, copy);
        }
        throw new RuntimeException(dividend.getClass().toString());
    }

    public static <E> E remainderCoefficientBound(UnivariatePolynomial<E> dividend, UnivariatePolynomial<E> divider) {
        if (divider.degree < dividend.degree) {
            return dividend.maxAbsCoefficient();
        }
        Ring<E> ring = dividend.ring;
        return ring.multiply(dividend.maxAbsCoefficient(), (E)ring.pow(ring.increment(ring.quotient(divider.maxAbsCoefficient(), divider.lc())), dividend.degree - divider.degree + 1));
    }

    public static final class InverseModMonomial<Poly extends IUnivariatePolynomial<Poly>>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final Poly poly;
        private final ArrayList<Poly> inverses = new ArrayList();

        private InverseModMonomial(Poly poly) {
            if (!poly.isUnitCC()) {
                throw new IllegalArgumentException("Smallest coefficient is not a unit: " + poly);
            }
            this.poly = poly;
        }

        public Poly getInverse(int xDegree) {
            if (xDegree < 1) {
                return null;
            }
            int r = UnivariateDivision.log2(xDegree);
            if (this.inverses.size() >= r) {
                return (Poly)((IUnivariatePolynomial)this.inverses.get(r - 1));
            }
            int currentSize = this.inverses.size();
            IUnivariatePolynomial gPrev = currentSize == 0 ? (IUnivariatePolynomial)this.poly.createOne() : (IUnivariatePolynomial)this.inverses.get(this.inverses.size() - 1);
            for (int i = currentSize; i < r; ++i) {
                IUnivariatePolynomial tmp = ((IUnivariatePolynomial)gPrev.clone().multiply(2L)).subtract((IUnivariatePolynomial)((IUnivariatePolynomial)gPrev.clone().square()).multiply(this.poly));
                gPrev = UnivariateDivision.remainderMonomial(tmp, 1 << i, false);
                this.inverses.add(gPrev);
            }
            return (Poly)gPrev;
        }

        /* synthetic */ InverseModMonomial(IUnivariatePolynomial x0, 1 x1) {
            this(x0);
        }
    }
}

