/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.univar;

import cc.redberry.rings.IntegersZp;
import cc.redberry.rings.IntegersZp64;
import cc.redberry.rings.Rational;
import cc.redberry.rings.Ring;
import cc.redberry.rings.Rings;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.bigint.BigIntegerUtil;
import cc.redberry.rings.io.Coder;
import cc.redberry.rings.io.IStringifier;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.multivar.DegreeVector;
import cc.redberry.rings.poly.multivar.MonomialOrder;
import cc.redberry.rings.poly.multivar.MultivariatePolynomial;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZ64;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZp64;
import cc.redberry.rings.util.ArraysUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Stream;

public final class UnivariatePolynomial<E>
implements IUnivariatePolynomial<UnivariatePolynomial<E>>,
Iterable<E> {
    private static final long serialVersionUID = 1L;
    public final Ring<E> ring;
    E[] data;
    int degree;
    static final long KARATSUBA_THRESHOLD = 1024L;
    static final long MUL_CLASSICAL_THRESHOLD = 65536L;
    static final long MUL_KRONECKER_THRESHOLD = 1024L;
    static final long MUL_MOD_CLASSICAL_THRESHOLD = 16384L;

    private UnivariatePolynomial(Ring<E> ring, E[] data, int degree) {
        this.ring = ring;
        this.data = data;
        this.degree = degree;
        assert (data.length > 0);
    }

    private UnivariatePolynomial(Ring<E> ring, E[] data) {
        this(ring, data, data.length - 1);
        this.fixDegree();
    }

    public static <E> UnivariatePolynomial<E> parse(String string, Ring<E> ring, String var) {
        return (UnivariatePolynomial)((Object)Coder.mkUnivariateCoder(Rings.UnivariateRing(ring), var).parse(string));
    }

    @Deprecated
    public static <E> UnivariatePolynomial<E> parse(String string, Ring<E> ring) {
        return (UnivariatePolynomial)((Object)Coder.mkUnivariateCoder(Rings.UnivariateRing(ring), UnivariatePolynomial.guessVariableString(string)).parse(string));
    }

    private static String guessVariableString(String string) {
        Matcher matcher = Pattern.compile("[a-zA-Z]+[0-9]*").matcher(string);
        ArrayList<String> variables = new ArrayList<String>();
        HashSet<String> seen = new HashSet<String>();
        while (matcher.find()) {
            String var = matcher.group();
            if (seen.contains(var)) continue;
            seen.add(var);
            variables.add(var);
        }
        return variables.size() == 0 ? "x" : (String)variables.get(0);
    }

    public static <E> UnivariatePolynomial<E> create(Ring<E> ring, E ... data) {
        ring.setToValueOf(data);
        return new UnivariatePolynomial<E>(ring, data);
    }

    public static <E> UnivariatePolynomial<E> createUnsafe(Ring<E> ring, E[] data) {
        return new UnivariatePolynomial<E>(ring, data);
    }

    public static UnivariatePolynomial<BigInteger> create(Ring<BigInteger> ring, long ... data) {
        return UnivariatePolynomial.create(ring, (BigInteger[])ring.valueOf((BigInteger)data));
    }

    public static UnivariatePolynomial<BigInteger> create(long ... data) {
        return UnivariatePolynomial.create(Rings.Z, data);
    }

    public static <E> UnivariatePolynomial<E> constant(Ring<E> ring, E constant) {
        return UnivariatePolynomial.create(ring, ring.createArray(constant));
    }

    public static <E> UnivariatePolynomial<E> zero(Ring<E> ring) {
        return UnivariatePolynomial.constant(ring, ring.getZero());
    }

    public static <E> UnivariatePolynomial<E> one(Ring<E> ring) {
        return UnivariatePolynomial.constant(ring, ring.getOne());
    }

    public static UnivariatePolynomialZ64 asOverZ64(UnivariatePolynomial<BigInteger> poly) {
        long[] data = new long[poly.degree + 1];
        for (int i = 0; i < data.length; ++i) {
            data[i] = ((BigInteger[])poly.data)[i].longValueExact();
        }
        return UnivariatePolynomialZ64.create(data);
    }

    public static UnivariatePolynomialZp64 asOverZp64(UnivariatePolynomial<BigInteger> poly) {
        if (!(poly.ring instanceof IntegersZp)) {
            throw new IllegalArgumentException("Not a modular ring: " + poly.ring);
        }
        long[] data = new long[poly.degree + 1];
        for (int i = 0; i < data.length; ++i) {
            data[i] = ((BigInteger[])poly.data)[i].longValueExact();
        }
        return UnivariatePolynomialZp64.create(((IntegersZp)poly.ring).modulus.longValueExact(), data);
    }

    public static UnivariatePolynomialZp64 asOverZp64(UnivariatePolynomial<BigInteger> poly, IntegersZp64 ring) {
        long modulus = ring.modulus;
        long[] data = new long[poly.degree + 1];
        for (int i = 0; i < data.length; ++i) {
            data[i] = ((BigInteger[])poly.data)[i].mod(modulus).longValueExact();
        }
        return UnivariatePolynomialZp64.create(ring, data);
    }

    public static UnivariatePolynomialZp64 asOverZp64Q(UnivariatePolynomial<Rational<BigInteger>> poly, IntegersZp64 ring) {
        long modulus = ring.modulus;
        long[] data = new long[poly.degree + 1];
        for (int i = 0; i < data.length; ++i) {
            data[i] = ring.divide(((BigInteger)((Rational[])poly.data)[i].numerator()).mod(modulus).longValueExact(), ((BigInteger)((Rational[])poly.data)[i].denominator()).mod(modulus).longValueExact());
        }
        return UnivariatePolynomialZp64.create(ring, data);
    }

    public static UnivariatePolynomial<BigInteger> asPolyZSymmetric(UnivariatePolynomial<BigInteger> poly) {
        if (!(poly.ring instanceof IntegersZp)) {
            throw new IllegalArgumentException("Not a modular ring: " + poly.ring);
        }
        IntegersZp ring = (IntegersZp)poly.ring;
        BigInteger[] newData = new BigInteger[poly.degree + 1];
        for (int i = poly.degree; i >= 0; --i) {
            newData[i] = ring.symmetricForm(((BigInteger[])poly.data)[i]);
        }
        return UnivariatePolynomial.createUnsafe(Rings.Z, newData);
    }

    @Override
    public int degree() {
        return this.degree;
    }

    public E get(int i) {
        return i > this.degree ? this.ring.getZero() : this.data[i];
    }

    public UnivariatePolynomial<E> set(int i, E el) {
        if (this.ring.isZero(el = this.ring.valueOf(el))) {
            if (i > this.degree) {
                return this;
            }
            this.data[i] = el;
            this.fixDegree();
            return this;
        }
        this.ensureCapacity(i);
        this.data[i] = el;
        this.fixDegree();
        return this;
    }

    public UnivariatePolynomial<E> setLC(E lc) {
        return this.set(this.degree, lc);
    }

    @Override
    public int firstNonZeroCoefficientPosition() {
        if (this.isZero()) {
            return -1;
        }
        int i = 0;
        while (this.ring.isZero(this.data[i])) {
            ++i;
        }
        return i;
    }

    public UnivariatePolynomial<E> setRing(Ring<E> newRing) {
        if (this.ring == newRing) {
            return this.clone();
        }
        E[] newData = Arrays.copyOf(this.data, this.degree + 1);
        newRing.setToValueOf(newData);
        return new UnivariatePolynomial<E>(newRing, newData);
    }

    public UnivariatePolynomial<E> setRingUnsafe(Ring<E> newRing) {
        return new UnivariatePolynomial<E>(newRing, this.data, this.degree);
    }

    public E lc() {
        return this.data[this.degree];
    }

    @Override
    public UnivariatePolynomial<E> lcAsPoly() {
        return this.createConstant(this.lc());
    }

    @Override
    public UnivariatePolynomial<E> ccAsPoly() {
        return this.createConstant(this.cc());
    }

    @Override
    public UnivariatePolynomial<E> getAsPoly(int i) {
        return this.createConstant(this.get(i));
    }

    public E cc() {
        return this.data[0];
    }

    @Override
    public void ensureInternalCapacity(int desiredCapacity) {
        if (this.data.length < desiredCapacity) {
            int oldLength = this.data.length;
            this.data = Arrays.copyOf(this.data, desiredCapacity);
            this.fillZeroes(this.data, oldLength, this.data.length);
        }
    }

    final void ensureCapacity(int desiredDegree) {
        if (this.degree < desiredDegree) {
            this.degree = desiredDegree;
        }
        if (this.data.length < desiredDegree + 1) {
            int oldLen = this.data.length;
            this.data = Arrays.copyOf(this.data, desiredDegree + 1);
            this.fillZeroes(this.data, oldLen, this.data.length);
        }
    }

    final void fixDegree() {
        int i;
        for (i = this.degree; i >= 0 && this.ring.isZero(this.data[i]); --i) {
        }
        if (i < 0) {
            i = 0;
        }
        if (i != this.degree) {
            this.degree = i;
        }
    }

    @Override
    public UnivariatePolynomial<E> getRange(int from, int to) {
        return new UnivariatePolynomial<E>(this.ring, Arrays.copyOfRange(this.data, from, to));
    }

    public UnivariatePolynomial<E>[] createArray(int length) {
        return new UnivariatePolynomial[length];
    }

    public UnivariatePolynomial<E>[] createArray(UnivariatePolynomial<E> a, UnivariatePolynomial<E> b) {
        return new UnivariatePolynomial[]{a, b};
    }

    public UnivariatePolynomial<E>[][] createArray2d(int length) {
        return new UnivariatePolynomial[length][];
    }

    public UnivariatePolynomial<E>[][] createArray2d(int length1, int length2) {
        return new UnivariatePolynomial[length1][length2];
    }

    @Override
    public boolean sameCoefficientRingWith(UnivariatePolynomial<E> oth) {
        return this.ring.equals(oth.ring);
    }

    @Override
    public UnivariatePolynomial<E> setCoefficientRingFrom(UnivariatePolynomial<E> poly) {
        return this.setRing(poly.ring);
    }

    public UnivariatePolynomial<E> createFromArray(E[] data) {
        this.ring.setToValueOf(data);
        return new UnivariatePolynomial<E>(this.ring, data);
    }

    @Override
    public UnivariatePolynomial<E> createMonomial(int degree) {
        return this.createMonomial(this.ring.getOne(), degree);
    }

    public UnivariatePolynomial<E> createLinear(E cc, E lc) {
        return this.createFromArray(this.ring.createArray(cc, lc));
    }

    public UnivariatePolynomial<E> createMonomial(E coefficient, int degree) {
        coefficient = this.ring.valueOf(coefficient);
        E[] data = this.ring.createZeroesArray(degree + 1);
        data[degree] = coefficient;
        return new UnivariatePolynomial<E>(this.ring, data);
    }

    public UnivariatePolynomial<E> createConstant(E val) {
        boolean[] array = this.ring.createArray(true);
        array[0] = val;
        return this.createFromArray(array);
    }

    @Override
    public UnivariatePolynomial<E> createZero() {
        return this.createConstant(this.ring.getZero());
    }

    @Override
    public UnivariatePolynomial<E> createOne() {
        return this.createConstant(this.ring.getOne());
    }

    @Override
    public boolean isZeroAt(int i) {
        return i >= this.data.length || this.ring.isZero(this.data[i]);
    }

    @Override
    public final UnivariatePolynomial<E> setZero(int i) {
        if (i < this.data.length) {
            this.data[i] = this.ring.getZero();
        }
        return this;
    }

    @Override
    public UnivariatePolynomial<E> setFrom(int indexInThis, UnivariatePolynomial<E> poly, int indexInPoly) {
        this.ensureCapacity(indexInThis);
        this.data[indexInThis] = poly.get(indexInPoly);
        this.fixDegree();
        return this;
    }

    @Override
    public boolean isZero() {
        return this.ring.isZero(this.data[this.degree]);
    }

    @Override
    public boolean isOne() {
        return this.degree == 0 && this.ring.isOne(this.data[0]);
    }

    @Override
    public boolean isMonic() {
        return this.ring.isOne(this.lc());
    }

    @Override
    public boolean isUnitCC() {
        return this.ring.isOne(this.cc());
    }

    @Override
    public boolean isConstant() {
        return this.degree == 0;
    }

    @Override
    public boolean isMonomial() {
        for (int i = this.degree - 1; i >= 0; --i) {
            if (this.ring.isZero(this.data[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int signumOfLC() {
        return this.ring.signum(this.lc());
    }

    @Override
    public boolean isOverField() {
        return this.ring.isField();
    }

    @Override
    public boolean isOverFiniteField() {
        return this.ring.isFinite();
    }

    @Override
    public boolean isOverZ() {
        return this.ring.equals(Rings.Z);
    }

    @Override
    public BigInteger coefficientRingCardinality() {
        return this.ring.cardinality();
    }

    @Override
    public BigInteger coefficientRingCharacteristic() {
        return this.ring.characteristic();
    }

    @Override
    public boolean isOverPerfectPower() {
        return this.ring.isPerfectPower();
    }

    @Override
    public BigInteger coefficientRingPerfectPowerBase() {
        return this.ring.perfectPowerBase();
    }

    @Override
    public BigInteger coefficientRingPerfectPowerExponent() {
        return this.ring.perfectPowerExponent();
    }

    public static BigInteger mignotteBound(UnivariatePolynomial<BigInteger> poly) {
        return BigInteger.ONE.shiftLeft(poly.degree).multiply(UnivariatePolynomial.norm2(poly));
    }

    public static BigInteger norm1(UnivariatePolynomial<BigInteger> poly) {
        BigInteger norm = BigInteger.ZERO;
        for (int i = poly.degree; i >= 0; --i) {
            norm = norm.add(BigIntegerUtil.abs(((BigInteger[])poly.data)[i]));
        }
        return norm;
    }

    public static BigInteger norm2(UnivariatePolynomial<BigInteger> poly) {
        BigInteger norm = BigInteger.ZERO;
        for (int i = poly.degree; i >= 0; --i) {
            norm = norm.add(((BigInteger[])poly.data)[i].multiply(((BigInteger[])poly.data)[i]));
        }
        return BigIntegerUtil.sqrtCeil(norm);
    }

    public static double norm2Double(UnivariatePolynomial<BigInteger> poly) {
        double norm = 0.0;
        for (int i = poly.degree; i >= 0; --i) {
            double d = ((BigInteger[])poly.data)[i].doubleValue();
            norm += d * d;
        }
        return Math.sqrt(norm);
    }

    public E maxAbsCoefficient() {
        E el = this.ring.abs(this.data[0]);
        for (int i = 1; i <= this.degree; ++i) {
            el = this.ring.max(el, this.ring.abs(this.data[i]));
        }
        return el;
    }

    public E normMax() {
        return this.maxAbsCoefficient();
    }

    private void fillZeroes(E[] data, int from, int to) {
        for (int i = from; i < to; ++i) {
            data[i] = this.ring.getZero();
        }
    }

    @Override
    public UnivariatePolynomial<E> toZero() {
        this.fillZeroes(this.data, 0, this.degree + 1);
        this.degree = 0;
        return this;
    }

    @Override
    public UnivariatePolynomial<E> set(UnivariatePolynomial<E> oth) {
        if (oth == this) {
            return this;
        }
        this.data = (Object[])oth.data.clone();
        this.degree = oth.degree;
        return this;
    }

    @Override
    public final UnivariatePolynomial<E> setAndDestroy(UnivariatePolynomial<E> oth) {
        this.data = oth.data;
        oth.data = null;
        this.degree = oth.degree;
        assert (this.data.length > 0);
        return this;
    }

    @Override
    public UnivariatePolynomial<E> shiftLeft(int offset) {
        if (offset == 0) {
            return this;
        }
        if (offset > this.degree) {
            return this.toZero();
        }
        System.arraycopy(this.data, offset, this.data, 0, this.degree - offset + 1);
        this.fillZeroes(this.data, this.degree - offset + 1, this.degree + 1);
        this.degree -= offset;
        return this;
    }

    @Override
    public UnivariatePolynomial<E> shiftRight(int offset) {
        if (offset == 0) {
            return this;
        }
        int degree = this.degree;
        this.ensureCapacity(offset + degree);
        System.arraycopy(this.data, 0, this.data, offset, degree + 1);
        this.fillZeroes(this.data, 0, offset);
        return this;
    }

    @Override
    public UnivariatePolynomial<E> truncate(int newDegree) {
        if (newDegree >= this.degree) {
            return this;
        }
        this.fillZeroes(this.data, newDegree + 1, this.degree + 1);
        this.degree = newDegree;
        this.fixDegree();
        return this;
    }

    @Override
    public UnivariatePolynomial<E> reverse() {
        ArraysUtil.reverse(this.data, 0, this.degree + 1);
        this.fixDegree();
        return this;
    }

    public E content() {
        if (this.degree == 0) {
            return this.data[0];
        }
        return this.isOverField() ? this.lc() : this.ring.gcd(this);
    }

    @Override
    public UnivariatePolynomial<E> contentAsPoly() {
        return this.createConstant(this.content());
    }

    @Override
    public UnivariatePolynomial<E> primitivePart() {
        E content = this.content();
        if (this.signumOfLC() < 0 && this.ring.signum(content) > 0) {
            content = this.ring.negate(content);
        }
        if (this.ring.isMinusOne(content)) {
            return this.negate();
        }
        return this.primitivePart0(content);
    }

    @Override
    public UnivariatePolynomial<E> primitivePartSameSign() {
        return this.primitivePart0(this.content());
    }

    private UnivariatePolynomial<E> primitivePart0(E content) {
        if (this.isZero()) {
            return this;
        }
        if (this.ring.isOne(content)) {
            return this;
        }
        for (int i = this.degree; i >= 0; --i) {
            this.data[i] = this.ring.divideOrNull(this.data[i], content);
            if (this.data[i] != null) continue;
            return null;
        }
        return this;
    }

    public E evaluate(long point) {
        return this.evaluate((E)this.ring.valueOf(point));
    }

    public E evaluate(E point) {
        if (this.ring.isZero(point)) {
            return this.cc();
        }
        point = this.ring.valueOf(point);
        E res = this.ring.getZero();
        for (int i = this.degree; i >= 0; --i) {
            res = this.ring.addMutable(this.ring.multiplyMutable(res, point), this.data[i]);
        }
        return res;
    }

    @Override
    public UnivariatePolynomial<E> composition(UnivariatePolynomial<E> value) {
        if (value.isOne()) {
            return this.clone();
        }
        if (value.isZero()) {
            return this.ccAsPoly();
        }
        if (value.degree == 1 && value.isMonomial() && this.ring.isOne(value.lc())) {
            return this.clone();
        }
        UnivariatePolynomial<E> result = this.createZero();
        for (int i = this.degree; i >= 0; --i) {
            result = result.multiply(value).add(this.data[i]);
        }
        return result;
    }

    @Override
    public MultivariatePolynomial<E> composition(AMultivariatePolynomial value) {
        if (!(value instanceof MultivariatePolynomial)) {
            throw new IllegalArgumentException();
        }
        if (!((MultivariatePolynomial)value).ring.equals(this.ring)) {
            throw new IllegalArgumentException();
        }
        if (value.isOne()) {
            return this.asMultivariate();
        }
        if (value.isZero()) {
            return ((UnivariatePolynomial)this.ccAsPoly()).asMultivariate();
        }
        MultivariatePolynomial result = (MultivariatePolynomial)value.createZero();
        for (int i = this.degree; i >= 0; --i) {
            result = result.multiply((MultivariatePolynomial)value).add(this.data[i]);
        }
        return result;
    }

    public UnivariatePolynomial<E> scale(E scaling) {
        if (this.ring.isOne(scaling)) {
            return this.clone();
        }
        if (this.ring.isZero(scaling)) {
            return this.ccAsPoly();
        }
        E factor = this.ring.getOne();
        int[] result = this.ring.createArray(this.degree + 1);
        for (int i = 0; i <= this.degree; ++i) {
            result[i] = (int)this.ring.multiply(this.data[i], factor);
            factor = this.ring.multiply(factor, scaling);
        }
        return UnivariatePolynomial.createUnsafe(this.ring, result);
    }

    public UnivariatePolynomial<E> shift(E value) {
        return this.composition(this.createLinear(value, this.ring.getOne()));
    }

    @Override
    public UnivariatePolynomial<E> add(E val) {
        this.data[0] = this.ring.add(this.data[0], this.ring.valueOf(val));
        this.fixDegree();
        return this;
    }

    @Override
    public UnivariatePolynomial<E> subtract(E val) {
        this.data[0] = this.ring.subtract(this.data[0], this.ring.valueOf(val));
        this.fixDegree();
        return this;
    }

    @Override
    public UnivariatePolynomial<E> decrement() {
        return this.subtract((UnivariatePolynomial<E>)this.createOne());
    }

    @Override
    public UnivariatePolynomial<E> increment() {
        return this.add((UnivariatePolynomial<E>)this.createOne());
    }

    @Override
    public UnivariatePolynomial<E> add(UnivariatePolynomial<E> oth) {
        this.assertSameCoefficientRingWith(oth);
        if (oth.isZero()) {
            return this;
        }
        if (this.isZero()) {
            return this.set(oth);
        }
        this.assertSameCoefficientRingWith(oth);
        this.ensureCapacity(oth.degree);
        for (int i = oth.degree; i >= 0; --i) {
            this.data[i] = this.ring.add(this.data[i], oth.data[i]);
        }
        this.fixDegree();
        return this;
    }

    public UnivariatePolynomial<E> addMonomial(E coefficient, int exponent) {
        if (this.ring.isZero(coefficient)) {
            return this;
        }
        this.ensureCapacity(exponent);
        this.data[exponent] = this.ring.add(this.data[exponent], this.ring.valueOf(coefficient));
        this.fixDegree();
        return this;
    }

    public UnivariatePolynomial<E> addMul(UnivariatePolynomial<E> oth, E factor) {
        this.assertSameCoefficientRingWith(oth);
        if (oth.isZero()) {
            return this;
        }
        if (this.ring.isZero(factor = this.ring.valueOf(factor))) {
            return this;
        }
        this.assertSameCoefficientRingWith(oth);
        this.ensureCapacity(oth.degree);
        for (int i = oth.degree; i >= 0; --i) {
            this.data[i] = this.ring.add(this.data[i], this.ring.multiply(factor, oth.data[i]));
        }
        this.fixDegree();
        return this;
    }

    @Override
    public UnivariatePolynomial<E> subtract(UnivariatePolynomial<E> oth) {
        this.assertSameCoefficientRingWith(oth);
        if (oth.isZero()) {
            return this;
        }
        if (this.isZero()) {
            return this.set(oth).negate();
        }
        this.assertSameCoefficientRingWith(oth);
        this.ensureCapacity(oth.degree);
        for (int i = oth.degree; i >= 0; --i) {
            this.data[i] = this.ring.subtract(this.data[i], oth.data[i]);
        }
        this.fixDegree();
        return this;
    }

    public UnivariatePolynomial<E> subtract(UnivariatePolynomial<E> oth, E factor, int exponent) {
        this.assertSameCoefficientRingWith(oth);
        if (oth.isZero()) {
            return this;
        }
        if (this.ring.isZero(factor = this.ring.valueOf(factor))) {
            return this;
        }
        this.assertSameCoefficientRingWith(oth);
        for (int i = oth.degree + exponent; i >= exponent; --i) {
            this.data[i] = this.ring.subtract(this.data[i], this.ring.multiply(factor, oth.data[i - exponent]));
        }
        this.fixDegree();
        return this;
    }

    @Override
    public UnivariatePolynomial<E> negate() {
        for (int i = this.degree; i >= 0; --i) {
            if (this.ring.isZero(this.data[i])) continue;
            this.data[i] = this.ring.negate(this.data[i]);
        }
        return this;
    }

    @Override
    public UnivariatePolynomial<E> multiply(E factor) {
        if (this.ring.isOne(factor = this.ring.valueOf(factor))) {
            return this;
        }
        if (this.ring.isZero(factor)) {
            return this.toZero();
        }
        for (int i = this.degree; i >= 0; --i) {
            this.data[i] = this.ring.multiply(this.data[i], factor);
        }
        return this;
    }

    @Override
    public UnivariatePolynomial<E> multiplyByLC(UnivariatePolynomial<E> other) {
        return this.multiply(other.lc());
    }

    @Override
    public UnivariatePolynomial<E> multiply(long factor) {
        return this.multiply((E)this.ring.valueOf(factor));
    }

    @Override
    public UnivariatePolynomial<E> divideByLC(UnivariatePolynomial<E> other) {
        return this.divideOrNull(other.lc());
    }

    public UnivariatePolynomial<E> divideOrNull(E factor) {
        if (this.ring.isZero(factor = this.ring.valueOf(factor))) {
            throw new ArithmeticException("Divide by zero");
        }
        if (this.ring.isOne(factor)) {
            return this;
        }
        if (this.ring.isMinusOne(factor)) {
            return this.negate();
        }
        if (this.ring.isField()) {
            return this.multiply(this.ring.reciprocal(factor));
        }
        for (int i = this.degree; i >= 0; --i) {
            E l = this.ring.divideOrNull(this.data[i], factor);
            if (l == null) {
                return null;
            }
            this.data[i] = l;
        }
        return this;
    }

    public UnivariatePolynomial<E> divideExact(E factor) {
        UnivariatePolynomial<E> r = this.divideOrNull(factor);
        if (r == null) {
            throw new ArithmeticException("not divisible " + this + " / " + factor);
        }
        return r;
    }

    @Override
    public UnivariatePolynomial<E> monic() {
        if (this.isZero()) {
            return this;
        }
        return this.divideOrNull(this.lc());
    }

    public UnivariatePolynomial<E> monic(E factor) {
        E lc = this.lc();
        return this.multiply(factor).divideOrNull(lc);
    }

    @Override
    public UnivariatePolynomial<E> monicWithLC(UnivariatePolynomial<E> other) {
        if (this.lc().equals(other.lc())) {
            return this;
        }
        return this.monic(other.lc());
    }

    @Override
    public UnivariatePolynomial<E> multiplyByBigInteger(BigInteger factor) {
        return this.multiply(this.ring.valueOfBigInteger(factor));
    }

    @Override
    public UnivariatePolynomial<E> multiply(UnivariatePolynomial<E> oth) {
        this.assertSameCoefficientRingWith(oth);
        if (this.isZero()) {
            return this;
        }
        if (oth.isZero()) {
            return this.toZero();
        }
        if (this == oth) {
            return this.square();
        }
        if (oth.degree == 0) {
            return this.multiply(oth.data[0]);
        }
        if (this.degree == 0) {
            E factor = this.data[0];
            this.data = (Object[])oth.data.clone();
            this.degree = oth.degree;
            return this.multiply(factor);
        }
        if (this.ring instanceof IntegersZp) {
            UnivariatePolynomial<BigInteger> iThis = this.setRingUnsafe(Rings.Z);
            UnivariatePolynomial<BigInteger> iOth = oth.setRingUnsafe(Rings.Z);
            this.data = iThis.multiply(iOth).data;
            this.ring.setToValueOf(this.data);
        } else {
            this.data = this.multiplySafe0(oth);
        }
        this.degree += oth.degree;
        this.fixDegree();
        return this;
    }

    @Override
    public UnivariatePolynomial<E> square() {
        if (this.isZero()) {
            return this;
        }
        if (this.degree == 0) {
            return this.multiply(this.data[0]);
        }
        if (this.ring instanceof IntegersZp) {
            UnivariatePolynomial<BigInteger> iThis = this.setRingUnsafe(Rings.Z);
            this.data = ((UnivariatePolynomial)iThis.square()).data;
            this.ring.setToValueOf(this.data);
        } else {
            this.data = this.squareSafe0();
        }
        this.degree += this.degree;
        this.fixDegree();
        return this;
    }

    @Override
    public UnivariatePolynomial<E> derivative() {
        if (this.isConstant()) {
            return this.createZero();
        }
        int[] newData = this.ring.createArray(this.degree);
        for (int i = this.degree; i > 0; --i) {
            newData[i - 1] = (int)this.ring.multiply((long)this.data[i], this.ring.valueOf((long)i));
        }
        return this.createFromArray(newData);
    }

    @Override
    public UnivariatePolynomial<E> clone() {
        return new UnivariatePolynomial<Object>(this.ring, (Object[])this.data.clone(), this.degree);
    }

    @Override
    public UnivariatePolynomial<E> parsePoly(String string) {
        return UnivariatePolynomial.parse(string, this.ring);
    }

    @Override
    public Iterator<E> iterator() {
        return new It();
    }

    public Stream<E> stream() {
        return Arrays.stream(this.data, 0, this.degree + 1);
    }

    @Override
    public Stream<UnivariatePolynomial<E>> streamAsPolys() {
        return this.stream().map(this::createConstant);
    }

    @Override
    public Spliterator<E> spliterator() {
        return Arrays.spliterator(this.data, 0, this.degree + 1);
    }

    public <T> UnivariatePolynomial<T> mapCoefficients(Ring<T> ring, Function<E, T> mapper) {
        return (UnivariatePolynomial)this.stream().map(mapper).collect(new PolynomialCollector<T>(ring));
    }

    public UnivariatePolynomialZp64 mapCoefficients(IntegersZp64 ring, ToLongFunction<E> mapper) {
        return UnivariatePolynomialZp64.create(ring, this.stream().mapToLong(mapper).toArray());
    }

    public E[] getDataReferenceUnsafe() {
        return this.data;
    }

    @Override
    public MultivariatePolynomial<E> asMultivariate() {
        return this.asMultivariate((Comparator)MonomialOrder.DEFAULT);
    }

    @Override
    public MultivariatePolynomial<E> asMultivariate(Comparator<DegreeVector> ordering) {
        return MultivariatePolynomial.asMultivariate(this, 1, 0, ordering);
    }

    @Override
    public int compareTo(UnivariatePolynomial<E> o) {
        int c = Integer.compare(this.degree, o.degree);
        if (c != 0) {
            return c;
        }
        for (int i = this.degree; i >= 0; --i) {
            c = this.ring.compare(this.data[i], o.data[i]);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    @Override
    public String coefficientRingToString(IStringifier<UnivariatePolynomial<E>> stringifier) {
        return this.ring.toString(stringifier.substringifier(this.ring));
    }

    public String toString() {
        return this.toString(IStringifier.dummy());
    }

    @Override
    public String toString(IStringifier<UnivariatePolynomial<E>> stringifier) {
        IStringifier<E> cfStringifier = stringifier.substringifier(this.ring);
        if (this.isConstant()) {
            return cfStringifier.stringify(this.cc());
        }
        String varString = stringifier.getBindings().getOrDefault(this.createMonomial(1), IStringifier.defaultVar());
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= this.degree; ++i) {
            E el = this.data[i];
            if (this.ring.isZero(el)) continue;
            String cfString = !this.ring.isOne(el) || i == 0 ? cfStringifier.stringify(el) : "";
            if (i != 0 && IStringifier.needParenthesisInSum(cfString)) {
                cfString = "(" + cfString + ")";
            }
            if (sb.length() != 0 && !cfString.startsWith("-")) {
                sb.append("+");
            }
            sb.append(cfString);
            if (i == 0) continue;
            if (!cfString.isEmpty()) {
                sb.append("*");
            }
            sb.append(varString);
            if (i <= 1) continue;
            sb.append("^").append(i);
        }
        return sb.toString();
    }

    String toStringForCopy() {
        String s = ArraysUtil.toString(this.data, 0, this.degree + 1, x -> "new BigInteger(\"" + x + "\")");
        return "of(" + s.substring(1, s.length() - 1) + ")";
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        UnivariatePolynomial oth = (UnivariatePolynomial)obj;
        if (this.degree != oth.degree) {
            return false;
        }
        for (int i = 0; i <= this.degree; ++i) {
            if (this.data[i].equals(oth.data[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        for (int i = this.degree; i >= 0; --i) {
            result = 31 * result + this.data[i].hashCode();
        }
        return result;
    }

    final E[] multiplySafe0(UnivariatePolynomial<E> oth) {
        long md = 1L * (long)(this.degree + 1) * (long)(oth.degree + 1);
        if (this.isOverZ() && md >= 1024L) {
            return UnivariatePolynomial.multiplyKronecker0(this, oth);
        }
        if (md <= 65536L) {
            return this.multiplyClassicalSafe(this.data, 0, this.degree + 1, oth.data, 0, oth.degree + 1);
        }
        return this.multiplyKaratsubaSafe(this.data, 0, this.degree + 1, oth.data, 0, oth.degree + 1);
    }

    final E[] squareSafe0() {
        long md = 1L * (long)(this.degree + 1) * (long)(this.degree + 1);
        if (this.isOverZ() && md >= 1024L) {
            return UnivariatePolynomial.squareKronecker0(this);
        }
        if (md <= 65536L) {
            return this.squareClassicalSafe(this.data, 0, this.degree + 1);
        }
        return this.squareKaratsubaSafe(this.data, 0, this.degree + 1);
    }

    final E[] multiplyClassicalSafe(E[] a, int aFrom, int aTo, E[] b, int bFrom, int bTo) {
        E[] result = this.ring.createZeroesArray(aTo - aFrom + bTo - bFrom - 1);
        this.multiplyClassicalSafe(result, a, aFrom, aTo, b, bFrom, bTo);
        return result;
    }

    final void multiplyClassicalSafe(E[] result, E[] a, int aFrom, int aTo, E[] b, int bFrom, int bTo) {
        if (aTo - aFrom > bTo - bFrom) {
            this.multiplyClassicalSafe(result, b, bFrom, bTo, a, aFrom, aTo);
            return;
        }
        for (int i = 0; i < aTo - aFrom; ++i) {
            E c = a[aFrom + i];
            if (this.ring.isZero(c)) continue;
            for (int j = 0; j < bTo - bFrom; ++j) {
                result[i + j] = this.ring.addMutable(result[i + j], this.ring.multiply(c, b[bFrom + j]));
            }
        }
    }

    E[] multiplyKaratsubaSafe(E[] f, int fFrom, int fTo, E[] g, int gFrom, int gTo) {
        int i;
        int i2;
        int oldLen;
        if (fFrom >= fTo || gFrom >= gTo) {
            return this.ring.createArray(false);
        }
        if (fTo - fFrom == 1) {
            int[] result = this.ring.createArray(gTo - gFrom);
            for (int i3 = gFrom; i3 < gTo; ++i3) {
                result[i3 - gFrom] = (int)this.ring.multiply(f[fFrom], g[i3]);
            }
            return result;
        }
        if (gTo - gFrom == 1) {
            int[] result = this.ring.createArray(fTo - fFrom);
            for (int i4 = fFrom; i4 < fTo; ++i4) {
                result[i4 - fFrom] = (int)this.ring.multiply(g[gFrom], f[i4]);
            }
            return result;
        }
        if (fTo - fFrom == 2 && gTo - gFrom == 2) {
            int[] result = this.ring.createArray(3);
            result[0] = (int)this.ring.multiply(f[fFrom], g[gFrom]);
            result[1] = (int)this.ring.addMutable(this.ring.multiply(f[fFrom], g[gFrom + 1]), this.ring.multiply(f[fFrom + 1], g[gFrom]));
            result[2] = (int)this.ring.multiply(f[fFrom + 1], g[gFrom + 1]);
            return result;
        }
        if (1L * (long)(fTo - fFrom) * (long)(gTo - gFrom) < 1024L) {
            return this.multiplyClassicalSafe(g, gFrom, gTo, f, fFrom, fTo);
        }
        if (fTo - fFrom < gTo - gFrom) {
            return this.multiplyKaratsubaSafe(g, gFrom, gTo, f, fFrom, fTo);
        }
        int split = (fTo - fFrom + 1) / 2;
        if (gFrom + split >= gTo) {
            E[] f0g = this.multiplyKaratsubaSafe(f, fFrom, fFrom + split, g, gFrom, gTo);
            E[] f1g = this.multiplyKaratsubaSafe(f, fFrom + split, fTo, g, gFrom, gTo);
            int oldLen2 = f0g.length;
            int newLen = fTo - fFrom + gTo - gFrom - 1;
            E[] result = Arrays.copyOf(f0g, newLen);
            this.fillZeroes(result, oldLen2, newLen);
            for (int i5 = 0; i5 < f1g.length; ++i5) {
                result[i5 + split] = this.ring.addMutable(result[i5 + split], f1g[i5]);
            }
            return result;
        }
        int fMid = fFrom + split;
        int gMid = gFrom + split;
        E[] f0g0 = this.multiplyKaratsubaSafe(f, fFrom, fMid, g, gFrom, gMid);
        E[] f1g1 = this.multiplyKaratsubaSafe(f, fMid, fTo, g, gMid, gTo);
        int[] f0_plus_f1 = this.ring.createArray(Math.max(fMid - fFrom, fTo - fMid));
        System.arraycopy(f, fFrom, f0_plus_f1, 0, fMid - fFrom);
        this.fillZeroes(f0_plus_f1, fMid - fFrom, f0_plus_f1.length);
        for (int i6 = fMid; i6 < fTo; ++i6) {
            f0_plus_f1[i6 - fMid] = this.ring.add(f0_plus_f1[i6 - fMid], (int)f[i6]);
        }
        int[] g0_plus_g1 = this.ring.createArray(Math.max(gMid - gFrom, gTo - gMid));
        System.arraycopy(g, gFrom, g0_plus_g1, 0, gMid - gFrom);
        this.fillZeroes(g0_plus_g1, gMid - gFrom, g0_plus_g1.length);
        for (int i7 = gMid; i7 < gTo; ++i7) {
            g0_plus_g1[i7 - gMid] = this.ring.add(g0_plus_g1[i7 - gMid], (int)g[i7]);
        }
        int[] mid = this.multiplyKaratsubaSafe(f0_plus_f1, 0, f0_plus_f1.length, g0_plus_g1, 0, g0_plus_g1.length);
        if (mid.length < f0g0.length) {
            oldLen = mid.length;
            mid = Arrays.copyOf(mid, f0g0.length);
            this.fillZeroes(mid, oldLen, mid.length);
        }
        if (mid.length < f1g1.length) {
            oldLen = mid.length;
            mid = Arrays.copyOf(mid, f1g1.length);
            this.fillZeroes(mid, oldLen, mid.length);
        }
        for (i2 = 0; i2 < f0g0.length; ++i2) {
            mid[i2] = this.ring.subtractMutable(mid[i2], (int)f0g0[i2]);
        }
        for (i2 = 0; i2 < f1g1.length; ++i2) {
            mid[i2] = this.ring.subtractMutable(mid[i2], (int)f1g1[i2]);
        }
        oldLen = f0g0.length;
        E[] result = Arrays.copyOf(f0g0, fTo - fFrom + (gTo - gFrom) - 1);
        this.fillZeroes(result, oldLen, result.length);
        for (i = 0; i < mid.length; ++i) {
            result[i + split] = this.ring.addMutable((int)result[i + split], mid[i]);
        }
        for (i = 0; i < f1g1.length; ++i) {
            result[i + 2 * split] = this.ring.addMutable(result[i + 2 * split], f1g1[i]);
        }
        return result;
    }

    E[] squareClassicalSafe(E[] a, int from, int to) {
        E[] x = this.ring.createZeroesArray((to - from) * 2 - 1);
        this.squareClassicalSafe(x, a, from, to);
        return x;
    }

    void squareClassicalSafe(E[] result, E[] data, int from, int to) {
        int len = to - from;
        for (int i = 0; i < len; ++i) {
            E c = data[from + i];
            if (this.ring.isZero(c)) continue;
            for (int j = 0; j < len; ++j) {
                result[i + j] = this.ring.addMutable(result[i + j], this.ring.multiply(c, data[from + j]));
            }
        }
    }

    E[] squareKaratsubaSafe(E[] f, int fFrom, int fTo) {
        int i;
        int i2;
        int oldLen;
        if (fFrom >= fTo) {
            return this.ring.createArray(false);
        }
        if (fTo - fFrom == 1) {
            boolean[] r = this.ring.createArray(true);
            r[0] = this.ring.multiply(f[fFrom], f[fFrom]);
            return r;
        }
        if (fTo - fFrom == 2) {
            int[] result = this.ring.createArray(3);
            result[0] = (int)this.ring.multiply(f[fFrom], f[fFrom]);
            result[1] = (int)this.ring.multiplyMutable((long)this.ring.multiply(f[fFrom], f[fFrom + 1]), this.ring.valueOf(2L));
            result[2] = (int)this.ring.multiply(f[fFrom + 1], f[fFrom + 1]);
            return result;
        }
        if (1L * (long)(fTo - fFrom) * (long)(fTo - fFrom) < 1024L) {
            return this.squareClassicalSafe(f, fFrom, fTo);
        }
        int split = (fTo - fFrom + 1) / 2;
        int fMid = fFrom + split;
        E[] f0g0 = this.squareKaratsubaSafe(f, fFrom, fMid);
        E[] f1g1 = this.squareKaratsubaSafe(f, fMid, fTo);
        int[] f0_plus_f1 = this.ring.createArray(Math.max(fMid - fFrom, fTo - fMid));
        System.arraycopy(f, fFrom, f0_plus_f1, 0, fMid - fFrom);
        this.fillZeroes(f0_plus_f1, fMid - fFrom, f0_plus_f1.length);
        for (int i3 = fMid; i3 < fTo; ++i3) {
            f0_plus_f1[i3 - fMid] = this.ring.add(f0_plus_f1[i3 - fMid], (int)f[i3]);
        }
        int[] mid = this.squareKaratsubaSafe(f0_plus_f1, 0, f0_plus_f1.length);
        if (mid.length < f0g0.length) {
            oldLen = mid.length;
            mid = Arrays.copyOf(mid, f0g0.length);
            this.fillZeroes(mid, oldLen, mid.length);
        }
        if (mid.length < f1g1.length) {
            oldLen = mid.length;
            mid = Arrays.copyOf(mid, f1g1.length);
            this.fillZeroes(mid, oldLen, mid.length);
        }
        for (i2 = 0; i2 < f0g0.length; ++i2) {
            mid[i2] = this.ring.subtractMutable(mid[i2], (int)f0g0[i2]);
        }
        for (i2 = 0; i2 < f1g1.length; ++i2) {
            mid[i2] = this.ring.subtractMutable(mid[i2], (int)f1g1[i2]);
        }
        oldLen = f0g0.length;
        E[] result = Arrays.copyOf(f0g0, 2 * (fTo - fFrom) - 1);
        this.fillZeroes(result, oldLen, result.length);
        for (i = 0; i < mid.length; ++i) {
            result[i + split] = this.ring.addMutable((int)result[i + split], mid[i]);
        }
        for (i = 0; i < f1g1.length; ++i) {
            result[i + 2 * split] = this.ring.addMutable(result[i + 2 * split], f1g1[i]);
        }
        return result;
    }

    static UnivariatePolynomial<BigInteger> squareKronecker(UnivariatePolynomial<BigInteger> poly) {
        return UnivariatePolynomial.create(Rings.Z, UnivariatePolynomial.squareKronecker0(poly));
    }

    private static BigInteger[] squareKronecker0(UnivariatePolynomial<BigInteger> poly) {
        int len = poly.degree + 1;
        int logMinDigits = 32 - Integer.numberOfLeadingZeros(len - 1);
        int maxLength = 0;
        for (BigInteger cf : poly) {
            maxLength = Math.max(maxLength, cf.bitLength());
        }
        int k = logMinDigits + 2 * maxLength + 1;
        k = (k + 31) / 32;
        int[] pInt = UnivariatePolynomial.toIntArray(poly, k);
        int[] cInt = UnivariatePolynomial.toIntArray(UnivariatePolynomial.toBigInteger(pInt).pow(2));
        BigInteger[] cPoly = new BigInteger[2 * len - 1];
        UnivariatePolynomial.decodePoly(k, cInt, cPoly);
        return cPoly;
    }

    private static void decodePoly(int k, int[] cInt, BigInteger[] cPoly) {
        BigInteger _2k = BigInteger.ONE.shiftLeft(k * 32);
        Arrays.fill(cPoly, BigInteger.ZERO);
        for (int i = 0; i < cPoly.length; ++i) {
            int[] cfInt = Arrays.copyOfRange(cInt, i * k, (i + 1) * k);
            BigInteger cf = UnivariatePolynomial.toBigInteger(cfInt);
            if (cfInt[k - 1] < 0) {
                boolean carry;
                cf = cf.subtract(_2k);
                int cIdx = (i + 1) * k;
                do {
                    int n = cIdx;
                    cInt[n] = cInt[n] + 1;
                    carry = cInt[cIdx] == 0;
                    ++cIdx;
                } while (carry);
            }
            cPoly[i] = cPoly[i].add(cf);
        }
    }

    static UnivariatePolynomial<BigInteger> multiplyKronecker(UnivariatePolynomial<BigInteger> poly1, UnivariatePolynomial<BigInteger> poly2) {
        return UnivariatePolynomial.create(Rings.Z, UnivariatePolynomial.multiplyKronecker0(poly1, poly2));
    }

    static BigInteger[] multiplyKronecker0(UnivariatePolynomial<BigInteger> poly1, UnivariatePolynomial<BigInteger> poly2) {
        if (poly2.degree > poly1.degree) {
            return UnivariatePolynomial.multiplyKronecker0(poly2, poly1);
        }
        int len1 = poly1.degree + 1;
        int len2 = poly2.degree + 1;
        int logMinDigits = 32 - Integer.numberOfLeadingZeros(len1 - 1);
        int maxLengthA = 0;
        for (BigInteger bigInteger : poly1) {
            maxLengthA = Math.max(maxLengthA, bigInteger.bitLength());
        }
        int maxLengthB = 0;
        for (BigInteger cf : poly2) {
            maxLengthB = Math.max(maxLengthB, cf.bitLength());
        }
        int n2 = logMinDigits + maxLengthA + maxLengthB + 1;
        n2 = (n2 + 31) / 32;
        int[] aInt = UnivariatePolynomial.toIntArray(poly1, n2);
        int[] bInt = UnivariatePolynomial.toIntArray(poly2, n2);
        int[] cInt = UnivariatePolynomial.toIntArray(UnivariatePolynomial.toBigInteger(aInt).multiply(UnivariatePolynomial.toBigInteger(bInt)));
        BigInteger[] cPoly = new BigInteger[len1 + len2 - 1];
        UnivariatePolynomial.decodePoly(n2, cInt, cPoly);
        int aSign = poly1.lc().signum();
        int bSign = poly2.lc().signum();
        if (aSign * bSign < 0) {
            for (int i = 0; i < cPoly.length; ++i) {
                cPoly[i] = cPoly[i].negate();
            }
        }
        return cPoly;
    }

    private static BigInteger toBigInteger(int[] a) {
        byte[] b = new byte[a.length * 4];
        for (int i = 0; i < a.length; ++i) {
            int iRev = a.length - 1 - i;
            b[i * 4] = (byte)(a[iRev] >>> 24);
            b[i * 4 + 1] = (byte)(a[iRev] >>> 16 & 0xFF);
            b[i * 4 + 2] = (byte)(a[iRev] >>> 8 & 0xFF);
            b[i * 4 + 3] = (byte)(a[iRev] & 0xFF);
        }
        return new BigInteger(1, b);
    }

    private static int[] toIntArray(BigInteger a) {
        byte[] aArr = a.toByteArray();
        int[] b = new int[(aArr.length + 3) / 4];
        for (int i = 0; i < aArr.length; ++i) {
            int n = i / 4;
            b[n] = b[n] + ((aArr[aArr.length - 1 - i] & 0xFF) << i % 4 * 8);
        }
        return b;
    }

    private static int[] toIntArray(UnivariatePolynomial<BigInteger> a, int k) {
        int len = a.degree + 1;
        int sign = a.lc().signum();
        int[] aInt = new int[len * k];
        for (int i = len - 1; i >= 0; --i) {
            int[] cArr = UnivariatePolynomial.toIntArray(((BigInteger[])a.data)[i].abs());
            if (((BigInteger[])a.data)[i].signum() * sign < 0) {
                UnivariatePolynomial.subShifted(aInt, cArr, i * k);
                continue;
            }
            UnivariatePolynomial.addShifted(aInt, cArr, i * k);
        }
        return aInt;
    }

    private static void addShifted(int[] a, int[] b, int numElements) {
        int i;
        boolean carry = false;
        for (i = 0; i < Math.min(b.length, a.length - numElements); ++i) {
            int ai = a[i + numElements];
            int sum = ai + b[i];
            if (carry) {
                ++sum;
            }
            carry = sum >>> 31 < (ai >>> 31) + (b[i] >>> 31);
            a[i + numElements] = sum;
        }
        i += numElements;
        while (carry) {
            int n = i;
            a[n] = a[n] + 1;
            carry = a[i] == 0;
            ++i;
        }
    }

    private static void subShifted(int[] a, int[] b, int numElements) {
        int i;
        boolean carry = false;
        for (i = 0; i < Math.min(b.length, a.length - numElements); ++i) {
            int ai = a[i + numElements];
            int diff = ai - b[i];
            if (carry) {
                --diff;
            }
            carry = diff >>> 31 > (a[i] >>> 31) - (b[i] >>> 31);
            a[i + numElements] = diff;
        }
        i += numElements;
        while (carry) {
            int n = i;
            a[n] = a[n] - 1;
            carry = a[i] == -1;
            ++i;
        }
    }

    private final class It
    implements Iterator<E> {
        int index = 0;

        private It() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            UnivariatePolynomial univariatePolynomial = UnivariatePolynomial.this;
            synchronized (univariatePolynomial) {
                return this.index <= UnivariatePolynomial.this.degree;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            UnivariatePolynomial univariatePolynomial = UnivariatePolynomial.this;
            synchronized (univariatePolynomial) {
                return UnivariatePolynomial.this.data[this.index++];
            }
        }
    }

    public static final class PolynomialCollector<E>
    implements Collector<E, List<E>, UnivariatePolynomial<E>> {
        final Supplier<List<E>> supplier = ArrayList::new;
        final BiConsumer<List<E>, E> accumulator = List::add;
        final BinaryOperator<List<E>> combiner = (l, r) -> {
            l.addAll(r);
            return l;
        };
        final Function<List<E>, UnivariatePolynomial<E>> finisher;
        final Ring<E> ring;

        public PolynomialCollector(Ring<E> ring) {
            this.ring = ring;
            this.finisher = new ListToPoly<E>(ring);
        }

        @Override
        public Supplier<List<E>> supplier() {
            return this.supplier;
        }

        @Override
        public BiConsumer<List<E>, E> accumulator() {
            return this.accumulator;
        }

        @Override
        public BinaryOperator<List<E>> combiner() {
            return this.combiner;
        }

        @Override
        public Function<List<E>, UnivariatePolynomial<E>> finisher() {
            return this.finisher;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }
    }

    private static final class ListToPoly<E>
    implements Function<List<E>, UnivariatePolynomial<E>> {
        final Ring<E> ring;

        public ListToPoly(Ring<E> ring) {
            this.ring = ring;
        }

        @Override
        public UnivariatePolynomial<E> apply(List<E> es) {
            return UnivariatePolynomial.create(this.ring, es.toArray(this.ring.createArray(es.size())));
        }
    }
}

