/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.univar;

import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.poly.MachineArithmetic;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariateDivision;

public final class UnivariatePolynomialArithmetic {
    private static final long MONOMIAL_MOD_EXPONENT_THRESHOLD = 64L;

    private UnivariatePolynomialArithmetic() {
    }

    public static <T extends IUnivariatePolynomial<T>> T polyMod(T dividend, T polyModulus, boolean copy) {
        return UnivariateDivision.remainder(dividend, polyModulus, copy);
    }

    public static <T extends IUnivariatePolynomial<T>> T polyMod(T dividend, T polyModulus, UnivariateDivision.InverseModMonomial<T> invMod, boolean copy) {
        return UnivariateDivision.remainderFast(dividend, polyModulus, invMod, copy);
    }

    public static <T extends IUnivariatePolynomial<T>> T polyMultiplyMod(T m1, T m2, T polyModulus, boolean copy) {
        return UnivariatePolynomialArithmetic.polyMod((copy ? m1.clone() : m1).multiply(m2), polyModulus, false);
    }

    public static <T extends IUnivariatePolynomial<T>> T polyMultiplyMod(T m1, T m2, T polyModulus, UnivariateDivision.InverseModMonomial<T> invMod, boolean copy) {
        return UnivariatePolynomialArithmetic.polyMod((copy ? m1.clone() : m1).multiply(m2), polyModulus, invMod, false);
    }

    public static <T extends IUnivariatePolynomial<T>> T polyAddMod(T m1, T m2, T polyModulus, UnivariateDivision.InverseModMonomial<T> invMod, boolean copy) {
        return UnivariatePolynomialArithmetic.polyMod((copy ? m1.clone() : m1).add(m2), polyModulus, invMod, false);
    }

    public static <T extends IUnivariatePolynomial<T>> T polyAddMod(T m1, T m2, T polyModulus, boolean copy) {
        return UnivariatePolynomialArithmetic.polyMod((copy ? m1.clone() : m1).add(m2), polyModulus, false);
    }

    public static <T extends IUnivariatePolynomial<T>> T polySubtractMod(T m1, T m2, T polyModulus, UnivariateDivision.InverseModMonomial<T> invMod, boolean copy) {
        return UnivariatePolynomialArithmetic.polyMod((copy ? m1.clone() : m1).subtract(m2), polyModulus, invMod, false);
    }

    public static <T extends IUnivariatePolynomial<T>> T polySubtractMod(T m1, T m2, T polyModulus, boolean copy) {
        return UnivariatePolynomialArithmetic.polyMod((copy ? m1.clone() : m1).subtract(m2), polyModulus, false);
    }

    public static <T extends IUnivariatePolynomial<T>> T polyNegateMod(T m1, T polyModulus, UnivariateDivision.InverseModMonomial<T> invMod, boolean copy) {
        return (T)UnivariatePolynomialArithmetic.polyMod((IUnivariatePolynomial)(copy ? m1.clone() : m1).negate(), polyModulus, invMod, false);
    }

    public static <T extends IUnivariatePolynomial<T>> T polyNegateMod(T m1, T polyModulus, boolean copy) {
        return (T)UnivariatePolynomialArithmetic.polyMod((IUnivariatePolynomial)(copy ? m1.clone() : m1).negate(), polyModulus, false);
    }

    public static <T extends IUnivariatePolynomial<T>> T polyPow(T base, long exponent, boolean copy) {
        Object k2p;
        if (exponent < 0L) {
            throw new IllegalArgumentException();
        }
        IUnivariatePolynomial<Object> result = (IUnivariatePolynomial)base.createOne();
        Object object = k2p = copy ? base.clone() : base;
        while (true) {
            if ((exponent & 1L) != 0L) {
                result = result.multiply(k2p);
            }
            if ((exponent >>= 1) == 0L) {
                return (T)result;
            }
            k2p = (IUnivariatePolynomial)k2p.multiply((Object)k2p);
        }
    }

    public static <T extends IUnivariatePolynomial<T>> T polyPowMod(T base, long exponent, T polyModulus, boolean copy) {
        return UnivariatePolynomialArithmetic.polyPowMod(base, exponent, polyModulus, UnivariateDivision.fastDivisionPreConditioning(polyModulus), copy);
    }

    public static <T extends IUnivariatePolynomial<T>> T polyPowMod(T base, long exponent, T polyModulus, UnivariateDivision.InverseModMonomial<T> invMod, boolean copy) {
        if (exponent < 0L) {
            throw new IllegalArgumentException();
        }
        if (exponent == 0L) {
            return (T)((IUnivariatePolynomial)base.createOne());
        }
        IUnivariatePolynomial<Object> result = (IUnivariatePolynomial)base.createOne();
        T k2p = UnivariatePolynomialArithmetic.polyMod(base, polyModulus, invMod, copy);
        while (true) {
            if ((exponent & 1L) != 0L) {
                result = UnivariatePolynomialArithmetic.polyMod(result.multiply(k2p), polyModulus, invMod, false);
            }
            if ((exponent >>= 1) == 0L) {
                return (T)result;
            }
            k2p = UnivariatePolynomialArithmetic.polyMod(k2p.multiply(k2p), polyModulus, invMod, false);
        }
    }

    public static <T extends IUnivariatePolynomial<T>> T polyPowMod(T base, BigInteger exponent, T polyModulus, UnivariateDivision.InverseModMonomial<T> invMod, boolean copy) {
        if (exponent.signum() < 0) {
            throw new IllegalArgumentException();
        }
        if (exponent.isZero()) {
            return (T)((IUnivariatePolynomial)base.createOne());
        }
        IUnivariatePolynomial<Object> result = (IUnivariatePolynomial)base.createOne();
        T k2p = UnivariatePolynomialArithmetic.polyMod(base, polyModulus, invMod, copy);
        while (true) {
            if (exponent.testBit(0)) {
                result = UnivariatePolynomialArithmetic.polyMod(result.multiply(k2p), polyModulus, invMod, false);
            }
            if ((exponent = exponent.shiftRight(1)).isZero()) {
                return (T)result;
            }
            k2p = UnivariatePolynomialArithmetic.polyMod(k2p.multiply(k2p), polyModulus, invMod, false);
        }
    }

    public static <T extends IUnivariatePolynomial<T>> T polyPowMod(T base, BigInteger exponent, T polyModulus, boolean copy) {
        return UnivariatePolynomialArithmetic.polyPowMod(base, exponent, polyModulus, UnivariateDivision.fastDivisionPreConditioning(polyModulus), copy);
    }

    public static <T extends IUnivariatePolynomial<T>> T createMonomialMod(long exponent, T polyModulus, UnivariateDivision.InverseModMonomial<T> invMod) {
        if (exponent < 0L) {
            throw new IllegalArgumentException("Negative exponent: " + exponent);
        }
        if (exponent == 0L) {
            return (T)((IUnivariatePolynomial)polyModulus.createOne());
        }
        if (exponent < 64L) {
            return UnivariatePolynomialArithmetic.smallMonomial(exponent, polyModulus, invMod);
        }
        return UnivariatePolynomialArithmetic.largeMonomial(exponent, polyModulus, invMod);
    }

    public static <T extends IUnivariatePolynomial<T>> T createMonomialMod(BigInteger exponent, T polyModulus, UnivariateDivision.InverseModMonomial<T> invMod) {
        if (exponent.signum() < 0) {
            throw new IllegalArgumentException("Negative exponent: " + exponent);
        }
        if (exponent.isZero()) {
            return (T)((IUnivariatePolynomial)polyModulus.createOne());
        }
        if (exponent.isLong()) {
            return UnivariatePolynomialArithmetic.createMonomialMod(exponent.longValueExact(), polyModulus, invMod);
        }
        return UnivariatePolynomialArithmetic.largeMonomial(exponent, polyModulus, invMod);
    }

    static <T extends IUnivariatePolynomial<T>> T smallMonomial(long exponent, T polyModulus, UnivariateDivision.InverseModMonomial<T> invMod) {
        return UnivariatePolynomialArithmetic.polyMod(polyModulus.createMonomial(MachineArithmetic.safeToInt(exponent)), polyModulus, invMod, false);
    }

    static <T extends IUnivariatePolynomial<T>> T largeMonomial(long exponent, T polyModulus, UnivariateDivision.InverseModMonomial<T> invMod) {
        return UnivariatePolynomialArithmetic.polyPowMod(polyModulus.createMonomial(1), exponent, polyModulus, invMod, false);
    }

    static <T extends IUnivariatePolynomial<T>> T largeMonomial(BigInteger exponent, T polyModulus, UnivariateDivision.InverseModMonomial<T> invMod) {
        return UnivariatePolynomialArithmetic.polyPowMod(polyModulus.createMonomial(1), exponent, polyModulus, invMod, false);
    }
}

