/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.univar;

import cc.redberry.rings.ChineseRemainders;
import cc.redberry.rings.IntegersZp;
import cc.redberry.rings.IntegersZp64;
import cc.redberry.rings.Rational;
import cc.redberry.rings.Ring;
import cc.redberry.rings.Rings;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.poly.AlgebraicNumberField;
import cc.redberry.rings.poly.FiniteField;
import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.MultipleFieldExtension;
import cc.redberry.rings.poly.SimpleFieldExtension;
import cc.redberry.rings.poly.Util;
import cc.redberry.rings.poly.multivar.AMonomial;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariateDivision;
import cc.redberry.rings.poly.univar.UnivariateGCD;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZp64;
import cc.redberry.rings.primes.PrimesIterator;
import gnu.trove.list.array.TLongArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;

public final class UnivariateResultants {
    private UnivariateResultants() {
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> Poly DiscriminantAsPoly(Poly a) {
        if (a instanceof UnivariatePolynomialZp64) {
            return (Poly)((UnivariatePolynomialZp64)a).createConstant(UnivariateResultants.Discriminant((UnivariatePolynomialZp64)a));
        }
        return (Poly)((UnivariatePolynomial)a).createConstant(UnivariateResultants.Discriminant((UnivariatePolynomial)a));
    }

    public static <E> E Discriminant(UnivariatePolynomial<E> a) {
        Ring ring = a.ring;
        Object disc = ring.divideExact(UnivariateResultants.Resultant(a, a.derivative()), a.lc());
        return a.degree * (a.degree - 1) / 2 % 2 == 1 ? ring.negate(disc) : disc;
    }

    public static long Discriminant(UnivariatePolynomialZp64 a) {
        IntegersZp64 ring = a.ring;
        long disc = ring.divide(UnivariateResultants.Resultant(a, a.derivative()), a.lc());
        return a.degree * (a.degree - 1) / 2 % 2 == 1 ? ring.negate(disc) : disc;
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> Poly ResultantAsPoly(Poly a, Poly b) {
        if (a instanceof UnivariatePolynomialZp64) {
            return (Poly)((UnivariatePolynomialZp64)a).createConstant(UnivariateResultants.Resultant((UnivariatePolynomialZp64)a, (UnivariatePolynomialZp64)b));
        }
        return (Poly)((UnivariatePolynomial)a).createConstant(UnivariateResultants.Resultant((UnivariatePolynomial)a, (UnivariatePolynomial)b));
    }

    public static <E> E Resultant(UnivariatePolynomial<E> a, UnivariatePolynomial<E> b) {
        if (Util.isOverMultipleFieldExtension(a)) {
            return UnivariateResultants.ResultantInMultipleFieldExtension(a, b);
        }
        if (a.isOverFiniteField()) {
            return UnivariateResultants.ClassicalPRS(a, b).resultant();
        }
        if (Util.isOverRationals(a)) {
            return (E)UnivariateResultants.ResultantInQ(a, b);
        }
        if (a.isOverZ()) {
            return (E)UnivariateResultants.ModularResultant(a, b);
        }
        if (Util.isOverSimpleNumberField(a)) {
            return (E)UnivariateResultants.ModularResultantInNumberField(a, b);
        }
        if (Util.isOverRingOfIntegersOfSimpleNumberField(a)) {
            return (E)UnivariateResultants.ModularResultantInRingOfIntegersOfNumberField(a, b);
        }
        return (E)UnivariateResultants.PrimitiveResultant(a, b, (p, q) -> UnivariateResultants.SubresultantPRS(p, q).resultant());
    }

    public static long Resultant(UnivariatePolynomialZp64 a, UnivariatePolynomialZp64 b) {
        return UnivariateResultants.ClassicalPRS(a, b).resultant();
    }

    private static <E> Rational<E> ResultantInQ(UnivariatePolynomial<Rational<E>> a, UnivariatePolynomial<Rational<E>> b) {
        Util.Tuple2<UnivariatePolynomial<E>, E> aZ = Util.toCommonDenominator(a);
        Util.Tuple2<UnivariatePolynomial<E>, E> bZ = Util.toCommonDenominator(b);
        Ring<Object> ring = ((UnivariatePolynomial)aZ._1).ring;
        E resultant = UnivariateResultants.Resultant((UnivariatePolynomial)aZ._1, (UnivariatePolynomial)bZ._1);
        Object den = ring.multiply(ring.pow(aZ._2, b.degree), ring.pow(bZ._2, a.degree));
        return new Rational(ring, resultant, den);
    }

    private static <Term extends AMonomial<Term>, mPoly extends AMultivariatePolynomial<Term, mPoly>, sPoly extends IUnivariatePolynomial<sPoly>> mPoly ResultantInMultipleFieldExtension(UnivariatePolynomial<mPoly> a, UnivariatePolynomial<mPoly> b) {
        MultipleFieldExtension ring = (MultipleFieldExtension)a.ring;
        SimpleFieldExtension simpleExtension = ring.getSimpleExtension();
        return (mPoly)((AMultivariatePolynomial)ring.image(UnivariateResultants.Resultant(a.mapCoefficients(simpleExtension, ring::inverse), b.mapCoefficients(simpleExtension, ring::inverse))));
    }

    public static <E> List<E> Subresultants(UnivariatePolynomial<E> a, UnivariatePolynomial<E> b) {
        if (a.isOverField()) {
            return UnivariateResultants.ClassicalPRS(a, b).getSubresultants();
        }
        return UnivariateResultants.SubresultantPRS(a, b).getSubresultants();
    }

    static <E> E PrimitiveResultant(UnivariatePolynomial<E> a, UnivariatePolynomial<E> b, BiFunction<UnivariatePolynomial<E>, UnivariatePolynomial<E>, E> algorithm) {
        E ac = a.content();
        E bc = b.content();
        a = ((UnivariatePolynomial)a.clone()).divideExact(ac);
        b = ((UnivariatePolynomial)b.clone()).divideExact(bc);
        E r = algorithm.apply(a, b);
        Ring<E> ring = a.ring;
        r = ring.multiply(r, (E)ring.pow(ac, b.degree));
        r = ring.multiply(r, (E)ring.pow(bc, a.degree));
        return r;
    }

    public static BigInteger ModularResultant(UnivariatePolynomial<BigInteger> a, UnivariatePolynomial<BigInteger> b) {
        return UnivariateResultants.PrimitiveResultant(a, b, UnivariateResultants::ModularResultant0);
    }

    private static BigInteger ModularResultant0(UnivariatePolynomial<BigInteger> a, UnivariatePolynomial<BigInteger> b) {
        BigInteger bound = UnivariatePolynomial.norm2(a).pow(b.degree).multiply(UnivariatePolynomial.norm2(b).pow(a.degree)).shiftLeft(1);
        BigInteger bModulus = null;
        BigInteger resultant = null;
        PrimesIterator primes = new PrimesIterator(0x2000000L);
        while (true) {
            long prime = primes.take();
            BigInteger bPrime = BigInteger.valueOf(prime);
            IntegersZp zpRing = Rings.Zp(prime);
            UnivariatePolynomialZp64 aMod = UnivariatePolynomial.asOverZp64(a.setRing(zpRing));
            UnivariatePolynomialZp64 bMod = UnivariatePolynomial.asOverZp64(b.setRing(zpRing));
            if (aMod.degree != a.degree || bMod.degree != b.degree) continue;
            long resultantMod = UnivariateResultants.ClassicalPRS(aMod, bMod).resultant();
            BigInteger bResultantMod = BigInteger.valueOf(resultantMod);
            if (bModulus == null) {
                bModulus = bPrime;
                resultant = bResultantMod;
                continue;
            }
            if (!resultant.isZero() && resultantMod == 0L) continue;
            resultant = ChineseRemainders.ChineseRemainders(bModulus, bPrime, resultant, bResultantMod);
            if ((bModulus = bModulus.multiply(BigInteger.valueOf(prime))).compareTo(bound) > 0) break;
        }
        return Rings.Zp(bModulus).symmetricForm(resultant);
    }

    private static <E> UnivariatePolynomial<E> TrivialResultantInNumberField(UnivariatePolynomial<UnivariatePolynomial<E>> a, UnivariatePolynomial<UnivariatePolynomial<E>> b) {
        AlgebraicNumberField ring;
        block3: {
            block2: {
                ring = (AlgebraicNumberField)a.ring;
                if (!a.stream().allMatch(ring::isInTheBaseField)) break block2;
                if (b.stream().allMatch(ring::isInTheBaseField)) break block3;
            }
            return null;
        }
        UnivariatePolynomial<Object> ar = a.mapCoefficients(((UnivariatePolynomial)ring.getMinimalPolynomial()).ring, UnivariatePolynomial::cc);
        UnivariatePolynomial<Object> br = b.mapCoefficients(((UnivariatePolynomial)ring.getMinimalPolynomial()).ring, UnivariatePolynomial::cc);
        return UnivariatePolynomial.constant(((UnivariatePolynomial)ring.getMinimalPolynomial()).ring, UnivariateResultants.Resultant(ar, br));
    }

    public static UnivariatePolynomial<Rational<BigInteger>> ModularResultantInNumberField(UnivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> a, UnivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> b) {
        UnivariatePolynomial<Rational<BigInteger>> r = UnivariateResultants.TrivialResultantInNumberField(a, b);
        if (r != null) {
            return r;
        }
        AlgebraicNumberField numberField = (AlgebraicNumberField)((UnivariatePolynomial)a).ring;
        UnivariatePolynomial minimalPoly = (UnivariatePolynomial)numberField.getMinimalPolynomial();
        assert (numberField.isField());
        a = ((UnivariatePolynomial)a).clone();
        b = ((UnivariatePolynomial)b).clone();
        if (minimalPoly.stream().allMatch(Rational::isIntegral)) {
            UnivariatePolynomial<BigInteger> minimalPolyZ = minimalPoly.mapCoefficients(Rings.Z, Rational::numerator);
            AlgebraicNumberField<UnivariatePolynomial<BigInteger>> numberFieldZ = new AlgebraicNumberField<UnivariatePolynomial<BigInteger>>(minimalPolyZ);
            BigInteger aDen = UnivariateGCD.removeDenominators((UnivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>>)a);
            BigInteger bDen = UnivariateGCD.removeDenominators((UnivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>>)b);
            BigInteger den = aDen.pow(((UnivariatePolynomial)b).degree).multiply(bDen.pow(((UnivariatePolynomial)a).degree));
            assert (((UnivariatePolynomial)a).stream().allMatch(p -> p.stream().allMatch(Rational::isIntegral)));
            assert (((UnivariatePolynomial)b).stream().allMatch(p -> p.stream().allMatch(Rational::isIntegral)));
            return UnivariateResultants.ModularResultantInRingOfIntegersOfNumberField(((UnivariatePolynomial)a).mapCoefficients(numberFieldZ, cf -> cf.mapCoefficients(Rings.Z, Rational::numerator)), ((UnivariatePolynomial)b).mapCoefficients(numberFieldZ, cf -> cf.mapCoefficients(Rings.Z, Rational::numerator))).mapCoefficients(Rings.Q, cf -> Rings.Q.mk((BigInteger)cf, den));
        }
        BigInteger minPolyLeadCoeff = (BigInteger)((UnivariatePolynomial)Util.toCommonDenominator(minimalPoly)._1).lc();
        Rational<BigInteger> scale = new Rational<BigInteger>(Rings.Z, Rings.Z.getOne(), minPolyLeadCoeff);
        Rational<BigInteger> scaleReciprocal = scale.reciprocal();
        AlgebraicNumberField<IPolynomial> scaledNumberField = new AlgebraicNumberField<IPolynomial>(minimalPoly.scale(scale).monic());
        return UnivariateResultants.ModularResultantInNumberField(((UnivariatePolynomial)a).mapCoefficients(scaledNumberField, cf -> cf.scale(scale)), ((UnivariatePolynomial)b).mapCoefficients(scaledNumberField, cf -> cf.scale(scale))).scale(scaleReciprocal);
    }

    public static BigInteger polyPowNumFieldCfBound(BigInteger maxCf, BigInteger maxMinPolyCf, int minPolyDeg, int exponent) {
        return BigInteger.valueOf(minPolyDeg).pow(exponent - 1).multiply(maxCf.pow(exponent)).multiply(maxMinPolyCf.increment().pow((exponent - 1) * (minPolyDeg + 1)));
    }

    public static UnivariatePolynomial<BigInteger> ModularResultantInRingOfIntegersOfNumberField(UnivariatePolynomial<UnivariatePolynomial<BigInteger>> a, UnivariatePolynomial<UnivariatePolynomial<BigInteger>> b) {
        return UnivariateResultants.PrimitiveResultant(a, b, UnivariateResultants::ModularResultantInRingOfIntegersOfNumberField0);
    }

    private static UnivariatePolynomial<BigInteger> ModularResultantInRingOfIntegersOfNumberField0(UnivariatePolynomial<UnivariatePolynomial<BigInteger>> a, UnivariatePolynomial<UnivariatePolynomial<BigInteger>> b) {
        UnivariatePolynomial<BigInteger> r = UnivariateResultants.TrivialResultantInNumberField(a, b);
        if (r != null) {
            return r;
        }
        AlgebraicNumberField numberField = (AlgebraicNumberField)a.ring;
        UnivariatePolynomial minimalPoly = (UnivariatePolynomial)numberField.getMinimalPolynomial();
        BigInteger aMax = a.stream().flatMap(UnivariatePolynomial::stream).map(Rings.Z::abs).max(Rings.Z).orElse(BigInteger.ZERO);
        BigInteger bMax = b.stream().flatMap(UnivariatePolynomial::stream).map(Rings.Z::abs).max(Rings.Z).orElse(BigInteger.ZERO);
        BigInteger mMax = (BigInteger)minimalPoly.maxAbsCoefficient();
        BigInteger bound = UnivariateResultants.polyPowNumFieldCfBound(aMax, mMax, minimalPoly.degree, b.degree).multiply(UnivariateResultants.polyPowNumFieldCfBound(bMax, mMax, minimalPoly.degree, a.degree));
        BigInteger bModulus = null;
        UnivariatePolynomial<BigInteger> resultant = null;
        PrimesIterator primes = new PrimesIterator(0x2000000L);
        while (true) {
            long prime = primes.take();
            IntegersZp64 zpRing = Rings.Zp64(prime);
            UnivariatePolynomialZp64 minimalPolyMod = UnivariatePolynomial.asOverZp64(minimalPoly, zpRing);
            FiniteField<UnivariatePolynomialZp64> numberFieldMod = new FiniteField<UnivariatePolynomialZp64>(minimalPolyMod);
            UnivariatePolynomial<UnivariatePolynomialZp64> aMod = a.mapCoefficients(numberFieldMod, cf -> UnivariatePolynomial.asOverZp64(cf, zpRing));
            UnivariatePolynomial<UnivariatePolynomialZp64> bMod = b.mapCoefficients(numberFieldMod, cf -> UnivariatePolynomial.asOverZp64(cf, zpRing));
            if (aMod.degree != a.degree || bMod.degree != b.degree) continue;
            UnivariatePolynomialZp64 resultantMod = UnivariateResultants.ClassicalPRS(aMod, bMod).resultant();
            if (bModulus == null) {
                bModulus = BigInteger.valueOf(prime);
                resultant = resultantMod.toBigPoly();
                continue;
            }
            if (!resultant.isZero() && resultantMod.isZero()) continue;
            UnivariateGCD.updateCRT(ChineseRemainders.createMagic(Rings.Z, bModulus, BigInteger.valueOf(prime)), resultant, resultantMod);
            if ((bModulus = bModulus.multiply(BigInteger.valueOf(prime))).compareTo(bound) > 0) break;
        }
        return UnivariatePolynomial.asPolyZSymmetric(resultant.setRingUnsafe(Rings.Zp(bModulus)));
    }

    public static PolynomialRemainderSequenceZp64 ClassicalPRS(UnivariatePolynomialZp64 a, UnivariatePolynomialZp64 b) {
        return new PolynomialRemainderSequenceZp64(a, b).run();
    }

    public static <E> PolynomialRemainderSequence<E> ClassicalPRS(UnivariatePolynomial<E> a, UnivariatePolynomial<E> b) {
        return new ClassicalPolynomialRemainderSequence<E>(a, b).run();
    }

    public static <E> PolynomialRemainderSequence<E> PseudoPRS(UnivariatePolynomial<E> a, UnivariatePolynomial<E> b) {
        return new PseudoPolynomialRemainderSequence<E>(a, b).run();
    }

    public static <E> PolynomialRemainderSequence<E> PrimitivePRS(UnivariatePolynomial<E> a, UnivariatePolynomial<E> b) {
        return new PrimitivePolynomialRemainderSequence<E>(a, b).run();
    }

    public static <E> PolynomialRemainderSequence<E> ReducedPRS(UnivariatePolynomial<E> a, UnivariatePolynomial<E> b) {
        return new ReducedPolynomialRemainderSequence<E>(a, b).run();
    }

    public static <E> PolynomialRemainderSequence<E> SubresultantPRS(UnivariatePolynomial<E> a, UnivariatePolynomial<E> b) {
        return new SubresultantPolynomialRemainderSequence<E>(a, b).run();
    }

    public static abstract class PolynomialRemainderSequence<E>
    extends APolynomialRemainderSequence<UnivariatePolynomial<E>> {
        public final List<E> alphas = new ArrayList();
        public final List<E> betas = new ArrayList();
        final Ring<E> ring;
        final boolean swap;
        private final ArrayList<E> subresultants = new ArrayList();

        PolynomialRemainderSequence(UnivariatePolynomial<E> a, UnivariatePolynomial<E> b) {
            super(a, b);
            this.ring = a.ring;
            if (a.degree >= b.degree) {
                this.remainders.add(a);
                this.remainders.add(b);
                this.swap = false;
            } else {
                this.remainders.add(b);
                this.remainders.add(a);
                this.swap = a.degree % 2 == 1 && b.degree % 2 == 1;
            }
        }

        abstract E nextAlpha();

        abstract E nextBeta(UnivariatePolynomial<E> var1);

        private UnivariatePolynomial<E> step() {
            int i = this.remainders.size();
            UnivariatePolynomial<E> dividend = ((UnivariatePolynomial)this.remainders.get(i - 2)).clone();
            UnivariatePolynomial divider = (UnivariatePolynomial)this.remainders.get(i - 1);
            E alpha = this.nextAlpha();
            UnivariatePolynomial<E>[] qd = UnivariateDivision.divideAndRemainder(dividend = dividend.multiply(alpha), divider, false);
            if (qd == null) {
                throw new RuntimeException("exact division is not possible");
            }
            UnivariatePolynomial<E> quotient = qd[0];
            UnivariatePolynomial<E> remainder = qd[1];
            if (remainder.isZero()) {
                return remainder;
            }
            E beta = this.nextBeta(remainder);
            remainder = remainder.divideExact(beta);
            this.alphas.add(alpha);
            this.betas.add(beta);
            this.quotients.add(quotient);
            this.remainders.add(remainder);
            return remainder;
        }

        final PolynomialRemainderSequence<E> run() {
            if (((UnivariatePolynomial)this.lastRemainder()).isZero()) {
                return this;
            }
            while (!this.step().isZero()) {
            }
            return this;
        }

        final int degreeDiff(int i) {
            return ((UnivariatePolynomial)this.remainders.get((int)i)).degree - ((UnivariatePolynomial)this.remainders.get((int)(i + 1))).degree;
        }

        final synchronized void computeSubresultants() {
            int i;
            if (!this.subresultants.isEmpty()) {
                return;
            }
            List<E> subresultants = this.nonZeroSubresultants();
            if (this.swap) {
                subresultants.replaceAll(this.ring::negate);
            }
            this.subresultants.ensureCapacity(((UnivariatePolynomial)this.remainders.get((int)1)).degree);
            for (i = 0; i <= ((UnivariatePolynomial)this.remainders.get((int)1)).degree; ++i) {
                this.subresultants.add(this.ring.getZero());
            }
            for (i = 1; i < this.remainders.size(); ++i) {
                this.subresultants.set(((UnivariatePolynomial)this.remainders.get((int)i)).degree, subresultants.get(i - 1));
            }
        }

        List<E> nonZeroSubresultants() {
            ArrayList<E> subresultants = new ArrayList<E>();
            E subresultant = this.ring.pow(((UnivariatePolynomial)this.remainders.get(1)).lc(), this.degreeDiff(0));
            subresultants.add(subresultant);
            for (int i = 1; i < this.remainders.size() - 1; ++i) {
                int di = this.degreeDiff(i);
                E rho = this.ring.pow(this.ring.multiply(((UnivariatePolynomial)this.remainders.get(i + 1)).lc(), ((UnivariatePolynomial)this.remainders.get(i)).lc()), di);
                E den = this.ring.getOne();
                for (int j = 1; j <= i; ++j) {
                    rho = this.ring.multiply(rho, this.ring.pow(this.betas.get(j - 1), di));
                    den = this.ring.multiply(den, this.ring.pow(this.alphas.get(j - 1), di));
                }
                if (di % 2 == 1 && (((UnivariatePolynomial)this.remainders.get((int)0)).degree - ((UnivariatePolynomial)this.remainders.get((int)(i + 1))).degree + i + 1) % 2 == 1) {
                    rho = this.ring.negate(rho);
                }
                subresultant = this.ring.multiply(subresultant, rho);
                subresultant = this.ring.divideExact(subresultant, den);
                subresultants.add(subresultant);
            }
            return subresultants;
        }

        public final List<E> getSubresultants() {
            if (this.subresultants.isEmpty()) {
                this.computeSubresultants();
            }
            return this.subresultants;
        }

        public final E resultant() {
            return this.getSubresultants().get(0);
        }
    }

    public static final class PolynomialRemainderSequenceZp64
    extends APolynomialRemainderSequence<UnivariatePolynomialZp64> {
        final IntegersZp64 ring;
        final boolean swap;
        private final TLongArrayList subresultants = new TLongArrayList();

        PolynomialRemainderSequenceZp64(UnivariatePolynomialZp64 a, UnivariatePolynomialZp64 b) {
            super(a, b);
            this.ring = a.ring;
            if (a.degree >= b.degree) {
                this.remainders.add(a);
                this.remainders.add(b);
                this.swap = false;
            } else {
                this.remainders.add(b);
                this.remainders.add(a);
                this.swap = a.degree % 2 == 1 && b.degree % 2 == 1;
            }
        }

        private UnivariatePolynomialZp64 step() {
            UnivariatePolynomialZp64 divider;
            int i = this.remainders.size();
            UnivariatePolynomialZp64 dividend = ((UnivariatePolynomialZp64)this.remainders.get(i - 2)).clone();
            UnivariatePolynomialZp64[] qd = UnivariateDivision.divideAndRemainder(dividend, divider = (UnivariatePolynomialZp64)this.remainders.get(i - 1), false);
            if (qd == null) {
                throw new RuntimeException("exact division is not possible");
            }
            UnivariatePolynomialZp64 quotient = qd[0];
            UnivariatePolynomialZp64 remainder = qd[1];
            if (remainder.isZero()) {
                return remainder;
            }
            this.quotients.add(quotient);
            this.remainders.add(remainder);
            return remainder;
        }

        private PolynomialRemainderSequenceZp64 run() {
            while (!this.step().isZero()) {
            }
            return this;
        }

        final int degreeDiff(int i) {
            return ((UnivariatePolynomialZp64)this.remainders.get((int)i)).degree - ((UnivariatePolynomialZp64)this.remainders.get((int)(i + 1))).degree;
        }

        final synchronized void computeSubresultants() {
            int i;
            if (!this.subresultants.isEmpty()) {
                return;
            }
            TLongArrayList subresultants = this.nonZeroSubresultants();
            if (this.swap) {
                for (i = 0; i < subresultants.size(); ++i) {
                    subresultants.set(i, this.ring.negate(subresultants.get(i)));
                }
            }
            this.subresultants.ensureCapacity(((UnivariatePolynomialZp64)this.remainders.get((int)1)).degree);
            for (i = 0; i <= ((UnivariatePolynomialZp64)this.remainders.get((int)1)).degree; ++i) {
                this.subresultants.add(0L);
            }
            for (i = 1; i < this.remainders.size(); ++i) {
                this.subresultants.set(((UnivariatePolynomialZp64)this.remainders.get((int)i)).degree, subresultants.get(i - 1));
            }
        }

        TLongArrayList nonZeroSubresultants() {
            TLongArrayList subresultants = new TLongArrayList();
            long subresultant = this.ring.powMod(((UnivariatePolynomialZp64)this.remainders.get(1)).lc(), this.degreeDiff(0));
            subresultants.add(subresultant);
            for (int i = 1; i < this.remainders.size() - 1; ++i) {
                int di = this.degreeDiff(i);
                long rho = this.ring.powMod(this.ring.multiply(((UnivariatePolynomialZp64)this.remainders.get(i + 1)).lc(), ((UnivariatePolynomialZp64)this.remainders.get(i)).lc()), di);
                if (di % 2 == 1 && (((UnivariatePolynomialZp64)this.remainders.get((int)0)).degree - ((UnivariatePolynomialZp64)this.remainders.get((int)(i + 1))).degree + i + 1) % 2 == 1) {
                    rho = this.ring.negate(rho);
                }
                subresultant = this.ring.multiply(subresultant, rho);
                subresultants.add(subresultant);
            }
            return subresultants;
        }

        public final TLongArrayList getSubresultants() {
            if (this.subresultants.isEmpty()) {
                this.computeSubresultants();
            }
            return this.subresultants;
        }

        public final long resultant() {
            return this.getSubresultants().get(0);
        }
    }

    private static final class ClassicalPolynomialRemainderSequence<E>
    extends PolynomialRemainderSequence<E> {
        ClassicalPolynomialRemainderSequence(UnivariatePolynomial<E> a, UnivariatePolynomial<E> b) {
            super(a, b);
        }

        @Override
        final E nextAlpha() {
            return this.ring.getOne();
        }

        @Override
        E nextBeta(UnivariatePolynomial<E> remainder) {
            return this.ring.getOne();
        }

        @Override
        List<E> nonZeroSubresultants() {
            ArrayList subresultants = new ArrayList();
            Object subresultant = this.ring.pow(((UnivariatePolynomial)this.remainders.get(1)).lc(), this.degreeDiff(0));
            subresultants.add(subresultant);
            for (int i = 1; i < this.remainders.size() - 1; ++i) {
                int di = this.degreeDiff(i);
                Object rho = this.ring.pow(this.ring.multiply(((UnivariatePolynomial)this.remainders.get(i + 1)).lc(), ((UnivariatePolynomial)this.remainders.get(i)).lc()), di);
                if (di % 2 == 1 && (((UnivariatePolynomial)this.remainders.get((int)0)).degree - ((UnivariatePolynomial)this.remainders.get((int)(i + 1))).degree + i + 1) % 2 == 1) {
                    rho = this.ring.negate(rho);
                }
                subresultant = this.ring.multiply(subresultant, rho);
                subresultants.add(subresultant);
            }
            return subresultants;
        }
    }

    private static class PseudoPolynomialRemainderSequence<E>
    extends PolynomialRemainderSequence<E> {
        PseudoPolynomialRemainderSequence(UnivariatePolynomial<E> a, UnivariatePolynomial<E> b) {
            super(a, b);
        }

        @Override
        final E nextAlpha() {
            int i = this.remainders.size();
            Object lc = ((UnivariatePolynomial)this.remainders.get(i - 1)).lc();
            int deg = ((UnivariatePolynomial)this.remainders.get((int)(i - 2))).degree - ((UnivariatePolynomial)this.remainders.get((int)(i - 1))).degree;
            return this.ring.pow(lc, deg + 1);
        }

        @Override
        E nextBeta(UnivariatePolynomial<E> remainder) {
            return this.ring.getOne();
        }
    }

    private static final class PrimitivePolynomialRemainderSequence<E>
    extends PseudoPolynomialRemainderSequence<E> {
        PrimitivePolynomialRemainderSequence(UnivariatePolynomial<E> a, UnivariatePolynomial<E> b) {
            super(a, b);
        }

        @Override
        E nextBeta(UnivariatePolynomial<E> remainder) {
            return remainder.content();
        }
    }

    private static final class ReducedPolynomialRemainderSequence<E>
    extends PseudoPolynomialRemainderSequence<E> {
        ReducedPolynomialRemainderSequence(UnivariatePolynomial<E> a, UnivariatePolynomial<E> b) {
            super(a, b);
        }

        @Override
        E nextBeta(UnivariatePolynomial<E> remainder) {
            return this.alphas.isEmpty() ? this.ring.getOne() : this.alphas.get(this.alphas.size() - 1);
        }

        @Override
        List<E> nonZeroSubresultants() {
            ArrayList subresultants = new ArrayList();
            Object subresultant = this.ring.pow(((UnivariatePolynomial)this.remainders.get(1)).lc(), this.degreeDiff(0));
            subresultants.add(subresultant);
            for (int i = 1; i < this.remainders.size() - 1; ++i) {
                int di = this.degreeDiff(i);
                Object rho = this.ring.pow(((UnivariatePolynomial)this.remainders.get(i + 1)).lc(), di);
                Object den = this.ring.pow(((UnivariatePolynomial)this.remainders.get(i)).lc(), this.degreeDiff(i - 1) * di);
                subresultant = this.ring.multiply(subresultant, rho);
                subresultant = this.ring.divideExact(subresultant, den);
                if (di % 2 == 1 && (((UnivariatePolynomial)this.remainders.get((int)0)).degree - ((UnivariatePolynomial)this.remainders.get((int)(i + 1))).degree + i + 1) % 2 == 1) {
                    subresultant = this.ring.negate(subresultant);
                }
                subresultants.add(subresultant);
            }
            return subresultants;
        }
    }

    private static final class SubresultantPolynomialRemainderSequence<E>
    extends PseudoPolynomialRemainderSequence<E> {
        final List<E> psis = new ArrayList();

        SubresultantPolynomialRemainderSequence(UnivariatePolynomial<E> a, UnivariatePolynomial<E> b) {
            super(a, b);
        }

        @Override
        E nextBeta(UnivariatePolynomial<E> remainder) {
            Object psi;
            Object lc;
            int i = this.remainders.size();
            UnivariatePolynomial prem = (UnivariatePolynomial)this.remainders.get(i - 2);
            Object e = lc = i == 2 ? this.ring.getOne() : prem.lc();
            if (i == 2) {
                psi = this.ring.getNegativeOne();
            } else {
                E prevPsi = this.psis.get(this.psis.size() - 1);
                int deg = ((UnivariatePolynomial)this.remainders.get((int)(i - 3))).degree - ((UnivariatePolynomial)this.remainders.get((int)(i - 2))).degree;
                Object f = this.ring.pow(this.ring.negate(lc), deg);
                psi = 1 - deg < 0 ? this.ring.divideExact(f, this.ring.pow(prevPsi, deg - 1)) : this.ring.multiply(f, this.ring.pow(prevPsi, 1 - deg));
            }
            this.psis.add(psi);
            return this.ring.negate(this.ring.multiply(lc, this.ring.pow(psi, ((UnivariatePolynomial)this.remainders.get((int)(i - 2))).degree - ((UnivariatePolynomial)this.remainders.get((int)(i - 1))).degree)));
        }

        private int eij(int i, int j) {
            int e = this.degreeDiff(j - 1);
            for (int k = j; k <= i; ++k) {
                e *= 1 - this.degreeDiff(k);
            }
            return e;
        }

        @Override
        List<E> nonZeroSubresultants() {
            ArrayList subresultants = new ArrayList();
            Object subresultant = this.ring.pow(((UnivariatePolynomial)this.remainders.get(1)).lc(), this.degreeDiff(0));
            subresultants.add(subresultant);
            for (int i = 1; i < this.remainders.size() - 1; ++i) {
                int di = this.degreeDiff(i);
                Object rho = this.ring.pow(((UnivariatePolynomial)this.remainders.get(i + 1)).lc(), di);
                Object den = this.ring.getOne();
                for (int k = 1; k <= i; ++k) {
                    int deg = -di * this.eij(i - 1, k);
                    if (deg >= 0) {
                        rho = this.ring.multiply(rho, this.ring.pow(((UnivariatePolynomial)this.remainders.get(k)).lc(), deg));
                        continue;
                    }
                    den = this.ring.multiply(den, this.ring.pow(((UnivariatePolynomial)this.remainders.get(k)).lc(), -deg));
                }
                subresultant = this.ring.multiply(subresultant, rho);
                subresultant = this.ring.divideExact(subresultant, den);
                subresultants.add(subresultant);
            }
            return subresultants;
        }
    }

    public static class APolynomialRemainderSequence<Poly extends IUnivariatePolynomial<Poly>> {
        public final List<Poly> remainders = new ArrayList<Poly>();
        public final List<Poly> quotients = new ArrayList<Poly>();
        public final Poly a;
        public final Poly b;

        public APolynomialRemainderSequence(Poly a, Poly b) {
            this.a = a;
            this.b = b;
        }

        public final Poly lastRemainder() {
            return (Poly)((IUnivariatePolynomial)this.remainders.get(this.remainders.size() - 1));
        }

        public final Poly gcd() {
            if (this.a.isZero()) {
                return this.b;
            }
            if (this.b.isZero()) {
                return this.a;
            }
            if (this.a.isOverField()) {
                return (Poly)((IUnivariatePolynomial)this.lastRemainder().clone().monic());
            }
            IUnivariatePolynomial r = (IUnivariatePolynomial)this.lastRemainder().clone().primitivePartSameSign();
            return (Poly)UnivariateGCD.PolynomialGCD((IUnivariatePolynomial)this.a.contentAsPoly(), (IUnivariatePolynomial)this.b.contentAsPoly()).multiply(r);
        }

        public final int size() {
            return this.remainders.size();
        }
    }
}

