/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.primes;

import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.primes.SmallPrimes;
import java.util.ArrayList;

final class QuadraticSieve {
    private final BigInteger n;
    private static final int bitChunkSize = 30;
    private static final int PRIME_BASE = 1500;
    private static final int ADDITIONAL = 30;
    private final int[] primes;
    private final BigInteger[] primesBig;
    private final double primeLog;
    private final double[] primeLogs;
    private final ArrayList<BigInteger> decomposedNumbers = new ArrayList();
    private BigInteger[] s;
    private BigInteger[] fs;
    private double[] logs;
    private int decomposed = 0;

    public QuadraticSieve(BigInteger num) {
        int nModP;
        this.n = num;
        this.primes = new int[1500];
        this.primes[0] = -1;
        this.primes[1] = 2;
        int k = 2;
        for (int j : SmallPrimes.SmallPrimes12) {
            if (j == 2 || QuadraticSieve.legendreSymbol(nModP = this.n.mod(BigInteger.valueOf(j)).intValue(), j) != 1L) continue;
            this.primes[k++] = j;
            if (k == 1500) break;
        }
        if (k < 1500) {
            int j = this.primes[k - 1] + 2;
            while (k < 1500) {
                if (SmallPrimes.isPrime(j) && QuadraticSieve.legendreSymbol(nModP = this.n.mod(BigInteger.valueOf(j)).intValue(), j) == 1L) {
                    this.primes[k++] = j;
                }
                j += 2;
            }
        }
        this.primesBig = new BigInteger[1500];
        this.primeLogs = new double[1500];
        for (k = 1; k < 1500; ++k) {
            this.primesBig[k] = BigInteger.valueOf(this.primes[k]);
            this.primeLogs[k] = Math.log(this.primes[k]);
        }
        this.primeLog = this.primeLogs[1499];
    }

    private static BigInteger quadraticF(BigInteger x, BigInteger n) {
        return x.multiply(x).subtract(n);
    }

    private byte[] decomposeNumber(BigInteger number) {
        byte[] result = new byte[1500];
        boolean divided = false;
        if (number.signum() < 0) {
            number = BigInteger.ZERO.subtract(number);
            result[0] = 1;
        } else {
            result[0] = 0;
        }
        for (int j = 1; j < 1500; ++j) {
            result[j] = 0;
            BigInteger k = this.primesBig[j];
            while (number.mod(k).compareTo(BigInteger.ZERO) == 0) {
                divided = true;
                number = number.divide(k);
                int n = j;
                result[n] = (byte)(result[n] + 1);
            }
            if (j * 2 == 1500 && !divided) break;
        }
        if (number.compareTo(BigInteger.ONE) > 0) {
            result[0] = -1;
        }
        return result;
    }

    private byte[][] buildMatrix(BigInteger[] numbers, int size) {
        byte[][] matrix = new byte[size][size];
        for (int j = 0; j < size; ++j) {
            int k;
            BigInteger temp = numbers[j];
            if (temp.signum() < 0) {
                temp = temp.negate();
                matrix[j][0] = 1;
            } else {
                matrix[j][0] = 0;
            }
            for (k = 1; k < 1500; ++k) {
                matrix[j][k] = 0;
                BigInteger prim = this.primesBig[k];
                while (temp.mod(prim).compareTo(BigInteger.ZERO) == 0) {
                    byte[] byArray = matrix[j];
                    int n = k;
                    byArray[n] = (byte)(byArray[n] + 1);
                    temp = temp.divide(prim);
                }
            }
            for (k = 1500; k < size; ++k) {
                matrix[j][k] = 0;
            }
        }
        return matrix;
    }

    private static int[][] flattenMatrix(byte[][] matrix) {
        int[][] m = new int[matrix.length][matrix.length / 30];
        for (int j = 0; j < matrix.length; ++j) {
            for (int k = 0; k < matrix.length / 30; ++k) {
                int comparation = 1;
                m[j][k] = 0;
                for (int n = 0; n < 30; ++n) {
                    if ((matrix[j][k * 30 + n] & 1) > 0) {
                        int[] nArray = m[j];
                        int n2 = k;
                        nArray[n2] = nArray[n2] + comparation;
                    }
                    comparation *= 2;
                }
            }
        }
        return m;
    }

    private static int[][] buildIdentity(int size) {
        int k;
        int j;
        int[][] matrix = new int[size][size / 30];
        for (j = 0; j < size; ++j) {
            for (k = 0; k < size / 30; ++k) {
                matrix[j][k] = 0;
            }
        }
        k = -1;
        int comparation = 0;
        for (j = 0; j < size; ++j) {
            if (j % 30 == 0) {
                ++k;
                comparation = 1;
            } else {
                comparation *= 2;
            }
            matrix[j][k] = comparation;
        }
        return matrix;
    }

    private static void gaussElim(int[][] matrix, int[][] right, int j, int k) {
        int c2;
        int c1;
        int comparation = 1;
        for (c1 = 1; c1 <= j % 30; ++c1) {
            comparation *= 2;
        }
        if ((matrix[j][j / 30] & comparation) == 0) {
            for (c1 = j + 1; c1 < k; ++c1) {
                int temp;
                if ((matrix[c1][j / 30] & comparation) <= 0) continue;
                for (c2 = j / 30; c2 < k / 30; ++c2) {
                    temp = matrix[j][c2];
                    matrix[j][c2] = matrix[c1][c2];
                    matrix[c1][c2] = temp;
                }
                for (c2 = 0; c2 < k / 30; ++c2) {
                    temp = right[j][c2];
                    right[j][c2] = right[c1][c2];
                    right[c1][c2] = temp;
                }
                break;
            }
        }
        if ((matrix[j][j / 30] & comparation) > 0) {
            for (c1 = j + 1; c1 < k; ++c1) {
                if ((matrix[c1][j / 30] & comparation) <= 0) continue;
                for (c2 = j / 30; c2 < k / 30; ++c2) {
                    matrix[c1][c2] = matrix[c1][c2] ^ matrix[j][c2];
                }
                for (c2 = 0; c2 < k / 30; ++c2) {
                    right[c1][c2] = right[c1][c2] ^ right[j][c2];
                }
            }
        }
    }

    private static void solveMatrix(int[][] matrix, int[][] right) {
        int k = matrix.length;
        for (int j = 0; j < k - 1; ++j) {
            QuadraticSieve.gaussElim(matrix, right, j, k);
        }
    }

    private byte[] extractLine(int[][] right, int index) {
        int[] line = right[index];
        byte[] result = new byte[1530];
        int comparation = 1;
        for (int j = 0; j < 1530; ++j) {
            result[j] = (line[j / 30] & comparation) > 0 ? (byte)1 : 0;
            if (j % 30 == 29) {
                comparation = 1;
                continue;
            }
            comparation *= 2;
        }
        return result;
    }

    private long[] findFlats(long p, long n) {
        long x;
        long k;
        long[] result = new long[]{-1L, -1L};
        if (p == 2L) {
            result[0] = n % 2L;
            result[1] = -1L;
            return result;
        }
        if (p % 4L == 3L) {
            long x2;
            long k2 = p / 4L;
            result[0] = x2 = QuadraticSieve.modPowLong(n, k2 + 1L, p) % p;
            result[1] = p - x2;
            return result;
        }
        if (p % 8L == 5L) {
            k = p / 8L;
            x = QuadraticSieve.modPowLong(n, 2L * k + 1L, p);
            if (x == 1L) {
                result[0] = x = QuadraticSieve.modPowLong(n, k + 1L, p);
                result[1] = p - x;
                return result;
            }
            if (x == p - 1L) {
                x = QuadraticSieve.modPowLong(4L * n, k + 1L, p);
                result[0] = x = x * (p + 1L) / 2L % p;
                result[1] = p - x;
                return result;
            }
        }
        long h = 13L;
        while (QuadraticSieve.legendreSymbol((h += 2L) * h - 4L * n, p) != -1L) {
        }
        k = (p + 1L) / 2L;
        x = QuadraticSieve.v_(k, h, n, p);
        if (x < 0L) {
            x += p;
        }
        result[0] = x = x * k % p;
        result[1] = p - x;
        return result;
    }

    private void removeHighestPower(int index, BigInteger p) {
        if (this.fs[index].mod(p).compareTo(BigInteger.ZERO) == 0) {
            do {
                this.fs[index] = this.fs[index].divide(p);
            } while (this.fs[index].mod(p).compareTo(BigInteger.ZERO) == 0);
            if (this.fs[index].compareTo(BigInteger.ONE) == 0) {
                this.logs[index] = 0.0;
                this.decomposedNumbers.add(this.s[index]);
                ++this.decomposed;
            }
        } else {
            throw new RuntimeException();
        }
    }

    public BigInteger CFRAC(int upperBound) {
        BigInteger x;
        int k;
        int i;
        BigInteger sqrt;
        BigInteger Bj = sqrt = QuadraticSieve.sqrtBigInt(this.n);
        BigInteger Ck = BigInteger.ONE;
        BigInteger Cj = this.n.subtract(sqrt.multiply(sqrt));
        BigInteger Pk = BigInteger.ONE;
        BigInteger Pj = sqrt;
        byte[][] factors = new byte[1530][1530];
        for (i = 0; i < 1530; ++i) {
            for (k = 0; k < 1530; ++k) {
                factors[i][k] = 0;
            }
        }
        BigInteger[] s = new BigInteger[1530];
        this.decomposed = 0;
        i = 1;
        while (this.decomposed < 1530) {
            BigInteger sqr;
            byte[] facs;
            BigInteger Ai = sqrt.add(Bj).divide(Cj).mod(this.n);
            BigInteger Bi = Ai.multiply(Cj).subtract(Bj).mod(this.n);
            BigInteger Ci = Ck.add(Ai.multiply(Bj.subtract(Bi))).mod(this.n);
            BigInteger Pi = Pk.add(Ai.multiply(Pj)).mod(this.n);
            if ((facs = this.decomposeNumber(sqr = ++i % 2 == 0 ? Ci : BigInteger.ZERO.subtract(Ci)))[0] >= 0) {
                for (k = 0; k < 1500; ++k) {
                    factors[this.decomposed][k] = facs[k];
                }
                s[this.decomposed] = Pi;
            }
            Bj = Bi;
            Ck = Cj;
            Cj = Ci;
            Pk = Pj;
            Pj = Pi;
        }
        int[][] identity = QuadraticSieve.buildIdentity(1530);
        int[][] matrix = QuadraticSieve.flattenMatrix(factors);
        QuadraticSieve.solveMatrix(matrix, identity);
        int loop = this.decomposed - 1;
        do {
            int[] primefacs = new int[1500];
            byte[] factorLine = this.extractLine(identity, loop);
            x = BigInteger.ONE;
            for (i = 0; i < 1500; ++i) {
                primefacs[i] = 0;
            }
            for (i = 0; i < this.decomposed; ++i) {
                if (factorLine[i] != 1) continue;
                for (int j = 0; j < 1500; ++j) {
                    int n = j;
                    primefacs[n] = primefacs[n] + factors[i][j];
                }
                x = x.multiply(s[i]).mod(this.n);
            }
            BigInteger y = BigInteger.ONE;
            for (i = 0; i < 1500; ++i) {
                y = y.multiply(BigInteger.valueOf(this.primes[i]).modPow(BigInteger.valueOf(primefacs[i] / 2), this.n)).mod(this.n);
            }
            x = x.mod(this.n);
            y = y.mod(this.n);
            x = x.add(y);
            y = x.subtract(y).subtract(y);
        } while (((x = this.n.gcd(x)).compareTo(BigInteger.ONE) == 0 || x.compareTo(this.n) == 0) && --loop > 1500);
        return x;
    }

    public BigInteger quadraticSieve(int upperBound) {
        BigInteger x;
        BigInteger test;
        int loop;
        int i;
        BigInteger quadraticN = this.n;
        int[][] flats = new int[1500][2];
        for (i = 1; i < 1500; ++i) {
            long[] tempflat = this.findFlats(this.primes[i], quadraticN.mod(this.primesBig[i]).intValue());
            flats[i][0] = (int)tempflat[0];
            flats[i][1] = (int)tempflat[1];
        }
        int offset = 0;
        int direction = 0;
        BigInteger m = QuadraticSieve.sqrtBigInt(this.n).add(BigInteger.ONE);
        this.s = new BigInteger[upperBound + 2];
        this.fs = new BigInteger[upperBound + 2];
        this.logs = new double[upperBound + 2];
        block6: do {
            int mInt;
            int p;
            switch (direction) {
                case 0: {
                    direction = 1;
                    offset = 0;
                    break;
                }
                case 1: {
                    direction = -1;
                    offset = -offset + upperBound;
                    break;
                }
                case -1: {
                    direction = 1;
                    offset = -offset;
                }
            }
            for (i = 0; i < upperBound; ++i) {
                this.s[i] = null;
                this.fs[i] = null;
                this.logs[i] = 0.0;
            }
            for (i = 1; i < 1500; ++i) {
                p = this.primes[i];
                double logp = this.primeLogs[i];
                mInt = m.mod(this.primesBig[i]).intValue() + offset;
                if (flats[i][0] >= 0) {
                    loop = (flats[i][0] - mInt) % p;
                    if (loop < 0) {
                        loop += p;
                    }
                    while (loop < upperBound) {
                        int n = loop;
                        this.logs[n] = this.logs[n] + logp;
                        loop += p;
                    }
                }
                if (flats[i][1] < 0) continue;
                loop = (flats[i][1] - mInt) % p;
                if (loop < 0) {
                    loop += p;
                }
                while (loop < upperBound) {
                    int n = loop;
                    this.logs[n] = this.logs[n] + logp;
                    loop += p;
                }
            }
            double TARGET = Math.log(m.doubleValue()) + Math.log(upperBound) - this.primeLog;
            for (i = 0; i < upperBound; ++i) {
                if (!(this.logs[i] > TARGET)) continue;
                this.s[i] = BigInteger.valueOf(i + offset).add(m);
                this.fs[i] = QuadraticSieve.quadraticF(this.s[i], quadraticN).abs();
            }
            for (i = 1; i < 1500; ++i) {
                p = this.primes[i];
                mInt = m.mod(this.primesBig[i]).intValue() + offset;
                if (flats[i][0] >= 0) {
                    loop = (flats[i][0] - mInt) % p;
                    if (loop < 0) {
                        loop += p;
                    }
                    while (loop < upperBound) {
                        if (this.logs[loop] > TARGET) {
                            this.removeHighestPower(loop, this.primesBig[i]);
                            if (this.decomposed >= 1530) break;
                        }
                        loop += p;
                    }
                }
                if (flats[i][1] >= 0) {
                    loop = (flats[i][1] - mInt) % p;
                    if (loop < 0) {
                        loop += p;
                    }
                    while (loop < upperBound) {
                        if (this.logs[loop] > TARGET) {
                            this.removeHighestPower(loop, this.primesBig[i]);
                            if (this.decomposed >= 1530) break;
                        }
                        loop += p;
                    }
                }
                if (this.decomposed >= 1530) continue block6;
            }
        } while (this.decomposed < 1530);
        if (this.decomposed > 1530) {
            this.decomposed = 1530;
        }
        this.s = new BigInteger[this.decomposed + 1];
        this.fs = new BigInteger[this.decomposed + 1];
        for (i = 0; i < this.decomposed; ++i) {
            this.s[i] = this.decomposedNumbers.get(i);
            this.fs[i] = QuadraticSieve.quadraticF(this.s[i], quadraticN);
        }
        byte[][] factors = this.buildMatrix(this.fs, this.decomposed);
        int[][] identity = QuadraticSieve.buildIdentity(this.decomposed);
        int[][] matrix = QuadraticSieve.flattenMatrix(factors);
        QuadraticSieve.solveMatrix(matrix, identity);
        loop = this.decomposed - 1;
        do {
            BigInteger y;
            int[] primefacs = new int[1500];
            byte[] factorLine = this.extractLine(identity, loop);
            test = BigInteger.ONE;
            for (i = 0; i < 1500; ++i) {
                primefacs[i] = 0;
            }
            for (i = 0; i < this.decomposed; ++i) {
                if (factorLine[i] != 1) continue;
                for (int j = 0; j < 1500; ++j) {
                    int n = j;
                    primefacs[n] = primefacs[n] + factors[i][j];
                }
                test = test.multiply(this.s[i]).mod(this.n);
            }
            BigInteger prim = BigInteger.ONE;
            for (i = 0; i < 1500; ++i) {
                y = BigInteger.valueOf(this.primes[i]).modPow(BigInteger.valueOf(primefacs[i] / 2), this.n);
                prim = prim.multiply(y).mod(this.n);
            }
            test = test.mod(this.n);
            prim = prim.mod(this.n);
            x = test.add(prim);
            y = test.subtract(prim);
        } while (((test = this.n.gcd(x)).compareTo(BigInteger.ONE) == 0 || test.compareTo(this.n) == 0) && --loop > 1500);
        return test;
    }

    static long legendreSymbol(long n, long p) {
        long legendre = 1L;
        if (n == 0L) {
            return 0L;
        }
        if (n < 0L) {
            n = -n;
            if (p % 4L == 3L) {
                legendre = -1L;
            }
        }
        do {
            long count = 0L;
            while (n % 2L == 0L) {
                n /= 2L;
                count = 1L - count;
            }
            if (count * (p * p - 1L) % 16L == 8L) {
                legendre = -legendre;
            }
            if ((n - 1L) * (p - 1L) % 8L == 4L) {
                legendre = -legendre;
            }
            long temp = n;
            n = p % n;
            p = temp;
        } while (n > 1L);
        return legendre;
    }

    private static long modPowLong(long n, long p, long m) {
        if (p == 0L) {
            return 1L;
        }
        if (p % 2L == 1L) {
            return n * QuadraticSieve.modPowLong(n, p - 1L, m) % m;
        }
        long result = QuadraticSieve.modPowLong(n, p / 2L, m);
        return result * result % m;
    }

    static BigInteger sqrtBigInt(BigInteger i) {
        BigInteger high = i;
        BigInteger low = BigInteger.ONE;
        while (high.subtract(low).compareTo(BigInteger.ONE) > 0) {
            BigInteger medium = high.add(low).divide(BigInteger.ONE.add(BigInteger.ONE));
            long c = medium.multiply(medium).compareTo(i);
            if (c > 0L) {
                high = medium;
            }
            if (c < 0L) {
                low = medium;
            }
            if (c != 0L) continue;
            return medium;
        }
        if (high.multiply(high).compareTo(i) == 0) {
            return high;
        }
        return low;
    }

    private static long v(long i, long h, long n, long p) {
        if (i == 1L) {
            return h;
        }
        if (i == 2L) {
            return (h * h - 2L * n) % p;
        }
        long vi = QuadraticSieve.v(i / 2L, h, n, p);
        long vi_1 = QuadraticSieve.v(i / 2L + 1L, h, n, p);
        if (i % 2L == 1L) {
            if ((vi = (vi * vi_1 - h * QuadraticSieve.modPowLong(n, i / 2L, p)) % p) < 0L) {
                vi += p;
            }
            return vi;
        }
        return (vi * vi - 2L * QuadraticSieve.modPowLong(n, i / 2L, p)) % p;
    }

    private static long v_(long j, long h, long n, long p) {
        long[] b = new long[64];
        long m = n;
        long v = h;
        long w = (h * h - 2L * m) % p;
        int t = 0;
        while (j > 0L) {
            b[++t] = j % 2L;
            j /= 2L;
        }
        for (int k = t - 1; k >= 1; --k) {
            long x = (v * w - h * m) % p;
            v = (v * v - 2L * m) % p;
            w = (w * w - 2L * n * m) % p;
            m = m * m % p;
            if (b[k] == 0L) {
                w = x;
                continue;
            }
            v = x;
            m = n * m % p;
        }
        return v;
    }
}

