/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.primes;

import cc.redberry.rings.bigint.BigInteger;
import java.util.BitSet;
import org.apache.commons.math3.random.RandomGenerator;

public final class SieveOfAtkin {
    private final int limit;
    private final BigInteger blimit;
    private final BitSet sieve;
    static final SieveOfAtkin SmallPrimesSieve = new SieveOfAtkin(65536);

    private SieveOfAtkin(int limit, BigInteger blimit, BitSet sieve) {
        this.limit = limit;
        this.blimit = blimit;
        this.sieve = sieve;
    }

    SieveOfAtkin toLimit(int newLimit) {
        return this.limit == newLimit ? this : new SieveOfAtkin(newLimit, BigInteger.valueOf(newLimit), this.sieve);
    }

    private SieveOfAtkin(int limit) {
        this(limit, BigInteger.valueOf(limit));
    }

    private SieveOfAtkin(int limit, BigInteger blimit) {
        this.limit = limit;
        this.blimit = blimit;
        this.sieve = new BitSet(limit + 1);
        int limitSqrt = (int)Math.sqrt(limit);
        this.sieve.set(2);
        this.sieve.set(3);
        for (int x = 1; x <= limitSqrt; ++x) {
            for (int y = 1; y <= limitSqrt; ++y) {
                int n = 4 * x * x + y * y;
                if (n <= limit && (n % 12 == 1 || n % 12 == 5)) {
                    this.sieve.flip(n);
                }
                if ((n = 3 * x * x + y * y) <= limit && n % 12 == 7) {
                    this.sieve.flip(n);
                }
                n = 3 * x * x - y * y;
                if (x <= y || n > limit || n % 12 != 11) continue;
                this.sieve.flip(n);
            }
        }
        for (int n = 5; n <= limitSqrt; ++n) {
            int x;
            if (!this.sieve.get(n)) continue;
            for (int i = x = n * n; i <= limit; i += x) {
                this.sieve.clear(i);
            }
        }
    }

    public boolean isPrime(int n) {
        if (n > this.limit) {
            throw new IndexOutOfBoundsException("Out of sieve bounds.");
        }
        return this.sieve.get(n);
    }

    public int lastPrime() {
        for (int i = this.limit; i >= 0; --i) {
            if (!this.isPrime(i)) continue;
            return i;
        }
        throw new IllegalStateException("No ant primes in the sieve");
    }

    public int randomPrime(RandomGenerator rnd) {
        int i;
        while (!this.isPrime(i = rnd.nextInt(this.limit))) {
        }
        return i;
    }

    public int getLimit() {
        return this.limit;
    }

    public BigInteger getLimitAsBigInteger() {
        return this.blimit;
    }

    public static SieveOfAtkin createSieve(int limit) {
        if (limit <= SieveOfAtkin.SmallPrimesSieve.limit) {
            return SmallPrimesSieve.toLimit(limit);
        }
        return new SieveOfAtkin(limit);
    }

    public static SieveOfAtkin createSieve(BigInteger limit) {
        if (limit.compareTo(SieveOfAtkin.SmallPrimesSieve.blimit) < 9) {
            return SmallPrimesSieve.toLimit(limit.intValue());
        }
        return new SieveOfAtkin(limit.intValueExact(), limit);
    }
}

