/*
 * Decompiled with CFR 0.152.
 */
package com.github.tueda.donuts;

import cc.redberry.rings.Rings;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.poly.PolynomialFactorDecomposition;
import cc.redberry.rings.poly.PolynomialMethods;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.multivar.Monomial;
import cc.redberry.rings.poly.multivar.MonomialOrder;
import cc.redberry.rings.poly.multivar.MultivariateDivision;
import cc.redberry.rings.poly.multivar.MultivariateFactorization;
import cc.redberry.rings.poly.multivar.MultivariateGCD;
import cc.redberry.rings.poly.multivar.MultivariatePolynomial;
import com.github.tueda.donuts.Multivariate;
import com.github.tueda.donuts.RationalFunction;
import com.github.tueda.donuts.SubstitutionUtils;
import com.github.tueda.donuts.Variable;
import com.github.tueda.donuts.VariableSet;
import com.github.tueda.donuts.util.IntArrayComparator;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class Polynomial
implements Serializable,
Iterable<Polynomial>,
Multivariate {
    private static final long serialVersionUID = 1L;
    static final MultivariatePolynomial<BigInteger> RAW_ZERO = MultivariatePolynomial.zero(0, Rings.Z, MonomialOrder.DEFAULT);
    private static final BigInteger SHORT_MIN_VALUE = BigInteger.valueOf(Short.MIN_VALUE);
    private static final BigInteger SHORT_MAX_VALUE = BigInteger.valueOf(Short.MAX_VALUE);
    private static final BigInteger INT_MIN_VALUE = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger INT_MAX_VALUE = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger LONG_MIN_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger LONG_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    private final VariableSet variables;
    private final MultivariatePolynomial<BigInteger> raw;
    public static final Polynomial ZERO = new Polynomial();
    public static final Polynomial ONE = new Polynomial(1L);

    public Polynomial() {
        this.variables = VariableSet.EMPTY;
        this.raw = RAW_ZERO;
    }

    public Polynomial(long value) {
        this.variables = VariableSet.EMPTY;
        this.raw = (MultivariatePolynomial)RAW_ZERO.createConstant(value);
    }

    public Polynomial(BigInteger value) {
        this.variables = VariableSet.EMPTY;
        this.raw = RAW_ZERO.createConstant(value);
    }

    public Polynomial(String string) {
        String[] names = Variable.guessVariableNames(string);
        this.variables = VariableSet.createFromRaw(names);
        try {
            this.raw = MultivariatePolynomial.parse(string, names);
        }
        catch (RuntimeException e) {
            if (this.isParserError(e)) {
                String s = string.length() <= 32 ? string : string.substring(0, 32) + "...";
                throw new IllegalArgumentException(String.format("Failed to parse \"%s\"", s), e);
            }
            throw e;
        }
    }

    private boolean isParserError(Throwable e) {
        StackTraceElement el = e.getStackTrace()[0];
        String s = el.getClassName() + "." + el.getMethodName();
        return s.startsWith("cc.redberry.rings.Ring.divideExact") || s.startsWith("cc.redberry.rings.bigint.BigInteger.pow") || s.startsWith("cc.redberry.rings.io.Coder.mkOperand") || s.startsWith("cc.redberry.rings.io.Coder.parse") || s.startsWith("cc.redberry.rings.io.Coder.popEvaluate") || s.startsWith("cc.redberry.rings.io.Tokenizer.checkChar") || s.startsWith("cc.redberry.rings.io.Tokenizer.nextToken") || s.startsWith("java.util.ArrayDeque.removeFirst");
    }

    private Polynomial(VariableSet newVariables, MultivariatePolynomial<BigInteger> rawPoly) {
        assert (newVariables.size() == rawPoly.nVariables);
        this.variables = newVariables;
        this.raw = rawPoly;
    }

    static Polynomial createFromRaw(VariableSet newVariables, MultivariatePolynomial<BigInteger> rawPoly) {
        return new Polynomial(newVariables, rawPoly);
    }

    public static Polynomial of(String string) {
        return new Polynomial(string);
    }

    public static Polynomial[] of(String ... strings) {
        return (Polynomial[])Stream.of(strings).map(Polynomial::new).toArray(Polynomial[]::new);
    }

    private Object readResolve() throws ObjectStreamException {
        return Polynomial.createFromRaw(this.variables, this.raw.setRingUnsafe(Rings.Z));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Polynomial)) {
            return false;
        }
        Polynomial aPoly = (Polynomial)other;
        if (this.variables.equals(aPoly.variables)) {
            return this.raw.equals(aPoly.raw);
        }
        if (this.size() != aPoly.size()) {
            return false;
        }
        VariableSet newVariables = this.variables.union(aPoly.variables);
        return this.translate(newVariables).equals(aPoly.translate(newVariables));
    }

    public int hashCode() {
        Polynomial poly = this.translate(this.getMinimalVariables());
        return Objects.hash(poly.variables, poly.raw);
    }

    public String toString() {
        return this.raw.toString(this.variables.getRawTable());
    }

    @Override
    public Iterator<Polynomial> iterator() {
        return new TermIterator(this.raw.iterator());
    }

    @Override
    public VariableSet getVariables() {
        return this.variables;
    }

    @Override
    public VariableSet getMinimalVariables() {
        if (this.variables.isEmpty()) {
            return this.variables;
        }
        String[] newTable = (String[])IntStream.range(0, this.variables.size()).filter(i -> Polynomial.isVariableUsed(this.raw, i)).mapToObj(i -> this.variables.getRawName(i)).toArray(String[]::new);
        return VariableSet.createFromRaw(newTable);
    }

    private static boolean isVariableUsed(MultivariatePolynomial<BigInteger> rawPolynomial, int variable) {
        for (Monomial monomial : rawPolynomial) {
            if (monomial.exponents[variable] <= 0) continue;
            return true;
        }
        return false;
    }

    public MultivariatePolynomial<BigInteger> getRawPolynomial() {
        return (MultivariatePolynomial)this.raw.copy();
    }

    MultivariatePolynomial<BigInteger> getRawPolynomialWithoutCopy() {
        return this.raw;
    }

    public boolean isZero() {
        return this.raw.isZero();
    }

    public boolean isOne() {
        return this.raw.isOne();
    }

    public boolean isMinusOne() {
        if (this.raw.size() != 1) {
            return false;
        }
        Monomial lt = (Monomial)this.raw.first();
        return lt.isZeroVector() && Rings.Z.isMinusOne((BigInteger)lt.coefficient);
    }

    public boolean isConstant() {
        return this.raw.isConstant();
    }

    public boolean isShortValue() {
        if (this.isZero()) {
            return true;
        }
        if (!this.isConstant()) {
            return false;
        }
        BigInteger c = this.raw.lc();
        return c.compareTo(SHORT_MIN_VALUE) >= 0 && c.compareTo(SHORT_MAX_VALUE) <= 0;
    }

    public boolean isIntValue() {
        if (this.isZero()) {
            return true;
        }
        if (!this.isConstant()) {
            return false;
        }
        BigInteger c = this.raw.lc();
        return c.compareTo(INT_MIN_VALUE) >= 0 && c.compareTo(INT_MAX_VALUE) <= 0;
    }

    public boolean isLongValue() {
        if (this.isZero()) {
            return true;
        }
        if (!this.isConstant()) {
            return false;
        }
        BigInteger c = this.raw.lc();
        return c.compareTo(LONG_MIN_VALUE) >= 0 && c.compareTo(LONG_MAX_VALUE) <= 0;
    }

    public boolean isMonomial() {
        return this.raw.isMonomial();
    }

    public boolean isMonic() {
        return this.raw.isMonic();
    }

    public boolean isVariable() {
        return this.raw.size() == 1 && this.raw.degree() == 1 && this.raw.isMonic();
    }

    public short asShortValue() {
        if (this.isZero()) {
            return 0;
        }
        if (!this.isShortValue()) {
            throw new IllegalStateException("not a short");
        }
        return this.raw.lc().shortValue();
    }

    public int asIntValue() {
        if (this.isZero()) {
            return 0;
        }
        if (!this.isIntValue()) {
            throw new IllegalStateException("not a int");
        }
        return this.raw.lc().intValue();
    }

    public long asLongValue() {
        if (this.isZero()) {
            return 0L;
        }
        if (!this.isLongValue()) {
            throw new IllegalStateException("not a long");
        }
        return this.raw.lc().longValue();
    }

    public Variable asVariable() {
        if (!this.isVariable()) {
            throw new IllegalStateException("not a variable");
        }
        Monomial term = (Monomial)this.raw.lt();
        for (int i = 0; i < term.exponents.length; ++i) {
            assert (term.exponents[i] == 0 || term.exponents[i] == 1);
            if (term.exponents[i] == 0) continue;
            return Variable.createWithoutCheck(this.variables.getRawName(i));
        }
        assert (false);
        return null;
    }

    public int size() {
        return this.raw.size();
    }

    public int signum() {
        return this.raw.signumOfLC();
    }

    public int degree() {
        return this.raw.degree();
    }

    public int degree(Variable variable) {
        int j = this.variables.indexOf(variable);
        if (j < 0) {
            return 0;
        }
        return this.raw.degree(j);
    }

    public int degree(VariableSet variables) {
        int[] indices = this.variables.findIndicesForVariableSet(variables);
        if (indices.length == 0) {
            return 0;
        }
        return this.raw.degree(indices);
    }

    public Polynomial coefficientOf(Variable variable, int exponent) {
        int j = this.variables.indexOf(variable);
        if (j < 0) {
            if (exponent == 0) {
                return this;
            }
            return new Polynomial(this.variables, (MultivariatePolynomial<BigInteger>)this.raw.createZero());
        }
        return new Polynomial(this.variables, (MultivariatePolynomial)this.raw.coefficientOf(j, exponent));
    }

    public Polynomial coefficientOf(Variable[] variables, int[] exponents) {
        if (variables.length != exponents.length) {
            throw new IllegalArgumentException("sizes of variables and exponents unmatch");
        }
        int length = variables.length;
        int[] variableIndices = new int[length];
        int[] newExponents = new int[length];
        int n = 0;
        for (int i = 0; i < variables.length; ++i) {
            Variable v = variables[i];
            int p = exponents[i];
            String x = v.getName();
            int j = this.variables.indexOf(x);
            if (j >= 0) {
                variableIndices[n] = j;
                newExponents[n++] = exponents[i];
                continue;
            }
            if (p == 0) continue;
            return new Polynomial(this.variables, (MultivariatePolynomial<BigInteger>)this.raw.createZero());
        }
        if (n == 0) {
            return this;
        }
        return new Polynomial(this.variables, (MultivariatePolynomial)this.raw.coefficientOf(Arrays.copyOfRange(variableIndices, 0, n), Arrays.copyOfRange(newExponents, 0, n)));
    }

    public Map<int[], Polynomial> getCoefficientMap(Variable ... variables) {
        int length = variables.length;
        int[] variableIndicesInclusive = new int[length];
        int[] variableIndicesExclusive = new int[length];
        int n = 0;
        for (int i = 0; i < length; ++i) {
            int j;
            variableIndicesInclusive[i] = j = this.variables.indexOf(variables[i]);
            if (j < 0) continue;
            variableIndicesExclusive[n++] = j;
        }
        int[] indices = Arrays.copyOfRange(variableIndicesExclusive, 0, n);
        IntArrayComparator comparator = new IntArrayComparator();
        TreeMap<int[], MultivariatePolynomial> map = new TreeMap<int[], MultivariatePolynomial>(comparator);
        for (Monomial monomial : this.raw) {
            Monomial<BigInteger> coefficient = new Monomial<BigInteger>(monomial.dvSetZero(indices), (BigInteger)monomial.coefficient);
            int[] exponents = new int[length];
            for (int i = 0; i < length; ++i) {
                int j = variableIndicesInclusive[i];
                exponents[i] = j < 0 ? 0 : monomial.exponents[j];
            }
            MultivariatePolynomial value = (MultivariatePolynomial)map.get(exponents);
            if (value == null) {
                map.put(exponents, (MultivariatePolynomial)this.raw.create(coefficient));
                continue;
            }
            value.add(coefficient);
        }
        TreeMap<int[], Polynomial> result = new TreeMap<int[], Polynomial>(comparator);
        for (Map.Entry entry : map.entrySet()) {
            result.put((int[])entry.getKey(), new Polynomial(this.variables, (MultivariatePolynomial)entry.getValue()));
        }
        return result;
    }

    public Polynomial translate(VariableSet newVariables) {
        if (this.variables == newVariables) {
            return this;
        }
        if (this.variables.equals(newVariables)) {
            return new Polynomial(newVariables, this.raw);
        }
        if (this.variables.isEmpty()) {
            return new Polynomial(newVariables, (MultivariatePolynomial)this.raw.setNVariables(newVariables.size()));
        }
        int[] mapping = this.variables.map(newVariables);
        if (mapping == null) {
            VariableSet minVariables = this.getMinimalVariables();
            if (this.variables.equals(minVariables)) {
                throw new IllegalArgumentException(String.format("Variables %s does not fit in %s", this.variables, newVariables));
            }
            int[] minMapping = this.variables.map(minVariables, this.variables.size() - 1);
            return new Polynomial(minVariables, (MultivariatePolynomial)((MultivariatePolynomial)this.raw.mapVariables(minMapping)).setNVariables(minVariables.size())).translate(newVariables);
        }
        return new Polynomial(newVariables, (MultivariatePolynomial)((MultivariatePolynomial)this.raw.mapVariables(mapping)).setNVariables(newVariables.size()));
    }

    public Polynomial negate() {
        if (this.isZero()) {
            return this;
        }
        return new Polynomial(this.variables, (MultivariatePolynomial)((MultivariatePolynomial)this.raw.copy()).negate());
    }

    private Polynomial performBinaryOperation(Polynomial other, BinaryOperator<MultivariatePolynomial<BigInteger>> operator, boolean doCopy) {
        if (this.variables.equals(other.variables)) {
            return new Polynomial(this.variables, (MultivariatePolynomial)operator.apply(doCopy ? (MultivariatePolynomial)this.raw.copy() : this.raw, other.raw));
        }
        VariableSet newVariables = this.variables.union(other.variables);
        MultivariatePolynomial raw1 = this.translate((VariableSet)newVariables).raw;
        return new Polynomial(newVariables, (MultivariatePolynomial)operator.apply(doCopy && raw1 == this.raw ? (MultivariatePolynomial)raw1.copy() : raw1, other.translate((VariableSet)newVariables).raw));
    }

    public Polynomial add(Polynomial other) {
        return this.performBinaryOperation(other, AMultivariatePolynomial::add, true);
    }

    public Polynomial subtract(Polynomial other) {
        return this.performBinaryOperation(other, AMultivariatePolynomial::subtract, true);
    }

    public Polynomial multiply(Polynomial other) {
        return this.performBinaryOperation(other, MultivariatePolynomial::multiply, true);
    }

    public Polynomial divideExact(Polynomial divisor) {
        return this.performBinaryOperation(divisor, MultivariateDivision::divideExact, false);
    }

    public RationalFunction divide(Polynomial divisor) {
        return new RationalFunction(this, divisor);
    }

    public Polynomial pow(int exponent) {
        return new Polynomial(this.variables, PolynomialMethods.polyPow(this.raw, exponent));
    }

    public Polynomial pow(BigInteger exponent) {
        return new Polynomial(this.variables, PolynomialMethods.polyPow(this.raw, exponent));
    }

    public static Polynomial sumOf(Polynomial polynomials) {
        return polynomials;
    }

    public static Polynomial sumOf(Polynomial ... polynomials) {
        switch (polynomials.length) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return polynomials[0];
            }
            case 2: {
                return polynomials[0].add(polynomials[1]);
            }
        }
        VariableSet newVariables = VariableSet.unionOf(polynomials);
        List polys = Stream.of(polynomials).map(p -> p.translate((VariableSet)newVariables).raw).collect(Collectors.toList());
        MultivariatePolynomial poly0 = (MultivariatePolynomial)polys.get(0);
        if (poly0 == polynomials[0].raw) {
            poly0 = (MultivariatePolynomial)poly0.copy();
        }
        for (int i = 1; i < polys.size(); ++i) {
            poly0.add((MultivariatePolynomial)polys.get(i));
        }
        return new Polynomial(newVariables, poly0);
    }

    public static Polynomial sumOf(Iterable<Polynomial> polynomials) {
        return Polynomial.sumOf((Polynomial[])StreamSupport.stream(polynomials.spliterator(), false).toArray(Polynomial[]::new));
    }

    public static Polynomial sumOf(Stream<Polynomial> polynomials) {
        return Polynomial.sumOf((Polynomial[])polynomials.toArray(Polynomial[]::new));
    }

    public static Polynomial productOf(Polynomial polynomials) {
        return polynomials;
    }

    public static Polynomial productOf(Polynomial ... polynomials) {
        switch (polynomials.length) {
            case 0: {
                return ONE;
            }
            case 1: {
                return polynomials[0];
            }
            case 2: {
                return polynomials[0].multiply(polynomials[1]);
            }
        }
        VariableSet newVariables = VariableSet.unionOf(polynomials);
        List polys = Stream.of(polynomials).map(p -> p.translate((VariableSet)newVariables).raw).collect(Collectors.toList());
        MultivariatePolynomial poly0 = (MultivariatePolynomial)polys.get(0);
        if (poly0 == polynomials[0].raw) {
            poly0 = (MultivariatePolynomial)poly0.copy();
        }
        for (int i = 1; i < polys.size(); ++i) {
            poly0.multiply((MultivariatePolynomial)polys.get(i));
        }
        return new Polynomial(newVariables, poly0);
    }

    public static Polynomial productOf(Iterable<Polynomial> polynomials) {
        return Polynomial.productOf((Polynomial[])StreamSupport.stream(polynomials.spliterator(), false).toArray(Polynomial[]::new));
    }

    public static Polynomial productOf(Stream<Polynomial> polynomials) {
        return Polynomial.productOf((Polynomial[])polynomials.toArray(Polynomial[]::new));
    }

    public Polynomial gcd(Polynomial other) {
        return this.performBinaryOperation(other, MultivariateGCD::PolynomialGCD, false);
    }

    public static Polynomial gcdOf(Polynomial polynomials) {
        return polynomials;
    }

    public static Polynomial gcdOf(Polynomial ... polynomials) {
        if (polynomials.length == 0) {
            return ZERO;
        }
        if (polynomials.length == 1) {
            return polynomials[0];
        }
        VariableSet newVariables = VariableSet.unionOf(polynomials);
        List polys = Stream.of(polynomials).map(p -> p.translate((VariableSet)newVariables).raw).collect(Collectors.toList());
        return new Polynomial(newVariables, (MultivariatePolynomial)MultivariateGCD.PolynomialGCD(polys));
    }

    public static Polynomial gcdOf(Iterable<Polynomial> polynomials) {
        return Polynomial.gcdOf((Polynomial[])StreamSupport.stream(polynomials.spliterator(), false).toArray(Polynomial[]::new));
    }

    public static Polynomial gcdOf(Stream<Polynomial> polynomials) {
        return Polynomial.gcdOf((Polynomial[])polynomials.toArray(Polynomial[]::new));
    }

    public Polynomial lcm(Polynomial other) {
        return this.performBinaryOperation(other, Polynomial::polynomialLcm, true);
    }

    public static Polynomial lcmOf(Polynomial polynomials) {
        return polynomials;
    }

    public static Polynomial lcmOf(Polynomial ... polynomials) {
        if (polynomials.length == 0) {
            throw new IllegalArgumentException("lcm with 0 arguments");
        }
        if (polynomials.length == 1) {
            return polynomials[0];
        }
        VariableSet newVariables = VariableSet.unionOf(polynomials);
        List<MultivariatePolynomial<BigInteger>> polys = Stream.of(polynomials).map(p -> p.translate((VariableSet)newVariables).raw).collect(Collectors.toList());
        return new Polynomial(newVariables, Polynomial.polynomialLcm(polys));
    }

    public static Polynomial lcmOf(Iterable<Polynomial> polynomials) {
        return Polynomial.lcmOf((Polynomial[])StreamSupport.stream(polynomials.spliterator(), false).toArray(Polynomial[]::new));
    }

    public static Polynomial lcmOf(Stream<Polynomial> polynomials) {
        return Polynomial.lcmOf((Polynomial[])polynomials.toArray(Polynomial[]::new));
    }

    private static MultivariatePolynomial<BigInteger> polynomialLcm(MultivariatePolynomial<BigInteger> a, MultivariatePolynomial<BigInteger> b) {
        if (a.isZero()) {
            return a;
        }
        if (b.isZero()) {
            return b;
        }
        if (a.isOne()) {
            return b;
        }
        if (b.isOne()) {
            return a;
        }
        MultivariatePolynomial<BigInteger> gcd = MultivariateGCD.PolynomialGCD(a, b);
        return MultivariateDivision.divideExact(a.multiply(b), gcd);
    }

    private static MultivariatePolynomial<BigInteger> polynomialLcm(Iterable<MultivariatePolynomial<BigInteger>> array) {
        boolean first = true;
        MultivariatePolynomial lcm = null;
        for (MultivariatePolynomial<BigInteger> poly : array) {
            if (first) {
                lcm = (MultivariatePolynomial)poly.copy();
                first = false;
                continue;
            }
            if ((lcm = Polynomial.polynomialLcm(lcm, poly)) != poly) continue;
            lcm = (MultivariatePolynomial)lcm.copy();
        }
        return lcm;
    }

    public Polynomial[] factors() {
        if (this.isConstant()) {
            return new Polynomial[]{this};
        }
        PolynomialFactorDecomposition<MultivariatePolynomial<BigInteger>> decomposition = MultivariateFactorization.FactorInZ(this.raw);
        decomposition.setLcFrom(this.raw);
        decomposition.canonical();
        ArrayList<Polynomial> factors = new ArrayList<Polynomial>();
        if (!((MultivariatePolynomial)decomposition.unit).isOne()) {
            factors.add(new Polynomial(this.variables, (MultivariatePolynomial)decomposition.unit));
        }
        for (int i = 0; i < decomposition.size(); ++i) {
            Polynomial poly;
            MultivariatePolynomial factor = (MultivariatePolynomial)decomposition.get(i);
            int exponent = decomposition.getExponent(i);
            if (exponent == 1 && factor.isMonomial() && factor.isEffectiveUnivariate()) {
                int variable = factor.univariateVariable();
                exponent = factor.degree(variable);
                poly = new Polynomial(this.variables, (MultivariatePolynomial)factor.createMonomial(variable, 1));
            } else {
                poly = new Polynomial(this.variables, factor);
            }
            for (int j = 0; j < exponent; ++j) {
                factors.add(poly);
            }
        }
        return factors.toArray(new Polynomial[0]);
    }

    public Polynomial substitute(Polynomial lhs, Polynomial rhs) {
        SubstitutionUtils.checkLhs(lhs);
        if (!this.getMinimalVariables().intersects(lhs.getMinimalVariables())) {
            return this;
        }
        VariableSet newVariables = this.variables.union(lhs.getVariables()).union(rhs.getVariables());
        MultivariatePolynomial<BigInteger> newRawPoly = SubstitutionUtils.substitute(this.translate((VariableSet)newVariables).raw, (Monomial<BigInteger>)((Monomial)lhs.translate((VariableSet)newVariables).raw.first()), rhs.translate((VariableSet)newVariables).raw);
        return new Polynomial(newVariables, newRawPoly);
    }

    public Polynomial evaluate(Variable variable, int value) {
        int j = this.variables.indexOf(variable);
        if (j < 0) {
            return this;
        }
        return new Polynomial(this.variables, this.raw.evaluate(j, BigInteger.valueOf(value)));
    }

    public Polynomial evaluate(Variable variable, BigInteger value) {
        int j = this.variables.indexOf(variable);
        if (j < 0) {
            return this;
        }
        return new Polynomial(this.variables, this.raw.evaluate(j, value));
    }

    public Polynomial evaluate(Variable[] variables, int[] values) {
        Object[] result = this.variables.findIndicesForVariablesAndValues(variables, values);
        int[] indices = (int[])result[0];
        if (indices.length == 0) {
            return this;
        }
        BigInteger[] newValues = (BigInteger[])result[1];
        return new Polynomial(this.variables, this.raw.evaluate(indices, (E[])newValues));
    }

    public Polynomial evaluate(Variable[] variables, BigInteger[] values) {
        Object[] result = this.variables.findIndicesForVariablesAndValues(variables, values);
        int[] indices = (int[])result[0];
        if (indices.length == 0) {
            return this;
        }
        BigInteger[] newValues = (BigInteger[])result[1];
        return new Polynomial(this.variables, this.raw.evaluate(indices, (E[])newValues));
    }

    public Polynomial evaluateAtZero(Variable variable) {
        int i = this.variables.indexOf(variable);
        if (i < 0) {
            return this;
        }
        return new Polynomial(this.variables, (MultivariatePolynomial)this.raw.evaluateAtZero(i));
    }

    public Polynomial evaluateAtZero(VariableSet variables) {
        int[] indices = this.variables.findIndicesForVariableSet(variables);
        if (indices.length == 0) {
            return this;
        }
        return new Polynomial(this.variables, (MultivariatePolynomial)this.raw.evaluateAtZero(indices));
    }

    public Polynomial evaluateAtOne(Variable variable) {
        int i = this.variables.indexOf(variable);
        if (i < 0) {
            return this;
        }
        return new Polynomial(this.variables, this.raw.evaluate(i, BigInteger.ONE));
    }

    public Polynomial evaluateAtOne(VariableSet variables) {
        int[] indices = this.variables.findIndicesForVariableSet(variables);
        if (indices.length == 0) {
            return this;
        }
        Object[] values = new BigInteger[indices.length];
        Arrays.fill(values, BigInteger.ONE);
        return new Polynomial(this.variables, this.raw.evaluate(indices, (E[])((BigInteger[])values)));
    }

    public Polynomial shift(Variable variable, int shift) {
        int i = this.variables.indexOf(variable);
        if (i < 0) {
            return this;
        }
        return new Polynomial(this.variables, this.raw.shift(i, BigInteger.valueOf(shift)));
    }

    public Polynomial shift(Variable variable, BigInteger shift) {
        int i = this.variables.indexOf(variable);
        if (i < 0) {
            return this;
        }
        return new Polynomial(this.variables, this.raw.shift(i, shift));
    }

    public Polynomial shift(Variable[] variables, int[] shifts) {
        Object[] result = this.variables.findIndicesForVariablesAndValues(variables, shifts, "shifts");
        int[] indices = (int[])result[0];
        if (indices.length == 0) {
            return this;
        }
        BigInteger[] newShifts = (BigInteger[])result[1];
        return new Polynomial(this.variables, this.raw.shift(indices, (BigInteger[])newShifts));
    }

    public Polynomial shift(Variable[] variables, BigInteger[] shifts) {
        Object[] result = this.variables.findIndicesForVariablesAndValues(variables, shifts, "shifts");
        int[] indices = (int[])result[0];
        if (indices.length == 0) {
            return this;
        }
        BigInteger[] newShifts = (BigInteger[])result[1];
        return new Polynomial(this.variables, this.raw.shift(indices, (BigInteger[])newShifts));
    }

    public Polynomial derivative(Variable variable) {
        return this.derivative(variable, 1);
    }

    public Polynomial derivative(Variable variable, int order) {
        if (order < 0) {
            throw new IllegalArgumentException(String.format("Negative order given: %s", order));
        }
        if (order == 0) {
            return this;
        }
        int i = this.variables.indexOf(variable);
        if (i < 0) {
            return ZERO;
        }
        return new Polynomial(this.variables, (MultivariatePolynomial<BigInteger>)this.raw.derivative(i, order));
    }

    private class TermIterator
    implements Iterator<Polynomial> {
        private final Iterator<Monomial<BigInteger>> rawIterator;

        public TermIterator(Iterator<Monomial<BigInteger>> iterator) {
            this.rawIterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.rawIterator.hasNext();
        }

        @Override
        public Polynomial next() {
            return new Polynomial(Polynomial.this.variables, (MultivariatePolynomial)((AMultivariatePolynomial)Polynomial.this.raw.createZero()).add(this.rawIterator.next()));
        }
    }
}

