"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const defaults = require("@aws-solutions-constructs/core");
const lambda = require("aws-cdk-lib/aws-lambda");
const test_helper_1 = require("./test-helper");
const core_1 = require("@aws-solutions-constructs/core");
const integ_tests_alpha_1 = require("@aws-cdk/integ-tests-alpha");
// Setup
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, (0, core_1.generateIntegStackName)(__filename));
(0, core_1.SetConsistentFeatureFlags)(stack);
stack.templateOptions.description = 'Integration Test for aws-lambda-sagemakerendpoint';
const getSagemakerModelResponse = (0, test_helper_1.getSagemakerModel)(stack);
const deploySagemakerEndpointResponse = defaults.deploySagemakerEndpoint(stack, 'test', {
    modelProps: {
        primaryContainer: {
            image: getSagemakerModelResponse.mapping.findInMap(aws_cdk_lib_1.Stack.of(stack).region, "containerArn"),
            modelDataUrl: getSagemakerModelResponse.asset.s3ObjectUrl
        },
    },
});
deploySagemakerEndpointResponse.endpoint.node.addDependency(getSagemakerModelResponse.asset);
deploySagemakerEndpointResponse.endpointConfig?.node.addDependency(getSagemakerModelResponse.asset);
deploySagemakerEndpointResponse.model?.node.addDependency(getSagemakerModelResponse.asset);
const constructProps = {
    existingSagemakerEndpointObj: deploySagemakerEndpointResponse.endpoint,
    lambdaFunctionProps: {
        runtime: lambda.Runtime.PYTHON_3_8,
        code: lambda.Code.fromAsset(`${__dirname}/lambda`),
        handler: 'index.handler',
        timeout: aws_cdk_lib_1.Duration.minutes(5),
        memorySize: 128,
    },
};
const lambdaToSagemakerConstruct = new lib_1.LambdaToSagemakerEndpoint(stack, 'test-lambda-sagemaker', constructProps);
lambdaToSagemakerConstruct.node.addDependency(getSagemakerModelResponse.asset);
// Synth
new integ_tests_alpha_1.IntegTest(stack, 'Integ', { testCases: [
        stack
    ] });
//# sourceMappingURL=data:application/json;base64,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