# coding: utf-8

"""
    YNAB API Endpoints

    Our API uses a REST based design, leverages the JSON data format, and relies upon HTTPS for transport. We respond with meaningful HTTP response codes and if an error occurs, we include error details in the response body.  API Documentation is at https://api.ynab.com

    The version of the OpenAPI document: 1.76.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date, datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ynab.models.account import Account
from ynab.models.category import Category
from ynab.models.category_group import CategoryGroup
from ynab.models.currency_format import CurrencyFormat
from ynab.models.date_format import DateFormat
from ynab.models.month_detail import MonthDetail
from ynab.models.payee import Payee
from ynab.models.payee_location import PayeeLocation
from ynab.models.scheduled_sub_transaction import ScheduledSubTransaction
from ynab.models.scheduled_transaction_summary import ScheduledTransactionSummary
from ynab.models.sub_transaction import SubTransaction
from ynab.models.transaction_summary import TransactionSummary
from typing import Optional, Set
from typing_extensions import Self

class BudgetDetail(BaseModel):
    """
    BudgetDetail
    """ # noqa: E501
    id: StrictStr
    name: StrictStr
    last_modified_on: Optional[datetime] = Field(default=None, description="The last time any changes were made to the budget from either a web or mobile client")
    first_month: Optional[date] = Field(default=None, description="The earliest budget month")
    last_month: Optional[date] = Field(default=None, description="The latest budget month")
    date_format: Optional[DateFormat] = None
    currency_format: Optional[CurrencyFormat] = None
    accounts: Optional[List[Account]] = None
    payees: Optional[List[Payee]] = None
    payee_locations: Optional[List[PayeeLocation]] = None
    category_groups: Optional[List[CategoryGroup]] = None
    categories: Optional[List[Category]] = None
    months: Optional[List[MonthDetail]] = None
    transactions: Optional[List[TransactionSummary]] = None
    subtransactions: Optional[List[SubTransaction]] = None
    scheduled_transactions: Optional[List[ScheduledTransactionSummary]] = None
    scheduled_subtransactions: Optional[List[ScheduledSubTransaction]] = None
    __properties: ClassVar[List[str]] = ["id", "name", "last_modified_on", "first_month", "last_month", "date_format", "currency_format", "accounts", "payees", "payee_locations", "category_groups", "categories", "months", "transactions", "subtransactions", "scheduled_transactions", "scheduled_subtransactions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BudgetDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of date_format
        if self.date_format:
            _dict['date_format'] = self.date_format.to_dict()
        # override the default output from pydantic by calling `to_dict()` of currency_format
        if self.currency_format:
            _dict['currency_format'] = self.currency_format.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in accounts (list)
        _items = []
        if self.accounts:
            for _item_accounts in self.accounts:
                if _item_accounts:
                    _items.append(_item_accounts.to_dict())
            _dict['accounts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in payees (list)
        _items = []
        if self.payees:
            for _item_payees in self.payees:
                if _item_payees:
                    _items.append(_item_payees.to_dict())
            _dict['payees'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in payee_locations (list)
        _items = []
        if self.payee_locations:
            for _item_payee_locations in self.payee_locations:
                if _item_payee_locations:
                    _items.append(_item_payee_locations.to_dict())
            _dict['payee_locations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in category_groups (list)
        _items = []
        if self.category_groups:
            for _item_category_groups in self.category_groups:
                if _item_category_groups:
                    _items.append(_item_category_groups.to_dict())
            _dict['category_groups'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in categories (list)
        _items = []
        if self.categories:
            for _item_categories in self.categories:
                if _item_categories:
                    _items.append(_item_categories.to_dict())
            _dict['categories'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in months (list)
        _items = []
        if self.months:
            for _item_months in self.months:
                if _item_months:
                    _items.append(_item_months.to_dict())
            _dict['months'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in transactions (list)
        _items = []
        if self.transactions:
            for _item_transactions in self.transactions:
                if _item_transactions:
                    _items.append(_item_transactions.to_dict())
            _dict['transactions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in subtransactions (list)
        _items = []
        if self.subtransactions:
            for _item_subtransactions in self.subtransactions:
                if _item_subtransactions:
                    _items.append(_item_subtransactions.to_dict())
            _dict['subtransactions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in scheduled_transactions (list)
        _items = []
        if self.scheduled_transactions:
            for _item_scheduled_transactions in self.scheduled_transactions:
                if _item_scheduled_transactions:
                    _items.append(_item_scheduled_transactions.to_dict())
            _dict['scheduled_transactions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in scheduled_subtransactions (list)
        _items = []
        if self.scheduled_subtransactions:
            for _item_scheduled_subtransactions in self.scheduled_subtransactions:
                if _item_scheduled_subtransactions:
                    _items.append(_item_scheduled_subtransactions.to_dict())
            _dict['scheduled_subtransactions'] = _items
        # set to None if date_format (nullable) is None
        # and model_fields_set contains the field
        if self.date_format is None and "date_format" in self.model_fields_set:
            _dict['date_format'] = None

        # set to None if currency_format (nullable) is None
        # and model_fields_set contains the field
        if self.currency_format is None and "currency_format" in self.model_fields_set:
            _dict['currency_format'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BudgetDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "last_modified_on": obj.get("last_modified_on"),
            "first_month": obj.get("first_month"),
            "last_month": obj.get("last_month"),
            "date_format": DateFormat.from_dict(obj["date_format"]) if obj.get("date_format") is not None else None,
            "currency_format": CurrencyFormat.from_dict(obj["currency_format"]) if obj.get("currency_format") is not None else None,
            "accounts": [Account.from_dict(_item) for _item in obj["accounts"]] if obj.get("accounts") is not None else None,
            "payees": [Payee.from_dict(_item) for _item in obj["payees"]] if obj.get("payees") is not None else None,
            "payee_locations": [PayeeLocation.from_dict(_item) for _item in obj["payee_locations"]] if obj.get("payee_locations") is not None else None,
            "category_groups": [CategoryGroup.from_dict(_item) for _item in obj["category_groups"]] if obj.get("category_groups") is not None else None,
            "categories": [Category.from_dict(_item) for _item in obj["categories"]] if obj.get("categories") is not None else None,
            "months": [MonthDetail.from_dict(_item) for _item in obj["months"]] if obj.get("months") is not None else None,
            "transactions": [TransactionSummary.from_dict(_item) for _item in obj["transactions"]] if obj.get("transactions") is not None else None,
            "subtransactions": [SubTransaction.from_dict(_item) for _item in obj["subtransactions"]] if obj.get("subtransactions") is not None else None,
            "scheduled_transactions": [ScheduledTransactionSummary.from_dict(_item) for _item in obj["scheduled_transactions"]] if obj.get("scheduled_transactions") is not None else None,
            "scheduled_subtransactions": [ScheduledSubTransaction.from_dict(_item) for _item in obj["scheduled_subtransactions"]] if obj.get("scheduled_subtransactions") is not None else None
        })
        return _obj


