

# This file was autogenerated by some hot garbage in the `uniffi` crate.
# Trust me, you don't want to mess with it!

# Common helper code.
#
# Ideally this would live in a separate .py file where it can be unittested etc
# in isolation, and perhaps even published as a re-useable package.
#
# However, it's important that the details of how this helper code works (e.g. the
# way that different builtin types are passed across the FFI) exactly match what's
# expected by the rust code on the other side of the interface. In practice right
# now that means coming from the exact some version of `uniffi` that was used to
# compile the rust component. The easiest way to ensure this is to bundle the Python
# helpers directly inline like we're doing here.

from __future__ import annotations
import os
import sys
import ctypes
import enum
import struct
import contextlib
import datetime
import threading
import itertools
import traceback
import typing
import asyncio
import platform
from .rusaint import ChapelInformation
from .rusaint import ClassGrade
from .rusaint import CourseType
from .rusaint import GradeSummary
from .rusaint import GraduationRequirements
from .rusaint import GraduationStudent
from .rusaint import Lecture
from .rusaint import LectureAssessmentResult
from .rusaint import LectureCategory
from .rusaint import PersonalCourseSchedule
from .rusaint import Scholarship
from .rusaint import SemesterGrade
from .rusaint import SemesterType
from .rusaint import StudentAcademicRecords
from .rusaint import StudentBankAccount
from .rusaint import StudentFamily
from .rusaint import StudentGraduation
from .rusaint import StudentInformation
from .rusaint import StudentQualification
from .rusaint import StudentReligion
from .rusaint import StudentResearchBankAccount
from .rusaint import StudentTransferRecords
from .rusaint import StudentWorkInformation
from .rusaint import _UniffiConverterTypeChapelInformation
from .rusaint import _UniffiConverterTypeClassGrade
from .rusaint import _UniffiConverterTypeCourseType
from .rusaint import _UniffiConverterTypeGradeSummary
from .rusaint import _UniffiConverterTypeGraduationRequirements
from .rusaint import _UniffiConverterTypeGraduationStudent
from .rusaint import _UniffiConverterTypeLecture
from .rusaint import _UniffiConverterTypeLectureAssessmentResult
from .rusaint import _UniffiConverterTypeLectureCategory
from .rusaint import _UniffiConverterTypePersonalCourseSchedule
from .rusaint import _UniffiConverterTypeScholarship
from .rusaint import _UniffiConverterTypeSemesterGrade
from .rusaint import _UniffiConverterTypeSemesterType
from .rusaint import _UniffiConverterTypeStudentAcademicRecords
from .rusaint import _UniffiConverterTypeStudentBankAccount
from .rusaint import _UniffiConverterTypeStudentFamily
from .rusaint import _UniffiConverterTypeStudentGraduation
from .rusaint import _UniffiConverterTypeStudentInformation
from .rusaint import _UniffiConverterTypeStudentQualification
from .rusaint import _UniffiConverterTypeStudentReligion
from .rusaint import _UniffiConverterTypeStudentResearchBankAccount
from .rusaint import _UniffiConverterTypeStudentTransferRecords
from .rusaint import _UniffiConverterTypeStudentWorkInformation
from .rusaint import _UniffiRustBuffer as _UniffiRustBufferChapelInformation
from .rusaint import _UniffiRustBuffer as _UniffiRustBufferClassGrade
from .rusaint import _UniffiRustBuffer as _UniffiRustBufferCourseType
from .rusaint import _UniffiRustBuffer as _UniffiRustBufferGradeSummary
from .rusaint import _UniffiRustBuffer as _UniffiRustBufferGraduationRequirements
from .rusaint import _UniffiRustBuffer as _UniffiRustBufferGraduationStudent
from .rusaint import _UniffiRustBuffer as _UniffiRustBufferLecture
from .rusaint import _UniffiRustBuffer as _UniffiRustBufferLectureAssessmentResult
from .rusaint import _UniffiRustBuffer as _UniffiRustBufferLectureCategory
from .rusaint import _UniffiRustBuffer as _UniffiRustBufferPersonalCourseSchedule
from .rusaint import _UniffiRustBuffer as _UniffiRustBufferScholarship
from .rusaint import _UniffiRustBuffer as _UniffiRustBufferSemesterGrade
from .rusaint import _UniffiRustBuffer as _UniffiRustBufferSemesterType
from .rusaint import _UniffiRustBuffer as _UniffiRustBufferStudentAcademicRecords
from .rusaint import _UniffiRustBuffer as _UniffiRustBufferStudentBankAccount
from .rusaint import _UniffiRustBuffer as _UniffiRustBufferStudentFamily
from .rusaint import _UniffiRustBuffer as _UniffiRustBufferStudentGraduation
from .rusaint import _UniffiRustBuffer as _UniffiRustBufferStudentInformation
from .rusaint import _UniffiRustBuffer as _UniffiRustBufferStudentQualification
from .rusaint import _UniffiRustBuffer as _UniffiRustBufferStudentReligion
from .rusaint import _UniffiRustBuffer as _UniffiRustBufferStudentResearchBankAccount
from .rusaint import _UniffiRustBuffer as _UniffiRustBufferStudentTransferRecords
from .rusaint import _UniffiRustBuffer as _UniffiRustBufferStudentWorkInformation

# Used for default argument values
_DEFAULT = object() # type: typing.Any


class _UniffiRustBuffer(ctypes.Structure):
    _fields_ = [
        ("capacity", ctypes.c_uint64),
        ("len", ctypes.c_uint64),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    @staticmethod
    def default():
        return _UniffiRustBuffer(0, 0, None)

    @staticmethod
    def alloc(size):
        return _uniffi_rust_call(_UniffiLib.ffi_rusaint_ffi_rustbuffer_alloc, size)

    @staticmethod
    def reserve(rbuf, additional):
        return _uniffi_rust_call(_UniffiLib.ffi_rusaint_ffi_rustbuffer_reserve, rbuf, additional)

    def free(self):
        return _uniffi_rust_call(_UniffiLib.ffi_rusaint_ffi_rustbuffer_free, self)

    def __str__(self):
        return "_UniffiRustBuffer(capacity={}, len={}, data={})".format(
            self.capacity,
            self.len,
            self.data[0:self.len]
        )

    @contextlib.contextmanager
    def alloc_with_builder(*args):
        """Context-manger to allocate a buffer using a _UniffiRustBufferBuilder.

        The allocated buffer will be automatically freed if an error occurs, ensuring that
        we don't accidentally leak it.
        """
        builder = _UniffiRustBufferBuilder()
        try:
            yield builder
        except:
            builder.discard()
            raise

    @contextlib.contextmanager
    def consume_with_stream(self):
        """Context-manager to consume a buffer using a _UniffiRustBufferStream.

        The _UniffiRustBuffer will be freed once the context-manager exits, ensuring that we don't
        leak it even if an error occurs.
        """
        try:
            s = _UniffiRustBufferStream.from_rust_buffer(self)
            yield s
            if s.remaining() != 0:
                raise RuntimeError("junk data left in buffer at end of consume_with_stream")
        finally:
            self.free()

    @contextlib.contextmanager
    def read_with_stream(self):
        """Context-manager to read a buffer using a _UniffiRustBufferStream.

        This is like consume_with_stream, but doesn't free the buffer afterwards.
        It should only be used with borrowed `_UniffiRustBuffer` data.
        """
        s = _UniffiRustBufferStream.from_rust_buffer(self)
        yield s
        if s.remaining() != 0:
            raise RuntimeError("junk data left in buffer at end of read_with_stream")

class _UniffiForeignBytes(ctypes.Structure):
    _fields_ = [
        ("len", ctypes.c_int32),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    def __str__(self):
        return "_UniffiForeignBytes(len={}, data={})".format(self.len, self.data[0:self.len])


class _UniffiRustBufferStream:
    """
    Helper for structured reading of bytes from a _UniffiRustBuffer
    """

    def __init__(self, data, len):
        self.data = data
        self.len = len
        self.offset = 0

    @classmethod
    def from_rust_buffer(cls, buf):
        return cls(buf.data, buf.len)

    def remaining(self):
        return self.len - self.offset

    def _unpack_from(self, size, format):
        if self.offset + size > self.len:
            raise InternalError("read past end of rust buffer")
        value = struct.unpack(format, self.data[self.offset:self.offset+size])[0]
        self.offset += size
        return value

    def read(self, size):
        if self.offset + size > self.len:
            raise InternalError("read past end of rust buffer")
        data = self.data[self.offset:self.offset+size]
        self.offset += size
        return data

    def read_i8(self):
        return self._unpack_from(1, ">b")

    def read_u8(self):
        return self._unpack_from(1, ">B")

    def read_i16(self):
        return self._unpack_from(2, ">h")

    def read_u16(self):
        return self._unpack_from(2, ">H")

    def read_i32(self):
        return self._unpack_from(4, ">i")

    def read_u32(self):
        return self._unpack_from(4, ">I")

    def read_i64(self):
        return self._unpack_from(8, ">q")

    def read_u64(self):
        return self._unpack_from(8, ">Q")

    def read_float(self):
        v = self._unpack_from(4, ">f")
        return v

    def read_double(self):
        return self._unpack_from(8, ">d")

class _UniffiRustBufferBuilder:
    """
    Helper for structured writing of bytes into a _UniffiRustBuffer.
    """

    def __init__(self):
        self.rbuf = _UniffiRustBuffer.alloc(16)
        self.rbuf.len = 0

    def finalize(self):
        rbuf = self.rbuf
        self.rbuf = None
        return rbuf

    def discard(self):
        if self.rbuf is not None:
            rbuf = self.finalize()
            rbuf.free()

    @contextlib.contextmanager
    def _reserve(self, num_bytes):
        if self.rbuf.len + num_bytes > self.rbuf.capacity:
            self.rbuf = _UniffiRustBuffer.reserve(self.rbuf, num_bytes)
        yield None
        self.rbuf.len += num_bytes

    def _pack_into(self, size, format, value):
        with self._reserve(size):
            # XXX TODO: I feel like I should be able to use `struct.pack_into` here but can't figure it out.
            for i, byte in enumerate(struct.pack(format, value)):
                self.rbuf.data[self.rbuf.len + i] = byte

    def write(self, value):
        with self._reserve(len(value)):
            for i, byte in enumerate(value):
                self.rbuf.data[self.rbuf.len + i] = byte

    def write_i8(self, v):
        self._pack_into(1, ">b", v)

    def write_u8(self, v):
        self._pack_into(1, ">B", v)

    def write_i16(self, v):
        self._pack_into(2, ">h", v)

    def write_u16(self, v):
        self._pack_into(2, ">H", v)

    def write_i32(self, v):
        self._pack_into(4, ">i", v)

    def write_u32(self, v):
        self._pack_into(4, ">I", v)

    def write_i64(self, v):
        self._pack_into(8, ">q", v)

    def write_u64(self, v):
        self._pack_into(8, ">Q", v)

    def write_float(self, v):
        self._pack_into(4, ">f", v)

    def write_double(self, v):
        self._pack_into(8, ">d", v)

    def write_c_size_t(self, v):
        self._pack_into(ctypes.sizeof(ctypes.c_size_t) , "@N", v)
# A handful of classes and functions to support the generated data structures.
# This would be a good candidate for isolating in its own ffi-support lib.

class InternalError(Exception):
    pass

class _UniffiRustCallStatus(ctypes.Structure):
    """
    Error runtime.
    """
    _fields_ = [
        ("code", ctypes.c_int8),
        ("error_buf", _UniffiRustBuffer),
    ]

    # These match the values from the uniffi::rustcalls module
    CALL_SUCCESS = 0
    CALL_ERROR = 1
    CALL_UNEXPECTED_ERROR = 2

    @staticmethod
    def default():
        return _UniffiRustCallStatus(code=_UniffiRustCallStatus.CALL_SUCCESS, error_buf=_UniffiRustBuffer.default())

    def __str__(self):
        if self.code == _UniffiRustCallStatus.CALL_SUCCESS:
            return "_UniffiRustCallStatus(CALL_SUCCESS)"
        elif self.code == _UniffiRustCallStatus.CALL_ERROR:
            return "_UniffiRustCallStatus(CALL_ERROR)"
        elif self.code == _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR:
            return "_UniffiRustCallStatus(CALL_UNEXPECTED_ERROR)"
        else:
            return "_UniffiRustCallStatus(<invalid code>)"

def _uniffi_rust_call(fn, *args):
    # Call a rust function
    return _uniffi_rust_call_with_error(None, fn, *args)

def _uniffi_rust_call_with_error(error_ffi_converter, fn, *args):
    # Call a rust function and handle any errors
    #
    # This function is used for rust calls that return Result<> and therefore can set the CALL_ERROR status code.
    # error_ffi_converter must be set to the _UniffiConverter for the error class that corresponds to the result.
    call_status = _UniffiRustCallStatus.default()

    args_with_error = args + (ctypes.byref(call_status),)
    result = fn(*args_with_error)
    _uniffi_check_call_status(error_ffi_converter, call_status)
    return result

def _uniffi_check_call_status(error_ffi_converter, call_status):
    if call_status.code == _UniffiRustCallStatus.CALL_SUCCESS:
        pass
    elif call_status.code == _UniffiRustCallStatus.CALL_ERROR:
        if error_ffi_converter is None:
            call_status.error_buf.free()
            raise InternalError("_uniffi_rust_call_with_error: CALL_ERROR, but error_ffi_converter is None")
        else:
            raise error_ffi_converter.lift(call_status.error_buf)
    elif call_status.code == _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR:
        # When the rust code sees a panic, it tries to construct a _UniffiRustBuffer
        # with the message.  But if that code panics, then it just sends back
        # an empty buffer.
        if call_status.error_buf.len > 0:
            msg = _UniffiConverterString.lift(call_status.error_buf)
        else:
            msg = "Unknown rust panic"
        raise InternalError(msg)
    else:
        raise InternalError("Invalid _UniffiRustCallStatus code: {}".format(
            call_status.code))

def _uniffi_trait_interface_call(call_status, make_call, write_return_value):
    try:
        return write_return_value(make_call())
    except Exception as e:
        call_status.code = _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR
        call_status.error_buf = _UniffiConverterString.lower(repr(e))

def _uniffi_trait_interface_call_with_error(call_status, make_call, write_return_value, error_type, lower_error):
    try:
        try:
            return write_return_value(make_call())
        except error_type as e:
            call_status.code = _UniffiRustCallStatus.CALL_ERROR
            call_status.error_buf = lower_error(e)
    except Exception as e:
        call_status.code = _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR
        call_status.error_buf = _UniffiConverterString.lower(repr(e))
class _UniffiHandleMap:
    """
    A map where inserting, getting and removing data is synchronized with a lock.
    """

    def __init__(self):
        # type Handle = int
        self._map = {}  # type: Dict[Handle, Any]
        self._lock = threading.Lock()
        self._counter = itertools.count()

    def insert(self, obj):
        with self._lock:
            handle = next(self._counter)
            self._map[handle] = obj
            return handle

    def get(self, handle):
        try:
            with self._lock:
                return self._map[handle]
        except KeyError:
            raise InternalError("_UniffiHandleMap.get: Invalid handle")

    def remove(self, handle):
        try:
            with self._lock:
                return self._map.pop(handle)
        except KeyError:
            raise InternalError("_UniffiHandleMap.remove: Invalid handle")

    def __len__(self):
        return len(self._map)
# Types conforming to `_UniffiConverterPrimitive` pass themselves directly over the FFI.
class _UniffiConverterPrimitive:
    @classmethod
    def lift(cls, value):
        return value

    @classmethod
    def lower(cls, value):
        return value

class _UniffiConverterPrimitiveInt(_UniffiConverterPrimitive):
    @classmethod
    def check_lower(cls, value):
        try:
            value = value.__index__()
        except Exception:
            raise TypeError("'{}' object cannot be interpreted as an integer".format(type(value).__name__))
        if not isinstance(value, int):
            raise TypeError("__index__ returned non-int (type {})".format(type(value).__name__))
        if not cls.VALUE_MIN <= value < cls.VALUE_MAX:
            raise ValueError("{} requires {} <= value < {}".format(cls.CLASS_NAME, cls.VALUE_MIN, cls.VALUE_MAX))

class _UniffiConverterPrimitiveFloat(_UniffiConverterPrimitive):
    @classmethod
    def check_lower(cls, value):
        try:
            value = value.__float__()
        except Exception:
            raise TypeError("must be real number, not {}".format(type(value).__name__))
        if not isinstance(value, float):
            raise TypeError("__float__ returned non-float (type {})".format(type(value).__name__))

# Helper class for wrapper types that will always go through a _UniffiRustBuffer.
# Classes should inherit from this and implement the `read` and `write` static methods.
class _UniffiConverterRustBuffer:
    @classmethod
    def lift(cls, rbuf):
        with rbuf.consume_with_stream() as stream:
            return cls.read(stream)

    @classmethod
    def lower(cls, value):
        with _UniffiRustBuffer.alloc_with_builder() as builder:
            cls.write(value, builder)
            return builder.finalize()

# Contains loading, initialization code, and the FFI Function declarations.
# Define some ctypes FFI types that we use in the library

"""
Function pointer for a Rust task, which a callback function that takes a opaque pointer
"""
_UNIFFI_RUST_TASK = ctypes.CFUNCTYPE(None, ctypes.c_void_p, ctypes.c_int8)

def _uniffi_future_callback_t(return_type):
    """
    Factory function to create callback function types for async functions
    """
    return ctypes.CFUNCTYPE(None, ctypes.c_uint64, return_type, _UniffiRustCallStatus)

def _uniffi_load_indirect():
    """
    This is how we find and load the dynamic library provided by the component.
    For now we just look it up by name.
    """
    if sys.platform == "darwin":
        libname = "lib{}.dylib"
    elif sys.platform.startswith("win"):
        # As of python3.8, ctypes does not seem to search $PATH when loading DLLs.
        # We could use `os.add_dll_directory` to configure the search path, but
        # it doesn't feel right to mess with application-wide settings. Let's
        # assume that the `.dll` is next to the `.py` file and load by full path.
        libname = os.path.join(
            os.path.dirname(__file__),
            "{}.dll",
        )
    else:
        # Anything else must be an ELF platform - Linux, *BSD, Solaris/illumos
        libname = "lib{}.so"

    libname = libname.format("rusaint_ffi")
    path = os.path.join(os.path.dirname(__file__), libname)
    lib = ctypes.cdll.LoadLibrary(path)
    return lib

def _uniffi_check_contract_api_version(lib):
    # Get the bindings contract version from our ComponentInterface
    bindings_contract_version = 29
    # Get the scaffolding contract version by calling the into the dylib
    scaffolding_contract_version = lib.ffi_rusaint_ffi_uniffi_contract_version()
    if bindings_contract_version != scaffolding_contract_version:
        raise InternalError("UniFFI contract version mismatch: try cleaning and rebuilding your project")

def _uniffi_check_api_checksums(lib):
    if lib.uniffi_rusaint_ffi_checksum_method_chapelapplication_get_selected_semester() != 6133:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_chapelapplication_information() != 21740:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_chapelapplicationbuilder_build() != 32906:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_coursegradesapplication_certificated_summary() != 8880:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_coursegradesapplication_class_detail() != 3843:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_coursegradesapplication_classes() != 12879:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_coursegradesapplication_get_selected_semester() != 50223:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_coursegradesapplication_recorded_summary() != 3787:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_coursegradesapplication_semesters() != 55958:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_coursegradesapplicationbuilder_build() != 50139:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_chapel_categories() != 21428:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_collages() != 50658:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_connected_majors() != 24954:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_departments() != 10692:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_find_lectures() != 7590:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_get_selected_semester() != 52870:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_graduated_collages() != 29655:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_graduated_departments() != 42882:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_majors() != 356:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_optional_elective_categories() != 63165:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_required_electives() != 46039:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_united_majors() != 41228:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplicationbuilder_build() != 60808:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_graduationrequirementsapplication_requirements() != 63669:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_graduationrequirementsapplication_student_info() != 6063:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_graduationrequirementsapplicationbuilder_build() != 18426:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_lectureassessmentapplication_find_assessments() != 53523:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_lectureassessmentapplication_get_selected_semester() != 2234:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_lectureassessmentapplicationbuilder_build() != 52720:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_personalcoursescheduleapplication_get_selected_semester() != 26180:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_personalcoursescheduleapplication_schedule() != 58730:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_personalcoursescheduleapplicationbuilder_build() != 42578:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_scholarshipsapplication_scholarships() != 28486:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_scholarshipsapplicationbuilder_build() != 35090:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_academic_record() != 56142:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_bank_account() != 24141:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_family() != 32983:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_general() != 64238:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_graduation() != 31914:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_qualifications() != 24889:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_religion() != 49903:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_research_bank_account() != 7706:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_transfer() != 46555:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_work() != 4701:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_studentinformationapplicationbuilder_build() != 12986:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_usaintsessionbuilder_anonymous() != 59232:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_usaintsessionbuilder_with_password() != 35896:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_method_usaintsessionbuilder_with_token() != 48669:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_constructor_chapelapplicationbuilder_new() != 52857:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_constructor_coursegradesapplicationbuilder_new() != 45366:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_constructor_coursescheduleapplicationbuilder_new() != 52419:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_constructor_graduationrequirementsapplicationbuilder_new() != 7670:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_constructor_lectureassessmentapplicationbuilder_new() != 61021:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_constructor_personalcoursescheduleapplicationbuilder_new() != 46717:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_constructor_scholarshipsapplicationbuilder_new() != 64614:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_constructor_studentinformationapplicationbuilder_new() != 5527:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_ffi_checksum_constructor_usaintsessionbuilder_new() != 54500:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")

# A ctypes library to expose the extern-C FFI definitions.
# This is an implementation detail which will be called internally by the public API.

_UniffiLib = _uniffi_load_indirect()
_UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK = ctypes.CFUNCTYPE(None,ctypes.c_uint64,ctypes.c_int8,
)
_UNIFFI_FOREIGN_FUTURE_FREE = ctypes.CFUNCTYPE(None,ctypes.c_uint64,
)
_UNIFFI_CALLBACK_INTERFACE_FREE = ctypes.CFUNCTYPE(None,ctypes.c_uint64,
)
class _UniffiForeignFuture(ctypes.Structure):
    _fields_ = [
        ("handle", ctypes.c_uint64),
        ("free", _UNIFFI_FOREIGN_FUTURE_FREE),
    ]
class _UniffiForeignFutureStructU8(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint8),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U8 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU8,
)
class _UniffiForeignFutureStructI8(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int8),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I8 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI8,
)
class _UniffiForeignFutureStructU16(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint16),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U16 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU16,
)
class _UniffiForeignFutureStructI16(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int16),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I16 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI16,
)
class _UniffiForeignFutureStructU32(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint32),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U32 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU32,
)
class _UniffiForeignFutureStructI32(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int32),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I32 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI32,
)
class _UniffiForeignFutureStructU64(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint64),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U64 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU64,
)
class _UniffiForeignFutureStructI64(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int64),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I64 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI64,
)
class _UniffiForeignFutureStructF32(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_float),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_F32 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructF32,
)
class _UniffiForeignFutureStructF64(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_double),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_F64 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructF64,
)
class _UniffiForeignFutureStructPointer(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_void_p),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_POINTER = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructPointer,
)
class _UniffiForeignFutureStructRustBuffer(ctypes.Structure):
    _fields_ = [
        ("return_value", _UniffiRustBuffer),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_RUST_BUFFER = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructRustBuffer,
)
class _UniffiForeignFutureStructVoid(ctypes.Structure):
    _fields_ = [
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_VOID = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructVoid,
)
_UniffiLib.uniffi_rusaint_ffi_fn_clone_chapelapplication.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_clone_chapelapplication.restype = ctypes.c_void_p
_UniffiLib.uniffi_rusaint_ffi_fn_free_chapelapplication.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_free_chapelapplication.restype = None
_UniffiLib.uniffi_rusaint_ffi_fn_method_chapelapplication_get_selected_semester.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_chapelapplication_get_selected_semester.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_method_chapelapplication_information.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint32,
    _UniffiRustBufferSemesterType,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_chapelapplication_information.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_clone_chapelapplicationbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_clone_chapelapplicationbuilder.restype = ctypes.c_void_p
_UniffiLib.uniffi_rusaint_ffi_fn_free_chapelapplicationbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_free_chapelapplicationbuilder.restype = None
_UniffiLib.uniffi_rusaint_ffi_fn_constructor_chapelapplicationbuilder_new.argtypes = (
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_constructor_chapelapplicationbuilder_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_rusaint_ffi_fn_method_chapelapplicationbuilder_build.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_chapelapplicationbuilder_build.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_clone_coursegradesapplication.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_clone_coursegradesapplication.restype = ctypes.c_void_p
_UniffiLib.uniffi_rusaint_ffi_fn_free_coursegradesapplication.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_free_coursegradesapplication.restype = None
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursegradesapplication_certificated_summary.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBufferCourseType,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursegradesapplication_certificated_summary.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursegradesapplication_class_detail.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBufferCourseType,
    ctypes.c_uint32,
    _UniffiRustBufferSemesterType,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursegradesapplication_class_detail.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursegradesapplication_classes.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBufferCourseType,
    ctypes.c_uint32,
    _UniffiRustBufferSemesterType,
    ctypes.c_int8,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursegradesapplication_classes.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursegradesapplication_get_selected_semester.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursegradesapplication_get_selected_semester.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursegradesapplication_recorded_summary.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBufferCourseType,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursegradesapplication_recorded_summary.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursegradesapplication_semesters.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBufferCourseType,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursegradesapplication_semesters.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_clone_coursegradesapplicationbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_clone_coursegradesapplicationbuilder.restype = ctypes.c_void_p
_UniffiLib.uniffi_rusaint_ffi_fn_free_coursegradesapplicationbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_free_coursegradesapplicationbuilder.restype = None
_UniffiLib.uniffi_rusaint_ffi_fn_constructor_coursegradesapplicationbuilder_new.argtypes = (
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_constructor_coursegradesapplicationbuilder_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursegradesapplicationbuilder_build.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursegradesapplicationbuilder_build.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_clone_coursescheduleapplication.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_clone_coursescheduleapplication.restype = ctypes.c_void_p
_UniffiLib.uniffi_rusaint_ffi_fn_free_coursescheduleapplication.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_free_coursescheduleapplication.restype = None
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_chapel_categories.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint32,
    _UniffiRustBufferSemesterType,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_chapel_categories.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_collages.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint32,
    _UniffiRustBufferSemesterType,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_collages.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_connected_majors.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint32,
    _UniffiRustBufferSemesterType,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_connected_majors.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_departments.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint32,
    _UniffiRustBufferSemesterType,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_departments.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_find_lectures.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint32,
    _UniffiRustBufferSemesterType,
    _UniffiRustBufferLectureCategory,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_find_lectures.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_get_selected_semester.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_get_selected_semester.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_graduated_collages.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint32,
    _UniffiRustBufferSemesterType,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_graduated_collages.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_graduated_departments.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint32,
    _UniffiRustBufferSemesterType,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_graduated_departments.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_majors.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint32,
    _UniffiRustBufferSemesterType,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_majors.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_optional_elective_categories.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint32,
    _UniffiRustBufferSemesterType,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_optional_elective_categories.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_required_electives.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint32,
    _UniffiRustBufferSemesterType,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_required_electives.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_united_majors.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint32,
    _UniffiRustBufferSemesterType,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_united_majors.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_clone_coursescheduleapplicationbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_clone_coursescheduleapplicationbuilder.restype = ctypes.c_void_p
_UniffiLib.uniffi_rusaint_ffi_fn_free_coursescheduleapplicationbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_free_coursescheduleapplicationbuilder.restype = None
_UniffiLib.uniffi_rusaint_ffi_fn_constructor_coursescheduleapplicationbuilder_new.argtypes = (
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_constructor_coursescheduleapplicationbuilder_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplicationbuilder_build.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplicationbuilder_build.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_clone_graduationrequirementsapplication.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_clone_graduationrequirementsapplication.restype = ctypes.c_void_p
_UniffiLib.uniffi_rusaint_ffi_fn_free_graduationrequirementsapplication.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_free_graduationrequirementsapplication.restype = None
_UniffiLib.uniffi_rusaint_ffi_fn_method_graduationrequirementsapplication_requirements.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_graduationrequirementsapplication_requirements.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_method_graduationrequirementsapplication_student_info.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_graduationrequirementsapplication_student_info.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_clone_graduationrequirementsapplicationbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_clone_graduationrequirementsapplicationbuilder.restype = ctypes.c_void_p
_UniffiLib.uniffi_rusaint_ffi_fn_free_graduationrequirementsapplicationbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_free_graduationrequirementsapplicationbuilder.restype = None
_UniffiLib.uniffi_rusaint_ffi_fn_constructor_graduationrequirementsapplicationbuilder_new.argtypes = (
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_constructor_graduationrequirementsapplicationbuilder_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_rusaint_ffi_fn_method_graduationrequirementsapplicationbuilder_build.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_graduationrequirementsapplicationbuilder_build.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_clone_lectureassessmentapplication.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_clone_lectureassessmentapplication.restype = ctypes.c_void_p
_UniffiLib.uniffi_rusaint_ffi_fn_free_lectureassessmentapplication.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_free_lectureassessmentapplication.restype = None
_UniffiLib.uniffi_rusaint_ffi_fn_method_lectureassessmentapplication_find_assessments.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint32,
    _UniffiRustBufferSemesterType,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_lectureassessmentapplication_find_assessments.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_method_lectureassessmentapplication_get_selected_semester.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_lectureassessmentapplication_get_selected_semester.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_clone_lectureassessmentapplicationbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_clone_lectureassessmentapplicationbuilder.restype = ctypes.c_void_p
_UniffiLib.uniffi_rusaint_ffi_fn_free_lectureassessmentapplicationbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_free_lectureassessmentapplicationbuilder.restype = None
_UniffiLib.uniffi_rusaint_ffi_fn_constructor_lectureassessmentapplicationbuilder_new.argtypes = (
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_constructor_lectureassessmentapplicationbuilder_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_rusaint_ffi_fn_method_lectureassessmentapplicationbuilder_build.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_lectureassessmentapplicationbuilder_build.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_clone_personalcoursescheduleapplication.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_clone_personalcoursescheduleapplication.restype = ctypes.c_void_p
_UniffiLib.uniffi_rusaint_ffi_fn_free_personalcoursescheduleapplication.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_free_personalcoursescheduleapplication.restype = None
_UniffiLib.uniffi_rusaint_ffi_fn_method_personalcoursescheduleapplication_get_selected_semester.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_personalcoursescheduleapplication_get_selected_semester.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_method_personalcoursescheduleapplication_schedule.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint32,
    _UniffiRustBufferSemesterType,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_personalcoursescheduleapplication_schedule.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_clone_personalcoursescheduleapplicationbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_clone_personalcoursescheduleapplicationbuilder.restype = ctypes.c_void_p
_UniffiLib.uniffi_rusaint_ffi_fn_free_personalcoursescheduleapplicationbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_free_personalcoursescheduleapplicationbuilder.restype = None
_UniffiLib.uniffi_rusaint_ffi_fn_constructor_personalcoursescheduleapplicationbuilder_new.argtypes = (
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_constructor_personalcoursescheduleapplicationbuilder_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_rusaint_ffi_fn_method_personalcoursescheduleapplicationbuilder_build.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_personalcoursescheduleapplicationbuilder_build.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_clone_scholarshipsapplication.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_clone_scholarshipsapplication.restype = ctypes.c_void_p
_UniffiLib.uniffi_rusaint_ffi_fn_free_scholarshipsapplication.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_free_scholarshipsapplication.restype = None
_UniffiLib.uniffi_rusaint_ffi_fn_method_scholarshipsapplication_scholarships.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_scholarshipsapplication_scholarships.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_clone_scholarshipsapplicationbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_clone_scholarshipsapplicationbuilder.restype = ctypes.c_void_p
_UniffiLib.uniffi_rusaint_ffi_fn_free_scholarshipsapplicationbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_free_scholarshipsapplicationbuilder.restype = None
_UniffiLib.uniffi_rusaint_ffi_fn_constructor_scholarshipsapplicationbuilder_new.argtypes = (
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_constructor_scholarshipsapplicationbuilder_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_rusaint_ffi_fn_method_scholarshipsapplicationbuilder_build.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_scholarshipsapplicationbuilder_build.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_clone_studentinformationapplication.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_clone_studentinformationapplication.restype = ctypes.c_void_p
_UniffiLib.uniffi_rusaint_ffi_fn_free_studentinformationapplication.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_free_studentinformationapplication.restype = None
_UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplication_academic_record.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplication_academic_record.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplication_bank_account.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplication_bank_account.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplication_family.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplication_family.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplication_general.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplication_general.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplication_graduation.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplication_graduation.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplication_qualifications.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplication_qualifications.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplication_religion.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplication_religion.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplication_research_bank_account.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplication_research_bank_account.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplication_transfer.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplication_transfer.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplication_work.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplication_work.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_clone_studentinformationapplicationbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_clone_studentinformationapplicationbuilder.restype = ctypes.c_void_p
_UniffiLib.uniffi_rusaint_ffi_fn_free_studentinformationapplicationbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_free_studentinformationapplicationbuilder.restype = None
_UniffiLib.uniffi_rusaint_ffi_fn_constructor_studentinformationapplicationbuilder_new.argtypes = (
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_constructor_studentinformationapplicationbuilder_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplicationbuilder_build.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplicationbuilder_build.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_clone_usaintsession.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_clone_usaintsession.restype = ctypes.c_void_p
_UniffiLib.uniffi_rusaint_ffi_fn_free_usaintsession.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_free_usaintsession.restype = None
_UniffiLib.uniffi_rusaint_ffi_fn_clone_usaintsessionbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_clone_usaintsessionbuilder.restype = ctypes.c_void_p
_UniffiLib.uniffi_rusaint_ffi_fn_free_usaintsessionbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_free_usaintsessionbuilder.restype = None
_UniffiLib.uniffi_rusaint_ffi_fn_constructor_usaintsessionbuilder_new.argtypes = (
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_constructor_usaintsessionbuilder_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_rusaint_ffi_fn_method_usaintsessionbuilder_anonymous.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_usaintsessionbuilder_anonymous.restype = ctypes.c_void_p
_UniffiLib.uniffi_rusaint_ffi_fn_method_usaintsessionbuilder_with_password.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_usaintsessionbuilder_with_password.restype = ctypes.c_uint64
_UniffiLib.uniffi_rusaint_ffi_fn_method_usaintsessionbuilder_with_token.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_rusaint_ffi_fn_method_usaintsessionbuilder_with_token.restype = ctypes.c_uint64
_UniffiLib.ffi_rusaint_ffi_rustbuffer_alloc.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_ffi_rustbuffer_alloc.restype = _UniffiRustBuffer
_UniffiLib.ffi_rusaint_ffi_rustbuffer_from_bytes.argtypes = (
    _UniffiForeignBytes,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_ffi_rustbuffer_from_bytes.restype = _UniffiRustBuffer
_UniffiLib.ffi_rusaint_ffi_rustbuffer_free.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_ffi_rustbuffer_free.restype = None
_UniffiLib.ffi_rusaint_ffi_rustbuffer_reserve.argtypes = (
    _UniffiRustBuffer,
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_ffi_rustbuffer_reserve.restype = _UniffiRustBuffer
_UniffiLib.ffi_rusaint_ffi_rust_future_poll_u8.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_poll_u8.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_cancel_u8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_cancel_u8.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_free_u8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_free_u8.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_complete_u8.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_ffi_rust_future_complete_u8.restype = ctypes.c_uint8
_UniffiLib.ffi_rusaint_ffi_rust_future_poll_i8.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_poll_i8.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_cancel_i8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_cancel_i8.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_free_i8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_free_i8.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_complete_i8.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_ffi_rust_future_complete_i8.restype = ctypes.c_int8
_UniffiLib.ffi_rusaint_ffi_rust_future_poll_u16.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_poll_u16.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_cancel_u16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_cancel_u16.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_free_u16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_free_u16.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_complete_u16.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_ffi_rust_future_complete_u16.restype = ctypes.c_uint16
_UniffiLib.ffi_rusaint_ffi_rust_future_poll_i16.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_poll_i16.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_cancel_i16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_cancel_i16.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_free_i16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_free_i16.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_complete_i16.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_ffi_rust_future_complete_i16.restype = ctypes.c_int16
_UniffiLib.ffi_rusaint_ffi_rust_future_poll_u32.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_poll_u32.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_cancel_u32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_cancel_u32.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_free_u32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_free_u32.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_complete_u32.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_ffi_rust_future_complete_u32.restype = ctypes.c_uint32
_UniffiLib.ffi_rusaint_ffi_rust_future_poll_i32.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_poll_i32.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_cancel_i32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_cancel_i32.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_free_i32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_free_i32.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_complete_i32.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_ffi_rust_future_complete_i32.restype = ctypes.c_int32
_UniffiLib.ffi_rusaint_ffi_rust_future_poll_u64.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_poll_u64.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_cancel_u64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_cancel_u64.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_free_u64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_free_u64.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_complete_u64.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_ffi_rust_future_complete_u64.restype = ctypes.c_uint64
_UniffiLib.ffi_rusaint_ffi_rust_future_poll_i64.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_poll_i64.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_cancel_i64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_cancel_i64.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_free_i64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_free_i64.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_complete_i64.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_ffi_rust_future_complete_i64.restype = ctypes.c_int64
_UniffiLib.ffi_rusaint_ffi_rust_future_poll_f32.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_poll_f32.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_cancel_f32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_cancel_f32.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_free_f32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_free_f32.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_complete_f32.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_ffi_rust_future_complete_f32.restype = ctypes.c_float
_UniffiLib.ffi_rusaint_ffi_rust_future_poll_f64.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_poll_f64.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_cancel_f64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_cancel_f64.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_free_f64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_free_f64.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_complete_f64.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_ffi_rust_future_complete_f64.restype = ctypes.c_double
_UniffiLib.ffi_rusaint_ffi_rust_future_poll_pointer.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_poll_pointer.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_cancel_pointer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_cancel_pointer.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_free_pointer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_free_pointer.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_complete_pointer.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_ffi_rust_future_complete_pointer.restype = ctypes.c_void_p
_UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_cancel_rust_buffer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_cancel_rust_buffer.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer.restype = _UniffiRustBuffer
_UniffiLib.ffi_rusaint_ffi_rust_future_poll_void.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_poll_void.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_cancel_void.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_cancel_void.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_free_void.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_ffi_rust_future_free_void.restype = None
_UniffiLib.ffi_rusaint_ffi_rust_future_complete_void.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_ffi_rust_future_complete_void.restype = None
_UniffiLib.uniffi_rusaint_ffi_checksum_method_chapelapplication_get_selected_semester.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_chapelapplication_get_selected_semester.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_chapelapplication_information.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_chapelapplication_information.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_chapelapplicationbuilder_build.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_chapelapplicationbuilder_build.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursegradesapplication_certificated_summary.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursegradesapplication_certificated_summary.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursegradesapplication_class_detail.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursegradesapplication_class_detail.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursegradesapplication_classes.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursegradesapplication_classes.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursegradesapplication_get_selected_semester.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursegradesapplication_get_selected_semester.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursegradesapplication_recorded_summary.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursegradesapplication_recorded_summary.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursegradesapplication_semesters.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursegradesapplication_semesters.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursegradesapplicationbuilder_build.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursegradesapplicationbuilder_build.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_chapel_categories.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_chapel_categories.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_collages.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_collages.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_connected_majors.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_connected_majors.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_departments.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_departments.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_find_lectures.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_find_lectures.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_get_selected_semester.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_get_selected_semester.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_graduated_collages.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_graduated_collages.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_graduated_departments.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_graduated_departments.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_majors.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_majors.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_optional_elective_categories.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_optional_elective_categories.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_required_electives.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_required_electives.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_united_majors.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_united_majors.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplicationbuilder_build.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplicationbuilder_build.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_graduationrequirementsapplication_requirements.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_graduationrequirementsapplication_requirements.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_graduationrequirementsapplication_student_info.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_graduationrequirementsapplication_student_info.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_graduationrequirementsapplicationbuilder_build.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_graduationrequirementsapplicationbuilder_build.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_lectureassessmentapplication_find_assessments.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_lectureassessmentapplication_find_assessments.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_lectureassessmentapplication_get_selected_semester.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_lectureassessmentapplication_get_selected_semester.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_lectureassessmentapplicationbuilder_build.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_lectureassessmentapplicationbuilder_build.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_personalcoursescheduleapplication_get_selected_semester.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_personalcoursescheduleapplication_get_selected_semester.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_personalcoursescheduleapplication_schedule.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_personalcoursescheduleapplication_schedule.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_personalcoursescheduleapplicationbuilder_build.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_personalcoursescheduleapplicationbuilder_build.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_scholarshipsapplication_scholarships.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_scholarshipsapplication_scholarships.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_scholarshipsapplicationbuilder_build.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_scholarshipsapplicationbuilder_build.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_academic_record.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_academic_record.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_bank_account.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_bank_account.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_family.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_family.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_general.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_general.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_graduation.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_graduation.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_qualifications.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_qualifications.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_religion.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_religion.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_research_bank_account.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_research_bank_account.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_transfer.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_transfer.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_work.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_work.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_studentinformationapplicationbuilder_build.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_studentinformationapplicationbuilder_build.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_usaintsessionbuilder_anonymous.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_usaintsessionbuilder_anonymous.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_usaintsessionbuilder_with_password.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_usaintsessionbuilder_with_password.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_method_usaintsessionbuilder_with_token.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_method_usaintsessionbuilder_with_token.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_constructor_chapelapplicationbuilder_new.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_constructor_chapelapplicationbuilder_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_constructor_coursegradesapplicationbuilder_new.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_constructor_coursegradesapplicationbuilder_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_constructor_coursescheduleapplicationbuilder_new.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_constructor_coursescheduleapplicationbuilder_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_constructor_graduationrequirementsapplicationbuilder_new.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_constructor_graduationrequirementsapplicationbuilder_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_constructor_lectureassessmentapplicationbuilder_new.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_constructor_lectureassessmentapplicationbuilder_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_constructor_personalcoursescheduleapplicationbuilder_new.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_constructor_personalcoursescheduleapplicationbuilder_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_constructor_scholarshipsapplicationbuilder_new.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_constructor_scholarshipsapplicationbuilder_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_constructor_studentinformationapplicationbuilder_new.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_constructor_studentinformationapplicationbuilder_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_ffi_checksum_constructor_usaintsessionbuilder_new.argtypes = (
)
_UniffiLib.uniffi_rusaint_ffi_checksum_constructor_usaintsessionbuilder_new.restype = ctypes.c_uint16
_UniffiLib.ffi_rusaint_ffi_uniffi_contract_version.argtypes = (
)
_UniffiLib.ffi_rusaint_ffi_uniffi_contract_version.restype = ctypes.c_uint32

_uniffi_check_contract_api_version(_UniffiLib)
# _uniffi_check_api_checksums(_UniffiLib)

# Public interface members begin here.


class _UniffiConverterUInt32(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "u32"
    VALUE_MIN = 0
    VALUE_MAX = 2**32

    @staticmethod
    def read(buf):
        return buf.read_u32()

    @staticmethod
    def write(value, buf):
        buf.write_u32(value)

class _UniffiConverterFloat(_UniffiConverterPrimitiveFloat):
    @staticmethod
    def read(buf):
        return buf.read_float()

    @staticmethod
    def write(value, buf):
        buf.write_float(value)

class _UniffiConverterBool:
    @classmethod
    def check_lower(cls, value):
        return not not value

    @classmethod
    def lower(cls, value):
        return 1 if value else 0

    @staticmethod
    def lift(value):
        return value != 0

    @classmethod
    def read(cls, buf):
        return cls.lift(buf.read_u8())

    @classmethod
    def write(cls, value, buf):
        buf.write_u8(value)

class _UniffiConverterString:
    @staticmethod
    def check_lower(value):
        if not isinstance(value, str):
            raise TypeError("argument must be str, not {}".format(type(value).__name__))
        return value

    @staticmethod
    def read(buf):
        size = buf.read_i32()
        if size < 0:
            raise InternalError("Unexpected negative string length")
        utf8_bytes = buf.read(size)
        return utf8_bytes.decode("utf-8")

    @staticmethod
    def write(value, buf):
        utf8_bytes = value.encode("utf-8")
        buf.write_i32(len(utf8_bytes))
        buf.write(utf8_bytes)

    @staticmethod
    def lift(buf):
        with buf.consume_with_stream() as stream:
            return stream.read(stream.remaining()).decode("utf-8")

    @staticmethod
    def lower(value):
        with _UniffiRustBuffer.alloc_with_builder() as builder:
            builder.write(value.encode("utf-8"))
            return builder.finalize()






































class YearSemester:
    year: "int"
    semester: "SemesterType"
    def __init__(self, *, year: "int", semester: "SemesterType"):
        self.year = year
        self.semester = semester

    def __str__(self):
        return "YearSemester(year={}, semester={})".format(self.year, self.semester)

    def __eq__(self, other):
        if self.year != other.year:
            return False
        if self.semester != other.semester:
            return False
        return True

class _UniffiConverterTypeYearSemester(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return YearSemester(
            year=_UniffiConverterUInt32.read(buf),
            semester=_UniffiConverterTypeSemesterType.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt32.check_lower(value.year)
        _UniffiConverterTypeSemesterType.check_lower(value.semester)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt32.write(value.year, buf)
        _UniffiConverterTypeSemesterType.write(value.semester, buf)


# RusaintError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class RusaintError(Exception):
    """
    Rusaint에서 반환하는 기본 오류
    """

    pass

_UniffiTempRusaintError = RusaintError

class RusaintError:  # type: ignore
    """
    Rusaint에서 반환하는 기본 오류
    """

    class General(_UniffiTempRusaintError):

        def __repr__(self):
            return "RusaintError.General({})".format(repr(str(self)))
    _UniffiTempRusaintError.General = General # type: ignore

RusaintError = _UniffiTempRusaintError # type: ignore
del _UniffiTempRusaintError


class _UniffiConverterTypeRusaintError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return RusaintError.General(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, RusaintError.General):
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, RusaintError.General):
            buf.write_i32(1)



class _UniffiConverterOptionalUInt32(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterUInt32.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterUInt32.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterUInt32.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalString(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterString.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterString.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterString.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterSequenceString(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterString.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterString.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterString.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeClassGrade(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeClassGrade.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeClassGrade.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeClassGrade.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeLecture(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeLecture.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeLecture.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeLecture.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeLectureAssessmentResult(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeLectureAssessmentResult.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeLectureAssessmentResult.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeLectureAssessmentResult.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeScholarship(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeScholarship.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeScholarship.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeScholarship.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeSemesterGrade(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeSemesterGrade.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeSemesterGrade.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeSemesterGrade.read(buf) for i in range(count)
        ]



class _UniffiConverterMapStringFloat(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, items):
        for (key, value) in items.items():
            _UniffiConverterString.check_lower(key)
            _UniffiConverterFloat.check_lower(value)

    @classmethod
    def write(cls, items, buf):
        buf.write_i32(len(items))
        for (key, value) in items.items():
            _UniffiConverterString.write(key, buf)
            _UniffiConverterFloat.write(value, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative map size")

        # It would be nice to use a dict comprehension,
        # but in Python 3.7 and before the evaluation order is not according to spec,
        # so we we're reading the value before the key.
        # This loop makes the order explicit: first reading the key, then the value.
        d = {}
        for i in range(count):
            key = _UniffiConverterString.read(buf)
            val = _UniffiConverterFloat.read(buf)
            d[key] = val
        return d

# objects.
class ChapelApplicationProtocol(typing.Protocol):
    """
    [채플정보조회](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMW3681)
    """

    def get_selected_semester(self, ):
        """
        현재 페이지에 선택된 년도와 학기를 가져옵니다. 최초 로드 시 현재 학기를 가져올 가능성이 있습니다.
        하지만 이 애플리케이션의 다른 함수를 호출하여 한번 정보를 가져왔다면 마지막으로 가져온 정보의 학기가 반환되므로 주의하여야 하며, 신뢰할 수 있는 현재 학기의 원천으로 사용되어서는 안됩니다.
        """

        raise NotImplementedError
    def information(self, year: "int",semester: "SemesterType"):
        """
        해당 학기의 채플 정보를 가져옵니다.
        """

        raise NotImplementedError
# ChapelApplication is a Rust-only trait - it's a wrapper around a Rust implementation.
class ChapelApplication():
    """
    [채플정보조회](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMW3681)
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_free_chapelapplication, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_clone_chapelapplication, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    async def get_selected_semester(self, ) -> "YearSemester":
        """
        현재 페이지에 선택된 년도와 학기를 가져옵니다. 최초 로드 시 현재 학기를 가져올 가능성이 있습니다.
        하지만 이 애플리케이션의 다른 함수를 호출하여 한번 정보를 가져왔다면 마지막으로 가져온 정보의 학기가 반환되므로 주의하여야 하며, 신뢰할 수 있는 현재 학기의 원천으로 사용되어서는 안됩니다.
        """

        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_chapelapplication_get_selected_semester(
                self._uniffi_clone_pointer(), 
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeYearSemester.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )



    async def information(self, year: "int",semester: "SemesterType") -> "ChapelInformation":
        """
        해당 학기의 채플 정보를 가져옵니다.
        """

        _UniffiConverterUInt32.check_lower(year)
        
        _UniffiConverterTypeSemesterType.check_lower(semester)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_chapelapplication_information(
                self._uniffi_clone_pointer(), 
        _UniffiConverterUInt32.lower(year),
        _UniffiConverterTypeSemesterType.lower(semester)
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeChapelInformation.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )





class _UniffiConverterTypeChapelApplication:

    @staticmethod
    def lift(value: int):
        return ChapelApplication._make_instance_(value)

    @staticmethod
    def check_lower(value: ChapelApplication):
        if not isinstance(value, ChapelApplication):
            raise TypeError("Expected ChapelApplication instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: ChapelApplicationProtocol):
        if not isinstance(value, ChapelApplication):
            raise TypeError("Expected ChapelApplication instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: ChapelApplicationProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class ChapelApplicationBuilderProtocol(typing.Protocol):
    """
    [`ChapelApplication`] 생성을 위한 빌더
    """

    def build(self, session: "USaintSession"):
        """
        세션과 함께 [`ChapelApplication`]을 만듭니다.
        """

        raise NotImplementedError
# ChapelApplicationBuilder is a Rust-only trait - it's a wrapper around a Rust implementation.
class ChapelApplicationBuilder():
    """
    [`ChapelApplication`] 생성을 위한 빌더
    """

    _pointer: ctypes.c_void_p
    def __init__(self, ):
        """
        새로운 [`ChapelApplicationBuilder`]를 만듭니다.
        """

        self._pointer = _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_constructor_chapelapplicationbuilder_new,)

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_free_chapelapplicationbuilder, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_clone_chapelapplicationbuilder, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    async def build(self, session: "USaintSession") -> "ChapelApplication":
        """
        세션과 함께 [`ChapelApplication`]을 만듭니다.
        """

        _UniffiConverterTypeUSaintSession.check_lower(session)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_chapelapplicationbuilder_build(
                self._uniffi_clone_pointer(), 
        _UniffiConverterTypeUSaintSession.lower(session)
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_pointer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_pointer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_pointer,
            # lift function
            _UniffiConverterTypeChapelApplication.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )





class _UniffiConverterTypeChapelApplicationBuilder:

    @staticmethod
    def lift(value: int):
        return ChapelApplicationBuilder._make_instance_(value)

    @staticmethod
    def check_lower(value: ChapelApplicationBuilder):
        if not isinstance(value, ChapelApplicationBuilder):
            raise TypeError("Expected ChapelApplicationBuilder instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: ChapelApplicationBuilderProtocol):
        if not isinstance(value, ChapelApplicationBuilder):
            raise TypeError("Expected ChapelApplicationBuilder instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: ChapelApplicationBuilderProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class CourseGradesApplicationProtocol(typing.Protocol):
    """
    [학생 성적 조회](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMB3W0017)
    """

    def certificated_summary(self, course_type: "CourseType"):
        """
        전체 학기의 증명 평점 정보를 가져옵니다.
        """

        raise NotImplementedError
    def class_detail(self, course_type: "CourseType",year: "int",semester: "SemesterType",code: "str"):
        """
        주어진 수업의 상세 성적 정보를 가져옵니다.
        """

        raise NotImplementedError
    def classes(self, course_type: "CourseType",year: "int",semester: "SemesterType",include_details: "bool"):
        """
        주어진 학기의 수업별 성적을 가져옵니다. `include_details`가 `true`인 경우 수업의 상세 성적도 가져옵니다.
        수업의 상세 성적까지 가져올 경우 상세 성적이 있는 수업의 수 만큼 서버에 요청을 보내므로 반드시 상세 성적도 한번에 가져와야 할 때에만 사용하십시오.

        수업 성적을 가져온 이후 상세 성적 또한 가져오려면 `[class_detail()]`함수를 이용하십시오.
        """

        raise NotImplementedError
    def get_selected_semester(self, ):
        """
        현재 페이지에 선택된 년도와 학기를 가져옵니다. 최초 로드 시 현재 학기를 가져올 가능성이 있습니다.
        하지만 이 애플리케이션의 다른 함수를 호출하여 한번 정보를 가져왔다면 마지막으로 가져온 정보의 학기가 반환되므로 주의하여야 하며, 신뢰할 수 있는 현재 학기의 원천으로 사용되어서는 안됩니다.
        """

        raise NotImplementedError
    def recorded_summary(self, course_type: "CourseType"):
        """
        전체 학기의 학적부 평점 정보를 가져옵니다.
        """

        raise NotImplementedError
    def semesters(self, course_type: "CourseType"):
        """
        학기별 평점 정보를 가져옵니다.
        """

        raise NotImplementedError
# CourseGradesApplication is a Rust-only trait - it's a wrapper around a Rust implementation.
class CourseGradesApplication():
    """
    [학생 성적 조회](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMB3W0017)
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_free_coursegradesapplication, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_clone_coursegradesapplication, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    async def certificated_summary(self, course_type: "CourseType") -> "GradeSummary":
        """
        전체 학기의 증명 평점 정보를 가져옵니다.
        """

        _UniffiConverterTypeCourseType.check_lower(course_type)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_coursegradesapplication_certificated_summary(
                self._uniffi_clone_pointer(), 
        _UniffiConverterTypeCourseType.lower(course_type)
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeGradeSummary.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )



    async def class_detail(self, course_type: "CourseType",year: "int",semester: "SemesterType",code: "str") -> "dict[str, float]":
        """
        주어진 수업의 상세 성적 정보를 가져옵니다.
        """

        _UniffiConverterTypeCourseType.check_lower(course_type)
        
        _UniffiConverterUInt32.check_lower(year)
        
        _UniffiConverterTypeSemesterType.check_lower(semester)
        
        _UniffiConverterString.check_lower(code)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_coursegradesapplication_class_detail(
                self._uniffi_clone_pointer(), 
        _UniffiConverterTypeCourseType.lower(course_type),
        _UniffiConverterUInt32.lower(year),
        _UniffiConverterTypeSemesterType.lower(semester),
        _UniffiConverterString.lower(code)
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterMapStringFloat.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )



    async def classes(self, course_type: "CourseType",year: "int",semester: "SemesterType",include_details: "bool") -> "typing.List[ClassGrade]":
        """
        주어진 학기의 수업별 성적을 가져옵니다. `include_details`가 `true`인 경우 수업의 상세 성적도 가져옵니다.
        수업의 상세 성적까지 가져올 경우 상세 성적이 있는 수업의 수 만큼 서버에 요청을 보내므로 반드시 상세 성적도 한번에 가져와야 할 때에만 사용하십시오.

        수업 성적을 가져온 이후 상세 성적 또한 가져오려면 `[class_detail()]`함수를 이용하십시오.
        """

        _UniffiConverterTypeCourseType.check_lower(course_type)
        
        _UniffiConverterUInt32.check_lower(year)
        
        _UniffiConverterTypeSemesterType.check_lower(semester)
        
        _UniffiConverterBool.check_lower(include_details)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_coursegradesapplication_classes(
                self._uniffi_clone_pointer(), 
        _UniffiConverterTypeCourseType.lower(course_type),
        _UniffiConverterUInt32.lower(year),
        _UniffiConverterTypeSemesterType.lower(semester),
        _UniffiConverterBool.lower(include_details)
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterSequenceTypeClassGrade.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )



    async def get_selected_semester(self, ) -> "YearSemester":
        """
        현재 페이지에 선택된 년도와 학기를 가져옵니다. 최초 로드 시 현재 학기를 가져올 가능성이 있습니다.
        하지만 이 애플리케이션의 다른 함수를 호출하여 한번 정보를 가져왔다면 마지막으로 가져온 정보의 학기가 반환되므로 주의하여야 하며, 신뢰할 수 있는 현재 학기의 원천으로 사용되어서는 안됩니다.
        """

        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_coursegradesapplication_get_selected_semester(
                self._uniffi_clone_pointer(), 
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeYearSemester.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )



    async def recorded_summary(self, course_type: "CourseType") -> "GradeSummary":
        """
        전체 학기의 학적부 평점 정보를 가져옵니다.
        """

        _UniffiConverterTypeCourseType.check_lower(course_type)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_coursegradesapplication_recorded_summary(
                self._uniffi_clone_pointer(), 
        _UniffiConverterTypeCourseType.lower(course_type)
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeGradeSummary.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )



    async def semesters(self, course_type: "CourseType") -> "typing.List[SemesterGrade]":
        """
        학기별 평점 정보를 가져옵니다.
        """

        _UniffiConverterTypeCourseType.check_lower(course_type)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_coursegradesapplication_semesters(
                self._uniffi_clone_pointer(), 
        _UniffiConverterTypeCourseType.lower(course_type)
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterSequenceTypeSemesterGrade.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )





class _UniffiConverterTypeCourseGradesApplication:

    @staticmethod
    def lift(value: int):
        return CourseGradesApplication._make_instance_(value)

    @staticmethod
    def check_lower(value: CourseGradesApplication):
        if not isinstance(value, CourseGradesApplication):
            raise TypeError("Expected CourseGradesApplication instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: CourseGradesApplicationProtocol):
        if not isinstance(value, CourseGradesApplication):
            raise TypeError("Expected CourseGradesApplication instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: CourseGradesApplicationProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class CourseGradesApplicationBuilderProtocol(typing.Protocol):
    """
    [`CourseGradesApplication`] 생성을 위한 빌더
    """

    def build(self, session: "USaintSession"):
        """
        세션과 함께 [`CourseGradesApplication`]을 만듭니다.
        """

        raise NotImplementedError
# CourseGradesApplicationBuilder is a Rust-only trait - it's a wrapper around a Rust implementation.
class CourseGradesApplicationBuilder():
    """
    [`CourseGradesApplication`] 생성을 위한 빌더
    """

    _pointer: ctypes.c_void_p
    def __init__(self, ):
        """
        새로운 [`CourseGradesApplicationBuilder`]를 만듭니다.
        """

        self._pointer = _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_constructor_coursegradesapplicationbuilder_new,)

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_free_coursegradesapplicationbuilder, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_clone_coursegradesapplicationbuilder, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    async def build(self, session: "USaintSession") -> "CourseGradesApplication":
        """
        세션과 함께 [`CourseGradesApplication`]을 만듭니다.
        """

        _UniffiConverterTypeUSaintSession.check_lower(session)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_coursegradesapplicationbuilder_build(
                self._uniffi_clone_pointer(), 
        _UniffiConverterTypeUSaintSession.lower(session)
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_pointer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_pointer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_pointer,
            # lift function
            _UniffiConverterTypeCourseGradesApplication.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )





class _UniffiConverterTypeCourseGradesApplicationBuilder:

    @staticmethod
    def lift(value: int):
        return CourseGradesApplicationBuilder._make_instance_(value)

    @staticmethod
    def check_lower(value: CourseGradesApplicationBuilder):
        if not isinstance(value, CourseGradesApplicationBuilder):
            raise TypeError("Expected CourseGradesApplicationBuilder instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: CourseGradesApplicationBuilderProtocol):
        if not isinstance(value, CourseGradesApplicationBuilder):
            raise TypeError("Expected CourseGradesApplicationBuilder instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: CourseGradesApplicationBuilderProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class CourseScheduleApplicationProtocol(typing.Protocol):
    """
    [강의시간표](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMW2100)
    """

    def chapel_categories(self, year: "int",semester: "SemesterType"):
        """
        선택한 학기의 채플 과목 분류 목록을 가져옵니다.
        """

        raise NotImplementedError
    def collages(self, year: "int",semester: "SemesterType"):
        """
        선택한 학기 기준 단과대 목록을 가져옵니다.
        """

        raise NotImplementedError
    def connected_majors(self, year: "int",semester: "SemesterType"):
        """
        선택한 학기의 연계전공 목록을 가져옵니다.
        """

        raise NotImplementedError
    def departments(self, year: "int",semester: "SemesterType",collage: "str"):
        """
        선택한 학기 기준 주어진 단과대의 학과(부) 목록을 가져옵니다.
        """

        raise NotImplementedError
    def find_lectures(self, year: "int",semester: "SemesterType",lecture_category: "LectureCategory"):
        """
        학기, 학년도, 강의 분류를 통해 강의를 찾습니다.
        """

        raise NotImplementedError
    def get_selected_semester(self, ):
        """
        현재 페이지에 선택된 년도와 학기를 가져옵니다. 최초 로드 시 현재 학기를 가져올 가능성이 있습니다.
        하지만 이 애플리케이션의 다른 함수를 호출하여 한번 정보를 가져왔다면 마지막으로 가져온 정보의 학기가 반환되므로 주의하여야 하며, 신뢰할 수 있는 현재 학기의 원천으로 사용되어서는 안됩니다.
        """

        raise NotImplementedError
    def graduated_collages(self, year: "int",semester: "SemesterType"):
        """
        선택한 학기의 대학원 단과대학 목록을 가져옵니다.
        """

        raise NotImplementedError
    def graduated_departments(self, year: "int",semester: "SemesterType",collage: "str"):
        """
        선택한 학기의 주어진 대학원 단과대의 학과 목록을 가져옵니다.
        """

        raise NotImplementedError
    def majors(self, year: "int",semester: "SemesterType",collage: "str",department: "str"):
        """
        선택한 학과(부)의 전공 목록을 가져옵니다.
        """

        raise NotImplementedError
    def optional_elective_categories(self, year: "int",semester: "SemesterType"):
        """
        선택한 학기의 교양선택 분야 목록을 가져옵니다.
        """

        raise NotImplementedError
    def required_electives(self, year: "int",semester: "SemesterType"):
        """
        선택한 학기의 교양필수 과목명 목록을 가져옵니다.
        """

        raise NotImplementedError
    def united_majors(self, year: "int",semester: "SemesterType"):
        """
        선택한 학기의 융합전공 목록을 가져옵니다.
        """

        raise NotImplementedError
# CourseScheduleApplication is a Rust-only trait - it's a wrapper around a Rust implementation.
class CourseScheduleApplication():
    """
    [강의시간표](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMW2100)
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_free_coursescheduleapplication, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_clone_coursescheduleapplication, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    async def chapel_categories(self, year: "int",semester: "SemesterType") -> "typing.List[str]":
        """
        선택한 학기의 채플 과목 분류 목록을 가져옵니다.
        """

        _UniffiConverterUInt32.check_lower(year)
        
        _UniffiConverterTypeSemesterType.check_lower(semester)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_chapel_categories(
                self._uniffi_clone_pointer(), 
        _UniffiConverterUInt32.lower(year),
        _UniffiConverterTypeSemesterType.lower(semester)
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterSequenceString.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )



    async def collages(self, year: "int",semester: "SemesterType") -> "typing.List[str]":
        """
        선택한 학기 기준 단과대 목록을 가져옵니다.
        """

        _UniffiConverterUInt32.check_lower(year)
        
        _UniffiConverterTypeSemesterType.check_lower(semester)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_collages(
                self._uniffi_clone_pointer(), 
        _UniffiConverterUInt32.lower(year),
        _UniffiConverterTypeSemesterType.lower(semester)
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterSequenceString.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )



    async def connected_majors(self, year: "int",semester: "SemesterType") -> "typing.List[str]":
        """
        선택한 학기의 연계전공 목록을 가져옵니다.
        """

        _UniffiConverterUInt32.check_lower(year)
        
        _UniffiConverterTypeSemesterType.check_lower(semester)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_connected_majors(
                self._uniffi_clone_pointer(), 
        _UniffiConverterUInt32.lower(year),
        _UniffiConverterTypeSemesterType.lower(semester)
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterSequenceString.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )



    async def departments(self, year: "int",semester: "SemesterType",collage: "str") -> "typing.List[str]":
        """
        선택한 학기 기준 주어진 단과대의 학과(부) 목록을 가져옵니다.
        """

        _UniffiConverterUInt32.check_lower(year)
        
        _UniffiConverterTypeSemesterType.check_lower(semester)
        
        _UniffiConverterString.check_lower(collage)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_departments(
                self._uniffi_clone_pointer(), 
        _UniffiConverterUInt32.lower(year),
        _UniffiConverterTypeSemesterType.lower(semester),
        _UniffiConverterString.lower(collage)
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterSequenceString.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )



    async def find_lectures(self, year: "int",semester: "SemesterType",lecture_category: "LectureCategory") -> "typing.List[Lecture]":
        """
        학기, 학년도, 강의 분류를 통해 강의를 찾습니다.
        """

        _UniffiConverterUInt32.check_lower(year)
        
        _UniffiConverterTypeSemesterType.check_lower(semester)
        
        _UniffiConverterTypeLectureCategory.check_lower(lecture_category)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_find_lectures(
                self._uniffi_clone_pointer(), 
        _UniffiConverterUInt32.lower(year),
        _UniffiConverterTypeSemesterType.lower(semester),
        _UniffiConverterTypeLectureCategory.lower(lecture_category)
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterSequenceTypeLecture.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )



    async def get_selected_semester(self, ) -> "YearSemester":
        """
        현재 페이지에 선택된 년도와 학기를 가져옵니다. 최초 로드 시 현재 학기를 가져올 가능성이 있습니다.
        하지만 이 애플리케이션의 다른 함수를 호출하여 한번 정보를 가져왔다면 마지막으로 가져온 정보의 학기가 반환되므로 주의하여야 하며, 신뢰할 수 있는 현재 학기의 원천으로 사용되어서는 안됩니다.
        """

        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_get_selected_semester(
                self._uniffi_clone_pointer(), 
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeYearSemester.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )



    async def graduated_collages(self, year: "int",semester: "SemesterType") -> "typing.List[str]":
        """
        선택한 학기의 대학원 단과대학 목록을 가져옵니다.
        """

        _UniffiConverterUInt32.check_lower(year)
        
        _UniffiConverterTypeSemesterType.check_lower(semester)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_graduated_collages(
                self._uniffi_clone_pointer(), 
        _UniffiConverterUInt32.lower(year),
        _UniffiConverterTypeSemesterType.lower(semester)
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterSequenceString.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )



    async def graduated_departments(self, year: "int",semester: "SemesterType",collage: "str") -> "typing.List[str]":
        """
        선택한 학기의 주어진 대학원 단과대의 학과 목록을 가져옵니다.
        """

        _UniffiConverterUInt32.check_lower(year)
        
        _UniffiConverterTypeSemesterType.check_lower(semester)
        
        _UniffiConverterString.check_lower(collage)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_graduated_departments(
                self._uniffi_clone_pointer(), 
        _UniffiConverterUInt32.lower(year),
        _UniffiConverterTypeSemesterType.lower(semester),
        _UniffiConverterString.lower(collage)
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterSequenceString.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )



    async def majors(self, year: "int",semester: "SemesterType",collage: "str",department: "str") -> "typing.List[str]":
        """
        선택한 학과(부)의 전공 목록을 가져옵니다.
        """

        _UniffiConverterUInt32.check_lower(year)
        
        _UniffiConverterTypeSemesterType.check_lower(semester)
        
        _UniffiConverterString.check_lower(collage)
        
        _UniffiConverterString.check_lower(department)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_majors(
                self._uniffi_clone_pointer(), 
        _UniffiConverterUInt32.lower(year),
        _UniffiConverterTypeSemesterType.lower(semester),
        _UniffiConverterString.lower(collage),
        _UniffiConverterString.lower(department)
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterSequenceString.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )



    async def optional_elective_categories(self, year: "int",semester: "SemesterType") -> "typing.List[str]":
        """
        선택한 학기의 교양선택 분야 목록을 가져옵니다.
        """

        _UniffiConverterUInt32.check_lower(year)
        
        _UniffiConverterTypeSemesterType.check_lower(semester)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_optional_elective_categories(
                self._uniffi_clone_pointer(), 
        _UniffiConverterUInt32.lower(year),
        _UniffiConverterTypeSemesterType.lower(semester)
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterSequenceString.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )



    async def required_electives(self, year: "int",semester: "SemesterType") -> "typing.List[str]":
        """
        선택한 학기의 교양필수 과목명 목록을 가져옵니다.
        """

        _UniffiConverterUInt32.check_lower(year)
        
        _UniffiConverterTypeSemesterType.check_lower(semester)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_required_electives(
                self._uniffi_clone_pointer(), 
        _UniffiConverterUInt32.lower(year),
        _UniffiConverterTypeSemesterType.lower(semester)
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterSequenceString.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )



    async def united_majors(self, year: "int",semester: "SemesterType") -> "typing.List[str]":
        """
        선택한 학기의 융합전공 목록을 가져옵니다.
        """

        _UniffiConverterUInt32.check_lower(year)
        
        _UniffiConverterTypeSemesterType.check_lower(semester)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_united_majors(
                self._uniffi_clone_pointer(), 
        _UniffiConverterUInt32.lower(year),
        _UniffiConverterTypeSemesterType.lower(semester)
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterSequenceString.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )





class _UniffiConverterTypeCourseScheduleApplication:

    @staticmethod
    def lift(value: int):
        return CourseScheduleApplication._make_instance_(value)

    @staticmethod
    def check_lower(value: CourseScheduleApplication):
        if not isinstance(value, CourseScheduleApplication):
            raise TypeError("Expected CourseScheduleApplication instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: CourseScheduleApplicationProtocol):
        if not isinstance(value, CourseScheduleApplication):
            raise TypeError("Expected CourseScheduleApplication instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: CourseScheduleApplicationProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class CourseScheduleApplicationBuilderProtocol(typing.Protocol):
    """
    [`CourseScheduleApplication`] 생성을 위한 빌더
    """

    def build(self, session: "USaintSession"):
        """
        세션과 함께 [`CourseScheduleApplication`]을 만듭니다.
        """

        raise NotImplementedError
# CourseScheduleApplicationBuilder is a Rust-only trait - it's a wrapper around a Rust implementation.
class CourseScheduleApplicationBuilder():
    """
    [`CourseScheduleApplication`] 생성을 위한 빌더
    """

    _pointer: ctypes.c_void_p
    def __init__(self, ):
        """
        새로운 [`CourseScheduleApplicationBuilder`]를 만듭니다.
        """

        self._pointer = _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_constructor_coursescheduleapplicationbuilder_new,)

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_free_coursescheduleapplicationbuilder, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_clone_coursescheduleapplicationbuilder, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    async def build(self, session: "USaintSession") -> "CourseScheduleApplication":
        """
        세션과 함께 [`CourseScheduleApplication`]을 만듭니다.
        """

        _UniffiConverterTypeUSaintSession.check_lower(session)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_coursescheduleapplicationbuilder_build(
                self._uniffi_clone_pointer(), 
        _UniffiConverterTypeUSaintSession.lower(session)
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_pointer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_pointer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_pointer,
            # lift function
            _UniffiConverterTypeCourseScheduleApplication.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )





class _UniffiConverterTypeCourseScheduleApplicationBuilder:

    @staticmethod
    def lift(value: int):
        return CourseScheduleApplicationBuilder._make_instance_(value)

    @staticmethod
    def check_lower(value: CourseScheduleApplicationBuilder):
        if not isinstance(value, CourseScheduleApplicationBuilder):
            raise TypeError("Expected CourseScheduleApplicationBuilder instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: CourseScheduleApplicationBuilderProtocol):
        if not isinstance(value, CourseScheduleApplicationBuilder):
            raise TypeError("Expected CourseScheduleApplicationBuilder instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: CourseScheduleApplicationBuilderProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class GraduationRequirementsApplicationProtocol(typing.Protocol):
    """
    [졸업사정표](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMW8015)
    """

    def requirements(self, ):
        """
        졸업사정 결과와 졸업 필요 요건별 충족 여부와 세부 정보를 반환합니다.
        """

        raise NotImplementedError
    def student_info(self, ):
        """
        학생 정보를 반환합니다.
        """

        raise NotImplementedError
# GraduationRequirementsApplication is a Rust-only trait - it's a wrapper around a Rust implementation.
class GraduationRequirementsApplication():
    """
    [졸업사정표](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMW8015)
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_free_graduationrequirementsapplication, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_clone_graduationrequirementsapplication, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    async def requirements(self, ) -> "GraduationRequirements":
        """
        졸업사정 결과와 졸업 필요 요건별 충족 여부와 세부 정보를 반환합니다.
        """

        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_graduationrequirementsapplication_requirements(
                self._uniffi_clone_pointer(), 
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeGraduationRequirements.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )



    async def student_info(self, ) -> "GraduationStudent":
        """
        학생 정보를 반환합니다.
        """

        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_graduationrequirementsapplication_student_info(
                self._uniffi_clone_pointer(), 
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeGraduationStudent.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )





class _UniffiConverterTypeGraduationRequirementsApplication:

    @staticmethod
    def lift(value: int):
        return GraduationRequirementsApplication._make_instance_(value)

    @staticmethod
    def check_lower(value: GraduationRequirementsApplication):
        if not isinstance(value, GraduationRequirementsApplication):
            raise TypeError("Expected GraduationRequirementsApplication instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: GraduationRequirementsApplicationProtocol):
        if not isinstance(value, GraduationRequirementsApplication):
            raise TypeError("Expected GraduationRequirementsApplication instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: GraduationRequirementsApplicationProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class GraduationRequirementsApplicationBuilderProtocol(typing.Protocol):
    """
    [`GraduationRequirementsApplication`] 생성을 위한 빌더
    """

    def build(self, session: "USaintSession"):
        """
        세션과 함께 [`GraduationRequirementsApplication`]을 만듭니다.
        """

        raise NotImplementedError
# GraduationRequirementsApplicationBuilder is a Rust-only trait - it's a wrapper around a Rust implementation.
class GraduationRequirementsApplicationBuilder():
    """
    [`GraduationRequirementsApplication`] 생성을 위한 빌더
    """

    _pointer: ctypes.c_void_p
    def __init__(self, ):
        """
        새로운 [`GraduationRequirementsApplicationBuilder`]를 만듭니다.
        """

        self._pointer = _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_constructor_graduationrequirementsapplicationbuilder_new,)

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_free_graduationrequirementsapplicationbuilder, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_clone_graduationrequirementsapplicationbuilder, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    async def build(self, session: "USaintSession") -> "GraduationRequirementsApplication":
        """
        세션과 함께 [`GraduationRequirementsApplication`]을 만듭니다.
        """

        _UniffiConverterTypeUSaintSession.check_lower(session)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_graduationrequirementsapplicationbuilder_build(
                self._uniffi_clone_pointer(), 
        _UniffiConverterTypeUSaintSession.lower(session)
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_pointer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_pointer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_pointer,
            # lift function
            _UniffiConverterTypeGraduationRequirementsApplication.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )





class _UniffiConverterTypeGraduationRequirementsApplicationBuilder:

    @staticmethod
    def lift(value: int):
        return GraduationRequirementsApplicationBuilder._make_instance_(value)

    @staticmethod
    def check_lower(value: GraduationRequirementsApplicationBuilder):
        if not isinstance(value, GraduationRequirementsApplicationBuilder):
            raise TypeError("Expected GraduationRequirementsApplicationBuilder instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: GraduationRequirementsApplicationBuilderProtocol):
        if not isinstance(value, GraduationRequirementsApplicationBuilder):
            raise TypeError("Expected GraduationRequirementsApplicationBuilder instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: GraduationRequirementsApplicationBuilderProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class LectureAssessmentApplicationProtocol(typing.Protocol):
    """
    [강의평가조회](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMB2W1010)
    """

    def find_assessments(self, year: "int",semester: "SemesterType",lecture_name: "typing.Union[object, typing.Optional[str]]" = _DEFAULT,lecture_code: "typing.Union[object, typing.Optional[int]]" = _DEFAULT,professor_name: "typing.Union[object, typing.Optional[str]]" = _DEFAULT):
        """
        검색 조건에 맞는 강의평가 정보를 가져옵니다.
        """

        raise NotImplementedError
    def get_selected_semester(self, ):
        """
        현재 페이지에 선택된 년도와 학기를 가져옵니다. 최초 로드 시 현재 학기를 가져올 가능성이 있습니다.
        하지만 이 애플리케이션의 다른 함수를 호출하여 한번 정보를 가져왔다면 마지막으로 가져온 정보의 학기가 반환되므로 주의하여야 하며, 신뢰할 수 있는 현재 학기의 원천으로 사용되어서는 안됩니다.
        """

        raise NotImplementedError
# LectureAssessmentApplication is a Rust-only trait - it's a wrapper around a Rust implementation.
class LectureAssessmentApplication():
    """
    [강의평가조회](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMB2W1010)
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_free_lectureassessmentapplication, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_clone_lectureassessmentapplication, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    async def find_assessments(self, year: "int",semester: "SemesterType",lecture_name: "typing.Union[object, typing.Optional[str]]" = _DEFAULT,lecture_code: "typing.Union[object, typing.Optional[int]]" = _DEFAULT,professor_name: "typing.Union[object, typing.Optional[str]]" = _DEFAULT) -> "typing.List[LectureAssessmentResult]":
        """
        검색 조건에 맞는 강의평가 정보를 가져옵니다.
        """

        _UniffiConverterUInt32.check_lower(year)
        
        _UniffiConverterTypeSemesterType.check_lower(semester)
        
        if lecture_name is _DEFAULT:
            lecture_name = None
        _UniffiConverterOptionalString.check_lower(lecture_name)
        
        if lecture_code is _DEFAULT:
            lecture_code = None
        _UniffiConverterOptionalUInt32.check_lower(lecture_code)
        
        if professor_name is _DEFAULT:
            professor_name = None
        _UniffiConverterOptionalString.check_lower(professor_name)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_lectureassessmentapplication_find_assessments(
                self._uniffi_clone_pointer(), 
        _UniffiConverterUInt32.lower(year),
        _UniffiConverterTypeSemesterType.lower(semester),
        _UniffiConverterOptionalString.lower(lecture_name),
        _UniffiConverterOptionalUInt32.lower(lecture_code),
        _UniffiConverterOptionalString.lower(professor_name)
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterSequenceTypeLectureAssessmentResult.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )



    async def get_selected_semester(self, ) -> "YearSemester":
        """
        현재 페이지에 선택된 년도와 학기를 가져옵니다. 최초 로드 시 현재 학기를 가져올 가능성이 있습니다.
        하지만 이 애플리케이션의 다른 함수를 호출하여 한번 정보를 가져왔다면 마지막으로 가져온 정보의 학기가 반환되므로 주의하여야 하며, 신뢰할 수 있는 현재 학기의 원천으로 사용되어서는 안됩니다.
        """

        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_lectureassessmentapplication_get_selected_semester(
                self._uniffi_clone_pointer(), 
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeYearSemester.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )





class _UniffiConverterTypeLectureAssessmentApplication:

    @staticmethod
    def lift(value: int):
        return LectureAssessmentApplication._make_instance_(value)

    @staticmethod
    def check_lower(value: LectureAssessmentApplication):
        if not isinstance(value, LectureAssessmentApplication):
            raise TypeError("Expected LectureAssessmentApplication instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: LectureAssessmentApplicationProtocol):
        if not isinstance(value, LectureAssessmentApplication):
            raise TypeError("Expected LectureAssessmentApplication instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: LectureAssessmentApplicationProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class LectureAssessmentApplicationBuilderProtocol(typing.Protocol):
    """
    [`LectureAssessmentApplication`] 생성을 위한 빌더
    """

    def build(self, session: "USaintSession"):
        """
        세션과 함께 [`LectureAssessmentApplication`]을 만듭니다.
        """

        raise NotImplementedError
# LectureAssessmentApplicationBuilder is a Rust-only trait - it's a wrapper around a Rust implementation.
class LectureAssessmentApplicationBuilder():
    """
    [`LectureAssessmentApplication`] 생성을 위한 빌더
    """

    _pointer: ctypes.c_void_p
    def __init__(self, ):
        """
        새로운 [`LectureAssessmentApplicationBuilder`]를 만듭니다.
        """

        self._pointer = _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_constructor_lectureassessmentapplicationbuilder_new,)

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_free_lectureassessmentapplicationbuilder, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_clone_lectureassessmentapplicationbuilder, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    async def build(self, session: "USaintSession") -> "LectureAssessmentApplication":
        """
        세션과 함께 [`LectureAssessmentApplication`]을 만듭니다.
        """

        _UniffiConverterTypeUSaintSession.check_lower(session)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_lectureassessmentapplicationbuilder_build(
                self._uniffi_clone_pointer(), 
        _UniffiConverterTypeUSaintSession.lower(session)
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_pointer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_pointer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_pointer,
            # lift function
            _UniffiConverterTypeLectureAssessmentApplication.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )





class _UniffiConverterTypeLectureAssessmentApplicationBuilder:

    @staticmethod
    def lift(value: int):
        return LectureAssessmentApplicationBuilder._make_instance_(value)

    @staticmethod
    def check_lower(value: LectureAssessmentApplicationBuilder):
        if not isinstance(value, LectureAssessmentApplicationBuilder):
            raise TypeError("Expected LectureAssessmentApplicationBuilder instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: LectureAssessmentApplicationBuilderProtocol):
        if not isinstance(value, LectureAssessmentApplicationBuilder):
            raise TypeError("Expected LectureAssessmentApplicationBuilder instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: LectureAssessmentApplicationBuilderProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class PersonalCourseScheduleApplicationProtocol(typing.Protocol):
    """
    [개인수업시간표](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMW2102)
    """

    def get_selected_semester(self, ):
        """
        현재 페이지에 선택된 년도와 학기를 가져옵니다. 최초 로드 시 현재 학기를 가져올 가능성이 있습니다.
        하지만 이 애플리케이션의 다른 함수를 호출하여 한번 정보를 가져왔다면 마지막으로 가져온 정보의 학기가 반환되므로 주의하여야 하며, 신뢰할 수 있는 현재 학기의 원천으로 사용되어서는 안됩니다.
        """

        raise NotImplementedError
    def schedule(self, year: "int",semester: "SemesterType"):
        """
        해당 학기의 시간표 정보를 가져옵니다.
        """

        raise NotImplementedError
# PersonalCourseScheduleApplication is a Rust-only trait - it's a wrapper around a Rust implementation.
class PersonalCourseScheduleApplication():
    """
    [개인수업시간표](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMW2102)
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_free_personalcoursescheduleapplication, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_clone_personalcoursescheduleapplication, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    async def get_selected_semester(self, ) -> "YearSemester":
        """
        현재 페이지에 선택된 년도와 학기를 가져옵니다. 최초 로드 시 현재 학기를 가져올 가능성이 있습니다.
        하지만 이 애플리케이션의 다른 함수를 호출하여 한번 정보를 가져왔다면 마지막으로 가져온 정보의 학기가 반환되므로 주의하여야 하며, 신뢰할 수 있는 현재 학기의 원천으로 사용되어서는 안됩니다.
        """

        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_personalcoursescheduleapplication_get_selected_semester(
                self._uniffi_clone_pointer(), 
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeYearSemester.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )



    async def schedule(self, year: "int",semester: "SemesterType") -> "PersonalCourseSchedule":
        """
        해당 학기의 시간표 정보를 가져옵니다.
        """

        _UniffiConverterUInt32.check_lower(year)
        
        _UniffiConverterTypeSemesterType.check_lower(semester)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_personalcoursescheduleapplication_schedule(
                self._uniffi_clone_pointer(), 
        _UniffiConverterUInt32.lower(year),
        _UniffiConverterTypeSemesterType.lower(semester)
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypePersonalCourseSchedule.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )





class _UniffiConverterTypePersonalCourseScheduleApplication:

    @staticmethod
    def lift(value: int):
        return PersonalCourseScheduleApplication._make_instance_(value)

    @staticmethod
    def check_lower(value: PersonalCourseScheduleApplication):
        if not isinstance(value, PersonalCourseScheduleApplication):
            raise TypeError("Expected PersonalCourseScheduleApplication instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: PersonalCourseScheduleApplicationProtocol):
        if not isinstance(value, PersonalCourseScheduleApplication):
            raise TypeError("Expected PersonalCourseScheduleApplication instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: PersonalCourseScheduleApplicationProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class PersonalCourseScheduleApplicationBuilderProtocol(typing.Protocol):
    """
    [`PersonalCourseScheduleApplication`] 생성을 위한 빌더
    """

    def build(self, session: "USaintSession"):
        """
        세션과 함께 [`PersonalCourseScheduleApplication`]을 만듭니다.
        """

        raise NotImplementedError
# PersonalCourseScheduleApplicationBuilder is a Rust-only trait - it's a wrapper around a Rust implementation.
class PersonalCourseScheduleApplicationBuilder():
    """
    [`PersonalCourseScheduleApplication`] 생성을 위한 빌더
    """

    _pointer: ctypes.c_void_p
    def __init__(self, ):
        """
        새로운 [`PersonalCourseScheduleApplicationBuilder`]를 만듭니다.
        """

        self._pointer = _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_constructor_personalcoursescheduleapplicationbuilder_new,)

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_free_personalcoursescheduleapplicationbuilder, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_clone_personalcoursescheduleapplicationbuilder, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    async def build(self, session: "USaintSession") -> "PersonalCourseScheduleApplication":
        """
        세션과 함께 [`PersonalCourseScheduleApplication`]을 만듭니다.
        """

        _UniffiConverterTypeUSaintSession.check_lower(session)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_personalcoursescheduleapplicationbuilder_build(
                self._uniffi_clone_pointer(), 
        _UniffiConverterTypeUSaintSession.lower(session)
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_pointer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_pointer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_pointer,
            # lift function
            _UniffiConverterTypePersonalCourseScheduleApplication.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )





class _UniffiConverterTypePersonalCourseScheduleApplicationBuilder:

    @staticmethod
    def lift(value: int):
        return PersonalCourseScheduleApplicationBuilder._make_instance_(value)

    @staticmethod
    def check_lower(value: PersonalCourseScheduleApplicationBuilder):
        if not isinstance(value, PersonalCourseScheduleApplicationBuilder):
            raise TypeError("Expected PersonalCourseScheduleApplicationBuilder instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: PersonalCourseScheduleApplicationBuilderProtocol):
        if not isinstance(value, PersonalCourseScheduleApplicationBuilder):
            raise TypeError("Expected PersonalCourseScheduleApplicationBuilder instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: PersonalCourseScheduleApplicationBuilderProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class ScholarshipsApplicationProtocol(typing.Protocol):
    """
    [장학금수혜내역조회](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMW7530n)
    """

    def scholarships(self, ):
        """
        장학금 수혜 내역을 가져옵니다.
        """

        raise NotImplementedError
# ScholarshipsApplication is a Rust-only trait - it's a wrapper around a Rust implementation.
class ScholarshipsApplication():
    """
    [장학금수혜내역조회](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMW7530n)
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_free_scholarshipsapplication, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_clone_scholarshipsapplication, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    async def scholarships(self, ) -> "typing.List[Scholarship]":
        """
        장학금 수혜 내역을 가져옵니다.
        """

        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_scholarshipsapplication_scholarships(
                self._uniffi_clone_pointer(), 
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterSequenceTypeScholarship.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )





class _UniffiConverterTypeScholarshipsApplication:

    @staticmethod
    def lift(value: int):
        return ScholarshipsApplication._make_instance_(value)

    @staticmethod
    def check_lower(value: ScholarshipsApplication):
        if not isinstance(value, ScholarshipsApplication):
            raise TypeError("Expected ScholarshipsApplication instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: ScholarshipsApplicationProtocol):
        if not isinstance(value, ScholarshipsApplication):
            raise TypeError("Expected ScholarshipsApplication instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: ScholarshipsApplicationProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class ScholarshipsApplicationBuilderProtocol(typing.Protocol):
    """
    [`ScholarshipsApplication`] 생성을 위한 빌더
    """

    def build(self, session: "USaintSession"):
        """
        세션과 함께 [`ScholarshipsApplication`]을 만듭니다.
        """

        raise NotImplementedError
# ScholarshipsApplicationBuilder is a Rust-only trait - it's a wrapper around a Rust implementation.
class ScholarshipsApplicationBuilder():
    """
    [`ScholarshipsApplication`] 생성을 위한 빌더
    """

    _pointer: ctypes.c_void_p
    def __init__(self, ):
        """
        새로운 [`ScholarshipsApplicationBuilder`]를 만듭니다.
        """

        self._pointer = _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_constructor_scholarshipsapplicationbuilder_new,)

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_free_scholarshipsapplicationbuilder, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_clone_scholarshipsapplicationbuilder, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    async def build(self, session: "USaintSession") -> "ScholarshipsApplication":
        """
        세션과 함께 [`ScholarshipsApplication`]을 만듭니다.
        """

        _UniffiConverterTypeUSaintSession.check_lower(session)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_scholarshipsapplicationbuilder_build(
                self._uniffi_clone_pointer(), 
        _UniffiConverterTypeUSaintSession.lower(session)
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_pointer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_pointer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_pointer,
            # lift function
            _UniffiConverterTypeScholarshipsApplication.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )





class _UniffiConverterTypeScholarshipsApplicationBuilder:

    @staticmethod
    def lift(value: int):
        return ScholarshipsApplicationBuilder._make_instance_(value)

    @staticmethod
    def check_lower(value: ScholarshipsApplicationBuilder):
        if not isinstance(value, ScholarshipsApplicationBuilder):
            raise TypeError("Expected ScholarshipsApplicationBuilder instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: ScholarshipsApplicationBuilderProtocol):
        if not isinstance(value, ScholarshipsApplicationBuilder):
            raise TypeError("Expected ScholarshipsApplicationBuilder instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: ScholarshipsApplicationBuilderProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class StudentInformationApplicationProtocol(typing.Protocol):
    """
    [학생 정보 수정 및 조회](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMW1001n)
    """

    def academic_record(self, ):
        """
        학생의 학적상태 정보를 반환합니다.
        """

        raise NotImplementedError
    def bank_account(self, ):
        """
        학생의 은행계좌 정보를 반환합니다.
        """

        raise NotImplementedError
    def family(self, ):
        """
        학생의 가족관계 정보를 반환합니다.
        """

        raise NotImplementedError
    def general(self, ):
        """
        일반 학생 정보를 반환합니다.
        """

        raise NotImplementedError
    def graduation(self, ):
        """
        학생의 졸업과 관련된 정보를 반환합니다.
        """

        raise NotImplementedError
    def qualifications(self, ):
        """
        학생의 교직, 평생교육사, 7+1 프로그램 등 자격 관련 정보를 반환합니다.
        """

        raise NotImplementedError
    def religion(self, ):
        """
        학생의 종교 정보를 반환합니다.
        """

        raise NotImplementedError
    def research_bank_account(self, ):
        """
        학생의 연구비 입금 계좌를 반환합니다.
        """

        raise NotImplementedError
    def transfer(self, ):
        """
        학생의 편입정보를 반환합니다.
        """

        raise NotImplementedError
    def work(self, ):
        """
        학생의 직장 정보를 반환합니다.
        """

        raise NotImplementedError
# StudentInformationApplication is a Rust-only trait - it's a wrapper around a Rust implementation.
class StudentInformationApplication():
    """
    [학생 정보 수정 및 조회](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMW1001n)
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_free_studentinformationapplication, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_clone_studentinformationapplication, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    async def academic_record(self, ) -> "StudentAcademicRecords":
        """
        학생의 학적상태 정보를 반환합니다.
        """

        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplication_academic_record(
                self._uniffi_clone_pointer(), 
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeStudentAcademicRecords.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )



    async def bank_account(self, ) -> "StudentBankAccount":
        """
        학생의 은행계좌 정보를 반환합니다.
        """

        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplication_bank_account(
                self._uniffi_clone_pointer(), 
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeStudentBankAccount.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )



    async def family(self, ) -> "StudentFamily":
        """
        학생의 가족관계 정보를 반환합니다.
        """

        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplication_family(
                self._uniffi_clone_pointer(), 
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeStudentFamily.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )



    async def general(self, ) -> "StudentInformation":
        """
        일반 학생 정보를 반환합니다.
        """

        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplication_general(
                self._uniffi_clone_pointer(), 
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeStudentInformation.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )



    async def graduation(self, ) -> "StudentGraduation":
        """
        학생의 졸업과 관련된 정보를 반환합니다.
        """

        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplication_graduation(
                self._uniffi_clone_pointer(), 
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeStudentGraduation.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )



    async def qualifications(self, ) -> "StudentQualification":
        """
        학생의 교직, 평생교육사, 7+1 프로그램 등 자격 관련 정보를 반환합니다.
        """

        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplication_qualifications(
                self._uniffi_clone_pointer(), 
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeStudentQualification.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )



    async def religion(self, ) -> "StudentReligion":
        """
        학생의 종교 정보를 반환합니다.
        """

        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplication_religion(
                self._uniffi_clone_pointer(), 
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeStudentReligion.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )



    async def research_bank_account(self, ) -> "StudentResearchBankAccount":
        """
        학생의 연구비 입금 계좌를 반환합니다.
        """

        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplication_research_bank_account(
                self._uniffi_clone_pointer(), 
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeStudentResearchBankAccount.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )



    async def transfer(self, ) -> "StudentTransferRecords":
        """
        학생의 편입정보를 반환합니다.
        """

        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplication_transfer(
                self._uniffi_clone_pointer(), 
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeStudentTransferRecords.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )



    async def work(self, ) -> "StudentWorkInformation":
        """
        학생의 직장 정보를 반환합니다.
        """

        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplication_work(
                self._uniffi_clone_pointer(), 
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeStudentWorkInformation.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )





class _UniffiConverterTypeStudentInformationApplication:

    @staticmethod
    def lift(value: int):
        return StudentInformationApplication._make_instance_(value)

    @staticmethod
    def check_lower(value: StudentInformationApplication):
        if not isinstance(value, StudentInformationApplication):
            raise TypeError("Expected StudentInformationApplication instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: StudentInformationApplicationProtocol):
        if not isinstance(value, StudentInformationApplication):
            raise TypeError("Expected StudentInformationApplication instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: StudentInformationApplicationProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class StudentInformationApplicationBuilderProtocol(typing.Protocol):
    """
    [`StudentInformationApplication`] 생성을 위한 빌더
    """

    def build(self, session: "USaintSession"):
        """
        세션과 함께 [`StudentInformationApplication`]을 만듭니다.
        """

        raise NotImplementedError
# StudentInformationApplicationBuilder is a Rust-only trait - it's a wrapper around a Rust implementation.
class StudentInformationApplicationBuilder():
    """
    [`StudentInformationApplication`] 생성을 위한 빌더
    """

    _pointer: ctypes.c_void_p
    def __init__(self, ):
        """
        새로운 [`StudentInformationApplicationBuilder`]를 만듭니다.
        """

        self._pointer = _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_constructor_studentinformationapplicationbuilder_new,)

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_free_studentinformationapplicationbuilder, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_clone_studentinformationapplicationbuilder, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    async def build(self, session: "USaintSession") -> "StudentInformationApplication":
        """
        세션과 함께 [`StudentInformationApplication`]을 만듭니다.
        """

        _UniffiConverterTypeUSaintSession.check_lower(session)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_studentinformationapplicationbuilder_build(
                self._uniffi_clone_pointer(), 
        _UniffiConverterTypeUSaintSession.lower(session)
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_pointer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_pointer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_pointer,
            # lift function
            _UniffiConverterTypeStudentInformationApplication.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )





class _UniffiConverterTypeStudentInformationApplicationBuilder:

    @staticmethod
    def lift(value: int):
        return StudentInformationApplicationBuilder._make_instance_(value)

    @staticmethod
    def check_lower(value: StudentInformationApplicationBuilder):
        if not isinstance(value, StudentInformationApplicationBuilder):
            raise TypeError("Expected StudentInformationApplicationBuilder instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: StudentInformationApplicationBuilderProtocol):
        if not isinstance(value, StudentInformationApplicationBuilder):
            raise TypeError("Expected StudentInformationApplicationBuilder instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: StudentInformationApplicationBuilderProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class USaintSessionProtocol(typing.Protocol):
    """
    u-saint에서 사용할 세션
    [`USaintSessionBuilder`]를 이용해 생성합니다.
    """

    pass
# USaintSession is a Rust-only trait - it's a wrapper around a Rust implementation.
class USaintSession():
    """
    u-saint에서 사용할 세션
    [`USaintSessionBuilder`]를 이용해 생성합니다.
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_free_usaintsession, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_clone_usaintsession, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst



class _UniffiConverterTypeUSaintSession:

    @staticmethod
    def lift(value: int):
        return USaintSession._make_instance_(value)

    @staticmethod
    def check_lower(value: USaintSession):
        if not isinstance(value, USaintSession):
            raise TypeError("Expected USaintSession instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: USaintSessionProtocol):
        if not isinstance(value, USaintSession):
            raise TypeError("Expected USaintSession instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: USaintSessionProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class USaintSessionBuilderProtocol(typing.Protocol):
    """
    [`USaintSession`]을 생성하기 위한 빌더
    """

    def anonymous(self, ):
        """
        익명 세션(비로그인)을 만듭니다.
        ## Kotlin
        ```kotlin
        fun createAnonymousSession() {
        val anonymous = USaintSessionBuilder().anonymous()
        }
        ```
        """

        raise NotImplementedError
    def with_password(self, id: "str",password: "str"):
        """
        ID, 비밀번호로 세션을 만듭니다.
        ## Kotlin
        ```kotlin
        suspend fun createSessionWithPassword() {
        val withPassword = USaintSessionBuilder().withPassword("20211561", "password") // suspend
        }
        """

        raise NotImplementedError
    def with_token(self, id: "str",token: "str"):
        """
        SSO 토큰으로 세션을 만듭니다.
        ## Kotlin
        ```kotlin
        suspend fun createSessionWithSsoToken() {
        val withToken = USaintSessionBuilder().withToken("<example sso token>") // suspend
        }
        """

        raise NotImplementedError
# USaintSessionBuilder is a Rust-only trait - it's a wrapper around a Rust implementation.
class USaintSessionBuilder():
    """
    [`USaintSession`]을 생성하기 위한 빌더
    """

    _pointer: ctypes.c_void_p
    def __init__(self, ):
        """
        새로운 [`USaintSessionBuilder`]를 만듭니다.
        """

        self._pointer = _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_constructor_usaintsessionbuilder_new,)

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_free_usaintsessionbuilder, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_clone_usaintsessionbuilder, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def anonymous(self, ) -> "USaintSession":
        """
        익명 세션(비로그인)을 만듭니다.
        ## Kotlin
        ```kotlin
        fun createAnonymousSession() {
        val anonymous = USaintSessionBuilder().anonymous()
        }
        ```
        """

        return _UniffiConverterTypeUSaintSession.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_ffi_fn_method_usaintsessionbuilder_anonymous,self._uniffi_clone_pointer(),)
        )




    async def with_password(self, id: "str",password: "str") -> "USaintSession":
        """
        ID, 비밀번호로 세션을 만듭니다.
        ## Kotlin
        ```kotlin
        suspend fun createSessionWithPassword() {
        val withPassword = USaintSessionBuilder().withPassword("20211561", "password") // suspend
        }
        """

        _UniffiConverterString.check_lower(id)
        
        _UniffiConverterString.check_lower(password)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_usaintsessionbuilder_with_password(
                self._uniffi_clone_pointer(), 
        _UniffiConverterString.lower(id),
        _UniffiConverterString.lower(password)
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_pointer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_pointer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_pointer,
            # lift function
            _UniffiConverterTypeUSaintSession.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )



    async def with_token(self, id: "str",token: "str") -> "USaintSession":
        """
        SSO 토큰으로 세션을 만듭니다.
        ## Kotlin
        ```kotlin
        suspend fun createSessionWithSsoToken() {
        val withToken = USaintSessionBuilder().withToken("<example sso token>") // suspend
        }
        """

        _UniffiConverterString.check_lower(id)
        
        _UniffiConverterString.check_lower(token)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_rusaint_ffi_fn_method_usaintsessionbuilder_with_token(
                self._uniffi_clone_pointer(), 
        _UniffiConverterString.lower(id),
        _UniffiConverterString.lower(token)
            ),
            _UniffiLib.ffi_rusaint_ffi_rust_future_poll_pointer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_complete_pointer,
            _UniffiLib.ffi_rusaint_ffi_rust_future_free_pointer,
            # lift function
            _UniffiConverterTypeUSaintSession.lift,
            
    # Error FFI converter
_UniffiConverterTypeRusaintError,

        )





class _UniffiConverterTypeUSaintSessionBuilder:

    @staticmethod
    def lift(value: int):
        return USaintSessionBuilder._make_instance_(value)

    @staticmethod
    def check_lower(value: USaintSessionBuilder):
        if not isinstance(value, USaintSessionBuilder):
            raise TypeError("Expected USaintSessionBuilder instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: USaintSessionBuilderProtocol):
        if not isinstance(value, USaintSessionBuilder):
            raise TypeError("Expected USaintSessionBuilder instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: USaintSessionBuilderProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))

# External type ChapelInformation: `from .rusaint import ChapelInformation`

# External type ClassGrade: `from .rusaint import ClassGrade`

# External type GradeSummary: `from .rusaint import GradeSummary`

# External type GraduationRequirements: `from .rusaint import GraduationRequirements`

# External type GraduationStudent: `from .rusaint import GraduationStudent`

# External type Lecture: `from .rusaint import Lecture`

# External type LectureAssessmentResult: `from .rusaint import LectureAssessmentResult`

# External type PersonalCourseSchedule: `from .rusaint import PersonalCourseSchedule`

# External type Scholarship: `from .rusaint import Scholarship`

# External type SemesterGrade: `from .rusaint import SemesterGrade`

# External type StudentAcademicRecords: `from .rusaint import StudentAcademicRecords`

# External type StudentBankAccount: `from .rusaint import StudentBankAccount`

# External type StudentFamily: `from .rusaint import StudentFamily`

# External type StudentGraduation: `from .rusaint import StudentGraduation`

# External type StudentInformation: `from .rusaint import StudentInformation`

# External type StudentQualification: `from .rusaint import StudentQualification`

# External type StudentReligion: `from .rusaint import StudentReligion`

# External type StudentResearchBankAccount: `from .rusaint import StudentResearchBankAccount`

# External type StudentTransferRecords: `from .rusaint import StudentTransferRecords`

# External type StudentWorkInformation: `from .rusaint import StudentWorkInformation`

# External type CourseType: `from .rusaint import CourseType`

# External type LectureCategory: `from .rusaint import LectureCategory`

# External type SemesterType: `from .rusaint import SemesterType`

# Async support# RustFuturePoll values
_UNIFFI_RUST_FUTURE_POLL_READY = 0
_UNIFFI_RUST_FUTURE_POLL_MAYBE_READY = 1

# Stores futures for _uniffi_continuation_callback
_UniffiContinuationHandleMap = _UniffiHandleMap()

_UNIFFI_GLOBAL_EVENT_LOOP = None

"""
Set the event loop to use for async functions

This is needed if some async functions run outside of the eventloop, for example:
    - A non-eventloop thread is spawned, maybe from `EventLoop.run_in_executor` or maybe from the
      Rust code spawning its own thread.
    - The Rust code calls an async callback method from a sync callback function, using something
      like `pollster` to block on the async call.

In this case, we need an event loop to run the Python async function, but there's no eventloop set
for the thread.  Use `uniffi_set_event_loop` to force an eventloop to be used in this case.
"""
def uniffi_set_event_loop(eventloop: asyncio.BaseEventLoop):
    global _UNIFFI_GLOBAL_EVENT_LOOP
    _UNIFFI_GLOBAL_EVENT_LOOP = eventloop

def _uniffi_get_event_loop():
    if _UNIFFI_GLOBAL_EVENT_LOOP is not None:
        return _UNIFFI_GLOBAL_EVENT_LOOP
    else:
        return asyncio.get_running_loop()

# Continuation callback for async functions
# lift the return value or error and resolve the future, causing the async function to resume.
@_UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK
def _uniffi_continuation_callback(future_ptr, poll_code):
    (eventloop, future) = _UniffiContinuationHandleMap.remove(future_ptr)
    eventloop.call_soon_threadsafe(_uniffi_set_future_result, future, poll_code)

def _uniffi_set_future_result(future, poll_code):
    if not future.cancelled():
        future.set_result(poll_code)

async def _uniffi_rust_call_async(rust_future, ffi_poll, ffi_complete, ffi_free, lift_func, error_ffi_converter):
    try:
        eventloop = _uniffi_get_event_loop()

        # Loop and poll until we see a _UNIFFI_RUST_FUTURE_POLL_READY value
        while True:
            future = eventloop.create_future()
            ffi_poll(
                rust_future,
                _uniffi_continuation_callback,
                _UniffiContinuationHandleMap.insert((eventloop, future)),
            )
            poll_code = await future
            if poll_code == _UNIFFI_RUST_FUTURE_POLL_READY:
                break

        return lift_func(
            _uniffi_rust_call_with_error(error_ffi_converter, ffi_complete, rust_future)
        )
    finally:
        ffi_free(rust_future)

__all__ = [
    "InternalError",
    "RusaintError",
    "YearSemester",
    "ChapelApplication",
    "ChapelApplicationBuilder",
    "CourseGradesApplication",
    "CourseGradesApplicationBuilder",
    "CourseScheduleApplication",
    "CourseScheduleApplicationBuilder",
    "GraduationRequirementsApplication",
    "GraduationRequirementsApplicationBuilder",
    "LectureAssessmentApplication",
    "LectureAssessmentApplicationBuilder",
    "PersonalCourseScheduleApplication",
    "PersonalCourseScheduleApplicationBuilder",
    "ScholarshipsApplication",
    "ScholarshipsApplicationBuilder",
    "StudentInformationApplication",
    "StudentInformationApplicationBuilder",
    "USaintSession",
    "USaintSessionBuilder",
]

