# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagementInterfaceArgs', 'ManagementInterface']

@pulumi.input_type
class ManagementInterfaceArgs:
    def __init__(__self__, *,
                 serial: pulumi.Input[_builtins.str],
                 wan1: Optional[pulumi.Input['ManagementInterfaceWan1Args']] = None,
                 wan2: Optional[pulumi.Input['ManagementInterfaceWan2Args']] = None):
        """
        The set of arguments for constructing a ManagementInterface resource.
        :param pulumi.Input[_builtins.str] serial: serial path parameter.
        :param pulumi.Input['ManagementInterfaceWan1Args'] wan1: WAN 1 settings
        :param pulumi.Input['ManagementInterfaceWan2Args'] wan2: WAN 2 settings (only for MX devices)
        """
        pulumi.set(__self__, "serial", serial)
        if wan1 is not None:
            pulumi.set(__self__, "wan1", wan1)
        if wan2 is not None:
            pulumi.set(__self__, "wan2", wan2)

    @_builtins.property
    @pulumi.getter
    def serial(self) -> pulumi.Input[_builtins.str]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "serial", value)

    @_builtins.property
    @pulumi.getter
    def wan1(self) -> Optional[pulumi.Input['ManagementInterfaceWan1Args']]:
        """
        WAN 1 settings
        """
        return pulumi.get(self, "wan1")

    @wan1.setter
    def wan1(self, value: Optional[pulumi.Input['ManagementInterfaceWan1Args']]):
        pulumi.set(self, "wan1", value)

    @_builtins.property
    @pulumi.getter
    def wan2(self) -> Optional[pulumi.Input['ManagementInterfaceWan2Args']]:
        """
        WAN 2 settings (only for MX devices)
        """
        return pulumi.get(self, "wan2")

    @wan2.setter
    def wan2(self, value: Optional[pulumi.Input['ManagementInterfaceWan2Args']]):
        pulumi.set(self, "wan2", value)


@pulumi.input_type
class _ManagementInterfaceState:
    def __init__(__self__, *,
                 ddns_hostnames: Optional[pulumi.Input['ManagementInterfaceDdnsHostnamesArgs']] = None,
                 serial: Optional[pulumi.Input[_builtins.str]] = None,
                 wan1: Optional[pulumi.Input['ManagementInterfaceWan1Args']] = None,
                 wan2: Optional[pulumi.Input['ManagementInterfaceWan2Args']] = None):
        """
        Input properties used for looking up and filtering ManagementInterface resources.
        :param pulumi.Input['ManagementInterfaceDdnsHostnamesArgs'] ddns_hostnames: Dynamic DNS hostnames.
        :param pulumi.Input[_builtins.str] serial: serial path parameter.
        :param pulumi.Input['ManagementInterfaceWan1Args'] wan1: WAN 1 settings
        :param pulumi.Input['ManagementInterfaceWan2Args'] wan2: WAN 2 settings (only for MX devices)
        """
        if ddns_hostnames is not None:
            pulumi.set(__self__, "ddns_hostnames", ddns_hostnames)
        if serial is not None:
            pulumi.set(__self__, "serial", serial)
        if wan1 is not None:
            pulumi.set(__self__, "wan1", wan1)
        if wan2 is not None:
            pulumi.set(__self__, "wan2", wan2)

    @_builtins.property
    @pulumi.getter(name="ddnsHostnames")
    def ddns_hostnames(self) -> Optional[pulumi.Input['ManagementInterfaceDdnsHostnamesArgs']]:
        """
        Dynamic DNS hostnames.
        """
        return pulumi.get(self, "ddns_hostnames")

    @ddns_hostnames.setter
    def ddns_hostnames(self, value: Optional[pulumi.Input['ManagementInterfaceDdnsHostnamesArgs']]):
        pulumi.set(self, "ddns_hostnames", value)

    @_builtins.property
    @pulumi.getter
    def serial(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "serial", value)

    @_builtins.property
    @pulumi.getter
    def wan1(self) -> Optional[pulumi.Input['ManagementInterfaceWan1Args']]:
        """
        WAN 1 settings
        """
        return pulumi.get(self, "wan1")

    @wan1.setter
    def wan1(self, value: Optional[pulumi.Input['ManagementInterfaceWan1Args']]):
        pulumi.set(self, "wan1", value)

    @_builtins.property
    @pulumi.getter
    def wan2(self) -> Optional[pulumi.Input['ManagementInterfaceWan2Args']]:
        """
        WAN 2 settings (only for MX devices)
        """
        return pulumi.get(self, "wan2")

    @wan2.setter
    def wan2(self, value: Optional[pulumi.Input['ManagementInterfaceWan2Args']]):
        pulumi.set(self, "wan2", value)


@pulumi.type_token("meraki:devices/managementInterface:ManagementInterface")
class ManagementInterface(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 serial: Optional[pulumi.Input[_builtins.str]] = None,
                 wan1: Optional[pulumi.Input[Union['ManagementInterfaceWan1Args', 'ManagementInterfaceWan1ArgsDict']]] = None,
                 wan2: Optional[pulumi.Input[Union['ManagementInterfaceWan2Args', 'ManagementInterfaceWan2ArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:devices/managementInterface:ManagementInterface example "serial"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] serial: serial path parameter.
        :param pulumi.Input[Union['ManagementInterfaceWan1Args', 'ManagementInterfaceWan1ArgsDict']] wan1: WAN 1 settings
        :param pulumi.Input[Union['ManagementInterfaceWan2Args', 'ManagementInterfaceWan2ArgsDict']] wan2: WAN 2 settings (only for MX devices)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagementInterfaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:devices/managementInterface:ManagementInterface example "serial"
        ```

        :param str resource_name: The name of the resource.
        :param ManagementInterfaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagementInterfaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 serial: Optional[pulumi.Input[_builtins.str]] = None,
                 wan1: Optional[pulumi.Input[Union['ManagementInterfaceWan1Args', 'ManagementInterfaceWan1ArgsDict']]] = None,
                 wan2: Optional[pulumi.Input[Union['ManagementInterfaceWan2Args', 'ManagementInterfaceWan2ArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagementInterfaceArgs.__new__(ManagementInterfaceArgs)

            if serial is None and not opts.urn:
                raise TypeError("Missing required property 'serial'")
            __props__.__dict__["serial"] = serial
            __props__.__dict__["wan1"] = wan1
            __props__.__dict__["wan2"] = wan2
            __props__.__dict__["ddns_hostnames"] = None
        super(ManagementInterface, __self__).__init__(
            'meraki:devices/managementInterface:ManagementInterface',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ddns_hostnames: Optional[pulumi.Input[Union['ManagementInterfaceDdnsHostnamesArgs', 'ManagementInterfaceDdnsHostnamesArgsDict']]] = None,
            serial: Optional[pulumi.Input[_builtins.str]] = None,
            wan1: Optional[pulumi.Input[Union['ManagementInterfaceWan1Args', 'ManagementInterfaceWan1ArgsDict']]] = None,
            wan2: Optional[pulumi.Input[Union['ManagementInterfaceWan2Args', 'ManagementInterfaceWan2ArgsDict']]] = None) -> 'ManagementInterface':
        """
        Get an existing ManagementInterface resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ManagementInterfaceDdnsHostnamesArgs', 'ManagementInterfaceDdnsHostnamesArgsDict']] ddns_hostnames: Dynamic DNS hostnames.
        :param pulumi.Input[_builtins.str] serial: serial path parameter.
        :param pulumi.Input[Union['ManagementInterfaceWan1Args', 'ManagementInterfaceWan1ArgsDict']] wan1: WAN 1 settings
        :param pulumi.Input[Union['ManagementInterfaceWan2Args', 'ManagementInterfaceWan2ArgsDict']] wan2: WAN 2 settings (only for MX devices)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagementInterfaceState.__new__(_ManagementInterfaceState)

        __props__.__dict__["ddns_hostnames"] = ddns_hostnames
        __props__.__dict__["serial"] = serial
        __props__.__dict__["wan1"] = wan1
        __props__.__dict__["wan2"] = wan2
        return ManagementInterface(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="ddnsHostnames")
    def ddns_hostnames(self) -> pulumi.Output['outputs.ManagementInterfaceDdnsHostnames']:
        """
        Dynamic DNS hostnames.
        """
        return pulumi.get(self, "ddns_hostnames")

    @_builtins.property
    @pulumi.getter
    def serial(self) -> pulumi.Output[_builtins.str]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @_builtins.property
    @pulumi.getter
    def wan1(self) -> pulumi.Output['outputs.ManagementInterfaceWan1']:
        """
        WAN 1 settings
        """
        return pulumi.get(self, "wan1")

    @_builtins.property
    @pulumi.getter
    def wan2(self) -> pulumi.Output['outputs.ManagementInterfaceWan2']:
        """
        WAN 2 settings (only for MX devices)
        """
        return pulumi.get(self, "wan2")

