# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SwitchWarmSpareArgs', 'SwitchWarmSpare']

@pulumi.input_type
class SwitchWarmSpareArgs:
    def __init__(__self__, *,
                 serial: pulumi.Input[_builtins.str],
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 spare_serial: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SwitchWarmSpare resource.
        :param pulumi.Input[_builtins.str] serial: serial path parameter.
        :param pulumi.Input[_builtins.bool] enabled: Enable or disable warm spare for a switch
        :param pulumi.Input[_builtins.str] spare_serial: Serial number of the warm spare switch
        """
        pulumi.set(__self__, "serial", serial)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if spare_serial is not None:
            pulumi.set(__self__, "spare_serial", spare_serial)

    @_builtins.property
    @pulumi.getter
    def serial(self) -> pulumi.Input[_builtins.str]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "serial", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable or disable warm spare for a switch
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="spareSerial")
    def spare_serial(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Serial number of the warm spare switch
        """
        return pulumi.get(self, "spare_serial")

    @spare_serial.setter
    def spare_serial(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spare_serial", value)


@pulumi.input_type
class _SwitchWarmSpareState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 primary_serial: Optional[pulumi.Input[_builtins.str]] = None,
                 serial: Optional[pulumi.Input[_builtins.str]] = None,
                 spare_serial: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SwitchWarmSpare resources.
        :param pulumi.Input[_builtins.bool] enabled: Enable or disable warm spare for a switch
        :param pulumi.Input[_builtins.str] primary_serial: Serial number of the primary switch
        :param pulumi.Input[_builtins.str] serial: serial path parameter.
        :param pulumi.Input[_builtins.str] spare_serial: Serial number of the warm spare switch
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if primary_serial is not None:
            pulumi.set(__self__, "primary_serial", primary_serial)
        if serial is not None:
            pulumi.set(__self__, "serial", serial)
        if spare_serial is not None:
            pulumi.set(__self__, "spare_serial", spare_serial)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable or disable warm spare for a switch
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="primarySerial")
    def primary_serial(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Serial number of the primary switch
        """
        return pulumi.get(self, "primary_serial")

    @primary_serial.setter
    def primary_serial(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_serial", value)

    @_builtins.property
    @pulumi.getter
    def serial(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "serial", value)

    @_builtins.property
    @pulumi.getter(name="spareSerial")
    def spare_serial(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Serial number of the warm spare switch
        """
        return pulumi.get(self, "spare_serial")

    @spare_serial.setter
    def spare_serial(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spare_serial", value)


@pulumi.type_token("meraki:devices/switchWarmSpare:SwitchWarmSpare")
class SwitchWarmSpare(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 serial: Optional[pulumi.Input[_builtins.str]] = None,
                 spare_serial: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.devices.SwitchWarmSpare("example",
            enabled=True,
            serial="string",
            spare_serial="Q234-ABCD-0002")
        pulumi.export("merakiDevicesSwitchWarmSpareExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:devices/switchWarmSpare:SwitchWarmSpare example "serial"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Enable or disable warm spare for a switch
        :param pulumi.Input[_builtins.str] serial: serial path parameter.
        :param pulumi.Input[_builtins.str] spare_serial: Serial number of the warm spare switch
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SwitchWarmSpareArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.devices.SwitchWarmSpare("example",
            enabled=True,
            serial="string",
            spare_serial="Q234-ABCD-0002")
        pulumi.export("merakiDevicesSwitchWarmSpareExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:devices/switchWarmSpare:SwitchWarmSpare example "serial"
        ```

        :param str resource_name: The name of the resource.
        :param SwitchWarmSpareArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SwitchWarmSpareArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 serial: Optional[pulumi.Input[_builtins.str]] = None,
                 spare_serial: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SwitchWarmSpareArgs.__new__(SwitchWarmSpareArgs)

            __props__.__dict__["enabled"] = enabled
            if serial is None and not opts.urn:
                raise TypeError("Missing required property 'serial'")
            __props__.__dict__["serial"] = serial
            __props__.__dict__["spare_serial"] = spare_serial
            __props__.__dict__["primary_serial"] = None
        super(SwitchWarmSpare, __self__).__init__(
            'meraki:devices/switchWarmSpare:SwitchWarmSpare',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            primary_serial: Optional[pulumi.Input[_builtins.str]] = None,
            serial: Optional[pulumi.Input[_builtins.str]] = None,
            spare_serial: Optional[pulumi.Input[_builtins.str]] = None) -> 'SwitchWarmSpare':
        """
        Get an existing SwitchWarmSpare resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Enable or disable warm spare for a switch
        :param pulumi.Input[_builtins.str] primary_serial: Serial number of the primary switch
        :param pulumi.Input[_builtins.str] serial: serial path parameter.
        :param pulumi.Input[_builtins.str] spare_serial: Serial number of the warm spare switch
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SwitchWarmSpareState.__new__(_SwitchWarmSpareState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["primary_serial"] = primary_serial
        __props__.__dict__["serial"] = serial
        __props__.__dict__["spare_serial"] = spare_serial
        return SwitchWarmSpare(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable or disable warm spare for a switch
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="primarySerial")
    def primary_serial(self) -> pulumi.Output[_builtins.str]:
        """
        Serial number of the primary switch
        """
        return pulumi.get(self, "primary_serial")

    @_builtins.property
    @pulumi.getter
    def serial(self) -> pulumi.Output[_builtins.str]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @_builtins.property
    @pulumi.getter(name="spareSerial")
    def spare_serial(self) -> pulumi.Output[_builtins.str]:
        """
        Serial number of the warm spare switch
        """
        return pulumi.get(self, "spare_serial")

