# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplianceRfProfilesArgs', 'ApplianceRfProfiles']

@pulumi.input_type
class ApplianceRfProfilesArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[_builtins.str],
                 five_ghz_settings: Optional[pulumi.Input['ApplianceRfProfilesFiveGhzSettingsArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 per_ssid_settings: Optional[pulumi.Input['ApplianceRfProfilesPerSsidSettingsArgs']] = None,
                 rf_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 two_four_ghz_settings: Optional[pulumi.Input['ApplianceRfProfilesTwoFourGhzSettingsArgs']] = None):
        """
        The set of arguments for constructing a ApplianceRfProfiles resource.
        :param pulumi.Input[_builtins.str] network_id: ID of network this RF Profile belongs in.
        :param pulumi.Input['ApplianceRfProfilesFiveGhzSettingsArgs'] five_ghz_settings: Settings related to 5Ghz band.
        :param pulumi.Input[_builtins.str] name: The name of the profile.
        :param pulumi.Input['ApplianceRfProfilesPerSsidSettingsArgs'] per_ssid_settings: Per-SSID radio settings by number.
        :param pulumi.Input[_builtins.str] rf_profile_id: rfProfileId path parameter. Rf profile ID
        :param pulumi.Input['ApplianceRfProfilesTwoFourGhzSettingsArgs'] two_four_ghz_settings: Settings related to 2.4Ghz band.
        """
        pulumi.set(__self__, "network_id", network_id)
        if five_ghz_settings is not None:
            pulumi.set(__self__, "five_ghz_settings", five_ghz_settings)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if per_ssid_settings is not None:
            pulumi.set(__self__, "per_ssid_settings", per_ssid_settings)
        if rf_profile_id is not None:
            pulumi.set(__self__, "rf_profile_id", rf_profile_id)
        if two_four_ghz_settings is not None:
            pulumi.set(__self__, "two_four_ghz_settings", two_four_ghz_settings)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of network this RF Profile belongs in.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="fiveGhzSettings")
    def five_ghz_settings(self) -> Optional[pulumi.Input['ApplianceRfProfilesFiveGhzSettingsArgs']]:
        """
        Settings related to 5Ghz band.
        """
        return pulumi.get(self, "five_ghz_settings")

    @five_ghz_settings.setter
    def five_ghz_settings(self, value: Optional[pulumi.Input['ApplianceRfProfilesFiveGhzSettingsArgs']]):
        pulumi.set(self, "five_ghz_settings", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the profile.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="perSsidSettings")
    def per_ssid_settings(self) -> Optional[pulumi.Input['ApplianceRfProfilesPerSsidSettingsArgs']]:
        """
        Per-SSID radio settings by number.
        """
        return pulumi.get(self, "per_ssid_settings")

    @per_ssid_settings.setter
    def per_ssid_settings(self, value: Optional[pulumi.Input['ApplianceRfProfilesPerSsidSettingsArgs']]):
        pulumi.set(self, "per_ssid_settings", value)

    @_builtins.property
    @pulumi.getter(name="rfProfileId")
    def rf_profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        rfProfileId path parameter. Rf profile ID
        """
        return pulumi.get(self, "rf_profile_id")

    @rf_profile_id.setter
    def rf_profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rf_profile_id", value)

    @_builtins.property
    @pulumi.getter(name="twoFourGhzSettings")
    def two_four_ghz_settings(self) -> Optional[pulumi.Input['ApplianceRfProfilesTwoFourGhzSettingsArgs']]:
        """
        Settings related to 2.4Ghz band.
        """
        return pulumi.get(self, "two_four_ghz_settings")

    @two_four_ghz_settings.setter
    def two_four_ghz_settings(self, value: Optional[pulumi.Input['ApplianceRfProfilesTwoFourGhzSettingsArgs']]):
        pulumi.set(self, "two_four_ghz_settings", value)


@pulumi.input_type
class _ApplianceRfProfilesState:
    def __init__(__self__, *,
                 five_ghz_settings: Optional[pulumi.Input['ApplianceRfProfilesFiveGhzSettingsArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 per_ssid_settings: Optional[pulumi.Input['ApplianceRfProfilesPerSsidSettingsArgs']] = None,
                 rf_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 two_four_ghz_settings: Optional[pulumi.Input['ApplianceRfProfilesTwoFourGhzSettingsArgs']] = None):
        """
        Input properties used for looking up and filtering ApplianceRfProfiles resources.
        :param pulumi.Input['ApplianceRfProfilesFiveGhzSettingsArgs'] five_ghz_settings: Settings related to 5Ghz band.
        :param pulumi.Input[_builtins.str] name: The name of the profile.
        :param pulumi.Input[_builtins.str] network_id: ID of network this RF Profile belongs in.
        :param pulumi.Input['ApplianceRfProfilesPerSsidSettingsArgs'] per_ssid_settings: Per-SSID radio settings by number.
        :param pulumi.Input[_builtins.str] rf_profile_id: rfProfileId path parameter. Rf profile ID
        :param pulumi.Input['ApplianceRfProfilesTwoFourGhzSettingsArgs'] two_four_ghz_settings: Settings related to 2.4Ghz band.
        """
        if five_ghz_settings is not None:
            pulumi.set(__self__, "five_ghz_settings", five_ghz_settings)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if per_ssid_settings is not None:
            pulumi.set(__self__, "per_ssid_settings", per_ssid_settings)
        if rf_profile_id is not None:
            pulumi.set(__self__, "rf_profile_id", rf_profile_id)
        if two_four_ghz_settings is not None:
            pulumi.set(__self__, "two_four_ghz_settings", two_four_ghz_settings)

    @_builtins.property
    @pulumi.getter(name="fiveGhzSettings")
    def five_ghz_settings(self) -> Optional[pulumi.Input['ApplianceRfProfilesFiveGhzSettingsArgs']]:
        """
        Settings related to 5Ghz band.
        """
        return pulumi.get(self, "five_ghz_settings")

    @five_ghz_settings.setter
    def five_ghz_settings(self, value: Optional[pulumi.Input['ApplianceRfProfilesFiveGhzSettingsArgs']]):
        pulumi.set(self, "five_ghz_settings", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the profile.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of network this RF Profile belongs in.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="perSsidSettings")
    def per_ssid_settings(self) -> Optional[pulumi.Input['ApplianceRfProfilesPerSsidSettingsArgs']]:
        """
        Per-SSID radio settings by number.
        """
        return pulumi.get(self, "per_ssid_settings")

    @per_ssid_settings.setter
    def per_ssid_settings(self, value: Optional[pulumi.Input['ApplianceRfProfilesPerSsidSettingsArgs']]):
        pulumi.set(self, "per_ssid_settings", value)

    @_builtins.property
    @pulumi.getter(name="rfProfileId")
    def rf_profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        rfProfileId path parameter. Rf profile ID
        """
        return pulumi.get(self, "rf_profile_id")

    @rf_profile_id.setter
    def rf_profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rf_profile_id", value)

    @_builtins.property
    @pulumi.getter(name="twoFourGhzSettings")
    def two_four_ghz_settings(self) -> Optional[pulumi.Input['ApplianceRfProfilesTwoFourGhzSettingsArgs']]:
        """
        Settings related to 2.4Ghz band.
        """
        return pulumi.get(self, "two_four_ghz_settings")

    @two_four_ghz_settings.setter
    def two_four_ghz_settings(self, value: Optional[pulumi.Input['ApplianceRfProfilesTwoFourGhzSettingsArgs']]):
        pulumi.set(self, "two_four_ghz_settings", value)


@pulumi.type_token("meraki:networks/applianceRfProfiles:ApplianceRfProfiles")
class ApplianceRfProfiles(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 five_ghz_settings: Optional[pulumi.Input[Union['ApplianceRfProfilesFiveGhzSettingsArgs', 'ApplianceRfProfilesFiveGhzSettingsArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 per_ssid_settings: Optional[pulumi.Input[Union['ApplianceRfProfilesPerSsidSettingsArgs', 'ApplianceRfProfilesPerSsidSettingsArgsDict']]] = None,
                 rf_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 two_four_ghz_settings: Optional[pulumi.Input[Union['ApplianceRfProfilesTwoFourGhzSettingsArgs', 'ApplianceRfProfilesTwoFourGhzSettingsArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/applianceRfProfiles:ApplianceRfProfiles example "network_id,rf_profile_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ApplianceRfProfilesFiveGhzSettingsArgs', 'ApplianceRfProfilesFiveGhzSettingsArgsDict']] five_ghz_settings: Settings related to 5Ghz band.
        :param pulumi.Input[_builtins.str] name: The name of the profile.
        :param pulumi.Input[_builtins.str] network_id: ID of network this RF Profile belongs in.
        :param pulumi.Input[Union['ApplianceRfProfilesPerSsidSettingsArgs', 'ApplianceRfProfilesPerSsidSettingsArgsDict']] per_ssid_settings: Per-SSID radio settings by number.
        :param pulumi.Input[_builtins.str] rf_profile_id: rfProfileId path parameter. Rf profile ID
        :param pulumi.Input[Union['ApplianceRfProfilesTwoFourGhzSettingsArgs', 'ApplianceRfProfilesTwoFourGhzSettingsArgsDict']] two_four_ghz_settings: Settings related to 2.4Ghz band.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplianceRfProfilesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/applianceRfProfiles:ApplianceRfProfiles example "network_id,rf_profile_id"
        ```

        :param str resource_name: The name of the resource.
        :param ApplianceRfProfilesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplianceRfProfilesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 five_ghz_settings: Optional[pulumi.Input[Union['ApplianceRfProfilesFiveGhzSettingsArgs', 'ApplianceRfProfilesFiveGhzSettingsArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 per_ssid_settings: Optional[pulumi.Input[Union['ApplianceRfProfilesPerSsidSettingsArgs', 'ApplianceRfProfilesPerSsidSettingsArgsDict']]] = None,
                 rf_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 two_four_ghz_settings: Optional[pulumi.Input[Union['ApplianceRfProfilesTwoFourGhzSettingsArgs', 'ApplianceRfProfilesTwoFourGhzSettingsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplianceRfProfilesArgs.__new__(ApplianceRfProfilesArgs)

            __props__.__dict__["five_ghz_settings"] = five_ghz_settings
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["per_ssid_settings"] = per_ssid_settings
            __props__.__dict__["rf_profile_id"] = rf_profile_id
            __props__.__dict__["two_four_ghz_settings"] = two_four_ghz_settings
        super(ApplianceRfProfiles, __self__).__init__(
            'meraki:networks/applianceRfProfiles:ApplianceRfProfiles',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            five_ghz_settings: Optional[pulumi.Input[Union['ApplianceRfProfilesFiveGhzSettingsArgs', 'ApplianceRfProfilesFiveGhzSettingsArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            per_ssid_settings: Optional[pulumi.Input[Union['ApplianceRfProfilesPerSsidSettingsArgs', 'ApplianceRfProfilesPerSsidSettingsArgsDict']]] = None,
            rf_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
            two_four_ghz_settings: Optional[pulumi.Input[Union['ApplianceRfProfilesTwoFourGhzSettingsArgs', 'ApplianceRfProfilesTwoFourGhzSettingsArgsDict']]] = None) -> 'ApplianceRfProfiles':
        """
        Get an existing ApplianceRfProfiles resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ApplianceRfProfilesFiveGhzSettingsArgs', 'ApplianceRfProfilesFiveGhzSettingsArgsDict']] five_ghz_settings: Settings related to 5Ghz band.
        :param pulumi.Input[_builtins.str] name: The name of the profile.
        :param pulumi.Input[_builtins.str] network_id: ID of network this RF Profile belongs in.
        :param pulumi.Input[Union['ApplianceRfProfilesPerSsidSettingsArgs', 'ApplianceRfProfilesPerSsidSettingsArgsDict']] per_ssid_settings: Per-SSID radio settings by number.
        :param pulumi.Input[_builtins.str] rf_profile_id: rfProfileId path parameter. Rf profile ID
        :param pulumi.Input[Union['ApplianceRfProfilesTwoFourGhzSettingsArgs', 'ApplianceRfProfilesTwoFourGhzSettingsArgsDict']] two_four_ghz_settings: Settings related to 2.4Ghz band.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplianceRfProfilesState.__new__(_ApplianceRfProfilesState)

        __props__.__dict__["five_ghz_settings"] = five_ghz_settings
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["per_ssid_settings"] = per_ssid_settings
        __props__.__dict__["rf_profile_id"] = rf_profile_id
        __props__.__dict__["two_four_ghz_settings"] = two_four_ghz_settings
        return ApplianceRfProfiles(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="fiveGhzSettings")
    def five_ghz_settings(self) -> pulumi.Output['outputs.ApplianceRfProfilesFiveGhzSettings']:
        """
        Settings related to 5Ghz band.
        """
        return pulumi.get(self, "five_ghz_settings")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the profile.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of network this RF Profile belongs in.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="perSsidSettings")
    def per_ssid_settings(self) -> pulumi.Output['outputs.ApplianceRfProfilesPerSsidSettings']:
        """
        Per-SSID radio settings by number.
        """
        return pulumi.get(self, "per_ssid_settings")

    @_builtins.property
    @pulumi.getter(name="rfProfileId")
    def rf_profile_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        rfProfileId path parameter. Rf profile ID
        """
        return pulumi.get(self, "rf_profile_id")

    @_builtins.property
    @pulumi.getter(name="twoFourGhzSettings")
    def two_four_ghz_settings(self) -> pulumi.Output['outputs.ApplianceRfProfilesTwoFourGhzSettings']:
        """
        Settings related to 2.4Ghz band.
        """
        return pulumi.get(self, "two_four_ghz_settings")

