# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplianceVpnBgpArgs', 'ApplianceVpnBgp']

@pulumi.input_type
class ApplianceVpnBgpArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[_builtins.str],
                 as_number: Optional[pulumi.Input[_builtins.int]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ibgp_hold_timer: Optional[pulumi.Input[_builtins.int]] = None,
                 neighbors: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceVpnBgpNeighborArgs']]]] = None):
        """
        The set of arguments for constructing a ApplianceVpnBgp resource.
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[_builtins.int] as_number: An Autonomous System Number (ASN) is required if you are to run BGP and peer with another BGP Speaker outside of the Auto VPN domain. This ASN will be applied to the entire Auto VPN domain. The entire 4-byte ASN range is supported. So, the ASN must be an integer between 1 and 4294967295. When absent, this field is not updated. If no value exists then it defaults to 64512.
        :param pulumi.Input[_builtins.bool] enabled: Boolean value to enable or disable the BGP configuration. When BGP is enabled, the asNumber (ASN) will be autopopulated with the preconfigured ASN at other Hubs or a default value if there is no ASN configured.
        :param pulumi.Input[_builtins.int] ibgp_hold_timer: The iBGP holdtimer in seconds. The iBGP holdtimer must be an integer between 12 and 240. When absent, this field is not updated. If no value exists then it defaults to 240.
        :param pulumi.Input[Sequence[pulumi.Input['ApplianceVpnBgpNeighborArgs']]] neighbors: List of BGP neighbors. This list replaces the existing set of neighbors. When absent, this field is not updated.
        """
        pulumi.set(__self__, "network_id", network_id)
        if as_number is not None:
            pulumi.set(__self__, "as_number", as_number)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ibgp_hold_timer is not None:
            pulumi.set(__self__, "ibgp_hold_timer", ibgp_hold_timer)
        if neighbors is not None:
            pulumi.set(__self__, "neighbors", neighbors)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[_builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="asNumber")
    def as_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        An Autonomous System Number (ASN) is required if you are to run BGP and peer with another BGP Speaker outside of the Auto VPN domain. This ASN will be applied to the entire Auto VPN domain. The entire 4-byte ASN range is supported. So, the ASN must be an integer between 1 and 4294967295. When absent, this field is not updated. If no value exists then it defaults to 64512.
        """
        return pulumi.get(self, "as_number")

    @as_number.setter
    def as_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "as_number", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean value to enable or disable the BGP configuration. When BGP is enabled, the asNumber (ASN) will be autopopulated with the preconfigured ASN at other Hubs or a default value if there is no ASN configured.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="ibgpHoldTimer")
    def ibgp_hold_timer(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The iBGP holdtimer in seconds. The iBGP holdtimer must be an integer between 12 and 240. When absent, this field is not updated. If no value exists then it defaults to 240.
        """
        return pulumi.get(self, "ibgp_hold_timer")

    @ibgp_hold_timer.setter
    def ibgp_hold_timer(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ibgp_hold_timer", value)

    @_builtins.property
    @pulumi.getter
    def neighbors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceVpnBgpNeighborArgs']]]]:
        """
        List of BGP neighbors. This list replaces the existing set of neighbors. When absent, this field is not updated.
        """
        return pulumi.get(self, "neighbors")

    @neighbors.setter
    def neighbors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceVpnBgpNeighborArgs']]]]):
        pulumi.set(self, "neighbors", value)


@pulumi.input_type
class _ApplianceVpnBgpState:
    def __init__(__self__, *,
                 as_number: Optional[pulumi.Input[_builtins.int]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ibgp_hold_timer: Optional[pulumi.Input[_builtins.int]] = None,
                 neighbors: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceVpnBgpNeighborArgs']]]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApplianceVpnBgp resources.
        :param pulumi.Input[_builtins.int] as_number: An Autonomous System Number (ASN) is required if you are to run BGP and peer with another BGP Speaker outside of the Auto VPN domain. This ASN will be applied to the entire Auto VPN domain. The entire 4-byte ASN range is supported. So, the ASN must be an integer between 1 and 4294967295. When absent, this field is not updated. If no value exists then it defaults to 64512.
        :param pulumi.Input[_builtins.bool] enabled: Boolean value to enable or disable the BGP configuration. When BGP is enabled, the asNumber (ASN) will be autopopulated with the preconfigured ASN at other Hubs or a default value if there is no ASN configured.
        :param pulumi.Input[_builtins.int] ibgp_hold_timer: The iBGP holdtimer in seconds. The iBGP holdtimer must be an integer between 12 and 240. When absent, this field is not updated. If no value exists then it defaults to 240.
        :param pulumi.Input[Sequence[pulumi.Input['ApplianceVpnBgpNeighborArgs']]] neighbors: List of BGP neighbors. This list replaces the existing set of neighbors. When absent, this field is not updated.
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        """
        if as_number is not None:
            pulumi.set(__self__, "as_number", as_number)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ibgp_hold_timer is not None:
            pulumi.set(__self__, "ibgp_hold_timer", ibgp_hold_timer)
        if neighbors is not None:
            pulumi.set(__self__, "neighbors", neighbors)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)

    @_builtins.property
    @pulumi.getter(name="asNumber")
    def as_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        An Autonomous System Number (ASN) is required if you are to run BGP and peer with another BGP Speaker outside of the Auto VPN domain. This ASN will be applied to the entire Auto VPN domain. The entire 4-byte ASN range is supported. So, the ASN must be an integer between 1 and 4294967295. When absent, this field is not updated. If no value exists then it defaults to 64512.
        """
        return pulumi.get(self, "as_number")

    @as_number.setter
    def as_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "as_number", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean value to enable or disable the BGP configuration. When BGP is enabled, the asNumber (ASN) will be autopopulated with the preconfigured ASN at other Hubs or a default value if there is no ASN configured.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="ibgpHoldTimer")
    def ibgp_hold_timer(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The iBGP holdtimer in seconds. The iBGP holdtimer must be an integer between 12 and 240. When absent, this field is not updated. If no value exists then it defaults to 240.
        """
        return pulumi.get(self, "ibgp_hold_timer")

    @ibgp_hold_timer.setter
    def ibgp_hold_timer(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ibgp_hold_timer", value)

    @_builtins.property
    @pulumi.getter
    def neighbors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceVpnBgpNeighborArgs']]]]:
        """
        List of BGP neighbors. This list replaces the existing set of neighbors. When absent, this field is not updated.
        """
        return pulumi.get(self, "neighbors")

    @neighbors.setter
    def neighbors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceVpnBgpNeighborArgs']]]]):
        pulumi.set(self, "neighbors", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)


@pulumi.type_token("meraki:networks/applianceVpnBgp:ApplianceVpnBgp")
class ApplianceVpnBgp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 as_number: Optional[pulumi.Input[_builtins.int]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ibgp_hold_timer: Optional[pulumi.Input[_builtins.int]] = None,
                 neighbors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplianceVpnBgpNeighborArgs', 'ApplianceVpnBgpNeighborArgsDict']]]]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/applianceVpnBgp:ApplianceVpnBgp example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] as_number: An Autonomous System Number (ASN) is required if you are to run BGP and peer with another BGP Speaker outside of the Auto VPN domain. This ASN will be applied to the entire Auto VPN domain. The entire 4-byte ASN range is supported. So, the ASN must be an integer between 1 and 4294967295. When absent, this field is not updated. If no value exists then it defaults to 64512.
        :param pulumi.Input[_builtins.bool] enabled: Boolean value to enable or disable the BGP configuration. When BGP is enabled, the asNumber (ASN) will be autopopulated with the preconfigured ASN at other Hubs or a default value if there is no ASN configured.
        :param pulumi.Input[_builtins.int] ibgp_hold_timer: The iBGP holdtimer in seconds. The iBGP holdtimer must be an integer between 12 and 240. When absent, this field is not updated. If no value exists then it defaults to 240.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplianceVpnBgpNeighborArgs', 'ApplianceVpnBgpNeighborArgsDict']]]] neighbors: List of BGP neighbors. This list replaces the existing set of neighbors. When absent, this field is not updated.
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplianceVpnBgpArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/applianceVpnBgp:ApplianceVpnBgp example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param ApplianceVpnBgpArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplianceVpnBgpArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 as_number: Optional[pulumi.Input[_builtins.int]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ibgp_hold_timer: Optional[pulumi.Input[_builtins.int]] = None,
                 neighbors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplianceVpnBgpNeighborArgs', 'ApplianceVpnBgpNeighborArgsDict']]]]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplianceVpnBgpArgs.__new__(ApplianceVpnBgpArgs)

            __props__.__dict__["as_number"] = as_number
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["ibgp_hold_timer"] = ibgp_hold_timer
            __props__.__dict__["neighbors"] = neighbors
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
        super(ApplianceVpnBgp, __self__).__init__(
            'meraki:networks/applianceVpnBgp:ApplianceVpnBgp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            as_number: Optional[pulumi.Input[_builtins.int]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            ibgp_hold_timer: Optional[pulumi.Input[_builtins.int]] = None,
            neighbors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplianceVpnBgpNeighborArgs', 'ApplianceVpnBgpNeighborArgsDict']]]]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ApplianceVpnBgp':
        """
        Get an existing ApplianceVpnBgp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] as_number: An Autonomous System Number (ASN) is required if you are to run BGP and peer with another BGP Speaker outside of the Auto VPN domain. This ASN will be applied to the entire Auto VPN domain. The entire 4-byte ASN range is supported. So, the ASN must be an integer between 1 and 4294967295. When absent, this field is not updated. If no value exists then it defaults to 64512.
        :param pulumi.Input[_builtins.bool] enabled: Boolean value to enable or disable the BGP configuration. When BGP is enabled, the asNumber (ASN) will be autopopulated with the preconfigured ASN at other Hubs or a default value if there is no ASN configured.
        :param pulumi.Input[_builtins.int] ibgp_hold_timer: The iBGP holdtimer in seconds. The iBGP holdtimer must be an integer between 12 and 240. When absent, this field is not updated. If no value exists then it defaults to 240.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplianceVpnBgpNeighborArgs', 'ApplianceVpnBgpNeighborArgsDict']]]] neighbors: List of BGP neighbors. This list replaces the existing set of neighbors. When absent, this field is not updated.
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplianceVpnBgpState.__new__(_ApplianceVpnBgpState)

        __props__.__dict__["as_number"] = as_number
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["ibgp_hold_timer"] = ibgp_hold_timer
        __props__.__dict__["neighbors"] = neighbors
        __props__.__dict__["network_id"] = network_id
        return ApplianceVpnBgp(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="asNumber")
    def as_number(self) -> pulumi.Output[_builtins.int]:
        """
        An Autonomous System Number (ASN) is required if you are to run BGP and peer with another BGP Speaker outside of the Auto VPN domain. This ASN will be applied to the entire Auto VPN domain. The entire 4-byte ASN range is supported. So, the ASN must be an integer between 1 and 4294967295. When absent, this field is not updated. If no value exists then it defaults to 64512.
        """
        return pulumi.get(self, "as_number")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Boolean value to enable or disable the BGP configuration. When BGP is enabled, the asNumber (ASN) will be autopopulated with the preconfigured ASN at other Hubs or a default value if there is no ASN configured.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="ibgpHoldTimer")
    def ibgp_hold_timer(self) -> pulumi.Output[_builtins.int]:
        """
        The iBGP holdtimer in seconds. The iBGP holdtimer must be an integer between 12 and 240. When absent, this field is not updated. If no value exists then it defaults to 240.
        """
        return pulumi.get(self, "ibgp_hold_timer")

    @_builtins.property
    @pulumi.getter
    def neighbors(self) -> pulumi.Output[Sequence['outputs.ApplianceVpnBgpNeighbor']]:
        """
        List of BGP neighbors. This list replaces the existing set of neighbors. When absent, this field is not updated.
        """
        return pulumi.get(self, "neighbors")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

