# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplianceWarmSpareArgs', 'ApplianceWarmSpare']

@pulumi.input_type
class ApplianceWarmSpareArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[_builtins.str],
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 spare_serial: Optional[pulumi.Input[_builtins.str]] = None,
                 uplink_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_ip1: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_ip2: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ApplianceWarmSpare resource.
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[_builtins.bool] enabled: Enable warm spare
        :param pulumi.Input[_builtins.str] spare_serial: Serial number of the warm spare appliance
        :param pulumi.Input[_builtins.str] uplink_mode: Uplink mode, either virtual or public
        :param pulumi.Input[_builtins.str] virtual_ip1: The WAN 1 shared IP
        :param pulumi.Input[_builtins.str] virtual_ip2: The WAN 2 shared IP
        """
        pulumi.set(__self__, "network_id", network_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if spare_serial is not None:
            pulumi.set(__self__, "spare_serial", spare_serial)
        if uplink_mode is not None:
            pulumi.set(__self__, "uplink_mode", uplink_mode)
        if virtual_ip1 is not None:
            pulumi.set(__self__, "virtual_ip1", virtual_ip1)
        if virtual_ip2 is not None:
            pulumi.set(__self__, "virtual_ip2", virtual_ip2)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[_builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable warm spare
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="spareSerial")
    def spare_serial(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Serial number of the warm spare appliance
        """
        return pulumi.get(self, "spare_serial")

    @spare_serial.setter
    def spare_serial(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spare_serial", value)

    @_builtins.property
    @pulumi.getter(name="uplinkMode")
    def uplink_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Uplink mode, either virtual or public
        """
        return pulumi.get(self, "uplink_mode")

    @uplink_mode.setter
    def uplink_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uplink_mode", value)

    @_builtins.property
    @pulumi.getter(name="virtualIp1")
    def virtual_ip1(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The WAN 1 shared IP
        """
        return pulumi.get(self, "virtual_ip1")

    @virtual_ip1.setter
    def virtual_ip1(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_ip1", value)

    @_builtins.property
    @pulumi.getter(name="virtualIp2")
    def virtual_ip2(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The WAN 2 shared IP
        """
        return pulumi.get(self, "virtual_ip2")

    @virtual_ip2.setter
    def virtual_ip2(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_ip2", value)


@pulumi.input_type
class _ApplianceWarmSpareState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_serial: Optional[pulumi.Input[_builtins.str]] = None,
                 spare_serial: Optional[pulumi.Input[_builtins.str]] = None,
                 uplink_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_ip1: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_ip2: Optional[pulumi.Input[_builtins.str]] = None,
                 wan1: Optional[pulumi.Input['ApplianceWarmSpareWan1Args']] = None,
                 wan2: Optional[pulumi.Input['ApplianceWarmSpareWan2Args']] = None):
        """
        Input properties used for looking up and filtering ApplianceWarmSpare resources.
        :param pulumi.Input[_builtins.bool] enabled: Enable warm spare
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[_builtins.str] spare_serial: Serial number of the warm spare appliance
        :param pulumi.Input[_builtins.str] uplink_mode: Uplink mode, either virtual or public
        :param pulumi.Input[_builtins.str] virtual_ip1: The WAN 1 shared IP
        :param pulumi.Input[_builtins.str] virtual_ip2: The WAN 2 shared IP
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if primary_serial is not None:
            pulumi.set(__self__, "primary_serial", primary_serial)
        if spare_serial is not None:
            pulumi.set(__self__, "spare_serial", spare_serial)
        if uplink_mode is not None:
            pulumi.set(__self__, "uplink_mode", uplink_mode)
        if virtual_ip1 is not None:
            pulumi.set(__self__, "virtual_ip1", virtual_ip1)
        if virtual_ip2 is not None:
            pulumi.set(__self__, "virtual_ip2", virtual_ip2)
        if wan1 is not None:
            pulumi.set(__self__, "wan1", wan1)
        if wan2 is not None:
            pulumi.set(__self__, "wan2", wan2)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable warm spare
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="primarySerial")
    def primary_serial(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "primary_serial")

    @primary_serial.setter
    def primary_serial(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_serial", value)

    @_builtins.property
    @pulumi.getter(name="spareSerial")
    def spare_serial(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Serial number of the warm spare appliance
        """
        return pulumi.get(self, "spare_serial")

    @spare_serial.setter
    def spare_serial(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spare_serial", value)

    @_builtins.property
    @pulumi.getter(name="uplinkMode")
    def uplink_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Uplink mode, either virtual or public
        """
        return pulumi.get(self, "uplink_mode")

    @uplink_mode.setter
    def uplink_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uplink_mode", value)

    @_builtins.property
    @pulumi.getter(name="virtualIp1")
    def virtual_ip1(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The WAN 1 shared IP
        """
        return pulumi.get(self, "virtual_ip1")

    @virtual_ip1.setter
    def virtual_ip1(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_ip1", value)

    @_builtins.property
    @pulumi.getter(name="virtualIp2")
    def virtual_ip2(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The WAN 2 shared IP
        """
        return pulumi.get(self, "virtual_ip2")

    @virtual_ip2.setter
    def virtual_ip2(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_ip2", value)

    @_builtins.property
    @pulumi.getter
    def wan1(self) -> Optional[pulumi.Input['ApplianceWarmSpareWan1Args']]:
        return pulumi.get(self, "wan1")

    @wan1.setter
    def wan1(self, value: Optional[pulumi.Input['ApplianceWarmSpareWan1Args']]):
        pulumi.set(self, "wan1", value)

    @_builtins.property
    @pulumi.getter
    def wan2(self) -> Optional[pulumi.Input['ApplianceWarmSpareWan2Args']]:
        return pulumi.get(self, "wan2")

    @wan2.setter
    def wan2(self, value: Optional[pulumi.Input['ApplianceWarmSpareWan2Args']]):
        pulumi.set(self, "wan2", value)


@pulumi.type_token("meraki:networks/applianceWarmSpare:ApplianceWarmSpare")
class ApplianceWarmSpare(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spare_serial: Optional[pulumi.Input[_builtins.str]] = None,
                 uplink_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_ip1: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_ip2: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.ApplianceWarmSpare("example",
            enabled=True,
            network_id="string",
            spare_serial="Q234-ABCD-5678",
            uplink_mode="virtual",
            virtual_ip1="1.2.3.4",
            virtual_ip2="1.2.3.4")
        pulumi.export("merakiNetworksApplianceWarmSpareExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/applianceWarmSpare:ApplianceWarmSpare example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Enable warm spare
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[_builtins.str] spare_serial: Serial number of the warm spare appliance
        :param pulumi.Input[_builtins.str] uplink_mode: Uplink mode, either virtual or public
        :param pulumi.Input[_builtins.str] virtual_ip1: The WAN 1 shared IP
        :param pulumi.Input[_builtins.str] virtual_ip2: The WAN 2 shared IP
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplianceWarmSpareArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.ApplianceWarmSpare("example",
            enabled=True,
            network_id="string",
            spare_serial="Q234-ABCD-5678",
            uplink_mode="virtual",
            virtual_ip1="1.2.3.4",
            virtual_ip2="1.2.3.4")
        pulumi.export("merakiNetworksApplianceWarmSpareExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/applianceWarmSpare:ApplianceWarmSpare example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param ApplianceWarmSpareArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplianceWarmSpareArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spare_serial: Optional[pulumi.Input[_builtins.str]] = None,
                 uplink_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_ip1: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_ip2: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplianceWarmSpareArgs.__new__(ApplianceWarmSpareArgs)

            __props__.__dict__["enabled"] = enabled
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["spare_serial"] = spare_serial
            __props__.__dict__["uplink_mode"] = uplink_mode
            __props__.__dict__["virtual_ip1"] = virtual_ip1
            __props__.__dict__["virtual_ip2"] = virtual_ip2
            __props__.__dict__["primary_serial"] = None
            __props__.__dict__["wan1"] = None
            __props__.__dict__["wan2"] = None
        super(ApplianceWarmSpare, __self__).__init__(
            'meraki:networks/applianceWarmSpare:ApplianceWarmSpare',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            primary_serial: Optional[pulumi.Input[_builtins.str]] = None,
            spare_serial: Optional[pulumi.Input[_builtins.str]] = None,
            uplink_mode: Optional[pulumi.Input[_builtins.str]] = None,
            virtual_ip1: Optional[pulumi.Input[_builtins.str]] = None,
            virtual_ip2: Optional[pulumi.Input[_builtins.str]] = None,
            wan1: Optional[pulumi.Input[Union['ApplianceWarmSpareWan1Args', 'ApplianceWarmSpareWan1ArgsDict']]] = None,
            wan2: Optional[pulumi.Input[Union['ApplianceWarmSpareWan2Args', 'ApplianceWarmSpareWan2ArgsDict']]] = None) -> 'ApplianceWarmSpare':
        """
        Get an existing ApplianceWarmSpare resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Enable warm spare
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[_builtins.str] spare_serial: Serial number of the warm spare appliance
        :param pulumi.Input[_builtins.str] uplink_mode: Uplink mode, either virtual or public
        :param pulumi.Input[_builtins.str] virtual_ip1: The WAN 1 shared IP
        :param pulumi.Input[_builtins.str] virtual_ip2: The WAN 2 shared IP
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplianceWarmSpareState.__new__(_ApplianceWarmSpareState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["primary_serial"] = primary_serial
        __props__.__dict__["spare_serial"] = spare_serial
        __props__.__dict__["uplink_mode"] = uplink_mode
        __props__.__dict__["virtual_ip1"] = virtual_ip1
        __props__.__dict__["virtual_ip2"] = virtual_ip2
        __props__.__dict__["wan1"] = wan1
        __props__.__dict__["wan2"] = wan2
        return ApplianceWarmSpare(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable warm spare
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="primarySerial")
    def primary_serial(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "primary_serial")

    @_builtins.property
    @pulumi.getter(name="spareSerial")
    def spare_serial(self) -> pulumi.Output[_builtins.str]:
        """
        Serial number of the warm spare appliance
        """
        return pulumi.get(self, "spare_serial")

    @_builtins.property
    @pulumi.getter(name="uplinkMode")
    def uplink_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Uplink mode, either virtual or public
        """
        return pulumi.get(self, "uplink_mode")

    @_builtins.property
    @pulumi.getter(name="virtualIp1")
    def virtual_ip1(self) -> pulumi.Output[_builtins.str]:
        """
        The WAN 1 shared IP
        """
        return pulumi.get(self, "virtual_ip1")

    @_builtins.property
    @pulumi.getter(name="virtualIp2")
    def virtual_ip2(self) -> pulumi.Output[_builtins.str]:
        """
        The WAN 2 shared IP
        """
        return pulumi.get(self, "virtual_ip2")

    @_builtins.property
    @pulumi.getter
    def wan1(self) -> pulumi.Output['outputs.ApplianceWarmSpareWan1']:
        return pulumi.get(self, "wan1")

    @_builtins.property
    @pulumi.getter
    def wan2(self) -> pulumi.Output['outputs.ApplianceWarmSpareWan2']:
        return pulumi.get(self, "wan2")

