# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FirmwareUpgradesStagedGroupsArgs', 'FirmwareUpgradesStagedGroups']

@pulumi.input_type
class FirmwareUpgradesStagedGroupsArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[_builtins.str],
                 assigned_devices: Optional[pulumi.Input['FirmwareUpgradesStagedGroupsAssignedDevicesArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FirmwareUpgradesStagedGroups resource.
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input['FirmwareUpgradesStagedGroupsAssignedDevicesArgs'] assigned_devices: The devices and Switch Stacks assigned to the Group
        :param pulumi.Input[_builtins.str] description: Description of the Staged Upgrade Group
        :param pulumi.Input[_builtins.str] group_id: Id of staged upgrade group
        :param pulumi.Input[_builtins.bool] is_default: Boolean indicating the default Group. Any device that does not have a group explicitly assigned will upgrade with this group
        :param pulumi.Input[_builtins.str] name: Name of the Staged Upgrade Group
        """
        pulumi.set(__self__, "network_id", network_id)
        if assigned_devices is not None:
            pulumi.set(__self__, "assigned_devices", assigned_devices)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[_builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="assignedDevices")
    def assigned_devices(self) -> Optional[pulumi.Input['FirmwareUpgradesStagedGroupsAssignedDevicesArgs']]:
        """
        The devices and Switch Stacks assigned to the Group
        """
        return pulumi.get(self, "assigned_devices")

    @assigned_devices.setter
    def assigned_devices(self, value: Optional[pulumi.Input['FirmwareUpgradesStagedGroupsAssignedDevicesArgs']]):
        pulumi.set(self, "assigned_devices", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the Staged Upgrade Group
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of staged upgrade group
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean indicating the default Group. Any device that does not have a group explicitly assigned will upgrade with this group
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Staged Upgrade Group
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _FirmwareUpgradesStagedGroupsState:
    def __init__(__self__, *,
                 assigned_devices: Optional[pulumi.Input['FirmwareUpgradesStagedGroupsAssignedDevicesArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FirmwareUpgradesStagedGroups resources.
        :param pulumi.Input['FirmwareUpgradesStagedGroupsAssignedDevicesArgs'] assigned_devices: The devices and Switch Stacks assigned to the Group
        :param pulumi.Input[_builtins.str] description: Description of the Staged Upgrade Group
        :param pulumi.Input[_builtins.str] group_id: Id of staged upgrade group
        :param pulumi.Input[_builtins.bool] is_default: Boolean indicating the default Group. Any device that does not have a group explicitly assigned will upgrade with this group
        :param pulumi.Input[_builtins.str] name: Name of the Staged Upgrade Group
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        """
        if assigned_devices is not None:
            pulumi.set(__self__, "assigned_devices", assigned_devices)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)

    @_builtins.property
    @pulumi.getter(name="assignedDevices")
    def assigned_devices(self) -> Optional[pulumi.Input['FirmwareUpgradesStagedGroupsAssignedDevicesArgs']]:
        """
        The devices and Switch Stacks assigned to the Group
        """
        return pulumi.get(self, "assigned_devices")

    @assigned_devices.setter
    def assigned_devices(self, value: Optional[pulumi.Input['FirmwareUpgradesStagedGroupsAssignedDevicesArgs']]):
        pulumi.set(self, "assigned_devices", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the Staged Upgrade Group
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of staged upgrade group
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean indicating the default Group. Any device that does not have a group explicitly assigned will upgrade with this group
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Staged Upgrade Group
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)


@pulumi.type_token("meraki:networks/firmwareUpgradesStagedGroups:FirmwareUpgradesStagedGroups")
class FirmwareUpgradesStagedGroups(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assigned_devices: Optional[pulumi.Input[Union['FirmwareUpgradesStagedGroupsAssignedDevicesArgs', 'FirmwareUpgradesStagedGroupsAssignedDevicesArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/firmwareUpgradesStagedGroups:FirmwareUpgradesStagedGroups example "group_id,network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FirmwareUpgradesStagedGroupsAssignedDevicesArgs', 'FirmwareUpgradesStagedGroupsAssignedDevicesArgsDict']] assigned_devices: The devices and Switch Stacks assigned to the Group
        :param pulumi.Input[_builtins.str] description: Description of the Staged Upgrade Group
        :param pulumi.Input[_builtins.str] group_id: Id of staged upgrade group
        :param pulumi.Input[_builtins.bool] is_default: Boolean indicating the default Group. Any device that does not have a group explicitly assigned will upgrade with this group
        :param pulumi.Input[_builtins.str] name: Name of the Staged Upgrade Group
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FirmwareUpgradesStagedGroupsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/firmwareUpgradesStagedGroups:FirmwareUpgradesStagedGroups example "group_id,network_id"
        ```

        :param str resource_name: The name of the resource.
        :param FirmwareUpgradesStagedGroupsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FirmwareUpgradesStagedGroupsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assigned_devices: Optional[pulumi.Input[Union['FirmwareUpgradesStagedGroupsAssignedDevicesArgs', 'FirmwareUpgradesStagedGroupsAssignedDevicesArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FirmwareUpgradesStagedGroupsArgs.__new__(FirmwareUpgradesStagedGroupsArgs)

            __props__.__dict__["assigned_devices"] = assigned_devices
            __props__.__dict__["description"] = description
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["is_default"] = is_default
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
        super(FirmwareUpgradesStagedGroups, __self__).__init__(
            'meraki:networks/firmwareUpgradesStagedGroups:FirmwareUpgradesStagedGroups',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assigned_devices: Optional[pulumi.Input[Union['FirmwareUpgradesStagedGroupsAssignedDevicesArgs', 'FirmwareUpgradesStagedGroupsAssignedDevicesArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            group_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_default: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'FirmwareUpgradesStagedGroups':
        """
        Get an existing FirmwareUpgradesStagedGroups resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FirmwareUpgradesStagedGroupsAssignedDevicesArgs', 'FirmwareUpgradesStagedGroupsAssignedDevicesArgsDict']] assigned_devices: The devices and Switch Stacks assigned to the Group
        :param pulumi.Input[_builtins.str] description: Description of the Staged Upgrade Group
        :param pulumi.Input[_builtins.str] group_id: Id of staged upgrade group
        :param pulumi.Input[_builtins.bool] is_default: Boolean indicating the default Group. Any device that does not have a group explicitly assigned will upgrade with this group
        :param pulumi.Input[_builtins.str] name: Name of the Staged Upgrade Group
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FirmwareUpgradesStagedGroupsState.__new__(_FirmwareUpgradesStagedGroupsState)

        __props__.__dict__["assigned_devices"] = assigned_devices
        __props__.__dict__["description"] = description
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        return FirmwareUpgradesStagedGroups(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="assignedDevices")
    def assigned_devices(self) -> pulumi.Output['outputs.FirmwareUpgradesStagedGroupsAssignedDevices']:
        """
        The devices and Switch Stacks assigned to the Group
        """
        return pulumi.get(self, "assigned_devices")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Description of the Staged Upgrade Group
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Id of staged upgrade group
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[_builtins.bool]:
        """
        Boolean indicating the default Group. Any device that does not have a group explicitly assigned will upgrade with this group
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Staged Upgrade Group
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

