# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GroupPoliciesArgs', 'GroupPolicies']

@pulumi.input_type
class GroupPoliciesArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[_builtins.str],
                 bandwidth: Optional[pulumi.Input['GroupPoliciesBandwidthArgs']] = None,
                 bonjour_forwarding: Optional[pulumi.Input['GroupPoliciesBonjourForwardingArgs']] = None,
                 content_filtering: Optional[pulumi.Input['GroupPoliciesContentFilteringArgs']] = None,
                 firewall_and_traffic_shaping: Optional[pulumi.Input['GroupPoliciesFirewallAndTrafficShapingArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduling: Optional[pulumi.Input['GroupPoliciesSchedulingArgs']] = None,
                 splash_auth_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan_tagging: Optional[pulumi.Input['GroupPoliciesVlanTaggingArgs']] = None):
        """
        The set of arguments for constructing a GroupPolicies resource.
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input['GroupPoliciesBandwidthArgs'] bandwidth: The bandwidth settings for clients bound to your group policy.
        :param pulumi.Input['GroupPoliciesBonjourForwardingArgs'] bonjour_forwarding: The Bonjour settings for your group policy. Only valid if your network has a wireless configuration.
        :param pulumi.Input['GroupPoliciesContentFilteringArgs'] content_filtering: The content filtering settings for your group policy
        :param pulumi.Input['GroupPoliciesFirewallAndTrafficShapingArgs'] firewall_and_traffic_shaping: The firewall and traffic shaping rules and settings for your policy.
        :param pulumi.Input[_builtins.str] name: The name for your group policy. Required.
        :param pulumi.Input['GroupPoliciesSchedulingArgs'] scheduling: The schedule for the group policy. Schedules are applied to days of the week.
        :param pulumi.Input[_builtins.str] splash_auth_settings: Whether clients bound to your policy will bypass splash authorization or behave according to the network's rules. Can be one of 'network default' or 'bypass'. Only available if your network has a wireless configuration.
        :param pulumi.Input['GroupPoliciesVlanTaggingArgs'] vlan_tagging: The VLAN tagging settings for your group policy. Only available if your network has a wireless configuration.
        """
        pulumi.set(__self__, "network_id", network_id)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if bonjour_forwarding is not None:
            pulumi.set(__self__, "bonjour_forwarding", bonjour_forwarding)
        if content_filtering is not None:
            pulumi.set(__self__, "content_filtering", content_filtering)
        if firewall_and_traffic_shaping is not None:
            pulumi.set(__self__, "firewall_and_traffic_shaping", firewall_and_traffic_shaping)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if scheduling is not None:
            pulumi.set(__self__, "scheduling", scheduling)
        if splash_auth_settings is not None:
            pulumi.set(__self__, "splash_auth_settings", splash_auth_settings)
        if vlan_tagging is not None:
            pulumi.set(__self__, "vlan_tagging", vlan_tagging)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[_builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input['GroupPoliciesBandwidthArgs']]:
        """
        The bandwidth settings for clients bound to your group policy.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input['GroupPoliciesBandwidthArgs']]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="bonjourForwarding")
    def bonjour_forwarding(self) -> Optional[pulumi.Input['GroupPoliciesBonjourForwardingArgs']]:
        """
        The Bonjour settings for your group policy. Only valid if your network has a wireless configuration.
        """
        return pulumi.get(self, "bonjour_forwarding")

    @bonjour_forwarding.setter
    def bonjour_forwarding(self, value: Optional[pulumi.Input['GroupPoliciesBonjourForwardingArgs']]):
        pulumi.set(self, "bonjour_forwarding", value)

    @_builtins.property
    @pulumi.getter(name="contentFiltering")
    def content_filtering(self) -> Optional[pulumi.Input['GroupPoliciesContentFilteringArgs']]:
        """
        The content filtering settings for your group policy
        """
        return pulumi.get(self, "content_filtering")

    @content_filtering.setter
    def content_filtering(self, value: Optional[pulumi.Input['GroupPoliciesContentFilteringArgs']]):
        pulumi.set(self, "content_filtering", value)

    @_builtins.property
    @pulumi.getter(name="firewallAndTrafficShaping")
    def firewall_and_traffic_shaping(self) -> Optional[pulumi.Input['GroupPoliciesFirewallAndTrafficShapingArgs']]:
        """
        The firewall and traffic shaping rules and settings for your policy.
        """
        return pulumi.get(self, "firewall_and_traffic_shaping")

    @firewall_and_traffic_shaping.setter
    def firewall_and_traffic_shaping(self, value: Optional[pulumi.Input['GroupPoliciesFirewallAndTrafficShapingArgs']]):
        pulumi.set(self, "firewall_and_traffic_shaping", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for your group policy. Required.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def scheduling(self) -> Optional[pulumi.Input['GroupPoliciesSchedulingArgs']]:
        """
        The schedule for the group policy. Schedules are applied to days of the week.
        """
        return pulumi.get(self, "scheduling")

    @scheduling.setter
    def scheduling(self, value: Optional[pulumi.Input['GroupPoliciesSchedulingArgs']]):
        pulumi.set(self, "scheduling", value)

    @_builtins.property
    @pulumi.getter(name="splashAuthSettings")
    def splash_auth_settings(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether clients bound to your policy will bypass splash authorization or behave according to the network's rules. Can be one of 'network default' or 'bypass'. Only available if your network has a wireless configuration.
        """
        return pulumi.get(self, "splash_auth_settings")

    @splash_auth_settings.setter
    def splash_auth_settings(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "splash_auth_settings", value)

    @_builtins.property
    @pulumi.getter(name="vlanTagging")
    def vlan_tagging(self) -> Optional[pulumi.Input['GroupPoliciesVlanTaggingArgs']]:
        """
        The VLAN tagging settings for your group policy. Only available if your network has a wireless configuration.
        """
        return pulumi.get(self, "vlan_tagging")

    @vlan_tagging.setter
    def vlan_tagging(self, value: Optional[pulumi.Input['GroupPoliciesVlanTaggingArgs']]):
        pulumi.set(self, "vlan_tagging", value)


@pulumi.input_type
class _GroupPoliciesState:
    def __init__(__self__, *,
                 bandwidth: Optional[pulumi.Input['GroupPoliciesBandwidthArgs']] = None,
                 bonjour_forwarding: Optional[pulumi.Input['GroupPoliciesBonjourForwardingArgs']] = None,
                 content_filtering: Optional[pulumi.Input['GroupPoliciesContentFilteringArgs']] = None,
                 firewall_and_traffic_shaping: Optional[pulumi.Input['GroupPoliciesFirewallAndTrafficShapingArgs']] = None,
                 group_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduling: Optional[pulumi.Input['GroupPoliciesSchedulingArgs']] = None,
                 splash_auth_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan_tagging: Optional[pulumi.Input['GroupPoliciesVlanTaggingArgs']] = None):
        """
        Input properties used for looking up and filtering GroupPolicies resources.
        :param pulumi.Input['GroupPoliciesBandwidthArgs'] bandwidth: The bandwidth settings for clients bound to your group policy.
        :param pulumi.Input['GroupPoliciesBonjourForwardingArgs'] bonjour_forwarding: The Bonjour settings for your group policy. Only valid if your network has a wireless configuration.
        :param pulumi.Input['GroupPoliciesContentFilteringArgs'] content_filtering: The content filtering settings for your group policy
        :param pulumi.Input['GroupPoliciesFirewallAndTrafficShapingArgs'] firewall_and_traffic_shaping: The firewall and traffic shaping rules and settings for your policy.
        :param pulumi.Input[_builtins.str] group_policy_id: The ID of the group policy
        :param pulumi.Input[_builtins.str] name: The name for your group policy. Required.
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input['GroupPoliciesSchedulingArgs'] scheduling: The schedule for the group policy. Schedules are applied to days of the week.
        :param pulumi.Input[_builtins.str] splash_auth_settings: Whether clients bound to your policy will bypass splash authorization or behave according to the network's rules. Can be one of 'network default' or 'bypass'. Only available if your network has a wireless configuration.
        :param pulumi.Input['GroupPoliciesVlanTaggingArgs'] vlan_tagging: The VLAN tagging settings for your group policy. Only available if your network has a wireless configuration.
        """
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if bonjour_forwarding is not None:
            pulumi.set(__self__, "bonjour_forwarding", bonjour_forwarding)
        if content_filtering is not None:
            pulumi.set(__self__, "content_filtering", content_filtering)
        if firewall_and_traffic_shaping is not None:
            pulumi.set(__self__, "firewall_and_traffic_shaping", firewall_and_traffic_shaping)
        if group_policy_id is not None:
            pulumi.set(__self__, "group_policy_id", group_policy_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if scheduling is not None:
            pulumi.set(__self__, "scheduling", scheduling)
        if splash_auth_settings is not None:
            pulumi.set(__self__, "splash_auth_settings", splash_auth_settings)
        if vlan_tagging is not None:
            pulumi.set(__self__, "vlan_tagging", vlan_tagging)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input['GroupPoliciesBandwidthArgs']]:
        """
        The bandwidth settings for clients bound to your group policy.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input['GroupPoliciesBandwidthArgs']]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="bonjourForwarding")
    def bonjour_forwarding(self) -> Optional[pulumi.Input['GroupPoliciesBonjourForwardingArgs']]:
        """
        The Bonjour settings for your group policy. Only valid if your network has a wireless configuration.
        """
        return pulumi.get(self, "bonjour_forwarding")

    @bonjour_forwarding.setter
    def bonjour_forwarding(self, value: Optional[pulumi.Input['GroupPoliciesBonjourForwardingArgs']]):
        pulumi.set(self, "bonjour_forwarding", value)

    @_builtins.property
    @pulumi.getter(name="contentFiltering")
    def content_filtering(self) -> Optional[pulumi.Input['GroupPoliciesContentFilteringArgs']]:
        """
        The content filtering settings for your group policy
        """
        return pulumi.get(self, "content_filtering")

    @content_filtering.setter
    def content_filtering(self, value: Optional[pulumi.Input['GroupPoliciesContentFilteringArgs']]):
        pulumi.set(self, "content_filtering", value)

    @_builtins.property
    @pulumi.getter(name="firewallAndTrafficShaping")
    def firewall_and_traffic_shaping(self) -> Optional[pulumi.Input['GroupPoliciesFirewallAndTrafficShapingArgs']]:
        """
        The firewall and traffic shaping rules and settings for your policy.
        """
        return pulumi.get(self, "firewall_and_traffic_shaping")

    @firewall_and_traffic_shaping.setter
    def firewall_and_traffic_shaping(self, value: Optional[pulumi.Input['GroupPoliciesFirewallAndTrafficShapingArgs']]):
        pulumi.set(self, "firewall_and_traffic_shaping", value)

    @_builtins.property
    @pulumi.getter(name="groupPolicyId")
    def group_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the group policy
        """
        return pulumi.get(self, "group_policy_id")

    @group_policy_id.setter
    def group_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_policy_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for your group policy. Required.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter
    def scheduling(self) -> Optional[pulumi.Input['GroupPoliciesSchedulingArgs']]:
        """
        The schedule for the group policy. Schedules are applied to days of the week.
        """
        return pulumi.get(self, "scheduling")

    @scheduling.setter
    def scheduling(self, value: Optional[pulumi.Input['GroupPoliciesSchedulingArgs']]):
        pulumi.set(self, "scheduling", value)

    @_builtins.property
    @pulumi.getter(name="splashAuthSettings")
    def splash_auth_settings(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether clients bound to your policy will bypass splash authorization or behave according to the network's rules. Can be one of 'network default' or 'bypass'. Only available if your network has a wireless configuration.
        """
        return pulumi.get(self, "splash_auth_settings")

    @splash_auth_settings.setter
    def splash_auth_settings(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "splash_auth_settings", value)

    @_builtins.property
    @pulumi.getter(name="vlanTagging")
    def vlan_tagging(self) -> Optional[pulumi.Input['GroupPoliciesVlanTaggingArgs']]:
        """
        The VLAN tagging settings for your group policy. Only available if your network has a wireless configuration.
        """
        return pulumi.get(self, "vlan_tagging")

    @vlan_tagging.setter
    def vlan_tagging(self, value: Optional[pulumi.Input['GroupPoliciesVlanTaggingArgs']]):
        pulumi.set(self, "vlan_tagging", value)


@pulumi.type_token("meraki:networks/groupPolicies:GroupPolicies")
class GroupPolicies(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[Union['GroupPoliciesBandwidthArgs', 'GroupPoliciesBandwidthArgsDict']]] = None,
                 bonjour_forwarding: Optional[pulumi.Input[Union['GroupPoliciesBonjourForwardingArgs', 'GroupPoliciesBonjourForwardingArgsDict']]] = None,
                 content_filtering: Optional[pulumi.Input[Union['GroupPoliciesContentFilteringArgs', 'GroupPoliciesContentFilteringArgsDict']]] = None,
                 firewall_and_traffic_shaping: Optional[pulumi.Input[Union['GroupPoliciesFirewallAndTrafficShapingArgs', 'GroupPoliciesFirewallAndTrafficShapingArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduling: Optional[pulumi.Input[Union['GroupPoliciesSchedulingArgs', 'GroupPoliciesSchedulingArgsDict']]] = None,
                 splash_auth_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan_tagging: Optional[pulumi.Input[Union['GroupPoliciesVlanTaggingArgs', 'GroupPoliciesVlanTaggingArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/groupPolicies:GroupPolicies example "group_policy_id,network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['GroupPoliciesBandwidthArgs', 'GroupPoliciesBandwidthArgsDict']] bandwidth: The bandwidth settings for clients bound to your group policy.
        :param pulumi.Input[Union['GroupPoliciesBonjourForwardingArgs', 'GroupPoliciesBonjourForwardingArgsDict']] bonjour_forwarding: The Bonjour settings for your group policy. Only valid if your network has a wireless configuration.
        :param pulumi.Input[Union['GroupPoliciesContentFilteringArgs', 'GroupPoliciesContentFilteringArgsDict']] content_filtering: The content filtering settings for your group policy
        :param pulumi.Input[Union['GroupPoliciesFirewallAndTrafficShapingArgs', 'GroupPoliciesFirewallAndTrafficShapingArgsDict']] firewall_and_traffic_shaping: The firewall and traffic shaping rules and settings for your policy.
        :param pulumi.Input[_builtins.str] name: The name for your group policy. Required.
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Union['GroupPoliciesSchedulingArgs', 'GroupPoliciesSchedulingArgsDict']] scheduling: The schedule for the group policy. Schedules are applied to days of the week.
        :param pulumi.Input[_builtins.str] splash_auth_settings: Whether clients bound to your policy will bypass splash authorization or behave according to the network's rules. Can be one of 'network default' or 'bypass'. Only available if your network has a wireless configuration.
        :param pulumi.Input[Union['GroupPoliciesVlanTaggingArgs', 'GroupPoliciesVlanTaggingArgsDict']] vlan_tagging: The VLAN tagging settings for your group policy. Only available if your network has a wireless configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GroupPoliciesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/groupPolicies:GroupPolicies example "group_policy_id,network_id"
        ```

        :param str resource_name: The name of the resource.
        :param GroupPoliciesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupPoliciesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[Union['GroupPoliciesBandwidthArgs', 'GroupPoliciesBandwidthArgsDict']]] = None,
                 bonjour_forwarding: Optional[pulumi.Input[Union['GroupPoliciesBonjourForwardingArgs', 'GroupPoliciesBonjourForwardingArgsDict']]] = None,
                 content_filtering: Optional[pulumi.Input[Union['GroupPoliciesContentFilteringArgs', 'GroupPoliciesContentFilteringArgsDict']]] = None,
                 firewall_and_traffic_shaping: Optional[pulumi.Input[Union['GroupPoliciesFirewallAndTrafficShapingArgs', 'GroupPoliciesFirewallAndTrafficShapingArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduling: Optional[pulumi.Input[Union['GroupPoliciesSchedulingArgs', 'GroupPoliciesSchedulingArgsDict']]] = None,
                 splash_auth_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan_tagging: Optional[pulumi.Input[Union['GroupPoliciesVlanTaggingArgs', 'GroupPoliciesVlanTaggingArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupPoliciesArgs.__new__(GroupPoliciesArgs)

            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["bonjour_forwarding"] = bonjour_forwarding
            __props__.__dict__["content_filtering"] = content_filtering
            __props__.__dict__["firewall_and_traffic_shaping"] = firewall_and_traffic_shaping
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["scheduling"] = scheduling
            __props__.__dict__["splash_auth_settings"] = splash_auth_settings
            __props__.__dict__["vlan_tagging"] = vlan_tagging
            __props__.__dict__["group_policy_id"] = None
        super(GroupPolicies, __self__).__init__(
            'meraki:networks/groupPolicies:GroupPolicies',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bandwidth: Optional[pulumi.Input[Union['GroupPoliciesBandwidthArgs', 'GroupPoliciesBandwidthArgsDict']]] = None,
            bonjour_forwarding: Optional[pulumi.Input[Union['GroupPoliciesBonjourForwardingArgs', 'GroupPoliciesBonjourForwardingArgsDict']]] = None,
            content_filtering: Optional[pulumi.Input[Union['GroupPoliciesContentFilteringArgs', 'GroupPoliciesContentFilteringArgsDict']]] = None,
            firewall_and_traffic_shaping: Optional[pulumi.Input[Union['GroupPoliciesFirewallAndTrafficShapingArgs', 'GroupPoliciesFirewallAndTrafficShapingArgsDict']]] = None,
            group_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            scheduling: Optional[pulumi.Input[Union['GroupPoliciesSchedulingArgs', 'GroupPoliciesSchedulingArgsDict']]] = None,
            splash_auth_settings: Optional[pulumi.Input[_builtins.str]] = None,
            vlan_tagging: Optional[pulumi.Input[Union['GroupPoliciesVlanTaggingArgs', 'GroupPoliciesVlanTaggingArgsDict']]] = None) -> 'GroupPolicies':
        """
        Get an existing GroupPolicies resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['GroupPoliciesBandwidthArgs', 'GroupPoliciesBandwidthArgsDict']] bandwidth: The bandwidth settings for clients bound to your group policy.
        :param pulumi.Input[Union['GroupPoliciesBonjourForwardingArgs', 'GroupPoliciesBonjourForwardingArgsDict']] bonjour_forwarding: The Bonjour settings for your group policy. Only valid if your network has a wireless configuration.
        :param pulumi.Input[Union['GroupPoliciesContentFilteringArgs', 'GroupPoliciesContentFilteringArgsDict']] content_filtering: The content filtering settings for your group policy
        :param pulumi.Input[Union['GroupPoliciesFirewallAndTrafficShapingArgs', 'GroupPoliciesFirewallAndTrafficShapingArgsDict']] firewall_and_traffic_shaping: The firewall and traffic shaping rules and settings for your policy.
        :param pulumi.Input[_builtins.str] group_policy_id: The ID of the group policy
        :param pulumi.Input[_builtins.str] name: The name for your group policy. Required.
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Union['GroupPoliciesSchedulingArgs', 'GroupPoliciesSchedulingArgsDict']] scheduling: The schedule for the group policy. Schedules are applied to days of the week.
        :param pulumi.Input[_builtins.str] splash_auth_settings: Whether clients bound to your policy will bypass splash authorization or behave according to the network's rules. Can be one of 'network default' or 'bypass'. Only available if your network has a wireless configuration.
        :param pulumi.Input[Union['GroupPoliciesVlanTaggingArgs', 'GroupPoliciesVlanTaggingArgsDict']] vlan_tagging: The VLAN tagging settings for your group policy. Only available if your network has a wireless configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupPoliciesState.__new__(_GroupPoliciesState)

        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["bonjour_forwarding"] = bonjour_forwarding
        __props__.__dict__["content_filtering"] = content_filtering
        __props__.__dict__["firewall_and_traffic_shaping"] = firewall_and_traffic_shaping
        __props__.__dict__["group_policy_id"] = group_policy_id
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["scheduling"] = scheduling
        __props__.__dict__["splash_auth_settings"] = splash_auth_settings
        __props__.__dict__["vlan_tagging"] = vlan_tagging
        return GroupPolicies(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output['outputs.GroupPoliciesBandwidth']:
        """
        The bandwidth settings for clients bound to your group policy.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="bonjourForwarding")
    def bonjour_forwarding(self) -> pulumi.Output['outputs.GroupPoliciesBonjourForwarding']:
        """
        The Bonjour settings for your group policy. Only valid if your network has a wireless configuration.
        """
        return pulumi.get(self, "bonjour_forwarding")

    @_builtins.property
    @pulumi.getter(name="contentFiltering")
    def content_filtering(self) -> pulumi.Output['outputs.GroupPoliciesContentFiltering']:
        """
        The content filtering settings for your group policy
        """
        return pulumi.get(self, "content_filtering")

    @_builtins.property
    @pulumi.getter(name="firewallAndTrafficShaping")
    def firewall_and_traffic_shaping(self) -> pulumi.Output['outputs.GroupPoliciesFirewallAndTrafficShaping']:
        """
        The firewall and traffic shaping rules and settings for your policy.
        """
        return pulumi.get(self, "firewall_and_traffic_shaping")

    @_builtins.property
    @pulumi.getter(name="groupPolicyId")
    def group_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the group policy
        """
        return pulumi.get(self, "group_policy_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name for your group policy. Required.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter
    def scheduling(self) -> pulumi.Output['outputs.GroupPoliciesScheduling']:
        """
        The schedule for the group policy. Schedules are applied to days of the week.
        """
        return pulumi.get(self, "scheduling")

    @_builtins.property
    @pulumi.getter(name="splashAuthSettings")
    def splash_auth_settings(self) -> pulumi.Output[_builtins.str]:
        """
        Whether clients bound to your policy will bypass splash authorization or behave according to the network's rules. Can be one of 'network default' or 'bypass'. Only available if your network has a wireless configuration.
        """
        return pulumi.get(self, "splash_auth_settings")

    @_builtins.property
    @pulumi.getter(name="vlanTagging")
    def vlan_tagging(self) -> pulumi.Output['outputs.GroupPoliciesVlanTagging']:
        """
        The VLAN tagging settings for your group policy. Only available if your network has a wireless configuration.
        """
        return pulumi.get(self, "vlan_tagging")

